/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca;

import gov.aps.jca.ValuedEnum;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CASeverity
extends ValuedEnum {
    private static final Map _map;
    public static final CASeverity WARNING;
    public static final CASeverity SUCCESS;
    public static final CASeverity ERROR;
    public static final CASeverity INFO;
    public static final CASeverity SEVERE;
    public static final CASeverity FATAL;
    static CASeverity[] _cachedTypesByValue;

    protected CASeverity(String name, int value) {
        super(name, value, _map);
    }

    public boolean isSuccessful() {
        return (this.getValue() & 1) != 0;
    }

    public boolean isError() {
        return (this.getValue() & 2) != 0;
    }

    public boolean isFatal() {
        return (this.getValue() & 4) != 0;
    }

    public static CASeverity forName(String name) {
        return (CASeverity)_map.get(name);
    }

    public static final CASeverity forValue(int value) {
        if (value >= 0 && value < _cachedTypesByValue.length) {
            return _cachedTypesByValue[value];
        }
        return null;
    }

    static {
        CASeverity t;
        _map = new HashMap();
        WARNING = new CASeverity("WARNING", 0);
        SUCCESS = new CASeverity("SUCCESS", 1);
        ERROR = new CASeverity("ERROR", 2);
        INFO = new CASeverity("INFO", 3);
        SEVERE = new CASeverity("SEVERE", 4);
        FATAL = new CASeverity("FATAL", 6);
        int maxValue = 0;
        Iterator it = _map.values().iterator();
        while (it.hasNext()) {
            t = (CASeverity)it.next();
            if (t.getValue() <= maxValue) continue;
            maxValue = t.getValue();
        }
        _cachedTypesByValue = new CASeverity[maxValue + 1];
        it = _map.values().iterator();
        while (it.hasNext()) {
            t = (CASeverity)it.next();
            if (t.getValue() < 0) continue;
            CASeverity._cachedTypesByValue[t.getValue()] = t;
        }
    }
}

