/*
 * Decompiled with CFR 0.152.
 */
package runtime;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSLayeredPane;
import DOOCSComponents.DOOCSParameter;
import editor.DoocsFrameCache;
import editor.ExampleFileFilter;
import editor.StartParameters;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import jsvnbrowser.JSVNBrowser;
import jsvnbrowser.JSVNFileInfo;
import org.w3c.dom.Document;
import runtime.FirstFrame;
import xmlparser.DOOCSParser;

public class jddd_run {
    public static void main(String[] args) {
        jddd_run.startPanel(null, null, null, false, true, null);
    }

    public static void startPanel(String filePath, String baseAddress, DOOCSComponent comp, boolean override, boolean firstFrame, Point position) {
        DOOCSLayeredPane panel;
        JSVNFileInfo fInfo = null;
        if (filePath == null || filePath != null && filePath.equalsIgnoreCase("null")) {
            StartParameters startParams = StartParameters.getInstance();
            if (startParams.getSvnRepository() != null) {
                JSVNBrowser browser = new JSVNBrowser();
                if (startParams.getSvnDirectory() != null) {
                    browser.setCurrentDirectory(startParams.getSvnDirectory());
                }
                if ((fInfo = browser.showOpenDialog(null)) != null) {
                    filePath = fInfo.filepath;
                }
            }
            if (fInfo == null) {
                JFileChooser chooser = new JFileChooser();
                ExampleFileFilter filter = new ExampleFileFilter();
                filter.addExtension("xml");
                filter.setDescription("XML files");
                chooser.setFileFilter(filter);
                chooser.showOpenDialog(null);
                File selFile = chooser.getSelectedFile();
                if (selFile != null) {
                    filePath = selFile.getPath();
                }
            }
        } else if (!filePath.endsWith(".xml") && !filePath.contains(".")) {
            filePath = filePath + ".xml";
        }
        if (override && (panel = DoocsFrameCache.getInstance().getDOOCSLayeredPane(DOOCSParameter.getDoocsFileTitle(filePath))) != null) {
            panel.setRunMode(false);
            if (baseAddress != null && !baseAddress.equalsIgnoreCase("null")) {
                panel.setFullDoocsAddress(baseAddress);
                DOOCSParser.inherit(panel);
            }
            panel.setRunMode(true);
            if (panel.showToolTip) {
                panel.showToolTipText(false);
                panel.showToolTipText(true);
            }
            JFrame frameComp = DOOCSParameter.getParentFrame(panel);
            frameComp.toFront();
            frameComp.requestFocus();
            return;
        }
        if (fInfo == null) {
            fInfo = DOOCSParameter.getDoocsPath(filePath, comp);
        }
        if (fInfo != null) {
            JFrame frame;
            System.out.println("Open file: " + fInfo.filepath);
            panel = new DOOCSLayeredPane();
            panel.setEditMode(false);
            panel.setDoocsXmlFilePath(fInfo.filepath);
            DOOCSParser.parseStringBuffer(panel, fInfo.buf);
            if (baseAddress != null) {
                panel.setFullDoocsAddress(baseAddress);
                DOOCSParser.inherit(panel);
            }
            if (firstFrame) {
                frame = new FirstFrame(panel);
            } else {
                frame = new JFrame();
                frame.setDefaultCloseOperation(2);
            }
            Document doc = DOOCSParser.parseXmlStringBuffer(fInfo.buf, false);
            ImageIcon icon = DOOCSParameter.getThumbnailIcon(doc);
            if (icon != null) {
                frame.setIconImage(icon.getImage());
            }
            JScrollPane scrPane = new JScrollPane(panel);
            frame.setContentPane(scrPane);
            String oldTitle = frame.getTitle();
            if (oldTitle != null && oldTitle.length() > 3) {
                oldTitle = oldTitle + "  ";
            }
            frame.setTitle(oldTitle + DOOCSParameter.getDoocsFileTitle(filePath));
            panel.setRunMode(true);
            if (comp != null) {
                if (DOOCSParameter.getParentLayeredPane(comp) != null && DOOCSParameter.getParentLayeredPane((DOOCSComponent)comp).showToolTip) {
                    panel.showToolTipText(true);
                }
                if (position != null) {
                    frame.setLocation(position);
                } else {
                    JFrame tcomp = DOOCSParameter.getParentFrame(comp);
                    frame.setLocation(tcomp.getX() + 50, tcomp.getY() + 50);
                }
            }
            jddd_run.optimizeFrameSize(frame);
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    panel.setRunMode(false);
                    DoocsFrameCache.getInstance().removeDOOCSLayeredPane(frame.getTitle());
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frame.pack();
                    if (!panel.getDoocsMinSize().equalsIgnoreCase("0,0")) {
                        panel.setPreferredSize(DOOCSParameter.convertToSize(panel.getDoocsMinSize()));
                    }
                    frame.setVisible(true);
                }
            });
            DoocsFrameCache.getInstance().addDOOCSLayeredPane(frame.getTitle(), panel);
        } else {
            JOptionPane.showMessageDialog(null, "Cannot find " + filePath + "!");
        }
    }

    public static void startPanel(String filePath, String baseAddress, String repos) {
        JSVNFileInfo fInfo = null;
        if (filePath == null) {
            return;
        }
        if (!filePath.endsWith(".xml") && !filePath.contains(".")) {
            filePath = filePath + ".xml";
        }
        System.out.println("Read from: " + repos + filePath);
        fInfo = DOOCSParameter.getHttpInfo(filePath, repos);
        if (fInfo != null) {
            System.out.println("Open file: " + fInfo.filepath);
            final DOOCSLayeredPane panel = new DOOCSLayeredPane();
            panel.setEditMode(false);
            panel.setDoocsXmlFilePath(fInfo.filepath);
            DOOCSParser.parseStringBuffer(panel, fInfo.buf);
            if (baseAddress != null) {
                panel.setFullDoocsAddress(baseAddress);
                DOOCSParser.inherit(panel);
            }
            final FirstFrame frame = new FirstFrame(panel);
            Document doc = DOOCSParser.parseXmlStringBuffer(fInfo.buf, false);
            ImageIcon icon = DOOCSParameter.getThumbnailIcon(doc);
            if (icon != null) {
                frame.setIconImage(icon.getImage());
            }
            JScrollPane scrPane = new JScrollPane(panel);
            frame.setContentPane(scrPane);
            String oldTitle = frame.getTitle();
            if (oldTitle != null && oldTitle.length() > 3) {
                oldTitle = oldTitle + "  ";
            }
            frame.setTitle(oldTitle + DOOCSParameter.getDoocsFileTitle(filePath));
            panel.setRunMode(true);
            jddd_run.optimizeFrameSize(frame);
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent evt) {
                    panel.setRunMode(false);
                    DoocsFrameCache.getInstance().removeDOOCSLayeredPane(frame.getTitle());
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    frame.pack();
                    if (!panel.getDoocsMinSize().equalsIgnoreCase("0,0")) {
                        panel.setPreferredSize(DOOCSParameter.convertToSize(panel.getDoocsMinSize()));
                    }
                    frame.setVisible(true);
                }
            });
            DoocsFrameCache.getInstance().addDOOCSLayeredPane(frame.getTitle(), panel);
        } else {
            JOptionPane.showMessageDialog(null, "Cannot find " + filePath + "!");
        }
    }

    public static void optimizeFrameSize(JFrame frame) {
        GraphicsDevice device = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        Rectangle r = device.getDefaultConfiguration().getBounds();
        int screenWidth = r.width;
        int screenHeight = r.height;
        if (frame.getPreferredSize().height > screenHeight || frame.getPreferredSize().width > screenWidth) {
            frame.setLocation(0, 0);
            if (frame.getPreferredSize().height < screenHeight) {
                screenHeight = frame.getPreferredSize().height;
            }
            if (frame.getPreferredSize().width < screenWidth) {
                screenWidth = frame.getPreferredSize().width;
            }
            frame.setPreferredSize(new Dimension(screenWidth, screenHeight));
            System.out.println("Panel size changed to: " + screenWidth + "," + screenHeight);
        }
    }
}

