/*
 * Decompiled with CFR 0.152.
 */
package editor;

import DOOCSComponents.ShowException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import xmlparser.IntegerParser;

public class StartParameters {
    String m_PropertiesFilename = System.getProperty("user.home") + File.separatorChar + ".jddd";
    private URLClassLoader newCL;
    private File pluginFile = null;
    private int m_Height = 750;
    private int m_Width = 1070;
    private int m_Divider_Hor1 = 200;
    private int m_Divider_Hor2 = 600;
    private int m_Divider_Ver1 = 350;
    private boolean m_DefaultGrid = true;
    private boolean m_ShowToolTips = false;
    private String m_LastPrinter = null;
    private String m_SvnRepository = null;
    private String m_SvnName = null;
    private String m_SvnPassword = null;
    private String m_PluginPath = null;
    private String m_ExternalLibraries = null;
    private String m_Directory = System.getProperty("user.home");
    private String m_SvnDirectory = null;
    private Vector<String> m_Files = new Vector();
    private static StartParameters instance;

    private StartParameters() {
        this.read();
        this.setClassLoader();
        this.setPluginFile();
    }

    public static synchronized StartParameters getInstance() {
        if (instance == null) {
            instance = new StartParameters();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read() {
        Properties properties = new Properties();
        if (new File(this.m_PropertiesFilename).exists()) {
            FileInputStream inStream = null;
            try {
                inStream = new FileInputStream(this.m_PropertiesFilename);
                properties.load(inStream);
                this.m_Height = IntegerParser.parseInt(properties.getProperty("height"));
                this.m_Width = IntegerParser.parseInt(properties.getProperty("width"));
                this.m_Divider_Hor1 = IntegerParser.parseInt(properties.getProperty("divider_hor1"));
                this.m_Divider_Hor2 = IntegerParser.parseInt(properties.getProperty("divider_hor2"));
                this.m_Divider_Ver1 = IntegerParser.parseInt(properties.getProperty("divider_ver1"));
                this.m_DefaultGrid = Boolean.parseBoolean(properties.getProperty("defaultGrid"));
                this.m_ShowToolTips = Boolean.parseBoolean(properties.getProperty("showToolTips"));
                this.m_LastPrinter = properties.getProperty("lastPrinter");
                this.m_PluginPath = properties.getProperty("pluginPath");
                this.m_ExternalLibraries = properties.getProperty("externalLibraries");
                if (properties.getProperty("svnRepository") != null) {
                    this.m_SvnRepository = properties.getProperty("svnRepository");
                }
                if (properties.getProperty("svnName") != null) {
                    this.m_SvnName = properties.getProperty("svnName");
                }
                this.m_Directory = properties.getProperty("directory");
                this.m_SvnDirectory = properties.getProperty("svnDirectory");
                for (int i = 0; i < 10; ++i) {
                    String f = properties.getProperty("file" + i);
                    if (f == null) continue;
                    this.m_Files.add(f);
                }
            }
            catch (IOException e) {
                new ShowException(null, "StartParameters", e);
            }
            catch (NumberFormatException e) {
                new ShowException(null, "StartParameters", e);
            }
            finally {
                try {
                    if (inStream != null) {
                        ((InputStream)inStream).close();
                    }
                }
                catch (IOException e) {
                    new ShowException(null, "StartParameters", e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(int newWidth, int newHeight, int newDividerHor1, int newDividerHor2, int newDividerVer1) {
        Properties properties = new Properties();
        OutputStream outStream = null;
        try {
            properties.setProperty("height", Integer.toString(newHeight));
            properties.setProperty("width", Integer.toString(newWidth));
            properties.setProperty("divider_hor1", Integer.toString(newDividerHor1));
            properties.setProperty("divider_hor2", Integer.toString(newDividerHor2));
            properties.setProperty("divider_ver1", Integer.toString(newDividerVer1));
            properties.setProperty("defaultGrid", Boolean.toString(this.m_DefaultGrid));
            properties.setProperty("showToolTips", Boolean.toString(this.m_ShowToolTips));
            if (this.m_LastPrinter != null) {
                properties.setProperty("lastPrinter", this.m_LastPrinter);
            }
            if (this.m_SvnRepository != null) {
                properties.setProperty("svnRepository", this.m_SvnRepository);
            }
            if (this.m_SvnName != null) {
                properties.setProperty("svnName", this.m_SvnName);
            }
            if (this.m_PluginPath != null) {
                properties.setProperty("pluginPath", this.m_PluginPath);
            }
            if (this.m_ExternalLibraries != null) {
                properties.setProperty("externalLibraries", this.m_ExternalLibraries);
            }
            if (this.m_Directory != null) {
                properties.setProperty("directory", this.m_Directory);
            }
            if (this.m_SvnDirectory != null) {
                properties.setProperty("svnDirectory", this.m_SvnDirectory);
            }
            for (int i = 0; i < this.m_Files.size(); ++i) {
                properties.setProperty("file" + i, this.m_Files.get(i));
            }
            outStream = new FileOutputStream(this.m_PropertiesFilename);
            properties.store(outStream, null);
        }
        catch (IOException e) {
            new ShowException(null, "StartParameters", e);
        }
        finally {
            try {
                if (outStream != null) {
                    outStream.close();
                }
            }
            catch (IOException e) {
                new ShowException(null, "StartParameters", e);
            }
        }
    }

    public int getHeight() {
        return this.m_Height;
    }

    public int getWidth() {
        return this.m_Width;
    }

    public int getDividerHor1() {
        return this.m_Divider_Hor1;
    }

    public int getDividerHor2() {
        return this.m_Divider_Hor2;
    }

    public int getDividerVer1() {
        return this.m_Divider_Ver1;
    }

    public boolean getDefaultGrid() {
        return this.m_DefaultGrid;
    }

    public void setDefaultGrid(boolean grid) {
        this.m_DefaultGrid = grid;
    }

    public boolean getShowToolTips() {
        return this.m_ShowToolTips;
    }

    public void setShowToolTips(boolean show) {
        this.m_ShowToolTips = show;
    }

    public String getLastPrinter() {
        return this.m_LastPrinter;
    }

    public void setLastPrinter(String printer) {
        this.m_LastPrinter = printer;
    }

    public String getSvnRepository() {
        return this.m_SvnRepository;
    }

    public void setSvnRepository(String repos) {
        this.m_SvnRepository = repos;
    }

    public String getSvnName() {
        return this.m_SvnName;
    }

    public void setSvnName(String name) {
        this.m_SvnName = name;
    }

    public String getSvnPassword() {
        return this.m_SvnPassword;
    }

    public void setSvnPassword(String passw) {
        this.m_SvnPassword = passw;
    }

    public String getPluginPath() {
        return this.m_PluginPath;
    }

    public void setPluginPath(String path) {
        this.m_PluginPath = path;
        this.setPluginFile();
    }

    public String getExternalLibraries() {
        return this.m_ExternalLibraries;
    }

    public void setExternalLibraries(String libs) {
        this.m_ExternalLibraries = libs;
        this.setClassLoader();
    }

    public String getDirectory() {
        return this.m_Directory;
    }

    public void setDirectory(String dir) {
        this.m_Directory = dir;
    }

    public String getSvnDirectory() {
        return this.m_SvnDirectory;
    }

    public void setSvnDirectory(String dir) {
        this.m_SvnDirectory = dir;
    }

    public Vector getFiles() {
        return this.m_Files;
    }

    public void addFile(String file) {
        for (int i = 0; i < this.m_Files.size(); ++i) {
            if (!this.m_Files.get(i).equalsIgnoreCase(file)) continue;
            this.m_Files.removeElementAt(i);
        }
        this.m_Files.insertElementAt(file, 0);
        if (this.m_Files.size() > 9) {
            this.m_Files.removeElementAt(9);
        }
    }

    private void setClassLoader() {
        try {
            ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
            ArrayList<URL> mylist = new ArrayList<URL>();
            if (this.m_PluginPath != null && this.m_PluginPath.length() > 0) {
                if (this.m_PluginPath.startsWith("http://")) {
                    mylist.add(new URL(this.m_PluginPath));
                } else {
                    File file = new File(this.m_PluginPath);
                    mylist.add(file.toURI().toURL());
                }
            }
            if (this.m_ExternalLibraries != null && this.m_ExternalLibraries.length() > 0) {
                try {
                    StringTokenizer st = new StringTokenizer(this.m_ExternalLibraries);
                    while (st.hasMoreTokens()) {
                        String entry = st.nextToken();
                        if (entry.startsWith("http://")) {
                            mylist.add(new URL(entry));
                            continue;
                        }
                        File file = new File(entry);
                        mylist.add(file.toURI().toURL());
                    }
                }
                catch (IOException ex) {
                    System.out.println("StartParameters: " + ex);
                }
            }
            URL[] array = mylist.toArray(new URL[mylist.size()]);
            this.newCL = new URLClassLoader(array, oldCL);
        }
        catch (MalformedURLException mue) {
            System.out.println("StartParameters: " + mue);
        }
    }

    public URLClassLoader getClassLoader() {
        return this.newCL;
    }

    private void setPluginFile() {
        try {
            if (this.m_PluginPath != null && this.m_PluginPath.length() > 0) {
                if (this.m_PluginPath.startsWith("http://")) {
                    int len;
                    URL url = new URL(this.m_PluginPath);
                    InputStream in = url.openStream();
                    String filename = url.getPath().substring(url.getPath().lastIndexOf("/"));
                    this.pluginFile = new File(System.getProperty("user.home") + File.separatorChar + filename);
                    FileOutputStream out = new FileOutputStream(this.pluginFile);
                    byte[] buf = new byte[1024];
                    while ((len = in.read(buf)) > 0) {
                        ((OutputStream)out).write(buf, 0, len);
                    }
                    in.close();
                    ((OutputStream)out).close();
                } else {
                    this.pluginFile = new File(this.m_PluginPath);
                }
            }
        }
        catch (MalformedURLException mue) {
            System.out.println("StartParameters: " + mue);
        }
        catch (IOException ex) {
            System.out.println("StartParameters: " + ex);
        }
    }

    public File getPluginFile() {
        return this.pluginFile;
    }
}

