/*
 * Decompiled with CFR 0.152.
 */
package editor;

import DOOCSComponents.DOOCSParameter;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.File;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JToolTip;
import javax.swing.plaf.metal.MetalToolTipUI;
import jsvnbrowser.JSVNBrowser;
import jsvnbrowser.JSVNFileInfo;
import org.w3c.dom.Document;
import xmlparser.DOOCSParser;

public class JToolTipWithIcon
extends JToolTip {
    ImageIcon icon = null;

    public JToolTipWithIcon(ImageIcon icon) {
        this.icon = icon;
        this.setUI(new IconToolTipUI());
    }

    public JToolTipWithIcon(String filename, String repository) {
        if (filename != null && filename.toLowerCase().endsWith(".xml")) {
            if (filename.startsWith("/svn/")) {
                JSVNBrowser browser = new JSVNBrowser();
                JSVNFileInfo fInfo = browser.openFile(filename = filename.substring(5));
                if (fInfo != null) {
                    Document doc = DOOCSParser.parseXmlStringBuffer(fInfo.buf, false);
                    this.icon = DOOCSParameter.getThumbnailIcon(doc);
                }
            } else {
                File file = new File(filename);
                this.icon = DOOCSParameter.getThumbnailIcon(file);
            }
        }
        this.setUI(new IconToolTipUI());
    }

    public JToolTipWithIcon(MetalToolTipUI toolTipUI) {
        this.setUI(toolTipUI);
    }

    private class IconToolTipUI
    extends MetalToolTipUI {
        private IconToolTipUI() {
        }

        @Override
        public void paint(Graphics g, JComponent c) {
            Dimension size = c.getSize();
            g.setColor(c.getBackground());
            g.fillRect(0, 0, size.width, size.height);
            if (JToolTipWithIcon.this.icon != null) {
                JToolTipWithIcon.this.icon.paintIcon(c, g, 0, 0);
            }
        }

        @Override
        public Dimension getPreferredSize(JComponent c) {
            int width = 0;
            int height = 0;
            if (JToolTipWithIcon.this.icon != null) {
                width = JToolTipWithIcon.this.icon.getIconWidth() + 1;
                height = JToolTipWithIcon.this.icon.getIconHeight() + 1;
            }
            return new Dimension(width, height);
        }
    }
}

