/*
 * Decompiled with CFR 0.152.
 */
package editor;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSGroup;
import DOOCSComponents.DOOCSIfCase;
import DOOCSComponents.DOOCSIncludeComponent;
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.DOOCSSwitch;
import DOOCSComponents.DOOCSSwitchCase;
import DOOCSComponents.DOOCSTab;
import DOOCSComponents.DOOCSTabbedPane;
import editor.EditorPanel;
import editor.EditorPanelPopup;
import editor.IconTreeRenderer;
import editor.InspectorTreeModel;
import editor.events.DOOCSOpenIncludeComponentEvent;
import editor.events.DOOCSSelectEvent;
import editor.events.DOOCSUpdateTreeEvent;
import java.awt.Container;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public class InspectorTree
extends JTree
implements DOOCSSelectEvent,
TreeSelectionListener,
DOOCSUpdateTreeEvent,
MouseListener {
    InspectorTreeModel m_tm;
    protected Vector<DOOCSSelectEvent> selectionListener;
    protected Vector<DOOCSOpenIncludeComponentEvent> openIncludeComponentListener;

    public InspectorTree() {
        this.m_tm = new InspectorTreeModel();
        this.setModel(this.m_tm);
        this.addTreeSelectionListener(this);
        this.addMouseListener(this);
        this.getSelectionModel().setSelectionMode(4);
        this.setCellRenderer(new IconTreeRenderer());
        this.selectionListener = new Vector();
        this.openIncludeComponentListener = new Vector();
    }

    public InspectorTree(Container root) {
        this.m_tm = new InspectorTreeModel(root);
        this.setModel(this.m_tm);
        this.addTreeSelectionListener(this);
        this.getSelectionModel().setSelectionMode(4);
        this.selectionListener = new Vector();
        this.openIncludeComponentListener = new Vector();
    }

    public void changeModel(Container root) {
        this.m_tm.setRoot(root);
        this.updateUI();
    }

    @Override
    public void DOOCSObjectSelected(DOOCSComponent[] comp) {
        this.clearSelection();
        Vector<TreePath> vtp = new Vector<TreePath>();
        TreePath[] dummy = new TreePath[]{};
        for (int i = 0; i < comp.length; ++i) {
            TreePath tp = this.m_tm.getPathForNode((Container)((Object)comp[i]));
            if (tp.toString().contains("DynamicList") && tp.getLastPathComponent().toString() != null && !tp.getLastPathComponent().toString().contains("DynamicList")) {
                Object[] pathObjects = tp.getPath();
                TreePath newTp = new TreePath(pathObjects[0]);
                for (int j = 1; j < pathObjects.length; ++j) {
                    newTp = newTp.pathByAddingChild(pathObjects[j]);
                    if (!pathObjects[j].toString().contains("DynamicList")) continue;
                    j += 2;
                }
                vtp.add(newTp);
                continue;
            }
            vtp.add(tp);
        }
        this.setSelectionPaths(vtp.toArray(dummy));
        if (comp.length == 1 && comp[0] instanceof DOOCSSwitch) {
            this.expandPath((TreePath)vtp.get(0));
        }
        if (comp.length == 1 && comp[0] instanceof DOOCSTabbedPane) {
            this.expandPath((TreePath)vtp.get(0));
        }
        if (vtp.size() > 0) {
            this.scrollPathToVisible((TreePath)vtp.get(0));
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null) {
            int i;
            DOOCSComponent[] dummy = new DOOCSComponent[]{};
            Vector<DOOCSComponent> selection = new Vector<DOOCSComponent>();
            for (i = 0; i < paths.length; ++i) {
                selection.add((DOOCSComponent)paths[i].getLastPathComponent());
            }
            for (i = 0; i < this.selectionListener.size(); ++i) {
                this.selectionListener.get(i).DOOCSObjectSelected(selection.toArray(dummy));
            }
            if (selection.size() == 1) {
                DOOCSComponent actComponent = (DOOCSComponent)selection.get(0);
                while (!(actComponent instanceof DOOCSSwitchCase || actComponent instanceof DOOCSIfCase || actComponent instanceof DOOCSTab || actComponent instanceof EditorPanel || actComponent == null)) {
                    if (actComponent.getParent() instanceof JViewport) {
                        actComponent = (DOOCSComponent)((Object)actComponent.getParent().getParent());
                        continue;
                    }
                    actComponent = (DOOCSComponent)((Object)actComponent.getParent());
                }
                if (actComponent instanceof DOOCSSwitchCase) {
                    ((DOOCSSwitchCase)actComponent).showThisCase();
                }
                if (actComponent instanceof DOOCSIfCase) {
                    ((DOOCSIfCase)actComponent).showThisCase();
                }
                if (actComponent instanceof DOOCSTab) {
                    ((DOOCSTab)actComponent).showThisTab();
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        DOOCSIncludeComponent icomp;
        String ifilename;
        Object selection;
        TreePath[] paths = this.getSelectionPaths();
        if (e.getClickCount() == 1 && e.isMetaDown() && paths.length > 0) {
            boolean group = false;
            if (paths.length == 1 && this.getSelectionPath().getLastPathComponent() instanceof DOOCSGroup) {
                group = true;
            }
            EditorPanel epanel = (EditorPanel)this.getPathForRow(0).getLastPathComponent();
            EditorPanelPopup popup = new EditorPanelPopup(epanel, paths.length, group);
            popup.show(e.getComponent(), e.getX(), e.getY());
        }
        if (e.getClickCount() == 2 && (selection = this.getSelectionPath().getLastPathComponent()) instanceof DOOCSIncludeComponent && (ifilename = (icomp = (DOOCSIncludeComponent)selection).getIncludeDoocsXmlFile()) != null && DOOCSParameter.getDoocsFilePath(ifilename, icomp) != null) {
            for (int i = 0; i < this.openIncludeComponentListener.size(); ++i) {
                this.openIncludeComponentListener.get(i).DOOCSOpenIncludeComponent(DOOCSParameter.getDoocsFilePath(ifilename, icomp));
            }
        }
    }

    public void addDOOCSSelectionListener(DOOCSSelectEvent dse) {
        this.selectionListener.add(dse);
    }

    public void addDOOCSOpenIncludeComponentListener(DOOCSOpenIncludeComponentEvent due) {
        this.openIncludeComponentListener.add(due);
    }

    @Override
    public void DOOCSPanelStructureChanged() {
        this.updateUI();
    }
}

