/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSLayeredPane;
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.DOOCSTabbedPane;
import java.awt.Color;
import java.awt.Component;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import jsvnbrowser.JSVNFileInfo;

public class DOOCSTab
extends DOOCSLayeredPane {
    private int index = 0;
    private String doocsIconFile = null;
    private String doocsTabTitle = null;

    public DOOCSTab() {
        this.setBackground(new Color(238, 238, 238));
    }

    @Override
    public void add(Component comp, Object constraints) {
        if (comp instanceof DOOCSTab) {
            this.getParent().add(comp, constraints);
            return;
        }
        super.add(comp, constraints);
    }

    public void setIndex(int i) {
        this.index = i;
    }

    public int getIndex() {
        return this.index;
    }

    public void setDoocsIconFile(String file) {
        this.doocsIconFile = file;
        if (file != null && this.getParent() != null) {
            if (file.startsWith("http://")) {
                try {
                    ((DOOCSTabbedPane)this.getParent()).setIconAt(this.index, new ImageIcon(new URL(file)));
                }
                catch (MalformedURLException mue) {
                    System.out.println(this.getName() + mue);
                }
            } else {
                JSVNFileInfo fInfo = DOOCSParameter.getDoocsFilePath(file, this);
                if (fInfo != null) {
                    ((DOOCSTabbedPane)this.getParent()).setIconAt(this.index, new ImageIcon(fInfo.buf));
                } else {
                    ((DOOCSTabbedPane)this.getParent()).setIconAt(this.index, null);
                }
            }
        }
        if (file == null) {
            ((DOOCSTabbedPane)this.getParent()).setIconAt(this.index, null);
        }
    }

    public String getDoocsIconFile() {
        return this.doocsIconFile;
    }

    public void setDoocsTabTitle(String title) {
        if (this.getParent() != null) {
            ((DOOCSTabbedPane)this.getParent()).setTitleAt(this.index, title);
        }
        this.doocsTabTitle = title;
    }

    public String getDoocsTabTitle() {
        return this.doocsTabTitle;
    }

    @Override
    public void setToolTipText(String ttt) {
        if (this.getParent() != null) {
            ((DOOCSTabbedPane)this.getParent()).setToolTipTextAt(this.index, ttt);
        }
    }

    @Override
    public String getToolTipText() {
        if (this.getParent() != null) {
            return ((DOOCSTabbedPane)this.getParent()).getToolTipTextAt(this.index);
        }
        return null;
    }

    public void showThisTab() {
        ((DOOCSTabbedPane)this.getParent()).setSelectedIndex(this.index);
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("title", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("iconFile", DOOCSParameter.ParameterTypes.ICONFILE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bgColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("transparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("grid", DOOCSParameter.ParameterTypes.GRID, DOOCSParameter.Levels.NORMAL)};
        return parameters;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSTab ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("\n");
        Component[] subcomp = this.getComponents();
        for (int i = 0; i < subcomp.length; ++i) {
            DOOCSComponent dcomp = (DOOCSComponent)((Object)subcomp[i]);
            xmlStructure.append(dcomp.getDOOCSXmlStructure());
        }
        xmlStructure.append("</DOOCSTab>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.equalsIgnoreCase("title")) {
            this.setDoocsTabTitle(value);
        } else if (parameter.equalsIgnoreCase("iconFile")) {
            this.setDoocsIconFile(value);
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("grid")) {
            this.setDoocsGrid(value);
        } else if (parameter.equalsIgnoreCase("bgColor")) {
            this.setBackground(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("transparent")) {
            this.setOpaque(!Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else {
            System.out.println("DOOCSTab.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.equalsIgnoreCase("title")) {
            return this.getDoocsTabTitle();
        }
        if (parameter.equalsIgnoreCase("iconFile")) {
            return this.getDoocsIconFile();
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("grid")) {
            return this.getDoocsGrid();
        }
        if (parameter.equalsIgnoreCase("bgColor")) {
            return DOOCSParameter.getDoocsColor(this.getBackground());
        }
        if (parameter.equalsIgnoreCase("transparent")) {
            return !this.isOpaque();
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        System.out.println("DOOCSTab.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }
}

