/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSLayeredPane;
import DOOCSComponents.DOOCSParameter;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import layoutmanager.ScaleConstraints;
import layoutmanager.ScaleLayout;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqCallback;
import ttf.doocs.clnt.EqData;

public class DOOCSAlive
extends DOOCSLayeredPane
implements EqCallback {
    private EqCall eq = new EqCall();
    private EqData ed = new EqData();
    private EqData data = new EqData();
    EqAdr eax = null;
    EqAdr eay = null;
    EqAdr eaw = null;
    EqAdr eah = null;
    private float xvalue = 0.0f;
    private float yvalue = 0.0f;
    private float wvalue = 0.0f;
    private float hvalue = 0.0f;
    private String errorMessage = null;
    private float doocsUpdateTime = 1.0f;
    private String doocsXposAdr = null;
    private String fullDoocsXposAdr = null;
    private String doocsYposAdr = null;
    private String fullDoocsYposAdr = null;
    private String doocsWidthAdr = null;
    private String fullDoocsWidthAdr = null;
    private String doocsHeightAdr = null;
    private String fullDoocsHeightAdr = null;
    private float doocsDataXmin = 0.0f;
    private float doocsDataYmin = 0.0f;
    private float doocsDataXmax = 1.0f;
    private float doocsDataYmax = 1.0f;
    private float doocsWidthScaleFactor = 1.0f;
    private float doocsWidthOffset = 0.0f;
    private String doocsWidthScaleDirection = "NORMAL";
    private float doocsHeightScaleFactor = 1.0f;
    private float doocsHeightOffset = 0.0f;
    private String doocsHeightScaleDirection = "NORMAL";

    public DOOCSAlive() {
        this.setOpaque(false);
    }

    private void startMonitors() {
        if ((double)this.doocsUpdateTime == 0.0) {
            if (this.eax != null) {
                this.eq.get_monitor(this.eax, this.ed, this.data, 1, this.doocsUpdateTime, (EqCallback)this, (Object)"eax");
            }
            if (this.eay != null) {
                this.eq.get_monitor(this.eay, this.ed, this.data, 1, this.doocsUpdateTime, (EqCallback)this, (Object)"eay");
            }
            if (this.eaw != null) {
                this.eq.get_monitor(this.eaw, this.ed, this.data, 1, this.doocsUpdateTime, (EqCallback)this, (Object)"eaw");
            }
            if (this.eah != null) {
                this.eq.get_monitor(this.eah, this.ed, this.data, 1, this.doocsUpdateTime, (EqCallback)this, (Object)"eah");
            }
        } else {
            if (this.eax != null) {
                this.eq.get_monitor(this.eax, this.ed, this.data, 3, this.doocsUpdateTime, (EqCallback)this, (Object)"eax");
            }
            if (this.eay != null) {
                this.eq.get_monitor(this.eay, this.ed, this.data, 3, this.doocsUpdateTime, (EqCallback)this, (Object)"eay");
            }
            if (this.eaw != null) {
                this.eq.get_monitor(this.eaw, this.ed, this.data, 3, this.doocsUpdateTime, (EqCallback)this, (Object)"eaw");
            }
            if (this.eah != null) {
                this.eq.get_monitor(this.eah, this.ed, this.data, 3, this.doocsUpdateTime, (EqCallback)this, (Object)"eah");
            }
        }
    }

    @Override
    public void setRunMode(boolean bRun) {
        super.setRunMode(bRun);
        if (bRun) {
            for (int i = 0; i < this.getComponentCount(); ++i) {
                ((DOOCSComponent)((Object)this.getComponent(i))).setInitialBounds(this.getComponent(i).getBounds());
            }
            this.startMonitors();
        } else {
            if (this.eax != null) {
                this.eq.clear_monitor(this.eax);
            }
            if (this.eay != null) {
                this.eq.clear_monitor(this.eay);
            }
            if (this.eaw != null) {
                this.eq.clear_monitor(this.eaw);
            }
            if (this.eah != null) {
                this.eq.clear_monitor(this.eah);
            }
        }
    }

    public void setDoocsUpdateTime(float time) {
        this.doocsUpdateTime = time;
    }

    public float getDoocsUpdateTime() {
        return this.doocsUpdateTime;
    }

    public void setDoocsXposAdr(String adr) {
        this.doocsXposAdr = adr;
    }

    public String getDoocsXposAdr() {
        return this.doocsXposAdr;
    }

    public void setFullDoocsXposAdr(String adr) {
        if (adr == null) {
            return;
        }
        if (this.fullDoocsXposAdr == null || !adr.startsWith(this.fullDoocsXposAdr)) {
            this.fullDoocsXposAdr = adr;
            if (this.eax != null) {
                this.eq.clear_monitor(this.eax);
            }
            this.eax = new EqAdr(this.fullDoocsXposAdr);
            if (!EqAdr.isValidAdr((String)this.fullDoocsXposAdr)) {
                this.eax = null;
            } else if (this.doocsRunMode) {
                if ((double)this.doocsUpdateTime == 0.0) {
                    this.eq.get_monitor(this.eax, this.ed, this.data, 1, this.doocsUpdateTime, (EqCallback)this, (Object)"eax");
                } else {
                    this.eq.get_monitor(this.eax, this.ed, this.data, 3, this.doocsUpdateTime, (EqCallback)this, (Object)"eax");
                }
            }
        }
    }

    public String getFullDoocsXposAdr() {
        return this.fullDoocsXposAdr;
    }

    public void setDoocsYposAdr(String adr) {
        this.doocsYposAdr = adr;
    }

    public String getDoocsYposAdr() {
        return this.doocsYposAdr;
    }

    public void setFullDoocsYposAdr(String adr) {
        if (adr == null) {
            return;
        }
        if (this.fullDoocsYposAdr == null || !adr.startsWith(this.fullDoocsYposAdr)) {
            this.fullDoocsYposAdr = adr;
            if (this.eay != null) {
                this.eq.clear_monitor(this.eay);
            }
            this.eay = new EqAdr(this.fullDoocsYposAdr);
            if (!EqAdr.isValidAdr((String)this.fullDoocsYposAdr)) {
                this.eay = null;
            } else if (this.doocsRunMode) {
                if ((double)this.doocsUpdateTime == 0.0) {
                    this.eq.get_monitor(this.eay, this.ed, this.data, 1, this.doocsUpdateTime, (EqCallback)this, (Object)"eay");
                } else {
                    this.eq.get_monitor(this.eay, this.ed, this.data, 3, this.doocsUpdateTime, (EqCallback)this, (Object)"eay");
                }
            }
        }
    }

    public String getFullDoocsYposAdr() {
        return this.fullDoocsYposAdr;
    }

    public void setDoocsWidthAdr(String adr) {
        this.doocsWidthAdr = adr;
    }

    public String getDoocsWidthAdr() {
        return this.doocsWidthAdr;
    }

    public void setFullDoocsWidthAdr(String adr) {
        if (adr == null) {
            return;
        }
        if (this.fullDoocsWidthAdr == null || !adr.startsWith(this.fullDoocsWidthAdr)) {
            this.fullDoocsWidthAdr = adr;
            if (this.eaw != null) {
                this.eq.clear_monitor(this.eaw);
            }
            this.eaw = new EqAdr(this.fullDoocsWidthAdr);
            if (!EqAdr.isValidAdr((String)this.fullDoocsWidthAdr)) {
                this.eaw = null;
            } else if (this.doocsRunMode) {
                if ((double)this.doocsUpdateTime == 0.0) {
                    this.eq.get_monitor(this.eaw, this.ed, this.data, 1, this.doocsUpdateTime, (EqCallback)this, (Object)"eaw");
                } else {
                    this.eq.get_monitor(this.eaw, this.ed, this.data, 3, this.doocsUpdateTime, (EqCallback)this, (Object)"eaw");
                }
            }
        }
    }

    public String getFullDoocsWidthAdr() {
        return this.fullDoocsWidthAdr;
    }

    public void setDoocsHeightAdr(String adr) {
        this.doocsHeightAdr = adr;
    }

    public String getDoocsHeightAdr() {
        return this.doocsHeightAdr;
    }

    public void setFullDoocsHeightAdr(String adr) {
        if (adr == null) {
            return;
        }
        if (this.fullDoocsHeightAdr == null || !adr.startsWith(this.fullDoocsHeightAdr)) {
            this.fullDoocsHeightAdr = adr;
            if (this.eah != null) {
                this.eq.clear_monitor(this.eah);
            }
            this.eah = new EqAdr(this.fullDoocsHeightAdr);
            if (!EqAdr.isValidAdr((String)this.fullDoocsHeightAdr)) {
                this.eah = null;
            } else if (this.doocsRunMode) {
                if ((double)this.doocsUpdateTime == 0.0) {
                    this.eq.get_monitor(this.eah, this.ed, this.data, 1, this.doocsUpdateTime, (EqCallback)this, (Object)"eah");
                } else {
                    this.eq.get_monitor(this.eah, this.ed, this.data, 3, this.doocsUpdateTime, (EqCallback)this, (Object)"eah");
                }
            }
        }
    }

    public String getFullDoocsHeightAdr() {
        return this.fullDoocsHeightAdr;
    }

    public void setDoocsDataXmin(float data) {
        this.doocsDataXmin = data;
    }

    public float getDoocsDataXmin() {
        return this.doocsDataXmin;
    }

    public void setDoocsDataYmin(float data) {
        this.doocsDataYmin = data;
    }

    public float getDoocsDataYmin() {
        return this.doocsDataYmin;
    }

    public void setDoocsDataXmax(float data) {
        this.doocsDataXmax = data;
    }

    public float getDoocsDataXmax() {
        return this.doocsDataXmax;
    }

    public void setDoocsDataYmax(float data) {
        this.doocsDataYmax = data;
    }

    public float getDoocsDataYmax() {
        return this.doocsDataYmax;
    }

    public void setDoocsWidthScaleFactor(float factor) {
        this.doocsWidthScaleFactor = factor;
    }

    public float getDoocsWidthScaleFactor() {
        return this.doocsWidthScaleFactor;
    }

    public void setDoocsHeightScaleFactor(float factor) {
        this.doocsHeightScaleFactor = factor;
    }

    public float getDoocsHeightScaleFactor() {
        return this.doocsHeightScaleFactor;
    }

    public void setDoocsWidthOffset(float offset) {
        this.doocsWidthOffset = offset;
    }

    public float getDoocsWidthOffset() {
        return this.doocsWidthOffset;
    }

    public void setDoocsHeightOffset(float offset) {
        this.doocsHeightOffset = offset;
    }

    public float getDoocsHeightOffset() {
        return this.doocsHeightOffset;
    }

    public void setDoocsWidthScaleDirection(String direction) {
        this.doocsWidthScaleDirection = direction;
    }

    public String getDoocsWidthScaleDirection() {
        return this.doocsWidthScaleDirection;
    }

    public void setDoocsHeightScaleDirection(String direction) {
        this.doocsHeightScaleDirection = direction;
    }

    public String getDoocsHeightScaleDirection() {
        return this.doocsHeightScaleDirection;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("updateTime", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("xposAdr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("xposDataMin", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("xposDataMax", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("yposAdr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("yposDataMin", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("yposDataMax", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("widthAdr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("widthScaleFactor", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("widthOffset", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("widthScaleDirection", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("heightAdr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("heightScaleFactor", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("heightOffset", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("heightScaleDirection", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("grid", DOOCSParameter.ParameterTypes.GRID, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        if (parameter.contains("ScaleDirection")) {
            String[] allowedValues = new String[]{"NORMAL", "CENTER"};
            return allowedValues;
        }
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSAlive ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("\n");
        Component[] subcomp = this.getComponents();
        for (int i = 0; i < subcomp.length; ++i) {
            DOOCSComponent dcomp = (DOOCSComponent)((Object)subcomp[i]);
            xmlStructure.append(dcomp.getDOOCSXmlStructure());
        }
        xmlStructure.append("</DOOCSAlive>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.equalsIgnoreCase("updateTime")) {
            this.setDoocsUpdateTime(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("XposAdr")) {
            this.setDoocsXposAdr(value);
        } else if (parameter.equalsIgnoreCase("YposAdr")) {
            this.setDoocsYposAdr(value);
        } else if (parameter.equalsIgnoreCase("widthAdr")) {
            this.setDoocsWidthAdr(value);
        } else if (parameter.equalsIgnoreCase("heightAdr")) {
            this.setDoocsHeightAdr(value);
        } else if (parameter.equalsIgnoreCase("xposDataMin")) {
            this.setDoocsDataXmin(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("yposDataMin")) {
            this.setDoocsDataYmin(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("xposDataMax")) {
            this.setDoocsDataXmax(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("yposDataMax")) {
            this.setDoocsDataYmax(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("widthScaleFactor")) {
            this.setDoocsWidthScaleFactor(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("widthOffset")) {
            this.setDoocsWidthOffset(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("widthScaleDirection")) {
            this.setDoocsWidthScaleDirection(value);
        } else if (parameter.equalsIgnoreCase("heightScaleFactor")) {
            this.setDoocsHeightScaleFactor(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("heightOffset")) {
            this.setDoocsHeightOffset(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("heightScaleDirection")) {
            this.setDoocsHeightScaleDirection(value);
        } else if (parameter.equalsIgnoreCase("grid")) {
            this.setDoocsGrid(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSAlive.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.equalsIgnoreCase("updateTime")) {
            return Float.valueOf(this.getDoocsUpdateTime());
        }
        if (parameter.equalsIgnoreCase("XposAdr")) {
            return this.getDoocsXposAdr();
        }
        if (parameter.equalsIgnoreCase("YposAdr")) {
            return this.getDoocsYposAdr();
        }
        if (parameter.equalsIgnoreCase("widthAdr")) {
            return this.getDoocsWidthAdr();
        }
        if (parameter.equalsIgnoreCase("heightAdr")) {
            return this.getDoocsHeightAdr();
        }
        if (parameter.equalsIgnoreCase("xposDataMin")) {
            return Float.valueOf(this.getDoocsDataXmin());
        }
        if (parameter.equalsIgnoreCase("yposDataMin")) {
            return Float.valueOf(this.getDoocsDataYmin());
        }
        if (parameter.equalsIgnoreCase("xposDataMax")) {
            return Float.valueOf(this.getDoocsDataXmax());
        }
        if (parameter.equalsIgnoreCase("yposDataMax")) {
            return Float.valueOf(this.getDoocsDataYmax());
        }
        if (parameter.equalsIgnoreCase("widthScaleFactor")) {
            return Float.valueOf(this.getDoocsWidthScaleFactor());
        }
        if (parameter.equalsIgnoreCase("widthOffset")) {
            return Float.valueOf(this.getDoocsWidthOffset());
        }
        if (parameter.equalsIgnoreCase("widthScaleDirection")) {
            return this.getDoocsWidthScaleDirection();
        }
        if (parameter.equalsIgnoreCase("heightScaleFactor")) {
            return Float.valueOf(this.getDoocsHeightScaleFactor());
        }
        if (parameter.equalsIgnoreCase("heightOffset")) {
            return Float.valueOf(this.getDoocsHeightOffset());
        }
        if (parameter.equalsIgnoreCase("heightScaleDirection")) {
            return this.getDoocsHeightScaleDirection();
        }
        if (parameter.equalsIgnoreCase("grid")) {
            return this.getDoocsGrid();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        System.out.println("DOOCSAlive.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    public void dataCallback(EqData dataOut, Object userData) {
        if (dataOut.error() == 0) {
            int i;
            int xpos = 0;
            int ypos = 0;
            if (userData.equals("eax")) {
                if (dataOut.type() == 2 || dataOut.type() == 1 || dataOut.type() == 100 || dataOut.type() == 1) {
                    this.xvalue = dataOut.get_float(0);
                } else {
                    System.out.println("DOOCSAlive: wrong data type for XposAdr");
                }
            }
            if (userData.equals("eay")) {
                if (dataOut.type() == 2 || dataOut.type() == 1 || dataOut.type() == 100 || dataOut.type() == 1) {
                    this.yvalue = dataOut.get_float(0);
                } else {
                    System.out.println("DOOCSAlive: wrong data type for YposAdr");
                }
            }
            if (this.doocsXposAdr != null || this.doocsYposAdr != null) {
                for (i = 0; i < this.getComponentCount(); ++i) {
                    ScaleConstraints constr = ((ScaleLayout)this.getParent().getLayout()).getScaleConstraints(this);
                    int compWidth = ((DOOCSComponent)((Object)this.getComponent((int)i))).getInitialBounds().width;
                    int compHeight = ((DOOCSComponent)((Object)this.getComponent((int)i))).getInitialBounds().height;
                    int offsetx = ((DOOCSComponent)((Object)this.getComponent((int)i))).getInitialBounds().x - constr.width / 2;
                    int offsety = ((DOOCSComponent)((Object)this.getComponent((int)i))).getInitialBounds().y - constr.height / 2;
                    float a = (this.doocsDataXmax - this.doocsDataXmin) / (float)constr.width;
                    xpos = Math.round((this.xvalue - this.doocsDataXmin) / a + (float)offsetx);
                    a = (this.doocsDataYmin - this.doocsDataYmax) / (float)constr.height;
                    ypos = Math.round((this.yvalue - this.doocsDataYmax) / a + (float)offsety);
                    if (xpos < 0) {
                        xpos = 0;
                    }
                    if (ypos < 0) {
                        ypos = 0;
                    }
                    if (xpos > constr.width - compWidth) {
                        xpos = constr.width - compWidth;
                    }
                    if (ypos > constr.height - compHeight) {
                        ypos = constr.height - compHeight;
                    }
                    if (this.doocsWidthAdr != null || this.doocsHeightAdr != null) continue;
                    ((ScaleLayout)this.getLayout()).changeComponentPosition(this.getComponent(i), xpos, ypos);
                    ((ScaleLayout)this.getLayout()).resetStoredFactors();
                    ((ScaleLayout)this.getLayout()).layoutContainer(this);
                }
            }
            if (userData.equals("eaw")) {
                if (dataOut.type() == 2 || dataOut.type() == 1 || dataOut.type() == 100 || dataOut.type() == 1) {
                    this.wvalue = dataOut.get_float(0);
                } else {
                    System.out.println("DOOCSAlive: wrong data type for WidthAdr");
                }
            }
            if (userData.equals("eah")) {
                if (dataOut.type() == 2 || dataOut.type() == 1 || dataOut.type() == 100 || dataOut.type() == 1) {
                    this.hvalue = dataOut.get_float(0);
                } else {
                    System.out.println("DOOCSAlive: wrong data type for HeightAdr");
                }
            }
            if (this.doocsWidthAdr != null || this.doocsHeightAdr != null) {
                for (i = 0; i < this.getComponentCount(); ++i) {
                    int compWidth = ((DOOCSComponent)((Object)this.getComponent((int)i))).getInitialBounds().width;
                    int compHeight = ((DOOCSComponent)((Object)this.getComponent((int)i))).getInitialBounds().height;
                    if (this.doocsXposAdr == null) {
                        xpos = ((DOOCSComponent)((Object)this.getComponent((int)i))).getInitialBounds().x;
                    }
                    if (this.doocsYposAdr == null) {
                        ypos = ((DOOCSComponent)((Object)this.getComponent((int)i))).getInitialBounds().y;
                    }
                    int compXcenter = xpos + compWidth / 2;
                    int compYcenter = ypos + compHeight / 2;
                    int compYbottom = ypos + compHeight;
                    if (this.wvalue != 0.0f) {
                        compWidth = Math.round(this.doocsWidthScaleFactor * this.wvalue + this.doocsWidthOffset);
                    }
                    if (this.hvalue != 0.0f) {
                        compHeight = Math.round(this.doocsHeightScaleFactor * this.hvalue + this.doocsHeightOffset);
                    }
                    if (compWidth > 0 && this.doocsWidthScaleDirection.equalsIgnoreCase("CENTER")) {
                        xpos = compXcenter - compWidth / 2;
                    }
                    if (compHeight > 0 && this.doocsHeightScaleDirection.equalsIgnoreCase("CENTER")) {
                        ypos = compYcenter - compHeight / 2;
                    }
                    if (compHeight > 0 && this.doocsHeightScaleDirection.equalsIgnoreCase("NORMAL")) {
                        ypos = compYbottom - compHeight;
                    }
                    if (compWidth < 0 && this.doocsWidthScaleDirection.equalsIgnoreCase("NORMAL")) {
                        compWidth = -compWidth;
                        xpos -= compWidth;
                    }
                    if (compHeight < 0 && this.doocsHeightScaleDirection.equalsIgnoreCase("NORMAL")) {
                        compHeight = -compHeight;
                        ypos = compYbottom;
                    }
                    ((ScaleLayout)this.getLayout()).changeComponentBounds(this.getComponent(i), xpos, ypos, compWidth, compHeight);
                    ((ScaleLayout)this.getLayout()).resetStoredFactors();
                    ((ScaleLayout)this.getLayout()).layoutContainer(this);
                }
            }
        } else if (this.errorMessage == null && this.doocsRunMode) {
            this.errorMessage = dataOut.get_string_arg();
            System.out.println(DOOCSParameter.getFullName(this) + ": " + this.fullDoocsAddress + ": " + this.errorMessage);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (!this.isRunMode()) {
            Graphics2D g2 = (Graphics2D)g;
            Color col = g2.getColor();
            g2.setColor(Color.LIGHT_GRAY);
            g2.drawLine(this.getWidth() / 2 - 5, this.getHeight() / 2, this.getWidth() / 2 + 5, this.getHeight() / 2);
            g2.drawLine(this.getWidth() / 2, this.getHeight() / 2 - 5, this.getWidth() / 2, this.getHeight() / 2 + 5);
            g2.setColor(col);
        }
    }
}

