/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.wc.admin;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNProperty;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea;
import org.tmatesoft.svn.core.internal.wc.admin.SVNAdminArea14;

public class SVNAdminArea15
extends SVNAdminArea14 {
    public static final int WC_FORMAT = 9;
    protected static final String ATTRIBUTE_KEEP_LOCAL = "keep-local";

    public SVNAdminArea15(File dir) {
        super(dir);
    }

    protected boolean readExtraOptions(BufferedReader reader, Map entryAttrs) throws SVNException, IOException {
        String line = reader.readLine();
        if (this.isEntryFinished(line)) {
            return true;
        }
        String changelist = this.parseString(line);
        if (changelist != null) {
            entryAttrs.put("svn:entry:changelist", changelist);
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return true;
        }
        boolean keepLocal = this.parseBoolean(line, ATTRIBUTE_KEEP_LOCAL);
        if (keepLocal) {
            entryAttrs.put("svn:entry:keep-local", SVNProperty.toString(keepLocal));
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return true;
        }
        String workingSize = this.parseString(line);
        if (workingSize != null) {
            entryAttrs.put("svn:entry:working-size", workingSize);
        }
        if (this.isEntryFinished(line = reader.readLine())) {
            return true;
        }
        String depthStr = this.parseValue(line);
        if (depthStr == null) {
            entryAttrs.put("svn:entry:depth", SVNDepth.INFINITY.getName());
        } else {
            entryAttrs.put("svn:entry:depth", depthStr);
        }
        return false;
    }

    protected void writeExtraOptions(Writer writer, String entryName, Map entryAttrs, int emptyFields) throws SVNException, IOException {
        String changelist = (String)entryAttrs.get("svn:entry:changelist");
        emptyFields = this.writeString(writer, changelist, emptyFields) ? 0 : ++emptyFields;
        String keepLocalAttr = (String)entryAttrs.get("svn:entry:keep-local");
        if (SVNProperty.booleanValue(keepLocalAttr)) {
            this.writeValue(writer, ATTRIBUTE_KEEP_LOCAL, emptyFields);
            emptyFields = 0;
        } else {
            ++emptyFields;
        }
        String workingSize = (String)entryAttrs.get("svn:entry:working-size");
        emptyFields = this.writeString(writer, workingSize, emptyFields) ? 0 : ++emptyFields;
        boolean isThisDir = this.getThisDirName().equals(entryName);
        boolean isSubDir = !isThisDir && "dir".equals(entryAttrs.get("svn:entry:kind"));
        String depth = (String)entryAttrs.get("svn:entry:depth");
        if (!isSubDir && SVNDepth.fromString(depth) != SVNDepth.INFINITY) {
            this.writeValue(writer, depth, emptyFields);
            emptyFields = 0;
        } else {
            ++emptyFields;
        }
    }

    protected int getFormatVersion() {
        return 9;
    }

    protected SVNAdminArea createAdminAreaForDir(File dir) {
        return new SVNAdminArea15(dir);
    }

    protected boolean isEntryPropertyApplicable(String propName) {
        return propName != null;
    }
}

