/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core.internal.io.dav;

import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.tmatesoft.svn.core.ISVNDirEntryHandler;
import org.tmatesoft.svn.core.ISVNLogEntryHandler;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLock;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNMergeInfoInheritance;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNPropertyValue;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVBaselineInfo;
import org.tmatesoft.svn.core.internal.io.dav.DAVCommitEditor;
import org.tmatesoft.svn.core.internal.io.dav.DAVConnection;
import org.tmatesoft.svn.core.internal.io.dav.DAVElement;
import org.tmatesoft.svn.core.internal.io.dav.DAVProperties;
import org.tmatesoft.svn.core.internal.io.dav.DAVUtil;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVDateRevisionHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVEditorHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVFileRevisionHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVLocationSegmentsHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVLocationsHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVLogHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVMergeInfoHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVProppatchHandler;
import org.tmatesoft.svn.core.internal.io.dav.handlers.DAVReplayHandler;
import org.tmatesoft.svn.core.internal.io.dav.http.HTTPStatus;
import org.tmatesoft.svn.core.internal.io.dav.http.IHTTPConnectionFactory;
import org.tmatesoft.svn.core.internal.util.SVNDate;
import org.tmatesoft.svn.core.internal.util.SVNEncodingUtil;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;
import org.tmatesoft.svn.core.internal.util.SVNPathUtil;
import org.tmatesoft.svn.core.internal.wc.SVNDepthFilterEditor;
import org.tmatesoft.svn.core.internal.wc.SVNErrorManager;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.ISVNFileRevisionHandler;
import org.tmatesoft.svn.core.io.ISVNLocationEntryHandler;
import org.tmatesoft.svn.core.io.ISVNLocationSegmentHandler;
import org.tmatesoft.svn.core.io.ISVNLockHandler;
import org.tmatesoft.svn.core.io.ISVNReplayHandler;
import org.tmatesoft.svn.core.io.ISVNReporterBaton;
import org.tmatesoft.svn.core.io.ISVNSession;
import org.tmatesoft.svn.core.io.ISVNWorkspaceMediator;
import org.tmatesoft.svn.core.io.SVNCapability;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.util.SVNLogType;

public class DAVRepository
extends SVNRepository {
    private DAVConnection myConnection;
    private IHTTPConnectionFactory myConnectionFactory;
    private boolean myIsSpoolResponse;
    private static boolean ourIsKeepCredentials = Boolean.valueOf(System.getProperty("svnkit.http.keepCredentials", Boolean.TRUE.toString()));

    public static void setKeepCredentials(boolean keepCredentials) {
        ourIsKeepCredentials = keepCredentials;
    }

    protected DAVRepository(IHTTPConnectionFactory connectionFactory, SVNURL location, ISVNSession options) {
        super(location, options);
        this.myConnectionFactory = connectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testConnection() throws SVNException {
        try {
            this.openConnection();
            this.myRepositoryRoot = null;
            this.myRepositoryUUID = null;
            this.myConnection.fetchRepositoryUUID(this);
            this.myConnection.fetchRepositoryRoot(this);
        }
        finally {
            this.closeConnection();
        }
    }

    public boolean hasRepositoryUUID() {
        return this.myRepositoryUUID != null;
    }

    public void setRepositoryUUID(String uuid) {
        this.myRepositoryUUID = uuid;
    }

    public boolean hasRepositoryRoot() {
        return this.myRepositoryRoot != null;
    }

    public void setRepositoryRoot(SVNURL root) {
        this.myRepositoryRoot = root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNURL getRepositoryRoot(boolean forceConnection) throws SVNException {
        if (this.myRepositoryRoot != null && !forceConnection) {
            return this.myRepositoryRoot;
        }
        if (this.myRepositoryRoot == null) {
            try {
                this.openConnection();
                this.myConnection.fetchRepositoryRoot(this);
            }
            finally {
                this.closeConnection();
            }
        }
        return this.myRepositoryRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRepositoryUUID(boolean forceConnection) throws SVNException {
        if (this.myRepositoryUUID != null && !forceConnection) {
            return this.myRepositoryUUID;
        }
        if (this.myRepositoryUUID == null) {
            try {
                this.openConnection();
                this.myConnection.fetchRepositoryUUID(this);
            }
            finally {
                this.closeConnection();
            }
        }
        return this.myRepositoryUUID;
    }

    public void setSpoolResponse(boolean spool) {
        this.myIsSpoolResponse = spool;
        if (this.myConnection != null) {
            this.myConnection.setReportResponseSpooled(spool);
        }
    }

    public boolean isSpoolResponse() {
        return this.myIsSpoolResponse;
    }

    public void setAuthenticationManager(ISVNAuthenticationManager authManager) {
        if (authManager != this.getAuthenticationManager() && this.myConnection != null) {
            this.myConnection.clearAuthenticationCache();
        }
        super.setAuthenticationManager(authManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLatestRevision() throws SVNException {
        try {
            this.openConnection();
            String path = this.getLocation().getPath();
            path = SVNEncodingUtil.uriEncode(path);
            DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this, path, -1L, false, true, null);
            long l = info.revision;
            return l;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDatedRevision(Date date) throws SVNException {
        date = date == null ? new Date(System.currentTimeMillis()) : date;
        DAVDateRevisionHandler handler = new DAVDateRevisionHandler();
        StringBuffer request = DAVDateRevisionHandler.generateDateRevisionRequest(null, date);
        try {
            this.openConnection();
            String path = this.getLocation().getURIEncodedPath();
            path = DAVUtil.getVCCPath(this.myConnection, this, path);
            HTTPStatus status = this.myConnection.doReport(path, request, handler);
            if (status.getError() != null) {
                if (status.getError().getErrorCode() == SVNErrorCode.UNSUPPORTED_FEATURE) {
                    SVNErrorMessage err2 = SVNErrorMessage.create(status.getError().getErrorCode(), "Server does not support date-based operations");
                    SVNErrorManager.error(err2, status.getError(), SVNLogType.NETWORK);
                }
                SVNErrorManager.error(status.getError(), SVNLogType.NETWORK);
            }
        }
        finally {
            this.closeConnection();
        }
        return handler.getRevisionNumber();
    }

    public SVNNodeKind checkPath(String path, long revision) throws SVNException {
        DAVBaselineInfo info = null;
        SVNNodeKind kind = SVNNodeKind.NONE;
        try {
            this.openConnection();
            path = this.doGetFullPath(path);
            path = SVNEncodingUtil.uriEncode(path);
            info = DAVUtil.getBaselineInfo(this.myConnection, this, path, revision, true, false, info);
            kind = info.isDirectory ? SVNNodeKind.DIR : SVNNodeKind.FILE;
        }
        catch (SVNException e) {
            for (SVNErrorMessage error = e.getErrorMessage(); error != null; error = error.getChildErrorMessage()) {
                if (error.getErrorCode() != SVNErrorCode.FS_NOT_FOUND) continue;
                SVNNodeKind sVNNodeKind = kind;
                return sVNNodeKind;
            }
            throw e;
        }
        finally {
            this.closeConnection();
        }
        return kind;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNProperties getRevisionProperties(long revision, SVNProperties properties) throws SVNException {
        properties = properties == null ? new SVNProperties() : properties;
        try {
            this.openConnection();
            String path = this.getLocation().getPath();
            path = SVNEncodingUtil.uriEncode(path);
            DAVProperties source = DAVUtil.getBaselineProperties(this.myConnection, this, path, revision, null);
            properties = DAVUtil.filterProperties(source, properties);
            if (revision >= 0L) {
                String commitMessage = properties.getStringValue("svn:log");
                this.getOptions().saveCommitMessage(this, revision, commitMessage);
            }
        }
        finally {
            this.closeConnection();
        }
        return properties;
    }

    public SVNPropertyValue getRevisionPropertyValue(long revision, String propertyName) throws SVNException {
        SVNProperties properties = this.getRevisionProperties(revision, null);
        return properties.getSVNPropertyValue(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFile(String path, long revision, SVNProperties properties, OutputStream contents) throws SVNException {
        long fileRevision = revision;
        try {
            this.openConnection();
            path = this.doGetFullPath(path);
            path = SVNEncodingUtil.uriEncode(path);
            if (revision != -2L) {
                DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this, path, revision, false, true, null);
                path = SVNPathUtil.append(info.baselineBase, info.baselinePath);
                fileRevision = info.revision;
            }
            if (properties != null) {
                DAVProperties props = DAVUtil.getResourceProperties(this.myConnection, path, null, null);
                DAVUtil.filterProperties(props, properties);
                Iterator names = props.getProperties().keySet().iterator();
                while (names.hasNext()) {
                    DAVElement property = (DAVElement)names.next();
                    DAVUtil.setSpecialWCProperties(properties, property, props.getPropertyValue(property));
                }
                if (fileRevision >= 0L) {
                    properties.put("svn:entry:revision", Long.toString(fileRevision));
                }
            }
            if (contents != null) {
                this.myConnection.doGet(path, contents);
            }
        }
        finally {
            this.closeConnection();
        }
        return fileRevision;
    }

    public long getDir(String path, long revision, SVNProperties properties, ISVNDirEntryHandler handler) throws SVNException {
        return this.getDir(path, revision, properties, -1, handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getDir(String path, long revision, SVNProperties properties, int entryFields, ISVNDirEntryHandler handler) throws SVNException {
        long dirRevision = revision;
        try {
            DAVProperties deadProp;
            boolean supportsDeadPropCount;
            this.openConnection();
            path = this.doGetFullPath(path);
            String fullPath = path = SVNEncodingUtil.uriEncode(path);
            if (revision != -2L) {
                DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this, path, revision, false, true, null);
                path = SVNPathUtil.append(info.baselineBase, info.baselinePath);
                dirRevision = info.revision;
            }
            boolean bl = supportsDeadPropCount = (deadProp = DAVUtil.getResourceProperties(this.myConnection, path, null, new DAVElement[]{DAVElement.DEADPROP_COUNT})) != null && deadProp.getPropertyValue(DAVElement.DEADPROP_COUNT) != null;
            if (handler != null) {
                DAVElement[] whichProps = null;
                if ((entryFields & 4) == 0 || supportsDeadPropCount) {
                    LinkedList<DAVElement> individualProps = new LinkedList<DAVElement>();
                    if ((entryFields & 1) != 0) {
                        individualProps.add(DAVElement.RESOURCE_TYPE);
                    }
                    if ((entryFields & 2) != 0) {
                        individualProps.add(DAVElement.GET_CONTENT_LENGTH);
                    }
                    if ((entryFields & 4) != 0) {
                        individualProps.add(DAVElement.DEADPROP_COUNT);
                    }
                    if ((entryFields & 8) != 0) {
                        individualProps.add(DAVElement.VERSION_NAME);
                    }
                    if ((entryFields & 0x10) != 0) {
                        individualProps.add(DAVElement.CREATION_DATE);
                    }
                    if ((entryFields & 0x20) != 0) {
                        individualProps.add(DAVElement.CREATOR_DISPLAY_NAME);
                    }
                    whichProps = individualProps.toArray(new DAVElement[individualProps.size()]);
                }
                int parentPathSegments = SVNPathUtil.getSegmentsCount(path);
                SVNHashMap dirEntsMap = new SVNHashMap();
                HTTPStatus status = DAVUtil.getProperties(this.myConnection, path, DAVUtil.DEPTH_ONE, null, whichProps, dirEntsMap);
                if (status.getError() != null) {
                    SVNErrorManager.error(status.getError(), SVNLogType.NETWORK);
                }
                if (!this.hasRepositoryRoot()) {
                    this.myConnection.fetchRepositoryRoot(this);
                }
                SVNURL repositryRoot = this.getRepositoryRoot(false);
                Iterator dirEnts = dirEntsMap.keySet().iterator();
                while (dirEnts.hasNext()) {
                    SVNPropertyValue dateValue;
                    SVNPropertyValue sizeValue;
                    String url = (String)dirEnts.next();
                    DAVProperties child = (DAVProperties)dirEntsMap.get(url);
                    String href = child.getURL();
                    if (parentPathSegments == SVNPathUtil.getSegmentsCount(href)) continue;
                    String name = SVNEncodingUtil.uriDecode(SVNPathUtil.tail(href));
                    SVNNodeKind kind = SVNNodeKind.UNKNOWN;
                    if ((entryFields & 1) != 0) {
                        kind = child.isCollection() ? SVNNodeKind.DIR : SVNNodeKind.FILE;
                    }
                    long size = 0L;
                    if ((entryFields & 2) != 0 && (sizeValue = child.getPropertyValue(DAVElement.GET_CONTENT_LENGTH)) != null) {
                        size = Long.parseLong(sizeValue.getString());
                    }
                    boolean hasProperties = false;
                    if ((entryFields & 4) != 0) {
                        if (supportsDeadPropCount) {
                            SVNPropertyValue propVal = child.getPropertyValue(DAVElement.DEADPROP_COUNT);
                            if (propVal == null) {
                                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.INCOMPLETE_DATA, "Server response missing the expected deadprop-count property");
                                SVNErrorManager.error(err, SVNLogType.NETWORK);
                            } else {
                                long propCount = Long.parseLong(propVal.getString());
                                hasProperties = propCount > 0L;
                            }
                        } else {
                            Iterator props = child.getProperties().keySet().iterator();
                            while (props.hasNext()) {
                                DAVElement property = (DAVElement)props.next();
                                if (!"http://subversion.tigris.org/xmlns/custom/".equals(property.getNamespace()) && !"http://subversion.tigris.org/xmlns/svn/".equals(property.getNamespace())) continue;
                                hasProperties = true;
                                break;
                            }
                        }
                    }
                    long lastRevision = -1L;
                    if ((entryFields & 8) != 0) {
                        SVNPropertyValue revisionStr = child.getPropertyValue(DAVElement.VERSION_NAME);
                        try {
                            lastRevision = Long.parseLong(((Object)revisionStr).toString());
                        }
                        catch (NumberFormatException nfe) {
                            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_MALFORMED_DATA);
                            SVNErrorManager.error(err, SVNLogType.NETWORK);
                        }
                    }
                    SVNDate date = null;
                    if ((entryFields & 0x10) != 0 && (dateValue = child.getPropertyValue(DAVElement.CREATION_DATE)) != null) {
                        date = SVNDate.parseDate(dateValue.getString());
                    }
                    String author = null;
                    if ((entryFields & 0x20) != 0) {
                        SVNPropertyValue authorValue = child.getPropertyValue(DAVElement.CREATOR_DISPLAY_NAME);
                        author = authorValue == null ? null : authorValue.getString();
                    }
                    SVNURL childURL = this.getLocation().setPath(fullPath, true);
                    childURL = childURL.appendPath(name, false);
                    SVNDirEntry dirEntry = new SVNDirEntry(childURL, repositryRoot, name, kind, size, hasProperties, lastRevision, date, author);
                    handler.handleDirEntry(dirEntry);
                }
            }
            if (properties != null) {
                DAVProperties dirProps = DAVUtil.getResourceProperties(this.myConnection, path, null, null);
                DAVUtil.filterProperties(dirProps, properties);
                Iterator props = dirProps.getProperties().keySet().iterator();
                while (props.hasNext()) {
                    DAVElement property = (DAVElement)props.next();
                    DAVUtil.setSpecialWCProperties(properties, property, dirProps.getPropertyValue(property));
                }
            }
        }
        finally {
            this.closeConnection();
        }
        return dirRevision;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNDirEntry getDir(String path, long revision, boolean includeComments, Collection entries) throws SVNException {
        SVNDirEntry[] parent;
        block17: {
            parent = new SVNDirEntry[1];
            String[] parentVCC = new String[1];
            try {
                this.openConnection();
                path = this.doGetFullPath(path);
                String fullPath = path = SVNEncodingUtil.uriEncode(path);
                if (revision >= 0L) {
                    DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this, path, revision, false, true, null);
                    path = SVNPathUtil.append(info.baselineBase, info.baselinePath);
                }
                int parentPathSegments = SVNPathUtil.getSegmentsCount(path);
                ArrayList<SVNPropertyValue> vccs = new ArrayList<SVNPropertyValue>();
                DAVElement[] dirProperties = new DAVElement[]{DAVElement.VERSION_CONTROLLED_CONFIGURATION, DAVElement.VERSION_NAME, DAVElement.GET_CONTENT_LENGTH, DAVElement.RESOURCE_TYPE, DAVElement.CREATOR_DISPLAY_NAME, DAVElement.CREATION_DATE};
                SVNHashMap dirEntsMap = new SVNHashMap();
                HTTPStatus status = DAVUtil.getProperties(this.myConnection, path, DAVUtil.DEPTH_ONE, null, dirProperties, dirEntsMap);
                if (status.getError() != null) {
                    SVNErrorManager.error(status.getError(), SVNLogType.NETWORK);
                }
                Iterator dirEnts = dirEntsMap.keySet().iterator();
                while (dirEnts.hasNext()) {
                    SVNPropertyValue authorValue;
                    long size;
                    String url = (String)dirEnts.next();
                    DAVProperties child = (DAVProperties)dirEntsMap.get(url);
                    String href = child.getURL();
                    String name = "";
                    if (parentPathSegments != SVNPathUtil.getSegmentsCount(href)) {
                        name = SVNEncodingUtil.uriDecode(SVNPathUtil.tail(href));
                    }
                    SVNNodeKind kind = SVNNodeKind.FILE;
                    SVNPropertyValue revisionStr = child.getPropertyValue(DAVElement.VERSION_NAME);
                    long lastRevision = Long.parseLong(((Object)revisionStr).toString());
                    SVNPropertyValue sizeValue = child.getPropertyValue(DAVElement.GET_CONTENT_LENGTH);
                    long l = size = sizeValue == null ? 0L : Long.parseLong(sizeValue.getString());
                    if (child.isCollection()) {
                        kind = SVNNodeKind.DIR;
                    }
                    String author = (authorValue = child.getPropertyValue(DAVElement.CREATOR_DISPLAY_NAME)) == null ? null : authorValue.getString();
                    SVNPropertyValue dateValue = child.getPropertyValue(DAVElement.CREATION_DATE);
                    SVNDate date = dateValue != null ? SVNDate.parseDate(dateValue.getString()) : null;
                    this.myConnection.fetchRepositoryRoot(this);
                    SVNURL repositoryRoot = this.getRepositoryRoot(false);
                    SVNURL childURL = this.getLocation().setPath(fullPath, true);
                    if ("".equals(name)) {
                        parent[0] = new SVNDirEntry(childURL, repositoryRoot, name, kind, size, false, lastRevision, date, author);
                        SVNPropertyValue vcc = child.getPropertyValue(DAVElement.VERSION_CONTROLLED_CONFIGURATION);
                        parentVCC[0] = vcc == null ? null : vcc.getString();
                        continue;
                    }
                    childURL = childURL.appendPath(name, false);
                    if (entries != null) {
                        entries.add(new SVNDirEntry(childURL, repositoryRoot, name, kind, size, false, lastRevision, date, author));
                    }
                    vccs.add(child.getPropertyValue(DAVElement.VERSION_CONTROLLED_CONFIGURATION));
                }
                if (!includeComments) break block17;
                DAVElement logProperty = DAVElement.getElement("http://subversion.tigris.org/xmlns/svn/", "log");
                Iterator ents = entries != null ? entries.iterator() : null;
                SVNDirEntry entry = parent[0];
                String vcc = parentVCC[0];
                int index = 0;
                while (true) {
                    String label = Long.toString(entry.getRevision());
                    if (entry.getDate() != null && this.getOptions().hasCommitMessage(this, entry.getRevision())) {
                        String message = this.getOptions().getCommitMessage(this, entry.getRevision());
                        entry.setCommitMessage(message);
                    } else if (entry.getDate() != null) {
                        String commitMessage;
                        SVNDirEntry currentEntry;
                        block18: {
                            currentEntry = entry;
                            commitMessage = null;
                            try {
                                commitMessage = DAVUtil.getPropertyValue(this.myConnection, vcc, label, logProperty);
                            }
                            catch (SVNException e) {
                                if (e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_DAV_PROPS_NOT_FOUND) break block18;
                                throw e;
                            }
                        }
                        this.getOptions().saveCommitMessage(this, currentEntry.getRevision(), commitMessage);
                        currentEntry.setCommitMessage(commitMessage);
                    }
                    if (ents != null && ents.hasNext()) {
                        entry = (SVNDirEntry)ents.next();
                        vcc = (String)vccs.get(index);
                        ++index;
                        continue;
                    }
                    break;
                }
            }
            finally {
                this.closeConnection();
            }
        }
        return parent[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getFileRevisionsImpl(String path, long startRevision, long endRevision, boolean includeMergedRevisions, ISVNFileRevisionHandler handler) throws SVNException {
        String bcPath = this.getLocation().getPath();
        bcPath = SVNEncodingUtil.uriEncode(bcPath);
        try {
            SVNErrorMessage err;
            this.openConnection();
            path = "".equals(path) ? "" : this.doGetRepositoryPath(path);
            DAVFileRevisionHandler davHandler = new DAVFileRevisionHandler(handler);
            StringBuffer request = DAVFileRevisionHandler.generateFileRevisionsRequest(null, startRevision, endRevision, path, includeMergedRevisions);
            long revision = -1L;
            if (DAVRepository.isValidRevision(startRevision) && DAVRepository.isValidRevision(endRevision)) {
                revision = Math.max(startRevision, endRevision);
            }
            DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this, bcPath, revision, false, false, null);
            bcPath = SVNPathUtil.append(info.baselineBase, info.baselinePath);
            HTTPStatus status = this.myConnection.doReport(bcPath, request, davHandler);
            if (status.getCode() == 501) {
                err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "'get-file-revs' REPORT not implemented");
                SVNErrorManager.error(err, status.getError(), SVNLogType.NETWORK);
            } else if (status.getError() != null) {
                SVNErrorManager.error(status.getError(), SVNLogType.NETWORK);
            }
            if (davHandler.getEntriesCount() <= 0) {
                err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "The file-revs report didn't contain any revisions");
                SVNErrorManager.error(err, SVNLogType.NETWORK);
            }
            int n = davHandler.getEntriesCount();
            return n;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long logImpl(String[] targetPaths, long startRevision, long endRevision, boolean changedPath, boolean strictNode, long limit, boolean includeMergedRevisions, String[] revPropNames, final ISVNLogEntryHandler handler) throws SVNException {
        DAVLogHandler davHandler;
        block13: {
            if (targetPaths == null || targetPaths.length == 0) {
                targetPaths = new String[]{""};
            }
            davHandler = null;
            ISVNLogEntryHandler cachingHandler = new ISVNLogEntryHandler(){

                public void handleLogEntry(SVNLogEntry logEntry) throws SVNException {
                    if (logEntry.getDate() != null) {
                        DAVRepository.this.getOptions().saveCommitMessage(DAVRepository.this, logEntry.getRevision(), logEntry.getMessage());
                    }
                    if (handler != null) {
                        handler.handleLogEntry(logEntry);
                    }
                }
            };
            long latestRev = -1L;
            if (DAVRepository.isInvalidRevision(startRevision)) {
                startRevision = latestRev = this.getLatestRevision();
            }
            if (DAVRepository.isInvalidRevision(endRevision)) {
                endRevision = latestRev != -1L ? latestRev : this.getLatestRevision();
            }
            try {
                String capability;
                this.openConnection();
                String[] fullPaths = new String[targetPaths.length];
                for (int i = 0; i < targetPaths.length; ++i) {
                    fullPaths[i] = this.doGetFullPath(targetPaths[i]);
                }
                HashSet<String> relativePaths = new HashSet<String>();
                String path = SVNPathUtil.condencePaths(fullPaths, relativePaths, false);
                if (relativePaths.isEmpty()) {
                    relativePaths.add("");
                }
                fullPaths = relativePaths.toArray(new String[relativePaths.size()]);
                StringBuffer request = DAVLogHandler.generateLogRequest(null, startRevision, endRevision, changedPath, strictNode, includeMergedRevisions, revPropNames, limit, fullPaths);
                davHandler = new DAVLogHandler(cachingHandler, limit, revPropNames);
                if (davHandler.isWantCustomRevprops() && !"server-yes".equals(capability = this.myConnection.getCapabilityResponse(SVNCapability.LOG_REVPROPS)) && !"yes".equals(capability)) {
                    SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "Server does not support custom revprops via log");
                    SVNErrorManager.error(err, SVNLogType.NETWORK);
                }
                long revision = Math.max(startRevision, endRevision);
                path = SVNEncodingUtil.uriEncode(path);
                DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this, path, revision, false, false, null);
                path = SVNPathUtil.append(info.baselineBase, info.baselinePath);
                try {
                    HTTPStatus status = this.myConnection.doReport(path, request, davHandler);
                    if (status.getError() != null) {
                        SVNErrorManager.error(status.getError(), SVNLogType.NETWORK);
                    }
                }
                catch (SVNException e) {
                    if (e.getErrorMessage() != null && e.getErrorMessage().getErrorCode() == SVNErrorCode.UNKNOWN && davHandler.isCompatibleMode()) {
                        cachingHandler.handleLogEntry(SVNLogEntry.EMPTY_ENTRY);
                        break block13;
                    }
                    throw e;
                }
            }
            finally {
                this.closeConnection();
            }
        }
        return davHandler.getEntriesCount();
    }

    protected void openConnection() throws SVNException {
        this.lock();
        this.fireConnectionOpened();
        if (this.myConnection == null) {
            this.myConnection = new DAVConnection(this.myConnectionFactory, this);
            this.myConnection.setReportResponseSpooled(this.isSpoolResponse());
            this.myConnection.open(this);
        }
    }

    protected void closeConnection() {
        if (this.myConnection != null && !ourIsKeepCredentials) {
            this.myConnection.clearAuthenticationCache();
        }
        if (!this.getOptions().keepConnection(this)) {
            this.closeSession();
        }
        this.unlock();
        this.fireConnectionClosed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getLocationsImpl(String path, long pegRevision, long[] revisions, ISVNLocationEntryHandler handler) throws SVNException {
        try {
            this.openConnection();
            if (path.startsWith("/")) {
                this.myConnection.fetchRepositoryRoot(this);
                path = SVNPathUtil.append(this.myRepositoryRoot.getPath(), path);
                path = path.equals(this.getLocation().getPath()) ? "" : path.substring(this.getLocation().getPath().length() + 1);
            }
            StringBuffer request = DAVLocationsHandler.generateLocationsRequest(null, path, pegRevision, revisions);
            DAVLocationsHandler davHandler = new DAVLocationsHandler(handler);
            String root = this.getLocation().getPath();
            root = SVNEncodingUtil.uriEncode(root);
            DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this, root, pegRevision, false, false, null);
            path = SVNPathUtil.append(info.baselineBase, info.baselinePath);
            HTTPStatus status = this.myConnection.doReport(path, request, davHandler);
            if (status.getCode() == 501) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "'get-locations' REPORT not implemented");
                SVNErrorManager.error(err, status.getError(), SVNLogType.NETWORK);
            } else if (status.getError() != null) {
                SVNErrorManager.error(status.getError(), SVNLogType.NETWORK);
            }
            int n = davHandler.getEntriesCount();
            return n;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getLocationSegmentsImpl(String path, long pegRevision, long startRevision, long endRevision, ISVNLocationSegmentHandler handler) throws SVNException {
        try {
            this.openConnection();
            boolean absolutePath = path.startsWith("/");
            if (absolutePath) {
                this.myConnection.fetchRepositoryRoot(this);
                path = SVNPathUtil.append(this.myRepositoryRoot.getPath(), path);
                path = path.equals(this.getLocation().getPath()) ? "" : path.substring(this.myRepositoryRoot.getPath().length() + 1);
            }
            StringBuffer request = DAVLocationSegmentsHandler.generateGetLocationSegmentsRequest(null, path, pegRevision, startRevision, endRevision);
            DAVLocationSegmentsHandler davHandler = new DAVLocationSegmentsHandler(handler);
            String root = absolutePath ? this.myRepositoryRoot.getPath() : this.getLocation().getPath();
            root = SVNEncodingUtil.uriEncode(root);
            DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this, root, pegRevision, false, false, null);
            path = SVNPathUtil.append(info.baselineBase, info.baselinePath);
            HTTPStatus status = this.myConnection.doReport(path, request, davHandler);
            if (status.getCode() == 501) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "'get-location-segments' REPORT not implemented");
                SVNErrorManager.error(err, status.getError(), SVNLogType.NETWORK);
            } else if (status.getError() != null) {
                SVNErrorManager.error(status.getError(), SVNLogType.NETWORK);
            }
            long l = davHandler.getTotalRevisions();
            return l;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replay(long lowRevision, long highRevision, boolean sendDeltas, ISVNEditor editor) throws SVNException {
        try {
            this.openConnection();
            StringBuffer request = DAVReplayHandler.generateReplayRequest(highRevision, lowRevision, sendDeltas);
            DAVReplayHandler handler = new DAVReplayHandler(editor, true);
            String bcPath = SVNEncodingUtil.uriEncode(this.getLocation().getPath());
            HTTPStatus status = this.myConnection.doReport(bcPath, request, handler);
            if (status.getCode() == 501) {
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED, "'replay' REPORT not implemented");
                SVNErrorManager.error(err, status.getError(), SVNLogType.NETWORK);
            } else if (status.getError() != null) {
                SVNErrorManager.error(status.getError(), SVNLogType.NETWORK);
            }
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRevisionPropertyValue(long revision, String propertyName, SVNPropertyValue propertyValue) throws SVNException {
        DAVRepository.assertValidRevision(revision);
        StringBuffer request = DAVProppatchHandler.generatePropertyRequest(null, propertyName, propertyValue);
        try {
            this.openConnection();
            DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this, SVNEncodingUtil.uriEncode(this.getLocation().getPath()), revision, false, false, null);
            String path = SVNPathUtil.append(info.baselineBase, info.baselinePath);
            path = info.baseline;
            DAVProppatchHandler handler = new DAVProppatchHandler();
            SVNErrorMessage requestError = null;
            try {
                this.myConnection.doProppatch(null, path, request, handler, null);
            }
            catch (SVNException e) {
                requestError = e.getErrorMessage();
            }
            if (requestError != null || handler.getError() != null) {
                if (requestError != null) {
                    requestError.setChildErrorMessage(handler.getError());
                } else {
                    requestError = handler.getError();
                }
                SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_DAV_REQUEST_FAILED, "DAV request failed; it's possible that the repository's pre-revprop-change hook either failed or is non-existent");
                SVNErrorManager.error(err, requestError, SVNLogType.NETWORK);
            }
        }
        finally {
            this.closeConnection();
        }
    }

    public ISVNEditor getCommitEditor(String logMessage, Map locks, boolean keepLocks, ISVNWorkspaceMediator mediator) throws SVNException {
        return this.getCommitEditor(logMessage, locks, keepLocks, null, mediator);
    }

    protected ISVNEditor getCommitEditorInternal(Map locks, boolean keepLocks, SVNProperties revProps, ISVNWorkspaceMediator mediator) throws SVNException {
        try {
            this.openConnection();
            SVNHashMap translatedLocks = null;
            if (locks != null && !locks.isEmpty()) {
                translatedLocks = new SVNHashMap();
                this.myConnection.fetchRepositoryRoot(this);
                String root = this.myRepositoryRoot.getPath();
                root = SVNEncodingUtil.uriEncode(root);
                Iterator paths = locks.keySet().iterator();
                while (paths.hasNext()) {
                    String path = (String)paths.next();
                    String lock = (String)locks.get(path);
                    if (path.startsWith("/")) {
                        path = SVNPathUtil.append(root, SVNEncodingUtil.uriEncode(path));
                    } else {
                        path = this.doGetFullPath(path);
                        path = SVNEncodingUtil.uriEncode(path);
                    }
                    translatedLocks.put(path, lock);
                }
            }
            this.myConnection.setLocks(translatedLocks, keepLocks);
            return new DAVCommitEditor(this, this.myConnection, revProps, mediator, new Runnable(){

                public void run() {
                    DAVRepository.this.closeConnection();
                }
            });
        }
        catch (Throwable th) {
            this.closeConnection();
            if (th instanceof SVNException) {
                throw (SVNException)th;
            }
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.UNKNOWN, "can not get commit editor: ''{0}''", th.getLocalizedMessage());
            SVNErrorManager.error(err, th, SVNLogType.NETWORK);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNLock getLock(String path) throws SVNException {
        try {
            this.openConnection();
            path = this.doGetFullPath(path);
            path = SVNEncodingUtil.uriEncode(path);
            SVNLock sVNLock = this.myConnection.doGetLock(path, this);
            return sVNLock;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SVNLock[] getLocks(String path) throws SVNException {
        try {
            this.openConnection();
            path = this.doGetFullPath(path);
            path = SVNEncodingUtil.uriEncode(path);
            SVNLock[] sVNLockArray = this.myConnection.doGetLocks(path);
            return sVNLockArray;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Map pathsToRevisions, String comment, boolean force, ISVNLockHandler handler) throws SVNException {
        try {
            this.openConnection();
            Iterator paths = pathsToRevisions.keySet().iterator();
            while (paths.hasNext()) {
                SVNErrorMessage error;
                SVNLock lock;
                String repositoryPath;
                block7: {
                    String path = (String)paths.next();
                    Long revision = (Long)pathsToRevisions.get(path);
                    repositoryPath = this.doGetRepositoryPath(path);
                    path = this.doGetFullPath(path);
                    path = SVNEncodingUtil.uriEncode(path);
                    lock = null;
                    error = null;
                    long revisionNumber = revision != null ? revision : -1L;
                    try {
                        lock = this.myConnection.doLock(path, this, comment, force, revisionNumber);
                    }
                    catch (SVNException e) {
                        SVNErrorCode code;
                        error = null;
                        if (e.getErrorMessage() != null && ((code = e.getErrorMessage().getErrorCode()) == SVNErrorCode.FS_PATH_ALREADY_LOCKED || code == SVNErrorCode.FS_OUT_OF_DATE)) {
                            error = e.getErrorMessage();
                        }
                        if (error != null) break block7;
                        throw e;
                    }
                }
                if (handler == null) continue;
                handler.handleLock(repositoryPath, lock, error);
            }
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock(Map pathToTokens, boolean force, ISVNLockHandler handler) throws SVNException {
        try {
            this.openConnection();
            Iterator paths = pathToTokens.keySet().iterator();
            while (paths.hasNext()) {
                String path;
                String shortPath = path = (String)paths.next();
                String id = (String)pathToTokens.get(path);
                String repositoryPath = this.doGetRepositoryPath(path);
                path = this.doGetFullPath(path);
                path = SVNEncodingUtil.uriEncode(path);
                SVNErrorMessage error = null;
                try {
                    this.myConnection.doUnlock(path, this, id, force);
                    error = null;
                }
                catch (SVNException e) {
                    if (e.getErrorMessage() != null && e.getErrorMessage().getErrorCode() == SVNErrorCode.RA_NOT_LOCKED) {
                        error = e.getErrorMessage();
                        error = SVNErrorMessage.create(error.getErrorCode(), error.getMessageTemplate(), shortPath);
                    }
                    throw e;
                }
                if (handler == null) continue;
                handler.handleUnlock(repositoryPath, new SVNLock(path, id, null, null, null, null), error);
            }
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SVNDirEntry info(String path, long revision) throws SVNException {
        try {
            SVNHashMap propsMap;
            DAVElement[] elements;
            HTTPStatus status;
            this.openConnection();
            path = this.doGetFullPath(path);
            String fullPath = path = SVNEncodingUtil.uriEncode(path);
            if (revision >= 0L) {
                try {
                    DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this, path, revision, false, true, null);
                    path = SVNPathUtil.append(info.baselineBase, info.baselinePath);
                }
                catch (SVNException e) {
                    if (e.getErrorMessage() == null) throw e;
                    if (e.getErrorMessage().getErrorCode() != SVNErrorCode.FS_NOT_FOUND) throw e;
                    SVNDirEntry sVNDirEntry = null;
                    this.closeConnection();
                    return sVNDirEntry;
                }
            }
            if ((status = DAVUtil.getProperties(this.myConnection, path, 0, null, elements = null, propsMap = new SVNHashMap())).getError() != null) {
                if (status.getError().getErrorCode() == SVNErrorCode.FS_NOT_FOUND) {
                    SVNDirEntry sVNDirEntry = null;
                    return sVNDirEntry;
                }
                SVNErrorManager.error(status.getError(), SVNLogType.NETWORK);
            }
            if (propsMap.isEmpty()) return null;
            DAVProperties props = (DAVProperties)propsMap.values().iterator().next();
            SVNDirEntry sVNDirEntry = this.createDirEntry(fullPath, props);
            return sVNDirEntry;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeSession() {
        this.lock(true);
        try {
            if (this.myConnection != null) {
                this.myConnection.close();
                this.myConnection = null;
            }
        }
        finally {
            this.unlock();
        }
    }

    public String doGetFullPath(String relativeOrRepositoryPath) throws SVNException {
        String fullPath;
        if (relativeOrRepositoryPath == null) {
            return this.doGetFullPath("/");
        }
        if (relativeOrRepositoryPath.length() > 0 && relativeOrRepositoryPath.charAt(0) == '/') {
            this.myConnection.fetchRepositoryRoot(this);
            fullPath = SVNPathUtil.append(this.myRepositoryRoot.getPath(), relativeOrRepositoryPath);
        } else {
            fullPath = SVNPathUtil.append(this.getLocation().getPath(), relativeOrRepositoryPath);
        }
        if (!fullPath.startsWith("/")) {
            fullPath = "/" + fullPath;
        }
        return fullPath;
    }

    protected String doGetRepositoryPath(String relativePath) throws SVNException {
        if (relativePath == null) {
            return "/";
        }
        if (relativePath.length() > 0 && relativePath.charAt(0) == '/') {
            return relativePath;
        }
        String fullPath = SVNPathUtil.append(this.getLocation().getPath(), relativePath);
        this.myConnection.fetchRepositoryRoot(this);
        String repositoryPath = fullPath.substring(this.myRepositoryRoot.getPath().length());
        if ("".equals(repositoryPath)) {
            return "/";
        }
        return repositoryPath;
    }

    private SVNDirEntry createDirEntry(String fullPath, DAVProperties child) throws SVNException {
        SVNPropertyValue authorValue;
        long size;
        String href = child.getURL();
        href = SVNEncodingUtil.uriDecode(href);
        String name = SVNPathUtil.tail(href);
        SVNNodeKind kind = SVNNodeKind.FILE;
        SVNPropertyValue revisionStr = child.getPropertyValue(DAVElement.VERSION_NAME);
        long lastRevision = Long.parseLong(((Object)revisionStr).toString());
        SVNPropertyValue sizeValue = child.getPropertyValue(DAVElement.GET_CONTENT_LENGTH);
        long l = size = sizeValue == null ? 0L : Long.parseLong(sizeValue.getString());
        if (child.isCollection()) {
            kind = SVNNodeKind.DIR;
        }
        String author = (authorValue = child.getPropertyValue(DAVElement.CREATOR_DISPLAY_NAME)) == null ? null : authorValue.getString();
        SVNPropertyValue dateValue = child.getPropertyValue(DAVElement.CREATION_DATE);
        SVNDate date = dateValue != null ? SVNDate.parseDate(dateValue.getString()) : null;
        boolean hasProperties = false;
        Iterator props = child.getProperties().keySet().iterator();
        while (props.hasNext()) {
            DAVElement property = (DAVElement)props.next();
            if (!"http://subversion.tigris.org/xmlns/custom/".equals(property.getNamespace()) && !"http://subversion.tigris.org/xmlns/svn/".equals(property.getNamespace())) continue;
            hasProperties = true;
            break;
        }
        this.myConnection.fetchRepositoryRoot(this);
        SVNURL repositoryRoot = this.getRepositoryRoot(false);
        SVNURL url = this.getLocation().setPath(fullPath, true);
        return new SVNDirEntry(url, repositoryRoot, name, kind, size, hasProperties, lastRevision, date, author);
    }

    public void diff(SVNURL url, long targetRevision, long revision, String target, boolean ignoreAncestry, SVNDepth depth, boolean getContents, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        if (url == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL could not be NULL");
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        if (revision < 0L) {
            revision = targetRevision;
        }
        this.runReport(this.getLocation(), targetRevision, target, url.toString(), depth, ignoreAncestry, false, getContents, false, false, false, true, reporter, editor);
    }

    public void status(long revision, String target, SVNDepth depth, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        this.runReport(this.getLocation(), revision, target, null, depth, false, false, false, false, true, false, false, reporter, editor);
    }

    public void update(SVNURL url, long revision, String target, SVNDepth depth, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        if (url == null) {
            SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_ILLEGAL_URL, "URL could not be NULL");
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        this.runReport(this.getLocation(), revision, target, url.toString(), depth, true, false, true, false, true, true, false, reporter, editor);
    }

    public void update(long revision, String target, SVNDepth depth, boolean sendCopyFromArgs, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        this.runReport(this.getLocation(), revision, target, null, depth, false, false, true, sendCopyFromArgs, true, false, false, reporter, editor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasCapability(SVNCapability capability) throws SVNException {
        if (capability == SVNCapability.COMMIT_REVPROPS) {
            return true;
        }
        try {
            Serializable error;
            this.openConnection();
            String result = this.myConnection.getCapabilityResponse(capability);
            if ("server-yes".equals(result)) {
                if (capability == SVNCapability.MERGE_INFO) {
                    error = null;
                    try {
                        this.doGetMergeInfo(new String[]{""}, -1L, SVNMergeInfoInheritance.EXPLICIT, false);
                    }
                    catch (SVNException svne) {
                        error = svne;
                    }
                    if (error != null) {
                        if (((SVNException)error).getErrorMessage().getErrorCode() == SVNErrorCode.UNSUPPORTED_FEATURE) {
                            result = "no";
                        } else {
                            if (((SVNException)error).getErrorMessage().getErrorCode() != SVNErrorCode.FS_NOT_FOUND) throw error;
                            result = "yes";
                        }
                    } else {
                        result = "yes";
                    }
                    this.myConnection.setCapability(SVNCapability.MERGE_INFO, result);
                } else {
                    error = SVNErrorMessage.create(SVNErrorCode.UNKNOWN_CAPABILITY, "Don''t know how to handle ''{0}'' for capability ''{1}''", new Object[]{"server-yes", SVNCapability.MERGE_INFO});
                    SVNErrorManager.error((SVNErrorMessage)error, SVNLogType.NETWORK);
                }
            }
            if ("yes".equals(result)) {
                boolean error2 = true;
                return error2;
            }
            if ("no".equals(result)) {
                boolean error2 = false;
                return error2;
            }
            if (result == null) {
                error = SVNErrorMessage.create(SVNErrorCode.UNKNOWN_CAPABILITY, "Don''t know anything about capability ''{0}''", new Object[]{capability});
                SVNErrorManager.error((SVNErrorMessage)error, SVNLogType.NETWORK);
                return false;
            } else {
                SVNErrorManager.error(SVNErrorMessage.create(SVNErrorCode.RA_DAV_OPTIONS_REQ_FAILED, "Attempt to fetch capability ''{0}'' resulted in ''{1}''", new Object[]{capability, result}), SVNLogType.NETWORK);
            }
            return false;
        }
        finally {
            this.closeConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map getMergeInfoImpl(String[] paths, long revision, SVNMergeInfoInheritance inherit, boolean includeDescendants) throws SVNException {
        try {
            this.openConnection();
            Map map = this.doGetMergeInfo(paths, revision, inherit, includeDescendants);
            return map;
        }
        finally {
            this.closeConnection();
        }
    }

    protected void replayRangeImpl(long startRevision, long endRevision, long lowRevision, boolean sendDeltas, ISVNReplayHandler handler) throws SVNException {
        SVNErrorMessage err = SVNErrorMessage.create(SVNErrorCode.RA_NOT_IMPLEMENTED);
        SVNErrorManager.error(err, SVNLogType.NETWORK);
    }

    private Map doGetMergeInfo(String[] paths, long revision, SVNMergeInfoInheritance inherit, boolean includeDescendants) throws SVNException {
        Map mergeInfo;
        DAVMergeInfoHandler handler;
        StringBuffer request;
        HTTPStatus status;
        String path = this.doGetFullPath("");
        path = SVNEncodingUtil.uriEncode(path);
        DAVBaselineInfo info = DAVUtil.getBaselineInfo(this.myConnection, this, path, revision, false, true, null);
        path = SVNPathUtil.append(info.baselineBase, info.baselinePath);
        if (paths == null || paths.length == 0) {
            paths = new String[]{""};
        }
        if ((status = this.myConnection.doReport(path, request = DAVMergeInfoHandler.generateMergeInfoRequest(null, revision, paths, inherit, includeDescendants), handler = new DAVMergeInfoHandler())).getCode() == 501) {
            SVNErrorMessage err = status.getError() != null ? status.getError() : SVNErrorMessage.create(SVNErrorCode.UNSUPPORTED_FEATURE, "Server does not support mergeinfo");
            SVNErrorManager.error(err, SVNLogType.NETWORK);
        }
        if (status.getError() != null) {
            SVNErrorManager.error(status.getError(), SVNLogType.NETWORK);
        }
        if ((mergeInfo = handler.getMergeInfo()) == null) {
            return null;
        }
        HashMap mergeInfoWithPath = new HashMap();
        Iterator items = mergeInfo.entrySet().iterator();
        while (items.hasNext()) {
            Map.Entry item = items.next();
            String repositoryPath = this.doGetRepositoryPath((String)item.getKey());
            Object value = item.getValue();
            mergeInfoWithPath.put(repositoryPath, value);
        }
        return mergeInfoWithPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runReport(SVNURL url, long targetRevision, String target, String dstPath, SVNDepth depth, boolean ignoreAncestry, boolean resourceWalk, boolean fetchContents, boolean sendCopyFromArgs, boolean sendAll, boolean closeEditorOnException, boolean spool, ISVNReporterBaton reporter, ISVNEditor editor) throws SVNException {
        boolean serverSupportsDepth = this.hasCapability(SVNCapability.DEPTH);
        if (depth != SVNDepth.FILES && depth != SVNDepth.INFINITY && !serverSupportsDepth) {
            editor = SVNDepthFilterEditor.getDepthFilterEditor(depth, editor, target != null);
        }
        DAVEditorHandler handler = null;
        try {
            this.openConnection();
            SVNHashMap lockTokens = new SVNHashMap();
            StringBuffer request = DAVEditorHandler.generateEditorRequest(this.myConnection, null, url.toString(), targetRevision, target, dstPath, depth, lockTokens, ignoreAncestry, resourceWalk, fetchContents, sendCopyFromArgs, sendAll, reporter);
            handler = new DAVEditorHandler(this.myConnectionFactory, this, editor, lockTokens, fetchContents, target != null && !"".equals(target));
            String bcPath = SVNEncodingUtil.uriEncode(this.getLocation().getPath());
            try {
                bcPath = DAVUtil.getVCCPath(this.myConnection, this, bcPath);
            }
            catch (SVNException e) {
                if (closeEditorOnException) {
                    editor.closeEdit();
                }
                throw e;
            }
            HTTPStatus status = this.myConnection.doReport(bcPath, request, handler, spool);
            if (status.getError() != null) {
                SVNErrorManager.error(status.getError(), SVNLogType.NETWORK);
            }
            Object var23_22 = null;
            if (handler != null) {
                handler.closeConnection();
            }
            this.closeConnection();
        }
        catch (Throwable throwable) {
            Object var23_23 = null;
            if (handler != null) {
                handler.closeConnection();
            }
            this.closeConnection();
            throw throwable;
        }
    }
}

