/*
 * Decompiled with CFR 0.152.
 */
package daq;

import daq.ChannelHeader;
import daq.DaqEvent;
import daq.time_stamp;
import daq.ttf2_bpm_channel;
import daq.ttf2_bpm_s_channel;
import daq.ttf2_bpm_z_channel;
import daq.ttf2_clpintl_channel;
import daq.ttf2_gunintl_channel;
import daq.ttf2_image_ext_frame_head;
import daq.ttf2_image_frame_head;
import daq.ttf2_mcp_channel;
import daq.ttf2_name_value_block;
import daq.ttf2_name_value_channel;
import daq.ttf2_name_value_string_block;
import daq.ttf2_name_value_string_channel;
import daq.ttf2_norm_bpm_block;
import daq.ttf2_norm_bpm_s_block;
import daq.ttf2_norm_bpm_single_block;
import daq.ttf2_norm_bpm_toroid_block;
import daq.ttf2_norm_bpm_z_block;
import daq.ttf2_norm_clpintl_block;
import daq.ttf2_norm_gunintl_block;
import daq.ttf2_norm_mcp_block;
import daq.ttf2_norm_rf_block;
import daq.ttf2_rf_channel;
import daq.ttf2_upd_data_block;
import daq.ttf2_ws_channel;
import daq.ttf2_ws_ws_block;
import java.nio.ByteBuffer;

public class EventUtil {
    public static final int TTF2_RAW_START = 1210767704;
    public static final String TTF2_TIME_SEP = "T";
    public static final String TTF2_ISO_FORMAT = "%Y%m%dT%H%M%S";
    public static final String TTF2_ISO_FORMAT2 = "%Y-%m-%dT%H:%M:%S";
    public static final int TTF2_ISO_TIME_LENGTH = 15;
    public static final String TTF2_DAQ_SLOW_SUBHEAD_NAME = "DAQ_SERVER_SLOW";
    public static int[] event_struct_type = new int[]{2, 1, 2, 2, 2, 2, 1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};

    public void EventUtil() {
    }

    public boolean ttf2_time_stamp_eq(time_stamp time_stamp2, time_stamp time_stamp3) {
        return time_stamp2.timeup == time_stamp3.timeup && time_stamp2.timelow == time_stamp3.timelow;
    }

    public boolean ttf2_time_stamp_eq(time_stamp time_stamp2, time_stamp time_stamp3, double d, int n, double d2) {
        double d3 = (double)time_stamp2.timeup * 1000000.0 + (double)time_stamp2.timelow;
        double d4 = (double)time_stamp3.timeup * 1000000.0 + (double)time_stamp3.timelow;
        if (Math.abs(d3 - d4) <= d) {
            if (n != 0) {
                n = 0;
            }
            return true;
        }
        if (n != 0) {
            n = d3 < d4 ? -1 : 1;
        }
        if (d2 != 0.0) {
            d2 = Math.abs(d3 - d4);
        }
        return false;
    }

    int get_event_struct_type(int n) {
        if (n < 0 || n >= 32) {
            return 0;
        }
        return event_struct_type[n];
    }

    public int get_channel_number(int n) {
        int n2 = n & 0xFFFF;
        if (n2 < 1 || n2 >= 32) {
            return -2;
        }
        return Integer.parseInt(DaqEvent.sblock_types_a[n2][1]);
    }

    String get_branch_name(int n) {
        int n2 = n & 0xFFFF;
        switch (n2) {
            case 0: {
                return "EventHeader";
            }
            case 32: {
                return "ServerBlockHeader";
            }
        }
        if (this.get_channel_number(n2) < 0) {
            return "UNKNOWN";
        }
        if (n2 < 1 || n2 >= 32) {
            return "UNKNOWN";
        }
        return DaqEvent.sblock_types_a[n2][2];
    }

    public String get_branch_class(int n) {
        int n2 = n & 0xFFFF;
        switch (n2) {
            case 0: {
                return "TTFEventHeader";
            }
            case 32: {
                return "TTFSvrBlockHeaderArray";
            }
        }
        if (this.get_channel_number(n2) < 0) {
            return "UNKNOWN";
        }
        if (n2 < 1 || n2 >= 32) {
            return "UNKNOWN";
        }
        return DaqEvent.sblock_types_a[n2][3];
    }

    public String get_chan_name(int n, int n2) {
        int n3 = n & 0xFFFF;
        if (n3 < 1 || n3 >= 32) {
            return "UNKNOWN";
        }
        int n4 = this.get_channel_number(n3);
        if (n4 < 0 || n4 <= n2) {
            return "UNKNOWN";
        }
        return DaqEvent.sblock_types_a[n3][4 + n2 * 3 + 0];
    }

    public String get_chan_units(int n, int n2) {
        int n3 = n & 0xFFFF;
        if (n3 < 1 || n3 >= 32) {
            return "UNKNOWN";
        }
        int n4 = this.get_channel_number(n3);
        if (n4 < 0 || n4 <= n2) {
            return "UNKNOWN";
        }
        int n5 = 4 + n2 * 3 + 1;
        return DaqEvent.sblock_types_a[n3][n5];
    }

    public String get_chan_descr(int n, int n2) {
        int n3 = n & 0xFFFF;
        if (n3 < 1 || n3 >= 32) {
            return "UNKNOWN";
        }
        int n4 = this.get_channel_number(n3);
        if (n4 < 0 || n4 <= n2) {
            return "UNKNOWN";
        }
        int n5 = 4 + n2 * 3 + 2;
        return DaqEvent.sblock_types_a[n3][n5];
    }

    public int find_default_data_type(String string, String string2) {
        if (string == null) {
            return 0;
        }
        if (string.startsWith("ML")) {
            return 9;
        }
        if (string.equals("LLRF")) {
            return 11;
        }
        if (string.equals("BPM")) {
            if (string2 != null && string2.indexOf("CAV") != -1) {
                return 8;
            }
            return 6;
        }
        if (string.equals("BLM")) {
            return 9;
        }
        if (string.equals("TOROID")) {
            return 10;
        }
        if (string.equals("IMAGE")) {
            return 13;
        }
        if (string.equals("IMAGE_EXT")) {
            return 27;
        }
        if (string.equals("WIRESCAN")) {
            return 15;
        }
        if (string.equals("CPL.ADC")) {
            return 16;
        }
        if (string.equals("PHASE_MON")) {
            return 19;
        }
        if (string.equals("MCP.ADC")) {
            return 18;
        }
        if (string.equals("GMD.ADC")) {
            return 17;
        }
        if (string.equals("WSS.RAW")) {
            return 20;
        }
        if (string.equals("WSS.COR")) {
            return 21;
        }
        if (string.equals("WSS.SET")) {
            return 22;
        }
        if (string.equals("WSS.RES")) {
            return 22;
        }
        if (string.equals("WSS.STR_SET")) {
            return 23;
        }
        if (string.equals("WSS.STR_RES")) {
            return 23;
        }
        if (string.equals("PG1.ADC")) {
            return 9;
        }
        if (string.equals("PG2.ADC")) {
            return 9;
        }
        if (string.equals("PG0.ADC")) {
            return 9;
        }
        if (string.equals("BL1.ADC")) {
            return 9;
        }
        if (string.equals("BL2.ADC")) {
            return 9;
        }
        if (string.equals("BL3.ADC")) {
            return 9;
        }
        return 0;
    }

    public boolean if_ndata_the_same(ChannelHeader channelHeader) {
        if (channelHeader == null) {
            return false;
        }
        switch (channelHeader.dtype & 0xFFFF) {
            case 24: 
            case 25: 
            case 26: {
                return false;
            }
        }
        return true;
    }

    public int get_sizeof_struct_no_data(int n) {
        switch (n & 0xFFFF) {
            case 1: 
            case 4: 
            case 5: {
                return ttf2_upd_data_block.get_size_nodata();
            }
            case 6: {
                return ttf2_norm_bpm_block.get_size_nodata();
            }
            case 7: {
                return ttf2_norm_bpm_z_block.get_size_nodata();
            }
            case 8: {
                return ttf2_norm_bpm_s_block.get_size_nodata();
            }
            case 9: {
                return ttf2_norm_bpm_single_block.get_size_nodata();
            }
            case 10: {
                return ttf2_norm_bpm_toroid_block.get_size_nodata();
            }
            case 11: {
                return ttf2_norm_rf_block.get_size_nodata();
            }
            case 13: {
                return ttf2_image_frame_head.get_size_nodata();
            }
            case 27: {
                return ttf2_image_ext_frame_head.get_size_nodata();
            }
            case 14: {
                return ttf2_ws_ws_block.get_size_nodata();
            }
            case 15: {
                return ttf2_ws_ws_block.get_size_nodata();
            }
            case 16: {
                return ttf2_norm_clpintl_block.get_size_nodata();
            }
            case 17: {
                return ttf2_norm_gunintl_block.get_size_nodata();
            }
            case 18: {
                return ttf2_norm_mcp_block.get_size_nodata();
            }
            case 20: {
                return ttf2_ws_ws_block.get_size_nodata();
            }
            case 21: {
                return ttf2_ws_ws_block.get_size_nodata();
            }
            case 22: {
                return ttf2_name_value_block.get_size_nodata();
            }
            case 23: {
                return ttf2_name_value_string_block.get_size_nodata();
            }
        }
        System.out.println("Unknown data type: " + Integer.toString(n & 0xFFFF));
        return -1;
    }

    public int get_sizeof_struct_data(int n, int n2, int n3, int n4) {
        int n5 = n & 0xFFFF;
        switch (n5) {
            case 1: 
            case 4: 
            case 5: {
                return this.get_sizeof_struct_no_data(n5) * n2;
            }
            case 6: {
                return this.get_sizeof_struct_no_data(n5) + n2 * ttf2_bpm_channel.get_size_nodata();
            }
            case 7: {
                return this.get_sizeof_struct_no_data(n5) + n2 * ttf2_bpm_z_channel.get_size_nodata();
            }
            case 8: {
                return this.get_sizeof_struct_no_data(n5) + n2 * ttf2_bpm_s_channel.get_size_nodata();
            }
            case 9: {
                return this.get_sizeof_struct_no_data(n5) + n2 * 4;
            }
            case 10: {
                return this.get_sizeof_struct_no_data(n5) + n2 * 4;
            }
            case 11: {
                return this.get_sizeof_struct_no_data(n5) + n2 * ttf2_rf_channel.get_size_nodata();
            }
            case 13: {
                return this.get_sizeof_struct_no_data(n5) + n2 * 2;
            }
            case 27: {
                return this.get_sizeof_struct_no_data(n5) + n2 * 2;
            }
            case 14: {
                return this.get_sizeof_struct_no_data(n5) + n2 * ttf2_ws_channel.get_size_nodata();
            }
            case 15: {
                return this.get_sizeof_struct_no_data(n5) + n2 * ttf2_ws_channel.get_size_nodata();
            }
            case 16: {
                return this.get_sizeof_struct_no_data(n5) + n2 * ttf2_clpintl_channel.get_size_nodata();
            }
            case 17: {
                return this.get_sizeof_struct_no_data(n5) + n2 * ttf2_gunintl_channel.get_size_nodata();
            }
            case 18: {
                return this.get_sizeof_struct_no_data(n5) + n2 * ttf2_mcp_channel.get_size_nodata();
            }
            case 20: {
                return this.get_sizeof_struct_no_data(n5) + n2 * ttf2_ws_channel.get_size_nodata();
            }
            case 21: {
                return this.get_sizeof_struct_no_data(n5) + n2 * ttf2_ws_channel.get_size_nodata();
            }
            case 22: {
                return this.get_sizeof_struct_no_data(n5) + n2 * ttf2_name_value_channel.get_size_nodata();
            }
            case 23: {
                return this.get_sizeof_struct_no_data(n5) + n2 * ttf2_name_value_string_channel.get_size_nodata();
            }
        }
        System.out.println("Unknown data type: " + Integer.toString(n5));
        return -1;
    }

    public boolean get_spect_params_for_data_type(ByteBuffer byteBuffer, ChannelHeader channelHeader, float f, float f2, Object object, int n, int n2) {
        if (n2 < 0) {
            return true;
        }
        if (channelHeader == null) {
            return true;
        }
        if ((channelHeader.error & 0x40000000) == 1) {
            System.out.println("get_spect_params_for_data_type() trying to access ZIPPED channel\n");
            return true;
        }
        int n3 = channelHeader.dtype & 0xFFFF;
        switch (n3) {
            default: 
        }
        return true;
    }

    public float[] get_pointer_to_data(byte[] byArray, ChannelHeader channelHeader, int n) {
        return null;
    }

    public int get_number_of_upd_channels(ChannelHeader channelHeader) {
        if (channelHeader == null) {
            return 0;
        }
        if ((channelHeader.error & 0x40000000) != 0) {
            System.out.println("get_number_of_upd_channels() trying to access ZIPPED channel");
            return 0;
        }
        int n = channelHeader.dtype & 0xFFFF;
        if (n == 1 || n == 4 || n == 5) {
            float f;
            ttf2_upd_data_block ttf2_upd_data_block2 = new ttf2_upd_data_block();
            int n2 = ttf2_upd_data_block2.get_size_nodata();
            int n3 = ttf2_upd_data_block2.get_size_data();
            int n4 = channelHeader.ldata - channelHeader.size();
            int n5 = n4 / (n2 + n3);
            if ((float)n5 == (f = (float)n4 / (float)(n2 + n3))) {
                return n5;
            }
            System.out.println("get_number_of_upd_channels() corrupted data !!!");
        }
        return 0;
    }

    public boolean get_update_params(ChannelHeader channelHeader, int n, String string, int n2, time_stamp time_stamp2, float f) {
        return false;
    }

    public int get_data_structure_type(int n) {
        switch (n & 0xFFFF) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return 103;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 26: {
                return 1013;
            }
            case 13: {
                return 22;
            }
            case 27: {
                return 22;
            }
            case 23: {
                return 103;
            }
            case 22: {
                return 16;
            }
        }
        return -1;
    }

    public static class ttf_daq_struct_type {
        static final int TTF2_DATA_SPECTRUM = 1013;
        static final int TTF2_DATA_IMAGE = 22;
        static final int TTF2_DATA_IMAGE_EXT = 22;
        static final int TTF2_DATA_SLOW = 103;
        static final int TTF2_DATA_NAMVAL = 16;
    }

    public static class sb_types2 {
        static final int TTF2_SB_TYPE_CHAN = 0;
        static final int TTF2_SB_TYPE_UNITS = 1;
        static final int TTF2_SB_TYPE_DESCR = 2;
        static final int TTF2_SB_TYPE_CHAN_MAX = 3;
    }

    public static class sb_types {
        static final int TTF2_SB_TYPE_NAME = 0;
        static final int TTF2_SB_TYPE_CHANNELS = 1;
        static final int TTF2_SB_TYPE_BRANCH_NAME = 2;
        static final int TTF2_SB_TYPE_BRANCH_CLASS = 3;
        static final int TTF2_SB_TYPE_MAX = 4;
    }

    public static class field_types {
        static final int TTF2_FIELD_EV_TYPE = 0;
        static final int TTF2_FIELD_TREE_NAME = 1;
        static final int TTF2_FIELD_TREE_COMMENT = 2;
        static final int TTF2_FIELD_TREE_MAX = 3;
    }

    public static class glob_ev_mode {
        static final int TTF2_GLOB_MODE_REAL = 0;
        static final int TTF2_GLOB_MODE_TEST = 1;
        static final int TTF2_GLOB_MODE_MAX = 2;
    }

    public static class TTF2_EV_STRUCT_TYPE {
        static final int TTF2_EV_STRUCT_UNKNOWN = 0;
        static final int TTF2_EV_STRUCT_LOCAL = 1;
        static final int TTF2_EV_STRUCT_GLOBAL = 2;
        static final int TTF2_EV_STRUCT_ML = 3;
        static final int TTF2_EV_STRUCT_UNDEF = 4;
    }
}

