/*
 * Decompiled with CFR 0.152.
 */
package daq;

import daq.EqDataCacheEntry;
import daq.time_stamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EqDataCacheRecord {
    public time_stamp time;
    public int event_number;
    public int flags = 0;
    public Vector<EqDataCacheEntry> entry = new Vector();

    public EqDataCacheRecord() {
        this.time = new time_stamp();
    }

    public time_stamp get_time() {
        return this.time;
    }

    public String get_time_string() {
        Date date = new Date((long)this.time.timeup * 1000L + (long)(this.time.timelow / 1000));
        String string = "dd-MMM-yyyy";
        String string2 = " HH:mm:ss.SSS";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(string);
        SimpleDateFormat simpleDateFormat2 = new SimpleDateFormat(string2);
        return new String("" + simpleDateFormat.format(date) + " " + simpleDateFormat2.format(date));
    }

    public int get_evtnum() {
        return this.event_number;
    }

    public Vector<EqDataCacheEntry> get_entry_vector() {
        return this.entry;
    }

    public int size() {
        return this.entry.size();
    }

    public void print() {
        System.out.println("Cache Record:" + this.time.timeup + ":" + this.time.timelow + "_" + this.event_number + "flags:" + this.flags);
        if (!this.entry.isEmpty()) {
            for (int i = 0; i < this.entry.size(); ++i) {
                EqDataCacheEntry eqDataCacheEntry = this.entry.elementAt(i);
                System.out.print("Entry:" + i);
                eqDataCacheEntry.print();
            }
        }
    }
}

