/*
 * Decompiled with CFR 0.152.
 */
package daq;

import daq.ChannelHeader;
import daq.EqDataCacheEntry;
import daq.EqDataCacheRecord;
import daq.EqDataDtype;
import daq.EventHeader;
import daq.EventUtil;
import daq.SBHeader;
import daq.spectr_block;
import daq.time_stamp;
import daq.ttf2_bpm_channel;
import daq.ttf2_bpm_s_channel;
import daq.ttf2_bpm_z_channel;
import daq.ttf2_clpintl_channel;
import daq.ttf2_gunintl_channel;
import daq.ttf2_mcp_channel;
import daq.ttf2_name_value_block;
import daq.ttf2_name_value_channel;
import daq.ttf2_rf_channel;
import daq.ttf2_ws_channel;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import ttf.doocs.clnt.EqData;
import ttf.doocs.clnt.IMAGE;
import ttf.doocs.clnt.IMH;
import ttf.doocs.clnt.SPECTRUM;
import ttf.doocs.clnt.time_t;
import ttf.doocs.clnt.u_char;

public class EqDataCache {
    static final int EQCACHE_FIND_TIME = 512;
    static final int EQCACHE_FIND_EVNUM = 1024;
    static final int EQCACHE_FIND_NOTSEEN = 2048;
    static final int EQCACHE_FLAG_SEEN = 1;
    static final int EQCACHE_OK = 0;
    static final int EQCACHE_ERROR_EMPTY = -1;
    static final int EQCACHE_ERROR_PARAM = -2;
    static final int EQCACHE_ERROR_NEW = -3;
    static final int EQCACHE_ERROR_WEIRD = -4;
    public static int UINT_MAX = Integer.MAX_VALUE;
    public static long ULONG_MAX = Long.MAX_VALUE;
    public static double DAQ_DATA_TIME_LOW_SCALE = 1000000.0;
    static final double EQCACHE_MAX_TIME_DIFF = 101000.0;
    static boolean NO_EQDATA = false;
    public static int TS_SPECTRUM_LENGTH = 128;
    public Vector<EqDataCacheRecord> cache = null;
    private int depth;
    public double max_time_diff;
    private ReentrantLock lock = new ReentrantLock();

    public EqDataCache() {
        this.depth = 300;
        NO_EQDATA = false;
        this.max_time_diff = 101000.0;
        this.cache = new Vector();
    }

    public EqDataCache(int n) {
        this.depth = n;
        NO_EQDATA = false;
        this.max_time_diff = 101000.0;
        try {
            this.cache = new Vector();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("cache couldn't be created, reason: " + illegalArgumentException.toString());
        }
    }

    public EqDataCache(int n, boolean bl) {
        this.depth = n;
        NO_EQDATA = bl;
        try {
            this.cache = new Vector();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("cache couldn't be created, reason: " + illegalArgumentException.toString());
        }
        if (this.cache == null) {
            System.out.println("cache is null");
        } else {
            System.out.println("records cache is created");
        }
    }

    public void lock() {
        this.lock.lock();
    }

    public void unlock() {
        this.lock.unlock();
    }

    public synchronized boolean SetDepth(int n) {
        if (n <= 0) {
            return true;
        }
        this.lock();
        this.depth = n;
        this.unlock();
        return false;
    }

    synchronized void SetTimeDiff(float f) {
        this.lock();
        this.max_time_diff = f;
        this.unlock();
    }

    public boolean IsFull() {
        return this.cache.size() == this.depth;
    }

    public boolean IsEmpty() {
        return this.cache.size() == 0;
    }

    public void PrintEntry(EqDataCacheEntry eqDataCacheEntry) {
        if (eqDataCacheEntry.data == null) {
            return;
        }
        System.out.print("Chan: " + eqDataCacheEntry.name + " Device: " + eqDataCacheEntry.data.devtype + " Dtype: " + eqDataCacheEntry.data.dtype + " type: ");
        if (eqDataCacheEntry.data.data != null) {
            System.out.println(eqDataCacheEntry.data.data.type());
        } else {
            System.out.println("not set");
        }
    }

    public void PrintRecord(EqDataCacheRecord eqDataCacheRecord) {
        if (eqDataCacheRecord == null) {
            return;
        }
        System.out.println("RECORD: Time:" + Integer.toString(eqDataCacheRecord.time.timeup) + ":" + Integer.toString(eqDataCacheRecord.time.timelow) + " Event#:" + Integer.toString(eqDataCacheRecord.event_number) + " Entries:" + eqDataCacheRecord.entry.size());
        for (int i = 0; i < eqDataCacheRecord.entry.size(); ++i) {
            System.out.println("Entry[" + Integer.toString(i) + "]");
            this.PrintEntry(eqDataCacheRecord.entry.get(i));
        }
        if (eqDataCacheRecord.entry.size() == 0) {
            System.out.println("");
        }
    }

    public void PrintAll(boolean bl) {
        if (bl) {
            this.lock();
        }
        System.out.println("DAQ CACHE");
        for (int i = 0; i < this.cache.size(); ++i) {
            System.out.println("[" + Integer.toString(i) + "]");
            this.PrintRecord(this.cache.get(i));
        }
        if (this.cache.size() == 0) {
            System.out.println("");
        }
        if (bl) {
            this.unlock();
        }
    }

    public void clean_record(EqDataCacheRecord eqDataCacheRecord, boolean bl) {
        if (eqDataCacheRecord != null) {
            if (bl) {
                this.lock();
            }
            for (int i = 0; i < eqDataCacheRecord.entry.size(); ++i) {
                EqDataCacheRecord eqDataCacheRecord2 = this.cache.get(i);
                if (!eqDataCacheRecord2.equals(eqDataCacheRecord)) continue;
                this.cache.remove(i);
            }
            if (bl) {
                this.unlock();
            }
        }
    }

    public void SetRecordSeen(boolean bl, EqDataCacheRecord eqDataCacheRecord) {
        eqDataCacheRecord.flags = bl ? (eqDataCacheRecord.flags |= 1) : (eqDataCacheRecord.flags &= 0xFFFFFFFE);
    }

    public void CleanAllSeen() {
        for (int i = 0; i < this.cache.size(); ++i) {
            this.SetRecordSeen(false, this.cache.get(i));
        }
    }

    public void CleanCache() {
        this.cache.clear();
    }

    public boolean get_first_time(time_stamp time_stamp2) {
        EqDataCacheRecord eqDataCacheRecord = this.FindFirstRecord(512);
        if (eqDataCacheRecord == null) {
            return true;
        }
        if (time_stamp2 != null) {
            time_stamp2.timeup = eqDataCacheRecord.time.timeup;
            time_stamp2.timelow = eqDataCacheRecord.time.timelow;
        }
        return false;
    }

    public boolean get_last_time(time_stamp time_stamp2) {
        EqDataCacheRecord eqDataCacheRecord = this.FindLastRecord(512);
        if (eqDataCacheRecord == null) {
            return true;
        }
        if (time_stamp2 != null) {
            time_stamp2.timeup = eqDataCacheRecord.time.timeup;
            time_stamp2.timelow = eqDataCacheRecord.time.timelow;
        }
        return false;
    }

    public boolean get_first_eventnum(int[] nArray) {
        EqDataCacheRecord eqDataCacheRecord = this.FindFirstRecord(1024);
        if (eqDataCacheRecord == null) {
            return true;
        }
        if (nArray != null) {
            nArray[0] = eqDataCacheRecord.event_number;
        }
        return false;
    }

    public boolean get_last_eventnum(int[] nArray) {
        EqDataCacheRecord eqDataCacheRecord = this.FindLastRecord(1024);
        if (eqDataCacheRecord == null) {
            return true;
        }
        if (nArray != null) {
            nArray[0] = eqDataCacheRecord.event_number;
        }
        return false;
    }

    public EqDataCacheRecord FindFirstRecord(int n) {
        int n2 = this.FindFirstIndx(n);
        if (n2 >= 0) {
            return this.cache.get(n2);
        }
        return null;
    }

    public int FindFirstIndx(int n) {
        if ((n & 0x200) != 0) {
            time_stamp time_stamp2 = new time_stamp();
            time_stamp2.timeup = UINT_MAX;
            time_stamp2.timelow = UINT_MAX;
            int n2 = -1;
            for (int i = 0; i < this.cache.size(); ++i) {
                EqDataCacheRecord eqDataCacheRecord = this.cache.get(i);
                if ((eqDataCacheRecord.flags & 1) != 0 && (n & 0x800) != 0 || eqDataCacheRecord.time.timeup >= time_stamp2.timeup && (eqDataCacheRecord.time.timeup != time_stamp2.timeup || eqDataCacheRecord.time.timelow >= time_stamp2.timelow)) continue;
                time_stamp2.timeup = eqDataCacheRecord.time.timeup;
                time_stamp2.timelow = eqDataCacheRecord.time.timelow;
                n2 = i;
            }
            if (n2 >= 0) {
                return n2;
            }
        } else if ((n & 0x400) != 0) {
            int n3 = UINT_MAX;
            int n4 = -1;
            for (int i = 0; i < this.cache.size(); ++i) {
                EqDataCacheRecord eqDataCacheRecord = this.cache.get(i);
                if ((eqDataCacheRecord.flags & 1) != 0 && (n & 0x800) != 0 || eqDataCacheRecord.event_number >= n3) continue;
                n3 = eqDataCacheRecord.event_number;
                n4 = i;
            }
            if (n4 >= 0) {
                return n4;
            }
        } else {
            return -2;
        }
        return -1;
    }

    public EqDataCacheRecord FindLastRecord(int n) {
        int n2 = this.FindLastIndx(n);
        if (n2 >= 0) {
            return this.cache.get(n2);
        }
        return null;
    }

    public int FindLastIndx(int n) {
        if ((n & 0x200) != 0) {
            time_stamp time_stamp2 = new time_stamp();
            time_stamp2.timeup = 0;
            time_stamp2.timelow = 0;
            int n2 = -1;
            for (int i = 0; i < this.cache.size(); ++i) {
                EqDataCacheRecord eqDataCacheRecord = this.cache.get(i);
                if ((eqDataCacheRecord.flags & 1) != 0 && (n & 0x800) != 0 || eqDataCacheRecord.time.timeup <= time_stamp2.timeup && (eqDataCacheRecord.time.timeup != time_stamp2.timeup || eqDataCacheRecord.time.timelow <= time_stamp2.timelow)) continue;
                time_stamp2.timeup = eqDataCacheRecord.time.timeup;
                time_stamp2.timelow = eqDataCacheRecord.time.timelow;
                n2 = i;
            }
            if (n2 >= 0) {
                return n2;
            }
        } else if ((n & 0x400) != 0) {
            int n3 = 0;
            int n4 = -1;
            for (int i = 0; i < this.cache.size(); ++i) {
                EqDataCacheRecord eqDataCacheRecord = this.cache.get(i);
                if ((eqDataCacheRecord.flags & 1) != 0 && (n & 0x800) != 0 || eqDataCacheRecord.event_number <= n3) continue;
                n3 = eqDataCacheRecord.event_number;
                n4 = i;
            }
            if (n4 >= 0) {
                return n4;
            }
        } else {
            return -2;
        }
        return -1;
    }

    public EqDataCacheRecord FindNextRecord(int n) {
        int n2 = this.find_closest_index(n, 8);
        if (n2 >= 0) {
            return this.cache.get(n2);
        }
        return null;
    }

    public int FindNextIndx(int n) {
        int n2 = n;
        int n3 = UINT_MAX;
        int n4 = -1;
        for (int i = 0; i < this.cache.size(); ++i) {
            EqDataCacheRecord eqDataCacheRecord = this.cache.get(i);
            int n5 = eqDataCacheRecord.event_number - n2;
            if (n5 <= 0 || n5 >= n3) continue;
            n3 = n5;
            n4 = i;
        }
        if (n4 >= 0) {
            return n4;
        }
        return -1;
    }

    public EqDataCacheRecord FindNextRecord(time_stamp time_stamp2) {
        int n = this.find_closest_index(time_stamp2, 8);
        if (n >= 0) {
            return this.cache.get(n);
        }
        return null;
    }

    public int FindNextIndx(time_stamp time_stamp2) {
        double d = (double)ULONG_MAX * DAQ_DATA_TIME_LOW_SCALE;
        int n = -1;
        double d2 = (double)time_stamp2.timeup * DAQ_DATA_TIME_LOW_SCALE + (double)time_stamp2.timelow;
        boolean bl = true;
        for (int i = 0; i < this.cache.size(); ++i) {
            EqDataCacheRecord eqDataCacheRecord = this.cache.get(i);
            double d3 = (double)eqDataCacheRecord.time.timeup * DAQ_DATA_TIME_LOW_SCALE + (double)eqDataCacheRecord.time.timelow - d2;
            if (bl) {
                bl = false;
            }
            if (!(d3 > 0.0) || !(d3 < d)) continue;
            d = d3;
            n = i;
        }
        if (n >= 0) {
            return n;
        }
        return -1;
    }

    public EqDataCacheRecord FindPrevRecord(int n) {
        int n2 = this.find_closest_index(n, 16);
        if (n2 >= 0) {
            return this.cache.get(n2);
        }
        return null;
    }

    public int FindPrevIndx(int n) {
        int n2 = n;
        int n3 = UINT_MAX;
        int n4 = -1;
        for (int i = 0; i < this.cache.size(); ++i) {
            EqDataCacheRecord eqDataCacheRecord = this.cache.get(i);
            int n5 = n2 - eqDataCacheRecord.event_number;
            if (n5 <= 0 || n5 >= n3) continue;
            n3 = n5;
            n4 = i;
        }
        if (n4 >= 0) {
            return n4;
        }
        return -1;
    }

    int find_closest_index(int n, int n2) {
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        int n6 = this.cache.size() - 1;
        int n7 = 0;
        while (n6 >= n5) {
            ++n4;
            n7 = n5 + n6 >> 1;
            EqDataCacheRecord eqDataCacheRecord = this.cache.get(n7);
            if (n < eqDataCacheRecord.event_number) {
                n6 = n7 - 1;
                continue;
            }
            if (n > eqDataCacheRecord.event_number) {
                n5 = n7 + 1;
                continue;
            }
            n3 = n7;
            break;
        }
        switch (n2) {
            case 4: {
                return n3;
            }
            case 16: {
                if (this.cache.get((int)n7).event_number < n) {
                    return n7;
                }
                while (this.cache.get((int)n7).event_number >= n && --n7 >= 0) {
                    ++n4;
                    if (this.cache.get((int)n7).event_number >= n) continue;
                    return n7;
                }
                return -1;
            }
            case 8: {
                if (this.cache.get((int)n7).event_number > n) {
                    return n7;
                }
                while (this.cache.get((int)n7).event_number <= n && ++n7 < this.cache.size()) {
                    ++n4;
                    if (this.cache.get((int)n7).event_number <= n) continue;
                    return n7;
                }
                return -1;
            }
        }
        return n3;
    }

    int find_closest_index(time_stamp time_stamp2, int n) {
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.cache.size() - 1;
        int n6 = 0;
        double d = (double)time_stamp2.timeup * DAQ_DATA_TIME_LOW_SCALE + (double)time_stamp2.timelow;
        double d2 = 0.0;
        double d3 = 150000.0;
        if (n == 16) {
            d -= d3;
        } else if (n == 8) {
            d += d3;
        }
        while (n5 >= n4) {
            ++n3;
            n6 = n4 + n5 >> 1;
            EqDataCacheRecord eqDataCacheRecord = this.cache.get(n6);
            d2 = (double)eqDataCacheRecord.time.timeup * DAQ_DATA_TIME_LOW_SCALE + (double)eqDataCacheRecord.time.timelow;
            if (d < d2) {
                n5 = n6 - 1;
                continue;
            }
            if (d > d2) {
                n4 = n6 + 1;
                continue;
            }
            n2 = n6;
            break;
        }
        switch (n) {
            case 4: {
                return n2;
            }
            case 16: {
                if (d2 <= d) {
                    return n6;
                }
                while (d2 > d && --n6 > 0) {
                    ++n3;
                    d2 = (double)this.cache.get((int)n6).time.timeup * DAQ_DATA_TIME_LOW_SCALE + (double)this.cache.get((int)n6).time.timelow;
                    if (!(d2 <= d)) continue;
                    return n6;
                }
                return -1;
            }
            case 8: {
                if (d2 >= d) {
                    return n6;
                }
                while (d2 < d && ++n6 < this.cache.size()) {
                    ++n3;
                    d2 = (double)this.cache.get((int)n6).time.timeup * DAQ_DATA_TIME_LOW_SCALE + (double)this.cache.get((int)n6).time.timelow;
                    if (!(d2 >= d)) continue;
                    return n6;
                }
                return -1;
            }
        }
        return n2;
    }

    public EqDataCacheRecord FindPrevRecord(time_stamp time_stamp2) {
        int n = this.find_closest_index(time_stamp2, 16);
        if (n >= 0) {
            return this.cache.get(n);
        }
        return null;
    }

    public int FindPrevIndx(time_stamp time_stamp2) {
        double d = ULONG_MAX;
        int n = -1;
        double d2 = (double)time_stamp2.timeup * DAQ_DATA_TIME_LOW_SCALE + (double)time_stamp2.timelow;
        for (int i = 0; i < this.cache.size(); ++i) {
            EqDataCacheRecord eqDataCacheRecord = this.cache.get(i);
            double d3 = d2 - ((double)eqDataCacheRecord.time.timeup * DAQ_DATA_TIME_LOW_SCALE + (double)eqDataCacheRecord.time.timelow);
            if (!(d3 > 0.0) || !(d3 < d)) continue;
            d = d3;
            n = i;
        }
        if (n >= 0) {
            return n;
        }
        return -1;
    }

    public int find_by_name(int n, String string) {
        if (n < 0 || string == null || string.length() == 0) {
            return -2;
        }
        if (n >= this.cache.size()) {
            return -2;
        }
        EqDataCacheRecord eqDataCacheRecord = this.cache.get(n);
        for (int i = 0; i < eqDataCacheRecord.entry.size(); ++i) {
            EqDataCacheEntry eqDataCacheEntry = eqDataCacheRecord.entry.get(i);
            if (string.compareTo(eqDataCacheEntry.name) != 0) continue;
            return i;
        }
        return -1;
    }

    public int find_by_name(EqDataCacheRecord eqDataCacheRecord, String string) {
        if (eqDataCacheRecord == null || string == null || string.length() == 0) {
            return -2;
        }
        for (int i = 0; i < eqDataCacheRecord.entry.size(); ++i) {
            EqDataCacheEntry eqDataCacheEntry = eqDataCacheRecord.entry.get(i);
            if (string.compareTo(eqDataCacheEntry.name) != 0) continue;
            return i;
        }
        return -1;
    }

    public int RemRecord(int n) {
        if (this.cache.size() <= n) {
            return -2;
        }
        try {
            this.cache.remove(n);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            System.err.println(arrayIndexOutOfBoundsException.toString());
            System.out.println("Coulnd't remove record " + Integer.toString(n));
        }
        return 0;
    }

    public int GetNRecords() {
        return this.cache.size();
    }

    public boolean RemEntry(EqDataCacheRecord eqDataCacheRecord, EqDataCacheEntry eqDataCacheEntry) {
        if (eqDataCacheRecord == null || eqDataCacheEntry == null) {
            return true;
        }
        for (int i = 0; i < eqDataCacheRecord.entry.size(); ++i) {
            if (!eqDataCacheEntry.equals(eqDataCacheRecord.entry.get(i))) continue;
            System.out.println("cache entry ent equals to rec.entry[" + Integer.toString(i) + "]");
            eqDataCacheRecord.entry.remove(i);
            return false;
        }
        return true;
    }

    public boolean RemRecord(EqDataCacheRecord eqDataCacheRecord) {
        if (eqDataCacheRecord == null) {
            return true;
        }
        for (int i = 0; i < this.cache.size(); ++i) {
            if (!eqDataCacheRecord.equals(this.cache.get(i))) continue;
            this.RemRecord(i);
            return false;
        }
        return true;
    }

    public int AddRecord(EqDataCacheRecord eqDataCacheRecord) {
        if (eqDataCacheRecord == null) {
            return -2;
        }
        eqDataCacheRecord.flags = 0;
        if (this.cache.size() < this.depth) {
            this.cache.add(eqDataCacheRecord);
            return 0;
        }
        int n = this.FindFirstIndx(0);
        int n2 = -1;
        n2 = this.RemRecord(n);
        if (n2 != 0) {
            return n2;
        }
        this.cache.add(eqDataCacheRecord);
        return 0;
    }

    public EqDataCacheRecord FindRecord(time_stamp time_stamp2) {
        for (int i = 0; i < this.cache.size(); ++i) {
            EqDataCacheRecord eqDataCacheRecord = this.cache.get(i);
            double d = (double)time_stamp2.timeup * DAQ_DATA_TIME_LOW_SCALE + (double)time_stamp2.timelow;
            double d2 = (double)eqDataCacheRecord.time.timeup * DAQ_DATA_TIME_LOW_SCALE + (double)eqDataCacheRecord.time.timelow;
            if (!(Math.abs(d - d2) <= this.max_time_diff)) continue;
            return eqDataCacheRecord;
        }
        return null;
    }

    public EqDataCacheEntry FindChannel(EqDataCacheRecord eqDataCacheRecord, String string) {
        if (eqDataCacheRecord == null || string == null) {
            return null;
        }
        int n = this.find_by_name(eqDataCacheRecord, string);
        if (n < 0) {
            return null;
        }
        return eqDataCacheRecord.entry.get(n);
    }

    public EqDataCacheEntry FindChannel(time_stamp time_stamp2, String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        EqDataCacheRecord eqDataCacheRecord = this.FindRecord(time_stamp2);
        if (eqDataCacheRecord == null) {
            return null;
        }
        return this.FindChannel(eqDataCacheRecord, string);
    }

    public EqDataCacheRecord FindRecord(int n) {
        int n2 = this.find_closest_index(n, 4);
        if (n2 >= 0) {
            return this.cache.get(n2);
        }
        return null;
    }

    public EqDataCacheEntry FindChannel(int n, String string) {
        if (string == null || string.length() == 0) {
            return null;
        }
        EqDataCacheRecord eqDataCacheRecord = this.FindRecord(n);
        if (eqDataCacheRecord == null) {
            return null;
        }
        int n2 = this.find_by_name(eqDataCacheRecord, string);
        if (n2 < 0) {
            return null;
        }
        return eqDataCacheRecord.entry.get(n2);
    }

    public int GetDepth() {
        return this.depth;
    }

    public int daq_data_to_cache(EventHeader eventHeader, byte[] byArray, int n) {
        ByteBuffer byteBuffer;
        EventHeader eventHeader2 = eventHeader != null ? eventHeader : new EventHeader();
        int n2 = eventHeader.size();
        boolean bl = false;
        try {
            byteBuffer = ByteBuffer.allocate(byArray.length);
            if (byteBuffer == null) {
                return -4;
            }
            byteBuffer.put(byArray);
            byteBuffer.rewind();
            if (eventHeader == null) {
                byte[] byArray2 = new byte[n2];
                byteBuffer.get(byArray2, 0, n2);
                eventHeader2.fill(byArray2);
            } else {
                byteBuffer.position(n2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println("daq_data_to_cache(): Exception occured : " + illegalArgumentException.toString());
            return -4;
        }
        catch (BufferOverflowException bufferOverflowException) {
            System.out.println("daq_data_to_cache(): Couldn't initialize ByteBuffer : " + bufferOverflowException.toString());
            return -4;
        }
        catch (BufferUnderflowException bufferUnderflowException) {
            System.out.println("daq_data_to_cache(): Couldn't initialize EventHeader from byte array : " + bufferUnderflowException.toString());
            return -4;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            System.out.println("daq_data_to_cache(): Couldn't initialize EventHeader from byte array : " + indexOutOfBoundsException.toString());
            return -4;
        }
        if (eventHeader2.event_length < 0) {
            return -4;
        }
        int n3 = eventHeader2.num_svr_block;
        if (n3 == 0) {
            System.out.println("daq_data_to_cache(): empty or incorrect event byte array content");
            return -4;
        }
        for (int i = 0; i < n3; ++i) {
            EqDataCacheRecord eqDataCacheRecord = null;
            if (this.IsFull()) {
                eqDataCacheRecord = this.FindFirstRecord(n);
                if (eqDataCacheRecord == null) {
                    System.out.println("daq_data_to_cache(): Failed to find first record in FULL cache !! ");
                    return -4;
                }
                eqDataCacheRecord.time.set_time(0, 0);
                eqDataCacheRecord.event_number = 0;
            } else {
                eqDataCacheRecord = new EqDataCacheRecord();
                if (eqDataCacheRecord == null) {
                    System.out.println("daq_data_to_cache(): Failed to allocate new record !! ");
                    return -3;
                }
                eqDataCacheRecord.entry.clear();
                eqDataCacheRecord.time.set_time(0, 0);
                eqDataCacheRecord.event_number = 0;
                bl = true;
            }
            eqDataCacheRecord.time.set_time(eventHeader2.time_up, eventHeader2.time_low);
            eqDataCacheRecord.event_number = eventHeader2.event_number;
            SBHeader sBHeader = new SBHeader();
            byte[] byArray3 = new byte[sBHeader.size()];
            try {
                byteBuffer.get(byArray3, 0, sBHeader.size());
                if (sBHeader.fill(byArray3)) {
                    System.out.println("Problem with filling server block header");
                }
            }
            catch (BufferUnderflowException bufferUnderflowException) {
                System.out.println("daq_data_to_cache(): Couldn't initialize SBHeader from byte array : " + bufferUnderflowException.toString());
                return -4;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                System.out.println("daq_data_to_cache(): Couldn't initialize SBHeader from byte array : " + indexOutOfBoundsException.toString());
                return -4;
            }
            ChannelHeader channelHeader = new ChannelHeader();
            byArray3 = new byte[channelHeader.size()];
            EqDataCacheEntry eqDataCacheEntry = null;
            switch (eventHeader2.event_type) {
                case 0: {
                    for (int j = 0; j < sBHeader.nchan; ++j) {
                        EventUtil eventUtil;
                        int n4;
                        channelHeader.clear();
                        byteBuffer.get(byArray3, 0, channelHeader.size());
                        channelHeader.fill(byArray3);
                        int n5 = channelHeader.dtype;
                        int n6 = (n5 & 0xFFFF0000) >> 16;
                        if (n6 == 0) {
                            n6 = n5;
                        } else {
                            n5 &= 0xFFFF;
                        }
                        EqData eqData = null;
                        if (n5 != 1) {
                            eqDataCacheEntry = this.FindChannel(eqDataCacheRecord, channelHeader.chname);
                            if (eqDataCacheEntry == null) {
                                eqDataCacheEntry = new EqDataCacheEntry();
                                if (eqDataCacheEntry == null) {
                                    System.out.println("daq_data_to_cache() Failed to allocate entry");
                                    return -3;
                                }
                                eqDataCacheEntry.name = channelHeader.chname;
                                eqDataCacheEntry.data = new EqDataDtype();
                                if (eqDataCacheEntry.data == null) {
                                    System.out.println("daq_data_to_cache() Failed to allocate EqData_dtype");
                                    return -3;
                                }
                                eqData = new EqData();
                                if (eqData == null) {
                                    System.out.println("daq_data_to_cache() Failed to allocate EqData");
                                    return -3;
                                }
                                eqData.init();
                                eqDataCacheEntry.data.dtype = n5;
                                eqDataCacheEntry.data.devtype = n6;
                                eqDataCacheRecord.entry.add(eqDataCacheEntry);
                            } else {
                                eqData = eqDataCacheEntry.data.data;
                                eqDataCacheEntry.data.dtype = n5;
                                eqDataCacheEntry.data.devtype = n6;
                            }
                        }
                        if ((n4 = (eventUtil = new EventUtil()).get_data_structure_type(n5)) > 0) {
                            switch (n4) {
                                case 16: {
                                    int n7;
                                    Object object;
                                    eqData.set_type(103);
                                    ttf2_name_value_block ttf2_name_value_block2 = new ttf2_name_value_block();
                                    Object object2 = new ttf2_name_value_channel();
                                    try {
                                        ttf2_name_value_block2.id = byteBuffer.getInt();
                                        byteBuffer.get(ttf2_name_value_block2.comment, 0, 80);
                                        ttf2_name_value_block2.ndata = byteBuffer.getInt();
                                        object = new float[ttf2_name_value_block2.ndata];
                                        for (n7 = 0; n7 < ttf2_name_value_block2.ndata && n7 < TS_SPECTRUM_LENGTH; ++n7) {
                                            byteBuffer.get(((ttf2_name_value_channel)object2).name, 0, 80);
                                            object[n7] = byteBuffer.getFloat();
                                        }
                                    }
                                    catch (BufferUnderflowException bufferUnderflowException) {
                                        System.out.println("daq_data_to_cache(): Couldn't fill name_val data for " + channelHeader.chname + " from byte array : " + bufferUnderflowException.toString());
                                        return -4;
                                    }
                                    for (n7 = 0; n7 < ttf2_name_value_block2.ndata && n7 < TS_SPECTRUM_LENGTH; ++n7) {
                                        eqData.set(eqDataCacheRecord.event_number, (float)object[n7], (float)channelHeader.error, eqDataCacheRecord.time.timeup, channelHeader.chname, n7);
                                    }
                                    eqDataCacheEntry.data.data = eqData;
                                    break;
                                }
                                case 1013: {
                                    eqData.set_type(n4);
                                    int n8 = eventUtil.get_channel_number(n5);
                                    Object object2 = new SPECTRUM();
                                    Object object = new String();
                                    float f = 0.0f;
                                    int n9 = 0;
                                    try {
                                        Object object3;
                                        ((SPECTRUM)object2).s_start = byteBuffer.getFloat();
                                        ((SPECTRUM)object2).s_inc = byteBuffer.getFloat();
                                        object = channelHeader.chname;
                                        ((SPECTRUM)object2).comment = ((String)object).getBytes();
                                        ((SPECTRUM)object2).tm = new time_t(eqDataCacheRecord.time.timeup);
                                        ((SPECTRUM)object2).status = eqDataCacheRecord.event_number;
                                        int n10 = 0;
                                        switch (n5) {
                                            case 6: {
                                                ttf2_bpm_channel ttf2_bpm_channel2 = new ttf2_bpm_channel();
                                                ttf2_bpm_channel2.X = byteBuffer.getFloat();
                                                ttf2_bpm_channel2.Y = byteBuffer.getFloat();
                                                n10 = spectr_block.get_size_nodata() + ttf2_bpm_channel2.get_size_nodata();
                                                break;
                                            }
                                            case 7: {
                                                object3 = new ttf2_bpm_z_channel();
                                                ((ttf2_bpm_z_channel)object3).X = byteBuffer.getFloat();
                                                ((ttf2_bpm_z_channel)object3).Y = byteBuffer.getFloat();
                                                ((ttf2_bpm_z_channel)object3).I = byteBuffer.getFloat();
                                                ((ttf2_bpm_z_channel)object3).Q = byteBuffer.getFloat();
                                                n10 = spectr_block.get_size_nodata() + ttf2_bpm_z_channel.get_size_nodata();
                                                break;
                                            }
                                            case 8: {
                                                ttf2_bpm_s_channel ttf2_bpm_s_channel2 = new ttf2_bpm_s_channel();
                                                ttf2_bpm_s_channel2.X = byteBuffer.getFloat();
                                                ttf2_bpm_s_channel2.Y = byteBuffer.getFloat();
                                                ttf2_bpm_s_channel2.C = byteBuffer.getFloat();
                                                n10 = spectr_block.get_size_nodata() + ttf2_bpm_s_channel2.get_size_nodata();
                                                break;
                                            }
                                            case 9: 
                                            case 10: {
                                                f = byteBuffer.getFloat();
                                                n10 = 16;
                                                break;
                                            }
                                            case 11: {
                                                ttf2_rf_channel ttf2_rf_channel2 = new ttf2_rf_channel();
                                                ttf2_rf_channel2.I = byteBuffer.getFloat();
                                                ttf2_rf_channel2.Q = byteBuffer.getFloat();
                                                n10 = spectr_block.get_size_nodata() + ttf2_rf_channel2.get_size_nodata();
                                                break;
                                            }
                                            case 14: 
                                            case 15: 
                                            case 20: 
                                            case 21: {
                                                ttf2_ws_channel ttf2_ws_channel2 = new ttf2_ws_channel();
                                                ttf2_ws_channel2.X = byteBuffer.getFloat();
                                                ttf2_ws_channel2.V = byteBuffer.getFloat();
                                                n10 = spectr_block.get_size_nodata() + ttf2_ws_channel2.get_size_nodata();
                                                break;
                                            }
                                            case 16: {
                                                ttf2_clpintl_channel ttf2_clpintl_channel2 = new ttf2_clpintl_channel();
                                                ttf2_clpintl_channel2.PM = byteBuffer.getFloat();
                                                ttf2_clpintl_channel2.e_minus1 = byteBuffer.getFloat();
                                                ttf2_clpintl_channel2.e_minus2 = byteBuffer.getFloat();
                                                ttf2_clpintl_channel2.e_minus3 = byteBuffer.getFloat();
                                                n10 = spectr_block.get_size_nodata() + ttf2_clpintl_channel2.get_size_nodata();
                                                break;
                                            }
                                            case 17: {
                                                ttf2_gunintl_channel ttf2_gunintl_channel2 = new ttf2_gunintl_channel();
                                                ttf2_gunintl_channel2.f1 = byteBuffer.getFloat();
                                                ttf2_gunintl_channel2.f2 = byteBuffer.getFloat();
                                                ttf2_gunintl_channel2.f3 = byteBuffer.getFloat();
                                                ttf2_gunintl_channel2.f4 = byteBuffer.getFloat();
                                                ttf2_gunintl_channel2.f5 = byteBuffer.getFloat();
                                                ttf2_gunintl_channel2.f6 = byteBuffer.getFloat();
                                                ttf2_gunintl_channel2.f7 = byteBuffer.getFloat();
                                                ttf2_gunintl_channel2.f8 = byteBuffer.getFloat();
                                                n10 = spectr_block.get_size_nodata() + ttf2_gunintl_channel2.get_size_nodata();
                                                break;
                                            }
                                            case 18: {
                                                ttf2_mcp_channel ttf2_mcp_channel2 = new ttf2_mcp_channel();
                                                ttf2_mcp_channel2.mcp1 = byteBuffer.getFloat();
                                                ttf2_mcp_channel2.mcp2 = byteBuffer.getFloat();
                                                ttf2_mcp_channel2.mcp3 = byteBuffer.getFloat();
                                                ttf2_mcp_channel2.mcp4 = byteBuffer.getFloat();
                                                ttf2_mcp_channel2.phd1 = byteBuffer.getFloat();
                                                ttf2_mcp_channel2.phd2 = byteBuffer.getFloat();
                                                ttf2_mcp_channel2.mcp5 = byteBuffer.getFloat();
                                                ttf2_mcp_channel2.mcp6 = byteBuffer.getFloat();
                                                n10 = spectr_block.get_size_nodata() + ttf2_mcp_channel2.get_size_nodata();
                                            }
                                        }
                                        n9 = byteBuffer.getInt();
                                        int n11 = channelHeader.ldata - channelHeader.size() - n10;
                                        if (n11 != n9 * n8 * 4) {
                                            System.out.println("Spectrum data incomplete, or incorrect data length in ChannelHeader: ldata:" + channelHeader.ldata + " subhead size: " + channelHeader.size() + " ndata: " + n9 + " nsubch:" + n8);
                                        }
                                        object3 = new float[n9];
                                        for (int k = 0; k < n8; ++k) {
                                            for (int i2 = 0; i2 < n9; ++i2) {
                                                object3[i2] = byteBuffer.getFloat();
                                            }
                                            if (((Object)object3).length == 0) {
                                                return -4;
                                            }
                                            ((SPECTRUM)object2).d_spect_array = (float[])object3;
                                            if (eqData.set_ts_spect(((SPECTRUM)object2).tm, (short)eventHeader2.time_low, (short)((SPECTRUM)object2).status, (SPECTRUM)object2, k) != 0) continue;
                                            System.out.println("daq_data_to_cache() problem with set_ts_spect()");
                                        }
                                        eqDataCacheEntry.data.data = eqData;
                                    }
                                    catch (BufferUnderflowException bufferUnderflowException) {
                                        System.out.println("daq_data_to_cache() Failed to get/fill spectrum, skipping : " + channelHeader.chname + "\n Reason: " + bufferUnderflowException.toString());
                                        this.RemEntry(eqDataCacheRecord, eqDataCacheEntry);
                                    }
                                    break;
                                }
                                case 22: {
                                    Object object;
                                    eqData.set_type(22);
                                    IMAGE iMAGE = new IMAGE();
                                    iMAGE.hdr = new IMH();
                                    try {
                                        iMAGE.hdr.width = byteBuffer.getInt();
                                        iMAGE.hdr.height = byteBuffer.getInt();
                                        iMAGE.hdr.aoi_width = byteBuffer.getInt();
                                        iMAGE.hdr.aoi_height = byteBuffer.getInt();
                                        iMAGE.hdr.x_start = byteBuffer.getInt();
                                        iMAGE.hdr.y_start = byteBuffer.getInt();
                                        iMAGE.hdr.bpp = byteBuffer.getInt();
                                        iMAGE.hdr.ebitpp = byteBuffer.getInt();
                                        iMAGE.hdr.hbin = byteBuffer.getInt();
                                        iMAGE.hdr.vbin = byteBuffer.getInt();
                                        iMAGE.hdr.source_format = byteBuffer.getInt();
                                        iMAGE.hdr.image_format = byteBuffer.getInt();
                                        iMAGE.hdr.frame = byteBuffer.getInt();
                                        iMAGE.hdr.event = byteBuffer.getInt();
                                        iMAGE.hdr.scale_x = byteBuffer.getFloat();
                                        iMAGE.hdr.scale_y = byteBuffer.getFloat();
                                        iMAGE.hdr.image_rotation = byteBuffer.getFloat();
                                        iMAGE.hdr.fspare2 = byteBuffer.getFloat();
                                        iMAGE.hdr.fspare3 = byteBuffer.getFloat();
                                        iMAGE.hdr.fspare4 = byteBuffer.getFloat();
                                        iMAGE.hdr.image_flags = byteBuffer.getInt();
                                        iMAGE.hdr.ispare2 = byteBuffer.getInt();
                                        iMAGE.hdr.ispare3 = byteBuffer.getInt();
                                        iMAGE.hdr.ispare4 = byteBuffer.getInt();
                                        int n12 = iMAGE.hdr.length = byteBuffer.getInt();
                                        object = new byte[n12];
                                        byteBuffer.get((byte[])object, 0, n12);
                                        eqDataCacheEntry.data.data = eqData;
                                    }
                                    catch (Exception exception) {
                                        System.out.println("daq_data_to_cache() Failed to get image_ext parameters, skipping " + channelHeader.chname);
                                        this.RemEntry(eqDataCacheRecord, eqDataCacheEntry);
                                        break;
                                    }
                                    u_char[] u_charArray = new u_char[((Object)object).length];
                                    for (int k = 0; k < ((Object)object).length; ++k) {
                                        u_charArray[k] = new u_char((byte)object[k]);
                                    }
                                    iMAGE.comment = channelHeader.chname.getBytes();
                                    eqData.set_image(u_charArray, iMAGE.hdr.length, iMAGE.hdr);
                                    eqData.set_image_comm(iMAGE.comment);
                                    break;
                                }
                                case 103: {
                                    int n13 = eventUtil.get_number_of_upd_channels(channelHeader);
                                    if (n13 == 0) {
                                        System.out.println("daq_data_to_cache() Failed to get number of UPD channels\n");
                                        this.RemEntry(eqDataCacheRecord, eqDataCacheEntry);
                                        break;
                                    }
                                    Object object2 = new time_stamp();
                                    byte[] byArray4 = new byte[80];
                                    for (int k = 0; k < n13; ++k) {
                                        for (int i3 = 0; i3 < byArray4.length; ++i3) {
                                            byArray4[i3] = 0;
                                        }
                                        byteBuffer.get(byArray4, 0, 80);
                                        int n14 = byteBuffer.getInt();
                                        ((time_stamp)object2).timeup = byteBuffer.getInt();
                                        ((time_stamp)object2).timelow = byteBuffer.getInt();
                                        float f = byteBuffer.getFloat();
                                        String string = new String(byArray4).replaceAll("[^a-zA-Z0-9/_.]", " ").trim();
                                        string = string.split(" ")[0];
                                        eqDataCacheEntry = this.FindChannel(eqDataCacheRecord, string);
                                        if (eqDataCacheEntry == null) {
                                            eqDataCacheEntry = new EqDataCacheEntry();
                                            if (eqDataCacheEntry == null) {
                                                System.out.println("daq_data_to_cache() Failed to allocate entry for UPD\n");
                                                return -3;
                                            }
                                            eqDataCacheEntry.name = string;
                                            eqDataCacheEntry.data = new EqDataDtype();
                                            if (eqDataCacheEntry.data == null) {
                                                System.out.println("daq_data_to_cache() Failed to allocate EqData_dtype for UPD\n");
                                                return -3;
                                            }
                                            eqDataCacheEntry.data.data = new EqData();
                                            if (eqDataCacheEntry.data.data == null) {
                                                System.out.println("daq_data_to_cache() Failed to allocate EqData for UPD\n");
                                                return -3;
                                            }
                                            eqData = eqDataCacheEntry.data.data;
                                            eqData.init();
                                            eqDataCacheRecord.entry.add(eqDataCacheEntry);
                                        } else {
                                            eqData = eqDataCacheEntry.data.data;
                                        }
                                        eqDataCacheEntry.data.dtype = n5;
                                        eqDataCacheEntry.data.devtype = n6;
                                        eqData.set(eqDataCacheRecord.event_number, f, (float)n14, ((time_stamp)object2).timeup, string, 0);
                                        eqDataCacheEntry.data.data = eqData;
                                    }
                                }
                            }
                            continue;
                        }
                        System.out.println("daq_data_to_cache() UNKNOWN DATA STRUCTURE TYPE:" + n5 + " for  " + channelHeader.chname + ", skipping\n");
                    }
                    break;
                }
                default: {
                    System.out.println("Uknonwn Event Type\n");
                }
            }
            if (!bl) continue;
            this.AddRecord(eqDataCacheRecord);
        }
        return 0;
    }
}

