/*
 * Decompiled with CFR 0.152.
 */
package daq;

import daq.DAQConnect;
import daq.DAQeqResult;
import daq.DAQgetOptions;
import daq.DataLink;
import daq.EqDataCache;
import daq.EqDataCacheEntry;
import daq.EqDataCacheRecord;
import daq.EqDataDtype;
import daq.EventHeader;
import daq.EventTail;
import daq.RunCtlTags;
import daq.chan_descr;
import daq.chan_descriptions;
import daq.daq_xml_reply;
import daq.daq_xml_request;
import daq.time_stamp;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.Vector;
import java.util.concurrent.locks.ReentrantLock;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DAQeqData
implements RunCtlTags,
Runnable {
    private int depth;
    private boolean must_swap = false;
    private EqDataCache cache = null;
    private daq_xml_reply reply = null;
    private DataLink dlink = null;
    private int evcnt;
    private DAQConnect connect = null;
    private long thr_id = 0L;
    private boolean stop;
    private Thread timeThread = null;
    private long sleep_time;
    boolean done;
    int clntcnt = 0;
    public static final int DAQEQDATA_CACHE_DEF = 3600;
    public static final int TTF2_FREQUENCY_CUR_HZ = 5;
    public static final double DAQEQDATA_CACHE_EXTRA = 1.1;
    public static final int DAQ_DATA_MALLOC_ERR = 2048;
    public static final int DAQ_DATA_NOT_FOUND = 1024;
    public static final int DAQ_DATA_OK = 1;
    public static final int DAQ_DATA_NO_DATA = 2;
    public static final int DAQ_DATA_END_DATA = 4;
    public static final int DAQ_DATA_FULL_DATA = 8;
    public static final int DAQ_DATA_NO_THREAD = 16;
    public static final int DAQ_DATA_DONE = 32;
    public static final int DAQ_DATA_STS_OK = 0;
    public static final int DAQ_DATA_STS_IDLE = 1;
    public static final int DAQ_DATA_STS_PROGRESS = 2;
    public static final int DAQ_DATA_STS_ERROR = 3;
    public static final int DAQ_DATA_STS_UNKNOWN = 4;
    public static final int DAQ_DATA_STS_CONNECT_ERROR = 5;
    public static final int DAQ_DATA_ACCESS_FIRST = 1;
    public static final int DAQ_DATA_ACCESS_LAST = 2;
    public static final int DAQ_DATA_ACCESS_EXACT = 4;
    public static final int DAQ_DATA_ACCESS_NEXT = 8;
    public static final int DAQ_DATA_ACCESS_PREV = 16;
    public static final int DAQ_DATA_ACCESS_NOTSEEN = 2048;
    public static final int DAQ_DATA_ACCESS_REM = 256;
    public static final int DAQ_DATA_ACCESS_TIME = 512;
    public static final int DAQ_DATA_ACCESS_EVNUM = 1024;
    private ReentrantLock lock = new ReentrantLock();
    public static final int DAQEQDATA_TIME_PERIOD_DEF = 900;
    EqCall eq = null;

    public boolean if_just_get_chan_list() {
        if (this.connect != null) {
            return this.connect.if_just_get_chan_list();
        }
        return false;
    }

    public void add_client() {
        this.lock.lock();
        ++this.clntcnt;
        this.lock.unlock();
    }

    public void rem_client() {
        this.lock.lock();
        --this.clntcnt;
        this.lock.unlock();
    }

    public int get_clients() {
        return this.clntcnt;
    }

    private byte[] get_buffer_for_request(EventHeader eventHeader, EventTail eventTail) {
        byte[] byArray = new byte[eventHeader.my_size + eventTail.my_size];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.put(eventHeader.get_buffer(null));
        byteBuffer.put(eventTail.get_buffer(null));
        return byArray;
    }

    public String get_connect_local_error() {
        if (this.connect != null) {
            return this.connect.get_local_error();
        }
        return "";
    }

    public String get_reply() {
        if (this.connect != null) {
            return this.connect.get_reply();
        }
        return new String("No connect");
    }

    public int get_number_of_events() {
        return this.evcnt;
    }

    public boolean set_max_connect_time(long l) {
        if (this.connect != null) {
            return this.connect.set_max_wait_time(l);
        }
        return true;
    }

    public long get_max_connect_time() {
        if (this.connect != null) {
            return this.connect.get_max_wait_time();
        }
        return 0L;
    }

    public boolean set_event_jump(int n) {
        int n2 = n << 4 | 0xF;
        return this.set_scan_mode(n2) != n2;
    }

    public int set_scan_mode(int n) {
        if (this.connect != null) {
            return this.connect.set_scan_mode(n);
        }
        return -1;
    }

    public int get_scan_mode() {
        if (this.connect != null) {
            return this.connect.get_scan_mode();
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block50: {
            int n = this.connect.status();
            this.connect.connect(null);
            while (true) {
                if (n != 0) {
                    if (n != 3) {
                        if (n != 2) break;
                    }
                }
                n = this.connect.status();
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    break;
                }
            }
            if (n != 4) {
                this.reset_thr_id();
                this.stop = true;
                return;
            }
            if (this.connect.if_just_get_chan_list()) {
                this.reset_thr_id();
                this.stop = true;
                return;
            }
            if (this.set_reply(this.connect.get_server_reply())) {
                this.reset_thr_id();
                this.stop = true;
                System.out.println("Failed to set reply from connect");
                return;
            }
            this.dlink = new DataLink();
            if (this.reply.port <= 0 || this.reply.host == null || this.reply.host.isEmpty()) {
                this.reset_thr_id();
                this.stop = true;
                System.out.println("Invalid port/host from reply port:" + this.reply.port);
                return;
            }
            this.dlink.SetNoDelay();
            this.dlink.set_own_cnt(false);
            if (this.connect()) {
                this.reset_thr_id();
                this.stop = true;
                System.out.println("Failed to connect to " + this.reply.port + ":" + this.reply.host);
                return;
            }
            EventHeader eventHeader = new EventHeader();
            EventTail eventTail = new EventTail();
            eventHeader.pattern = -1114130;
            eventHeader.event_length = eventHeader.my_size + eventTail.my_size;
            eventHeader.event_number = -1;
            eventHeader.event_type = 0;
            eventHeader.tmask = 0;
            eventHeader.status = 0;
            eventHeader.num_svr_block = 0;
            eventTail.event_length = eventHeader.event_length;
            int n2 = 0;
            boolean bl = false;
            if (this.reply.request.comm_mode == 2) {
                bl = true;
            }
            boolean bl2 = true;
            int n3 = 0;
            this.evcnt = 0;
            int n4 = this.cache.GetDepth();
            boolean bl3 = false;
            try {
                block51: {
                    block53: {
                        block54: {
                            while (!this.stop) {
                                boolean bl4;
                                byte[] byArray;
                                block49: {
                                    block52: {
                                        if (bl2) {
                                            int n5 = this.dlink.ReceiveEvent(null, 0);
                                            if (n5 != 0) {
                                                if (n5 != 22) {
                                                    if (n5 != 30) {
                                                        System.out.println("Error receiving event: " + n5);
                                                        bl3 = true;
                                                        break;
                                                    }
                                                }
                                                System.out.println("receiver() after ReceiveEven() BAD : " + n5);
                                                try {
                                                    Thread.sleep(10L);
                                                    continue;
                                                }
                                                catch (InterruptedException interruptedException) {
                                                    bl3 = true;
                                                    break;
                                                }
                                            }
                                            EventHeader eventHeader2 = this.dlink.get_event_header();
                                            if (eventHeader2.event_number < 0) break;
                                            byte[] byArray2 = this.dlink.buffer;
                                            ++this.evcnt;
                                            this.lock();
                                            this.cache.daq_data_to_cache(eventHeader2, byArray2, 0);
                                            this.unlock();
                                            eventHeader.copy(eventHeader2);
                                            eventHeader.event_length = eventHeader.my_size + eventTail.my_size;
                                            if (bl) {
                                                System.out.println("We have to send 'READY' flag");
                                                if (this.dlink.IsLinkActive() && (n2 = this.dlink.SendRequest(byArray = this.get_buffer_for_request(eventHeader, eventTail), byArray.length)) != 0) {
                                                    System.out.println("SendEvent() Failed to send event return: " + n2);
                                                    if (n2 == 6) {
                                                        bl3 = true;
                                                        break;
                                                    }
                                                    if (n2 == 23) {
                                                        System.out.println("SendEvent() Timeout");
                                                    } else if (n2 == 28) {
                                                        System.out.println("SendEvent() Resource temporarily unavailable");
                                                    } else {
                                                        System.out.println("SendEvent() Other errors: " + n2);
                                                        bl3 = true;
                                                        break;
                                                    }
                                                }
                                            }
                                        }
                                        bl4 = false;
                                        this.lock();
                                        int n6 = this.cache.GetNRecords();
                                        this.unlock();
                                        if (n4 == n6) {
                                            bl4 = true;
                                        }
                                        if (!bl2 && bl4) {
                                            eventHeader.event_number = -1;
                                            System.out.println("EVCNT:  " + this.evcnt + " We have to send 'HEARTBEAT' flag " + eventHeader.time_up + ":" + eventHeader.time_low + ":" + eventHeader.event_number);
                                            if (this.dlink.IsLinkActive() && (n2 = this.dlink.SendRequest(byArray = this.get_buffer_for_request(eventHeader, eventTail), byArray.length)) != 0) {
                                                System.out.println("SendEvent() Failed to send event return: " + n2);
                                                if (n2 == 6) {
                                                    System.out.println("SendEvent() connection lost");
                                                    bl3 = true;
                                                    break;
                                                }
                                                if (n2 == 23) {
                                                    System.out.println("SendEvent() Timeout");
                                                } else if (n2 == 28) {
                                                    System.out.println("SendEvent() Resource temporarily unavailable");
                                                } else {
                                                    System.out.println("SendEvent() Other errors: " + n2);
                                                    bl3 = true;
                                                    break;
                                                }
                                            }
                                            Thread.sleep(50L);
                                            continue;
                                        }
                                        if (!bl2 || !bl4) break block49;
                                        n3 = eventHeader.event_number;
                                        eventHeader.event_number = -1;
                                        System.out.println("EVCNT: " + this.evcnt + " We have to send 'PAUSE' " + eventHeader.time_up + ":" + eventHeader.time_low + "_" + eventHeader.event_number);
                                        if (!this.dlink.IsLinkActive()) break block49;
                                        byArray = this.get_buffer_for_request(eventHeader, eventTail);
                                        n2 = this.dlink.SendRequest(byArray, byArray.length);
                                        if (n2 == 0) break block52;
                                        System.out.println("SendEvent() Failed to send event return: " + n2);
                                        if (n2 == 6) {
                                            System.out.println("SendEvent() connection lost");
                                            bl3 = true;
                                            break;
                                        }
                                        if (n2 == 23) {
                                            System.out.println("SendEvent() Timeout");
                                            break block49;
                                        } else if (n2 == 28) {
                                            System.out.println("SendEvent() Resource temporarily unavailable");
                                            break block49;
                                        } else {
                                            System.out.println("SendEvent() Other errors: " + n2);
                                            bl3 = true;
                                            break;
                                        }
                                    }
                                    bl2 = false;
                                }
                                if (bl2 || bl4) continue;
                                eventHeader.event_number = n3;
                                System.out.println("EVCNT: " + this.evcnt + " We have to send 'RESUME' flag " + eventHeader.time_up + ":" + eventHeader.time_low + "_" + eventHeader.event_number);
                                if (!this.dlink.IsLinkActive()) continue;
                                byArray = this.get_buffer_for_request(eventHeader, eventTail);
                                n2 = this.dlink.SendRequest(byArray, byArray.length);
                                if (n2 != 0) {
                                    System.out.println("SendEvent() Failed to send event return: " + n2);
                                    if (n2 == 6) {
                                        System.out.println("SendEvent() connection lost");
                                        bl3 = true;
                                        break;
                                    }
                                    if (n2 == 23) {
                                        System.out.println("SendEvent() Timeout");
                                        continue;
                                    }
                                    if (n2 == 28) {
                                        System.out.println("SendEvent() Resource temporarily unavailable");
                                        continue;
                                    }
                                    System.out.println("SendEvent() Other errors: " + n2);
                                    bl3 = true;
                                    break;
                                }
                                bl2 = true;
                            }
                            if (!bl3) break block50;
                            System.out.println("SendEvent() informing server that we are finishing");
                            eventHeader.event_number = -2;
                            if (!this.dlink.IsLinkActive()) break block51;
                            byte[] byArray = this.get_buffer_for_request(eventHeader, eventTail);
                            n2 = this.dlink.SendRequest(byArray, byArray.length);
                            if (n2 == 0) break block53;
                            System.out.println("SendEvent() Failed to send event return: " + n2);
                            if (n2 != 6) break block54;
                            System.out.println("SendEvent() connection lost");
                            break block51;
                        }
                        if (n2 == 23) {
                            System.out.println("SendEvent() Timeout");
                            break block51;
                        } else if (n2 == 28) {
                            System.out.println("SendEvent() Resource temporarily unavailable");
                            break block51;
                        } else {
                            System.out.println("SendEvent() Other errors: " + n2);
                            bl3 = true;
                        }
                        break block51;
                    }
                    bl2 = true;
                }
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("receiver_thread(): interrupted " + interruptedException.getMessage());
            }
        }
        this.dlink.Disconnect();
        System.out.println("receiver_thread(): Terminated: events: " + this.evcnt);
        this.reset_thr_id();
        this.stop = true;
    }

    public Vector<chan_descr> get_channel_list() {
        return this.connect.get_chan_list();
    }

    private void reset_thr_id() {
        this.lock();
        this.thr_id = 0L;
        this.unlock();
    }

    public chan_descriptions get_chan_descriptions() {
        return this.connect.get_chan_descriptions();
    }

    public Vector<String> get_file_list() {
        return this.connect.get_file_list();
    }

    public void set_daq_server(String string) {
        this.connect.set_daq_server(string);
    }

    public daq_xml_request get_request() {
        return this.connect.get_request();
    }

    public DAQeqData(String[] stringArray, int n, int n2, String string, String string2) {
        int n3;
        this.init();
        this.eq = new EqCall();
        this.connect = new DAQConnect();
        if (stringArray != null && stringArray.length != 0) {
            this.connect.set_request_type(1);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].isEmpty()) continue;
                this.connect.add_channel(stringArray[i]);
            }
        } else {
            this.connect.set_request_type(2);
        }
        if (string != null && !string.isEmpty()) {
            this.connect.set_experiment(string);
        }
        if (string2 != null && !string2.isEmpty()) {
            this.connect.set_data_dir(string2);
        }
        if (!this.connect.get_experiment().equals("linac")) {
            this.connect.set_ctl_dir(new String("/daq/ttf2/adm/"));
        }
        Date date = new Date();
        if (n <= 0 && n2 <= 0) {
            n3 = (int)(date.getTime() / 1000L);
            int n4 = n3 - 900;
            this.connect.set_start_time(n4);
            this.connect.set_stop_time(n3);
        } else if (n <= 0) {
            this.connect.set_stop_time(n2);
            this.connect.set_start_time(n2 - 900);
        } else if (n2 <= 0) {
            this.connect.set_start_time(n);
            n3 = (int)(date.getTime() / 1000L);
            if (n + 900 > n3) {
                this.connect.set_stop_time(n3);
            } else {
                this.connect.set_stop_time(n + 900);
            }
        } else {
            this.connect.set_start_time(n);
            this.connect.set_stop_time(n2);
        }
        n3 = (int)this.connect.get_stop_time() - (int)this.connect.get_start_time();
        double d = (double)(n3 * 5) * 1.1;
        this.depth = 3600;
        if (d > 0.0) {
            this.depth = (int)d;
        }
        this.cache = new EqDataCache(this.depth);
    }

    public DAQeqData(String[] stringArray, int n, String string, String string2) {
        this.init();
        this.eq = new EqCall();
        this.connect = new DAQConnect();
        if (stringArray != null && stringArray.length != 0) {
            this.connect.set_request_type(1);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].isEmpty()) continue;
                this.connect.add_channel(stringArray[i]);
            }
        } else {
            this.connect.set_request_type(2);
        }
        if (string != null && !string.isEmpty()) {
            this.connect.set_experiment(string);
        }
        if (string2 != null && !string2.isEmpty()) {
            this.connect.set_data_dir(string2);
        }
        if (!this.connect.get_experiment().equals("linac")) {
            this.connect.set_ctl_dir(new String("/daq/ttf2/adm/"));
        }
        Date date = new Date();
        if (n <= 0) {
            int n2 = (int)(date.getTime() / 1000L);
            int n3 = n2 - 900;
            this.connect.set_start_time(n3);
            this.connect.set_stop_time(n2);
        } else {
            this.connect.set_run_first(n);
            this.connect.set_run_last(n);
        }
        this.depth = 3600;
        this.cache = new EqDataCache(this.depth);
    }

    public DAQeqData(String[] stringArray, int n, int n2, int n3, String string, String string2) {
        int n4;
        this.init();
        this.eq = new EqCall();
        this.connect = new DAQConnect();
        if (stringArray != null && stringArray.length != 0) {
            this.connect.set_request_type(1);
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] == null || stringArray[i].isEmpty()) continue;
                this.connect.add_channel(stringArray[i]);
            }
        } else {
            this.connect.set_request_type(2);
        }
        if (string != null && !string.isEmpty()) {
            this.connect.set_experiment(string);
        }
        if (string2 != null && !string2.isEmpty()) {
            this.connect.set_data_dir(string2);
        }
        if (!this.connect.get_experiment().equals("linac")) {
            this.connect.set_ctl_dir(new String("/daq/ttf2/adm/"));
        }
        Date date = new Date();
        if (n <= 0 && n2 <= 0) {
            n4 = (int)(date.getTime() / 1000L);
            int n5 = n4 - 900;
            this.connect.set_start_time(n5);
            this.connect.set_stop_time(n4);
        } else if (n <= 0) {
            this.connect.set_stop_time(n2);
            this.connect.set_start_time(n2 - 900);
        } else if (n2 <= 0) {
            this.connect.set_start_time(n);
            n4 = (int)(date.getTime() / 1000L);
            if (n + 900 > n4) {
                this.connect.set_stop_time(n4);
            } else {
                this.connect.set_stop_time(n + 900);
            }
        } else {
            this.connect.set_start_time(n);
            this.connect.set_stop_time(n2);
        }
        if (n3 > 0) {
            this.connect.set_run_first(n3);
            this.connect.set_run_last(n3);
        }
        n4 = (int)this.connect.get_stop_time() - (int)this.connect.get_start_time();
        double d = (double)(n4 * 5) * 1.1;
        this.depth = 3600;
        if (d > 0.0) {
            this.depth = (int)d;
        }
        this.cache = new EqDataCache(this.depth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void init() {
        this.lock();
        this.evcnt = 0;
        try {
            this.stop_receiver();
            if (this.cache != null) {
                this.cache.CleanCache();
            }
            this.reply = new daq_xml_reply();
        }
        finally {
            this.unlock();
        }
    }

    void lock() {
        this.lock.lock();
    }

    void unlock() {
        this.lock.unlock();
    }

    public void set_done(boolean bl) {
        this.done = bl;
    }

    public boolean set_cache_depth(int n) {
        if (this.cache.SetDepth(n)) {
            return true;
        }
        this.depth = n;
        return false;
    }

    public boolean set_reply(daq_xml_reply daq_xml_reply2) {
        if (this.reply.copy(daq_xml_reply2)) {
            return true;
        }
        if (this.depth <= 0) {
            long l = this.reply.request.tstop - this.reply.request.tstart;
            double d = (double)(l * 5L) * 1.1;
            int n = 3600;
            return this.set_cache_depth(n);
        }
        return false;
    }

    public void set_swap(boolean bl) {
        this.must_swap = bl;
    }

    public int get_number_of_entries() {
        return this.cache.GetNRecords();
    }

    public void print_record(EqDataCacheRecord eqDataCacheRecord) {
        this.cache.PrintRecord(eqDataCacheRecord);
    }

    public void stop_receiver() {
        this.stop = true;
    }

    public int status() {
        int n = this.connect.status();
        if (n == 0) {
            return 1;
        }
        if (n == 3) {
            return 2;
        }
        if (n == 2) {
            return 2;
        }
        if (n == 4) {
            if (this.connect.if_just_get_chan_list()) {
                return 0;
            }
            if (this.thr_id != 0L) {
                return 2;
            }
            if (this.evcnt > 0) {
                return 0;
            }
            return 3;
        }
        if (n == 1) {
            return 5;
        }
        return 4;
    }

    public String connect_status_string() {
        return this.connect.status_string();
    }

    public boolean start_receiver() {
        this.lock();
        if (this.thr_id != 0L) {
            System.out.println("Receiving thread is already running\n");
            this.unlock();
            return true;
        }
        if (this.timeThread == null) {
            this.timeThread = new Thread(this);
        }
        this.stop = false;
        this.timeThread.start();
        this.thr_id = this.timeThread.getId();
        this.unlock();
        return false;
    }

    public boolean connect() {
        if (this.reply.port == 0 || this.reply.host == null || this.reply.host.isEmpty()) {
            return true;
        }
        this.dlink.SetNoDelay();
        this.dlink.set_own_cnt(false);
        int n = this.dlink.Connect(this.reply.host, this.reply.port);
        if (n == 0) {
            this.must_swap = this.dlink.get_swap();
            return false;
        }
        return true;
    }

    DAQeqResult get_monitor(int n, time_stamp time_stamp2, String string, int n2, int n3) {
        boolean bl = false;
        if (string != null && string.length() != 0) {
            bl = true;
        }
        DAQeqResult dAQeqResult = new DAQeqResult();
        this.cache.lock();
        if (this.thr_id == 0L && this.cache.IsEmpty()) {
            this.cache.unlock();
            if (this.done) {
                dAQeqResult.status = 52;
            }
            dAQeqResult.status = 20;
            return dAQeqResult;
        }
        if (this.thr_id != 0L && this.cache.IsEmpty()) {
            this.cache.unlock();
            if (this.done) {
                dAQeqResult.status = 34;
            }
            dAQeqResult.status = 2;
            return dAQeqResult;
        }
        EqDataCacheRecord eqDataCacheRecord = null;
        EqDataCacheEntry eqDataCacheEntry = null;
        if ((n2 & 1) != 0) {
            eqDataCacheRecord = this.cache.FindFirstRecord(n2);
            if (bl) {
                eqDataCacheEntry = this.cache.FindChannel(eqDataCacheRecord, string);
            }
        } else if ((n2 & 2) != 0) {
            eqDataCacheRecord = this.cache.FindLastRecord(n2);
            if (bl) {
                eqDataCacheEntry = this.cache.FindChannel(eqDataCacheRecord, string);
            }
        } else if ((n2 & 4) != 0) {
            if (n != 0) {
                eqDataCacheRecord = this.cache.FindRecord(n);
                if (bl) {
                    eqDataCacheEntry = this.cache.FindChannel(eqDataCacheRecord, string);
                }
            } else {
                eqDataCacheRecord = this.cache.FindRecord(time_stamp2);
                if (bl) {
                    eqDataCacheEntry = this.cache.FindChannel(time_stamp2, string);
                }
            }
        } else if ((n2 & 8) != 0) {
            if (n != 0) {
                eqDataCacheRecord = this.cache.FindNextRecord(n);
                if (bl) {
                    eqDataCacheEntry = this.cache.FindChannel(eqDataCacheRecord, string);
                }
            } else {
                eqDataCacheRecord = this.cache.FindNextRecord(time_stamp2);
                if (bl) {
                    eqDataCacheEntry = this.cache.FindChannel(time_stamp2, string);
                }
            }
        } else if ((n2 & 0x10) != 0) {
            if (n != 0) {
                eqDataCacheRecord = this.cache.FindPrevRecord(n);
                if (bl) {
                    eqDataCacheEntry = this.cache.FindChannel(eqDataCacheRecord, string);
                }
            } else {
                eqDataCacheRecord = this.cache.FindPrevRecord(time_stamp2);
                if (bl) {
                    eqDataCacheEntry = this.cache.FindChannel(time_stamp2, string);
                }
            }
        } else if (n != 0) {
            eqDataCacheRecord = this.cache.FindRecord(n);
            if (bl) {
                eqDataCacheEntry = this.cache.FindChannel(n, string);
            }
        } else if (time_stamp2 != null) {
            eqDataCacheRecord = this.cache.FindRecord(time_stamp2);
            if (bl) {
                eqDataCacheEntry = this.cache.FindChannel(time_stamp2, string);
            }
        } else {
            eqDataCacheRecord = this.cache.FindFirstRecord(n2);
            if (bl) {
                eqDataCacheEntry = this.cache.FindChannel(eqDataCacheRecord, string);
            }
        }
        if (eqDataCacheRecord == null || bl && eqDataCacheEntry == null) {
            this.cache.unlock();
            if (this.thr_id != 0L) {
                if (this.done) {
                    dAQeqResult.status = 1056;
                }
                dAQeqResult.status = 1024;
            } else if ((n2 & 0x800) == 0) {
                if (this.done) {
                    dAQeqResult.status = 1072;
                }
                dAQeqResult.status = 1040;
            } else {
                if (this.done) {
                    dAQeqResult.status = 52;
                }
                dAQeqResult.status = 20;
            }
            return dAQeqResult;
        }
        Vector<EqDataDtype> vector = new Vector<EqDataDtype>();
        if (vector == null) {
            this.cache.unlock();
            if (this.done) {
                dAQeqResult.status = 2080;
            }
            dAQeqResult.status = 2048;
            return dAQeqResult;
        }
        vector.clear();
        EqDataDtype eqDataDtype = null;
        if (bl) {
            eqDataDtype = new EqDataDtype();
            if (eqDataDtype == null) {
                this.cache.unlock();
                if (this.thr_id != 0L) {
                    if (this.done) {
                        dAQeqResult.status = 2080;
                    }
                    dAQeqResult.status = 2048;
                } else {
                    if (this.done) {
                        dAQeqResult.status = 2096;
                    }
                    dAQeqResult.status = 2064;
                }
                return dAQeqResult;
            }
            eqDataDtype.data = new EqData();
            if (eqDataDtype.data == null) {
                this.cache.unlock();
                if (this.thr_id != 0L) {
                    if (this.done) {
                        dAQeqResult.status = 2080;
                    }
                    dAQeqResult.status = 2048;
                } else {
                    if (this.done) {
                        dAQeqResult.status = 2096;
                    }
                    dAQeqResult.status = 2064;
                }
                return dAQeqResult;
            }
            eqDataDtype.data.init();
            eqDataDtype.data.copy_from(eqDataCacheEntry.data.data);
            eqDataDtype.dtype = eqDataCacheEntry.data.dtype;
            eqDataDtype.devtype = eqDataCacheEntry.data.devtype;
            vector.add(eqDataDtype);
        } else {
            for (int i = 0; i < eqDataCacheRecord.entry.size(); ++i) {
                eqDataDtype = new EqDataDtype();
                if (eqDataDtype == null) {
                    this.cache.unlock();
                    if (this.thr_id != 0L) {
                        if (this.done) {
                            dAQeqResult.status = 2080;
                        }
                        dAQeqResult.status = 2048;
                    } else {
                        if (this.done) {
                            dAQeqResult.status = 2096;
                        }
                        dAQeqResult.status = 2064;
                    }
                    return dAQeqResult;
                }
                eqDataDtype.data = new EqData();
                if (eqDataDtype.data == null) {
                    this.cache.unlock();
                    if (this.thr_id != 0L) {
                        if (this.done) {
                            dAQeqResult.status = 2080;
                        }
                        dAQeqResult.status = 2048;
                    } else {
                        if (this.done) {
                            dAQeqResult.status = 2096;
                        }
                        dAQeqResult.status = 2064;
                    }
                    return dAQeqResult;
                }
                eqDataDtype.data.init();
                EqDataCacheEntry eqDataCacheEntry2 = eqDataCacheRecord.entry.elementAt(i);
                if (eqDataCacheEntry2 != null) {
                    if (eqDataCacheEntry2.data != null) {
                        eqDataDtype.data.copy_from(eqDataCacheEntry2.data.data);
                        eqDataDtype.dtype = eqDataCacheEntry2.data.dtype;
                        eqDataDtype.devtype = eqDataCacheEntry2.data.devtype;
                        vector.add(eqDataDtype);
                        continue;
                    }
                    System.out.println("get_monitor() NULL pointer for channel: " + eqDataCacheEntry2.name);
                    continue;
                }
                System.out.println("Entry pointer NULL");
            }
        }
        dAQeqResult.data = vector;
        this.cache.unlock();
        dAQeqResult.rec = eqDataCacheRecord;
        if ((n3 & 0x100) != 0) {
            this.cache.RemRecord(eqDataCacheRecord);
        } else {
            this.cache.SetRecordSeen(true, eqDataCacheRecord);
        }
        if (this.thr_id != 0L) {
            if (this.done) {
                dAQeqResult.status = 33;
            }
            dAQeqResult.status = 1;
        } else {
            if (this.done) {
                dAQeqResult.status = 49;
            }
            dAQeqResult.status = 17;
        }
        return dAQeqResult;
    }

    public DAQeqResult get_monitor(DAQgetOptions dAQgetOptions) {
        if (dAQgetOptions == null) {
            return this.get_monitor(0, null, null, 513, 256);
        }
        String string = dAQgetOptions.get_channel();
        if (string != null && string.length() != 0) {
            return this.get_monitor(dAQgetOptions.evnum, dAQgetOptions.time, string, dAQgetOptions.access, dAQgetOptions.access);
        }
        return this.get_monitor(dAQgetOptions.evnum, dAQgetOptions.time, null, dAQgetOptions.access, dAQgetOptions.access);
    }

    public int get_monitor(int n) {
        if (this.cache.IsEmpty()) {
            n = 0;
            if (this.thr_id != 0L) {
                if (this.done) {
                    return 34;
                }
                return 2;
            }
            if (this.done) {
                return 50;
            }
            return 18;
        }
        if (this.cache.IsFull()) {
            n = this.depth;
            if (this.thr_id != 0L) {
                if (this.done) {
                    return 41;
                }
                return 9;
            }
            if (this.done) {
                return 57;
            }
            return 25;
        }
        n = this.cache.GetNRecords();
        if (this.thr_id != 0L) {
            if (this.done) {
                return 33;
            }
            return 1;
        }
        if (this.done) {
            return 49;
        }
        return 17;
    }

    public boolean get_monitor(time_stamp time_stamp2, int n) {
        if (n == 0) {
            return this.cache.get_first_time(time_stamp2);
        }
        return this.cache.get_last_time(time_stamp2);
    }

    public boolean get_monitor(int[] nArray, int n) {
        if (n == 0) {
            return this.cache.get_first_eventnum(nArray);
        }
        return this.cache.get_last_eventnum(nArray);
    }

    public EqDataCache get_cache() {
        return this.cache;
    }

    public void clear_monitor() {
        this.init();
    }

    public boolean if_thread_is_over() {
        return this.thr_id == 0L;
    }
}

