/*
 * Decompiled with CFR 0.152.
 */
package runtime;

import DOOCSComponents.DOOCSLayeredPane;
import DOOCSComponents.DOOCSParameter;
import editor.ExampleFileFilter;
import editor.StartParameters;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import javax.imageio.ImageIO;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import jsvnbrowser.JSVNBrowser;
import jsvnbrowser.JSVNFileInfo;
import xmlparser.DOOCSParser;

public class jddd_png {
    public static int doocsUpdateTime = 60;

    public static void main(String[] args) {
        jddd_png.startPngCreation(null, null, null);
    }

    public static void startPngCreation(String file, String pngPath, String baseAddress) {
        JSVNFileInfo fInfo = null;
        if (file == null || file != null && file.equalsIgnoreCase("null")) {
            JOptionPane.showMessageDialog(null, "Choose jddd file.");
            StartParameters startParams = StartParameters.getInstance();
            if (startParams.getSvnRepository() != null) {
                JSVNBrowser browser = new JSVNBrowser();
                if (startParams.getSvnDirectory() != null) {
                    browser.setCurrentDirectory(startParams.getSvnDirectory());
                }
                fInfo = browser.showOpenDialog(null);
            }
            if (fInfo == null) {
                JFileChooser chooser = new JFileChooser();
                ExampleFileFilter filter = new ExampleFileFilter();
                filter.addExtension("xml");
                filter.setDescription("XML files");
                chooser.setFileFilter(filter);
                chooser.showOpenDialog(null);
                File selFile = chooser.getSelectedFile();
                if (selFile != null) {
                    file = selFile.getPath();
                }
            }
        } else if (!file.endsWith(".xml") && !file.contains(".")) {
            file = file + ".xml";
        }
        if (fInfo == null) {
            fInfo = DOOCSParameter.getDoocsPath(file, null);
        }
        if (fInfo != null) {
            if (pngPath == null) {
                JOptionPane.showMessageDialog(null, "Choose path for saving png files.");
                JFileChooser chooser = new JFileChooser();
                ExampleFileFilter filter = new ExampleFileFilter();
                filter.addExtension("xml");
                filter.setDescription("XML files");
                chooser.setFileFilter(filter);
                chooser.showOpenDialog(null);
                File selFile = chooser.getSelectedFile();
                if (selFile != null) {
                    pngPath = selFile.getParent();
                }
            }
            if (pngPath != null) {
                String filename = fInfo.filename.substring(0, fInfo.filename.indexOf("."));
                File saveFile = new File(pngPath + File.separator + filename + ".png");
                File bakFile = new File(pngPath + File.separator + filename + ".bak");
                final JFrame frame = new JFrame();
                DOOCSLayeredPane panel = new DOOCSLayeredPane();
                if (baseAddress != null) {
                    panel.setDoocsAddress(baseAddress);
                }
                panel.setDoocsXmlFilePath(fInfo.filepath);
                DOOCSParser.parseStringBuffer(panel, fInfo.buf);
                JScrollPane scrPane = new JScrollPane(panel);
                frame.setContentPane(scrPane);
                panel.setRunMode(true);
                frame.setTitle(fInfo.filepath);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        frame.pack();
                    }
                });
                BufferedImage bufferedImage = new BufferedImage(panel.getSize().width, panel.getSize().height, 1);
                Graphics2D g2d = bufferedImage.createGraphics();
                while (true) {
                    panel.paint(g2d);
                    try {
                        if (bakFile != null) {
                            ImageIO.write((RenderedImage)bufferedImage, "png", bakFile);
                        }
                        jddd_png.copy(bakFile, saveFile);
                    }
                    catch (IOException e) {
                        System.err.println("IOException: " + e);
                    }
                    try {
                        Thread.sleep(doocsUpdateTime * 1000);
                    }
                    catch (InterruptedException e) {
                        panel.setRunMode(false);
                        System.out.println(e);
                    }
                }
            }
        }
    }

    private static void copy(File src, File dst) throws IOException {
        FileChannel inChannel = new FileInputStream(src).getChannel();
        FileChannel outChannel = new FileOutputStream(dst).getChannel();
        try {
            inChannel.transferTo(0L, inChannel.size(), outChannel);
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (inChannel != null) {
                inChannel.close();
            }
            if (outChannel != null) {
                outChannel.close();
            }
        }
    }
}

