/*
 * Decompiled with CFR 0.152.
 */
package layoutmanager;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSIf;
import DOOCSComponents.DOOCSSwitch;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import layoutmanager.ScaleConstraints;

public class ScaleLayout
implements LayoutManager2,
Serializable {
    protected Hashtable<Component, Object> constraints = new Hashtable();
    protected double m_initialWidth = -1.0;
    protected double m_initialHeight = -1.0;
    protected boolean runMode = false;
    private double storedXFactor = 1.0;
    private double storedYFactor = 1.0;

    public ScaleLayout(Dimension size) {
        this.m_initialWidth = size.getWidth();
        this.m_initialHeight = size.getHeight();
    }

    public void setRunMode(boolean mode, Container parent) {
        this.runMode = mode;
    }

    public boolean isRunMode() {
        return this.runMode;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        throw new IllegalArgumentException();
    }

    @Override
    public void addLayoutComponent(Component comp, Object constr) {
        if (!(constr instanceof ScaleConstraints)) {
            throw new IllegalArgumentException();
        }
        this.constraints.put(comp, constr);
        if (!this.runMode) {
            comp.setLocation(((ScaleConstraints)constr).getX(), ((ScaleConstraints)constr).getY());
            comp.setSize(((ScaleConstraints)constr).getWidth(), ((ScaleConstraints)constr).getHeight());
        }
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this.constraints.remove(comp);
    }

    public void changeComponentPosition(Component comp, int x, int y) {
        ScaleConstraints sc = (ScaleConstraints)this.constraints.get(comp);
        sc.setX(x);
        sc.setY(y);
    }

    public void changeComponentBounds(Component comp, int x, int y, int width, int height) {
        ScaleConstraints sc = (ScaleConstraints)this.constraints.get(comp);
        sc.setX(x);
        sc.setY(y);
        sc.setWidth(width);
        sc.setHeight(height);
    }

    public void changeComponentBounds(Component comp, Rectangle rect) {
        ScaleConstraints sc = (ScaleConstraints)this.constraints.get(comp);
        sc.setX(rect.x);
        sc.setY(rect.y);
        sc.setWidth(rect.width);
        sc.setHeight(rect.height);
    }

    public ScaleConstraints getScaleConstraints(Component comp) {
        return (ScaleConstraints)this.constraints.get(comp);
    }

    public double getXFactor() {
        return this.storedXFactor;
    }

    public double getYFactor() {
        return this.storedYFactor;
    }

    public void resetStoredFactors() {
        this.storedXFactor = 0.0;
        this.storedYFactor = 0.0;
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return new Dimension((int)this.m_initialWidth, (int)this.m_initialHeight);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension((int)this.m_initialWidth, (int)this.m_initialHeight);
    }

    @Override
    public void layoutContainer(Container parent) {
        Dimension parentSize = parent.getSize();
        double xFactor = parentSize.getWidth() / this.m_initialWidth;
        double yFactor = parentSize.getHeight() / this.m_initialHeight;
        if (this.storedXFactor != xFactor || this.storedYFactor != yFactor) {
            this.storedXFactor = xFactor;
            this.storedYFactor = yFactor;
            if (this.m_initialHeight > 0.0 && this.m_initialWidth > 0.0 && this.runMode) {
                Enumeration<Component> e = this.constraints.keys();
                while (e.hasMoreElements()) {
                    Component comp = e.nextElement();
                    ScaleConstraints sc = (ScaleConstraints)this.constraints.get(comp);
                    Dimension size = comp.getPreferredSize();
                    int width = sc.getWidth();
                    int height = sc.getHeight();
                    if (width == -1) {
                        width = size.width;
                    }
                    if (height == -1) {
                        height = size.height;
                    }
                    double newWidth = (double)width * xFactor;
                    double newHeight = (double)height * yFactor;
                    if (((DOOCSComponent)((Object)comp)).getDoocsScale()) {
                        Font f;
                        if (comp instanceof DOOCSSwitch || comp instanceof DOOCSIf) {
                            ((DOOCSSwitch)comp).setNewBounds(Math.round((float)((double)sc.x * xFactor)), Math.round((float)((double)sc.y * yFactor)), Math.round((float)newWidth), Math.round((float)newHeight), false);
                        } else {
                            comp.setBounds(Math.round((float)((double)sc.x * xFactor)), Math.round((float)((double)sc.y * yFactor)), Math.round((float)newWidth), Math.round((float)newHeight));
                        }
                        if ((f = comp.getFont()) == null) continue;
                        AffineTransform aft = f.getTransform();
                        aft.setToScale(xFactor, yFactor);
                        f = f.deriveFont(aft);
                        comp.setFont(f);
                        continue;
                    }
                    comp.setLocation(Math.round((float)((double)sc.x * xFactor + newWidth / 2.0 - (double)((float)width / 2.0f))), Math.round((float)((double)sc.y * yFactor + newHeight / 2.0 - (double)((float)height / 2.0f))));
                }
            }
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }
}

