/*
 * Decompiled with CFR 0.152.
 */
package editor;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSParameter;
import editor.EditorPanel;
import editor.PropsTable;
import editor.PropsTableCellEditor2;
import editor.PropsTableModel;
import editor.TriangleIcon;
import editor.events.DOOCSSelectEvent;
import editor.events.DOOCSUpdateEditorEvent;
import editor.events.DOOCSUpdateTreeEvent;
import editor.events.UNDOPropertyChangeEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.UIManager;

public class PropsTablePanel
extends JPanel
implements DOOCSSelectEvent,
ActionListener,
MouseMotionListener {
    JToggleButton buttonNormal;
    JToggleButton buttonExpert;
    JToggleButton buttonScale;
    JToggleButton buttonXAxis;
    JToggleButton buttonYAxis;
    JToggleButton buttonChannel;
    PropsTable tableNormal;
    PropsTable tableExpert;
    PropsTable tableScale;
    PropsTable tableXAxis;
    PropsTable tableYAxis;
    PropsTable tableChannel;
    JPanel panelTop = new JPanel();
    JPanel panelCenter = new JPanel();
    private boolean resize = false;

    public PropsTablePanel() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.panelTop, "North");
        this.add((Component)this.panelCenter, "Center");
        GridBagLayout gbl = new GridBagLayout();
        this.panelTop.setLayout(gbl);
        this.buttonNormal = new JToggleButton("Standard Properties", new TriangleIcon(0));
        this.buttonExpert = new JToggleButton("Expert Properties", new TriangleIcon(0));
        this.buttonScale = new JToggleButton("Scale Properties", new TriangleIcon(0));
        this.buttonXAxis = new JToggleButton("X Axis Properties", new TriangleIcon(0));
        this.buttonYAxis = new JToggleButton("Y Axis Properties", new TriangleIcon(0));
        this.buttonChannel = new JToggleButton("Channel Properties", new TriangleIcon(0));
        this.tableNormal = new PropsTable(DOOCSParameter.Levels.NORMAL);
        this.tableExpert = new PropsTable(DOOCSParameter.Levels.EXPERT);
        this.tableScale = new PropsTable(DOOCSParameter.Levels.SCALE);
        this.tableXAxis = new PropsTable(DOOCSParameter.Levels.XAXIS);
        this.tableYAxis = new PropsTable(DOOCSParameter.Levels.YAXIS);
        this.tableChannel = new PropsTable(DOOCSParameter.Levels.CHANNEL);
        UIManager.put("ToggleButton.select", new Color(232, 232, 232));
        this.addComponent(gbl, this.buttonNormal, 0, 0, 0.0);
        this.addComponent(gbl, this.tableNormal, 0, 1, 1.0);
        this.addComponent(gbl, this.buttonChannel, 0, 2, 0.0);
        this.addComponent(gbl, this.tableChannel, 0, 3, 1.0);
        this.addComponent(gbl, this.buttonXAxis, 0, 4, 0.0);
        this.addComponent(gbl, this.tableXAxis, 0, 5, 1.0);
        this.addComponent(gbl, this.buttonYAxis, 0, 6, 0.0);
        this.addComponent(gbl, this.tableYAxis, 0, 7, 1.0);
        this.addComponent(gbl, this.buttonExpert, 0, 8, 0.0);
        this.addComponent(gbl, this.tableExpert, 0, 9, 1.0);
        this.addComponent(gbl, this.buttonScale, 0, 10, 0.0);
        this.addComponent(gbl, this.tableScale, 0, 11, 1.0);
        for (int i = 0; i < this.panelTop.getComponentCount(); ++i) {
            Component comp = this.panelTop.getComponent(i);
            if (comp instanceof PropsTable) {
                ((PropsTable)comp).setAutoResizeMode(0);
                ((PropsTable)comp).setCellSelectionEnabled(false);
                comp.addMouseMotionListener(this);
            }
            if (!(comp instanceof JToggleButton)) continue;
            ((JToggleButton)comp).setBackground(new Color(232, 232, 232));
            ((JToggleButton)comp).setSelectedIcon(new TriangleIcon(1));
            ((JToggleButton)comp).setHorizontalAlignment(2);
            ((JToggleButton)comp).addActionListener(this);
            ((JToggleButton)comp).setSelected(true);
            ((JToggleButton)comp).setBorder(BorderFactory.createBevelBorder(0));
            ((JToggleButton)comp).setVisible(false);
        }
    }

    private void addComponent(GridBagLayout gbl, Component c, int x, int y, double weighty) {
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.fill = 1;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.weightx = 1.0;
        gbc.weighty = weighty;
        gbl.setConstraints(c, gbc);
        this.panelTop.add(c);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (((JToggleButton)e.getSource()).getText().startsWith("Standard") && ((JToggleButton)e.getSource()).isSelected()) {
            this.tableNormal.setVisible(true);
        }
        if (((JToggleButton)e.getSource()).getText().startsWith("Standard") && !((JToggleButton)e.getSource()).isSelected()) {
            this.tableNormal.setVisible(false);
        }
        if (((JToggleButton)e.getSource()).getText().startsWith("Expert") && ((JToggleButton)e.getSource()).isSelected()) {
            this.tableExpert.setVisible(true);
        }
        if (((JToggleButton)e.getSource()).getText().startsWith("Expert") && !((JToggleButton)e.getSource()).isSelected()) {
            this.tableExpert.setVisible(false);
        }
        if (((JToggleButton)e.getSource()).getText().startsWith("Scale") && ((JToggleButton)e.getSource()).isSelected()) {
            this.tableScale.setVisible(true);
        }
        if (((JToggleButton)e.getSource()).getText().startsWith("Scale") && !((JToggleButton)e.getSource()).isSelected()) {
            this.tableScale.setVisible(false);
        }
        if (((JToggleButton)e.getSource()).getText().startsWith("X Axis") && ((JToggleButton)e.getSource()).isSelected()) {
            this.tableXAxis.setVisible(true);
        }
        if (((JToggleButton)e.getSource()).getText().startsWith("X Axis") && !((JToggleButton)e.getSource()).isSelected()) {
            this.tableXAxis.setVisible(false);
        }
        if (((JToggleButton)e.getSource()).getText().startsWith("Y Axis") && ((JToggleButton)e.getSource()).isSelected()) {
            this.tableYAxis.setVisible(true);
        }
        if (((JToggleButton)e.getSource()).getText().startsWith("Y Axis") && !((JToggleButton)e.getSource()).isSelected()) {
            this.tableYAxis.setVisible(false);
        }
        if (((JToggleButton)e.getSource()).getText().startsWith("Channel") && ((JToggleButton)e.getSource()).isSelected()) {
            this.tableChannel.setVisible(true);
        }
        if (((JToggleButton)e.getSource()).getText().startsWith("Channel") && !((JToggleButton)e.getSource()).isSelected()) {
            this.tableChannel.setVisible(false);
        }
    }

    @Override
    public void DOOCSObjectSelected(DOOCSComponent[] comp) {
        this.tableNormal.DOOCSObjectSelected(comp);
        if (this.tableNormal.getRowCount() > 0) {
            this.buttonNormal.setVisible(true);
        } else {
            this.buttonNormal.setVisible(false);
        }
        this.tableChannel.DOOCSObjectSelected(comp);
        if (this.tableChannel.getRowCount() > 0) {
            this.buttonChannel.setVisible(true);
        } else {
            this.buttonChannel.setVisible(false);
        }
        this.tableXAxis.DOOCSObjectSelected(comp);
        if (this.tableXAxis.getRowCount() > 0) {
            this.buttonXAxis.setVisible(true);
        } else {
            this.buttonXAxis.setVisible(false);
        }
        this.tableYAxis.DOOCSObjectSelected(comp);
        if (this.tableYAxis.getRowCount() > 0) {
            this.buttonYAxis.setVisible(true);
        } else {
            this.buttonYAxis.setVisible(false);
        }
        this.tableExpert.DOOCSObjectSelected(comp);
        if (this.tableExpert.getRowCount() > 0) {
            this.buttonExpert.setVisible(true);
        } else {
            this.buttonExpert.setVisible(false);
        }
        this.tableScale.DOOCSObjectSelected(comp);
        if (this.tableScale.getRowCount() > 0) {
            this.buttonScale.setVisible(true);
        } else {
            this.buttonScale.setVisible(false);
        }
    }

    public void addDOOCSUpdateEditorListener(DOOCSUpdateEditorEvent due) {
        ((PropsTableModel)this.tableNormal.getModel()).addDOOCSUpdateEditorListener(due);
        ((PropsTableModel)this.tableExpert.getModel()).addDOOCSUpdateEditorListener(due);
        ((PropsTableModel)this.tableChannel.getModel()).addDOOCSUpdateEditorListener(due);
        ((PropsTableModel)this.tableXAxis.getModel()).addDOOCSUpdateEditorListener(due);
        ((PropsTableModel)this.tableYAxis.getModel()).addDOOCSUpdateEditorListener(due);
        ((PropsTableModel)this.tableScale.getModel()).addDOOCSUpdateEditorListener(due);
    }

    public void addDOOCSUpdateTreeListener(DOOCSUpdateTreeEvent due) {
        ((PropsTableModel)this.tableNormal.getModel()).addDOOCSUpdateTreeListener(due);
        ((PropsTableModel)this.tableExpert.getModel()).addDOOCSUpdateTreeListener(due);
        ((PropsTableModel)this.tableChannel.getModel()).addDOOCSUpdateTreeListener(due);
        ((PropsTableModel)this.tableXAxis.getModel()).addDOOCSUpdateTreeListener(due);
        ((PropsTableModel)this.tableYAxis.getModel()).addDOOCSUpdateTreeListener(due);
        ((PropsTableModel)this.tableScale.getModel()).addDOOCSUpdateTreeListener(due);
    }

    public void addDOOCSUndoPropertyChangeListener(UNDOPropertyChangeEvent due) {
        ((PropsTableModel)this.tableNormal.getModel()).addDOOCSUndoPropertyChangeListener(due);
        ((PropsTableModel)this.tableExpert.getModel()).addDOOCSUndoPropertyChangeListener(due);
        ((PropsTableModel)this.tableChannel.getModel()).addDOOCSUndoPropertyChangeListener(due);
        ((PropsTableModel)this.tableXAxis.getModel()).addDOOCSUndoPropertyChangeListener(due);
        ((PropsTableModel)this.tableYAxis.getModel()).addDOOCSUndoPropertyChangeListener(due);
        ((PropsTableModel)this.tableScale.getModel()).addDOOCSUndoPropertyChangeListener(due);
    }

    public void setPanelFromSVN(boolean set) {
        ((PropsTableCellEditor2)this.tableNormal.getColumnModel().getColumn((int)2).getCellEditor()).panelFromSVN = set;
        ((PropsTableCellEditor2)this.tableChannel.getColumnModel().getColumn((int)2).getCellEditor()).panelFromSVN = set;
        ((PropsTableCellEditor2)this.tableXAxis.getColumnModel().getColumn((int)2).getCellEditor()).panelFromSVN = set;
        ((PropsTableCellEditor2)this.tableYAxis.getColumnModel().getColumn((int)2).getCellEditor()).panelFromSVN = set;
        ((PropsTableCellEditor2)this.tableExpert.getColumnModel().getColumn((int)2).getCellEditor()).panelFromSVN = set;
        ((PropsTableCellEditor2)this.tableScale.getColumnModel().getColumn((int)2).getCellEditor()).panelFromSVN = set;
    }

    public void setEpanel(EditorPanel panel) {
        ((PropsTableCellEditor2)this.tableNormal.getColumnModel().getColumn((int)2).getCellEditor()).epanel = panel;
        ((PropsTableCellEditor2)this.tableChannel.getColumnModel().getColumn((int)2).getCellEditor()).epanel = panel;
        ((PropsTableCellEditor2)this.tableXAxis.getColumnModel().getColumn((int)2).getCellEditor()).epanel = panel;
        ((PropsTableCellEditor2)this.tableYAxis.getColumnModel().getColumn((int)2).getCellEditor()).epanel = panel;
        ((PropsTableCellEditor2)this.tableExpert.getColumnModel().getColumn((int)2).getCellEditor()).epanel = panel;
        ((PropsTableCellEditor2)this.tableScale.getColumnModel().getColumn((int)2).getCellEditor()).epanel = panel;
    }

    @Override
    public void mouseDragged(MouseEvent me) {
        if (this.resize && me.getX() > 30 && me.getX() < this.tableNormal.getWidth() - 100) {
            for (int i = 0; i < this.panelTop.getComponentCount(); ++i) {
                Component comp = this.panelTop.getComponent(i);
                if (!(comp instanceof PropsTable)) continue;
                ((PropsTable)comp).getColumnModel().getColumn(0).setPreferredWidth(me.getX());
                ((PropsTable)comp).getColumnModel().getColumn(0).setMinWidth(me.getX());
                ((PropsTable)comp).getColumnModel().getColumn(0).setMaxWidth(me.getX());
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent me) {
        int firstColWidth = this.tableNormal.getColumnModel().getColumn(0).getWidth();
        if (firstColWidth - 2 < me.getX() && me.getX() < firstColWidth + 2) {
            if (!this.resize) {
                this.setCursor(new Cursor(11));
                this.resize = true;
            }
        } else if (this.resize) {
            this.setCursor(new Cursor(0));
            this.resize = false;
        }
    }
}

