/*
 * Decompiled with CFR 0.152.
 */
package editor;

import DOOCSComponents.DOOCSAlive;
import DOOCSComponents.DOOCSAudio;
import DOOCSComponents.DOOCSButton;
import DOOCSComponents.DOOCSCameraImage;
import DOOCSComponents.DOOCSCheckBox;
import DOOCSComponents.DOOCSColouredIndicator;
import DOOCSComponents.DOOCSComboBox;
import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSDeviceTree;
import DOOCSComponents.DOOCSDial;
import DOOCSComponents.DOOCSDynamicList;
import DOOCSComponents.DOOCSIcon;
import DOOCSComponents.DOOCSIf;
import DOOCSComponents.DOOCSIfCase;
import DOOCSComponents.DOOCSIncludeComponent;
import DOOCSComponents.DOOCSLabel;
import DOOCSComponents.DOOCSLayeredPane;
import DOOCSComponents.DOOCSLine;
import DOOCSComponents.DOOCSLocationChooser;
import DOOCSComponents.DOOCSOval;
import DOOCSComponents.DOOCSProgressBar;
import DOOCSComponents.DOOCSPropertiesTable;
import DOOCSComponents.DOOCSRect;
import DOOCSComponents.DOOCSSlider;
import DOOCSComponents.DOOCSStatusRegister;
import DOOCSComponents.DOOCSSwitch;
import DOOCSComponents.DOOCSSwitchCase;
import DOOCSComponents.DOOCSTab;
import DOOCSComponents.DOOCSTabbedPane;
import DOOCSComponents.DOOCSTextArea;
import DOOCSComponents.DOOCSTextField;
import DOOCSComponents.DOOCSToggleButton;
import DOOCSComponents.DOOCSTriangle;
import DOOCSComponents.DOOCSValue;
import DOOCSPlot.DOOCSPlotHist;
import DOOCSPlot.DOOCSPlotLocation;
import DOOCSPlot.DOOCSPlotSpectrum;
import DOOCSPlot.DOOCSPlotXY;
import editor.IconTreeRenderer;
import editor.StartParameters;
import editor.events.DOOCSAddEvent;
import editor.events.DOOCSSelectEvent;
import java.awt.datatransfer.StringSelection;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class PaletteTree
extends JTree
implements DOOCSSelectEvent,
DragGestureListener,
DragSourceListener {
    protected Vector<DOOCSAddEvent> addListener;
    private DragSource dragSource;
    private boolean dragOK = false;
    private String pluginPath = null;
    private File pluginFile = null;
    private URLClassLoader newCL;
    private MouseAdapter ml = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e) {
            PaletteTree.this.dragOK = false;
            int selRow = PaletteTree.this.getRowForLocation(e.getX(), e.getY());
            TreePath selPath = PaletteTree.this.getPathForLocation(e.getX(), e.getY());
            if (selRow != -1 && selPath.getPathCount() > 2 && e.getClickCount() == 1) {
                PaletteTree.this.setSelectionPath(selPath);
                String selComp = selPath.getLastPathComponent().toString();
                DOOCSComponent comp = null;
                if (selComp.equalsIgnoreCase("LayeredPane")) {
                    comp = new DOOCSLayeredPane();
                } else if (selComp.equalsIgnoreCase("Label")) {
                    comp = new DOOCSLabel();
                } else if (selComp.equalsIgnoreCase("Button")) {
                    comp = new DOOCSButton();
                } else if (selComp.equalsIgnoreCase("ToggleButton")) {
                    comp = new DOOCSToggleButton();
                } else if (selComp.equalsIgnoreCase("Value")) {
                    comp = new DOOCSValue();
                } else if (selComp.equalsIgnoreCase("Dial")) {
                    comp = new DOOCSDial();
                } else if (selComp.equalsIgnoreCase("CheckBox")) {
                    comp = new DOOCSCheckBox();
                } else if (selComp.equalsIgnoreCase("ProgressBar")) {
                    comp = new DOOCSProgressBar();
                } else if (selComp.equalsIgnoreCase("Slider")) {
                    comp = new DOOCSSlider();
                } else if (selComp.equalsIgnoreCase("Line")) {
                    comp = new DOOCSLine();
                } else if (selComp.equalsIgnoreCase("Oval")) {
                    comp = new DOOCSOval();
                } else if (selComp.equalsIgnoreCase("ColouredIndicator")) {
                    comp = new DOOCSColouredIndicator();
                } else if (selComp.equalsIgnoreCase("ComboBox")) {
                    comp = new DOOCSComboBox();
                } else if (selComp.equalsIgnoreCase("LocationChooser")) {
                    comp = new DOOCSLocationChooser();
                } else if (selComp.equalsIgnoreCase("Rectangle")) {
                    comp = new DOOCSRect();
                } else if (selComp.equalsIgnoreCase("Triangle")) {
                    comp = new DOOCSTriangle();
                } else if (selComp.equalsIgnoreCase("StatusRegister")) {
                    comp = new DOOCSStatusRegister();
                } else if (selComp.equalsIgnoreCase("PlotSpectrum")) {
                    comp = new DOOCSPlotSpectrum();
                } else if (selComp.equalsIgnoreCase("PlotHist")) {
                    comp = new DOOCSPlotHist();
                } else if (selComp.equalsIgnoreCase("PlotLocation")) {
                    comp = new DOOCSPlotLocation();
                } else if (selComp.equalsIgnoreCase("PlotXY")) {
                    comp = new DOOCSPlotXY();
                } else if (selComp.equalsIgnoreCase("Icon")) {
                    comp = new DOOCSIcon();
                } else if (selComp.equalsIgnoreCase("CameraImage")) {
                    comp = new DOOCSCameraImage();
                } else if (selComp.equalsIgnoreCase("TextField")) {
                    comp = new DOOCSTextField();
                } else if (selComp.equalsIgnoreCase("TextArea")) {
                    comp = new DOOCSTextArea();
                } else if (selComp.equalsIgnoreCase("PropertiesTable")) {
                    comp = new DOOCSPropertiesTable();
                } else if (selComp.equalsIgnoreCase("DeviceTree")) {
                    comp = new DOOCSDeviceTree();
                } else if (selComp.equalsIgnoreCase("DynamicList")) {
                    comp = new DOOCSDynamicList();
                } else if (selComp.equalsIgnoreCase("Alive")) {
                    comp = new DOOCSAlive();
                } else if (selComp.equalsIgnoreCase("Audio")) {
                    comp = new DOOCSAudio();
                } else if (selComp.equalsIgnoreCase("Switch")) {
                    comp = new DOOCSSwitch();
                    ((DOOCSSwitch)comp).addCases();
                } else if (selComp.equalsIgnoreCase("Case")) {
                    comp = new DOOCSSwitchCase();
                } else if (selComp.equalsIgnoreCase("If")) {
                    comp = new DOOCSIf();
                    ((DOOCSIf)comp).addCases();
                } else if (selComp.equalsIgnoreCase("IfCase")) {
                    comp = new DOOCSIfCase();
                } else if (selComp.equalsIgnoreCase("TabbedPane")) {
                    comp = new DOOCSTabbedPane();
                    ((DOOCSTabbedPane)comp).addTabs();
                } else if (selComp.equalsIgnoreCase("Tab")) {
                    comp = new DOOCSTab();
                } else if (selComp.equalsIgnoreCase("IncludeComponent")) {
                    comp = new DOOCSIncludeComponent();
                } else {
                    try {
                        if (PaletteTree.this.pluginPath != null && PaletteTree.this.pluginPath.length() > 0) {
                            Class<?> cl = PaletteTree.this.newCL.loadClass("DOOCS" + selComp);
                            comp = (DOOCSComponent)cl.newInstance();
                        }
                    }
                    catch (ClassNotFoundException ex) {
                        System.out.println("PaletteTree: " + ex);
                    }
                    catch (InstantiationException ex) {
                        System.out.println("PaletteTree: " + ex);
                    }
                    catch (IllegalAccessException ex) {
                        System.out.println("PaletteTree: " + ex);
                    }
                    catch (NoClassDefFoundError ex) {
                        System.out.println("PaletteTree: " + ex);
                    }
                }
                if (comp != null) {
                    PaletteTree.this.dragOK = true;
                    for (int i = 0; i < PaletteTree.this.addListener.size(); ++i) {
                        PaletteTree.this.addListener.get(i).DOOCSAddObjectSelected(comp);
                    }
                }
            }
        }
    };

    public PaletteTree(DefaultMutableTreeNode root) {
        super(root);
        this.pluginPath = StartParameters.getInstance().getPluginPath();
        if (this.pluginPath != null && this.pluginPath.length() > 0) {
            this.pluginFile = StartParameters.getInstance().getPluginFile();
            this.newCL = StartParameters.getInstance().getClassLoader();
        }
        this.fillPalette(root);
        TreePath rootPath = this.getPathForRow(0);
        this.expandAll(rootPath, true);
        this.setCellRenderer(new IconTreeRenderer());
        this.putClientProperty("JTree.lineStyle", "None");
        this.addMouseListener(this.ml);
        this.addListener = new Vector();
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 3, this);
    }

    public void fillPalette(DefaultMutableTreeNode root) {
        DefaultMutableTreeNode panes = new DefaultMutableTreeNode("Pane Components");
        DefaultMutableTreeNode statics = new DefaultMutableTreeNode("Static Components");
        DefaultMutableTreeNode dynamics = new DefaultMutableTreeNode("Dynamic Components");
        DefaultMutableTreeNode logics = new DefaultMutableTreeNode("Logic Components");
        DefaultMutableTreeNode plots = new DefaultMutableTreeNode("Plot Components");
        DefaultMutableTreeNode tabbedPane = new DefaultMutableTreeNode("TabbedPane");
        tabbedPane.add(new DefaultMutableTreeNode("Tab"));
        DefaultMutableTreeNode switchstatement = new DefaultMutableTreeNode("Switch");
        switchstatement.add(new DefaultMutableTreeNode("Case"));
        DefaultMutableTreeNode ifstatement = new DefaultMutableTreeNode("If");
        panes.add(new DefaultMutableTreeNode("LayeredPane"));
        panes.add(tabbedPane);
        panes.add(new DefaultMutableTreeNode("IncludeComponent"));
        panes.add(new DefaultMutableTreeNode("DynamicList"));
        panes.add(new DefaultMutableTreeNode("Alive"));
        statics.add(new DefaultMutableTreeNode("Label"));
        statics.add(new DefaultMutableTreeNode("Line"));
        statics.add(new DefaultMutableTreeNode("Oval"));
        statics.add(new DefaultMutableTreeNode("Rectangle"));
        statics.add(new DefaultMutableTreeNode("Triangle"));
        statics.add(new DefaultMutableTreeNode("Icon"));
        dynamics.add(new DefaultMutableTreeNode("Button"));
        dynamics.add(new DefaultMutableTreeNode("ToggleButton"));
        dynamics.add(new DefaultMutableTreeNode("Value"));
        dynamics.add(new DefaultMutableTreeNode("Dial"));
        dynamics.add(new DefaultMutableTreeNode("TextField"));
        dynamics.add(new DefaultMutableTreeNode("ComboBox"));
        dynamics.add(new DefaultMutableTreeNode("CheckBox"));
        dynamics.add(new DefaultMutableTreeNode("ProgressBar"));
        dynamics.add(new DefaultMutableTreeNode("Slider"));
        dynamics.add(new DefaultMutableTreeNode("StatusRegister"));
        dynamics.add(new DefaultMutableTreeNode("Audio"));
        dynamics.add(new DefaultMutableTreeNode("ColouredIndicator"));
        dynamics.add(new DefaultMutableTreeNode("LocationChooser"));
        dynamics.add(new DefaultMutableTreeNode("CameraImage"));
        dynamics.add(new DefaultMutableTreeNode("TextArea"));
        dynamics.add(new DefaultMutableTreeNode("PropertiesTable"));
        dynamics.add(new DefaultMutableTreeNode("DeviceTree"));
        logics.add(ifstatement);
        logics.add(switchstatement);
        plots.add(new DefaultMutableTreeNode("PlotSpectrum"));
        plots.add(new DefaultMutableTreeNode("PlotHist"));
        plots.add(new DefaultMutableTreeNode("PlotLocation"));
        plots.add(new DefaultMutableTreeNode("PlotXY"));
        root.add(panes);
        root.add(statics);
        root.add(dynamics);
        root.add(logics);
        root.add(plots);
        try {
            if (this.pluginFile != null) {
                String jarName = this.pluginFile.getName();
                jarName = jarName.substring(0, jarName.indexOf("."));
                DefaultMutableTreeNode plugins = new DefaultMutableTreeNode(jarName);
                JarFile jarFile = new JarFile(this.pluginFile);
                Enumeration<JarEntry> myenum = jarFile.entries();
                while (myenum.hasMoreElements()) {
                    String temp = ((Object)myenum.nextElement()).toString();
                    if (!temp.startsWith("DOOCS") || !temp.endsWith(".class")) continue;
                    temp = temp.substring(5, temp.indexOf("."));
                    plugins.add(new DefaultMutableTreeNode(temp));
                }
                root.add(plugins);
            }
        }
        catch (MalformedURLException ex) {
            System.out.println("PaletteTree: " + ex);
        }
        catch (IOException e) {
            System.out.println("PaletteTree: " + e);
        }
    }

    private void expandAll(TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(path, expand);
            }
        }
        if (expand) {
            this.expandPath(parent);
        } else {
            this.collapsePath(parent);
        }
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        if (this.getRowForLocation(evt.getX(), evt.getY()) == -1) {
            return null;
        }
        TreePath curPath = this.getPathForLocation(evt.getX(), evt.getY());
        if (curPath.getPathCount() < 3) {
            return null;
        }
        DefaultMutableTreeNode selNode = (DefaultMutableTreeNode)curPath.getLastPathComponent();
        String name = selNode.getUserObject().toString();
        if (name.equalsIgnoreCase("LayeredPane")) {
            return "A rectangular display area for DOOCS components.";
        }
        if (name.equalsIgnoreCase("TabbedPane")) {
            return "A TabbedPane with 2 Tabs. Additional Tabs can be added.";
        }
        if (name.equalsIgnoreCase("Tab")) {
            return "A Tab for the TabbedPane.";
        }
        if (name.equalsIgnoreCase("IncludeComponent")) {
            return "A display area which is included as xml-File.";
        }
        if (name.equalsIgnoreCase("Label")) {
            return "A component that displays a text string.";
        }
        if (name.equalsIgnoreCase("Button")) {
            return "A \"push\" button.";
        }
        if (name.equalsIgnoreCase("ToggleButton")) {
            return "A \"push\" button to toggle boolean values.";
        }
        if (name.equalsIgnoreCase("Value")) {
            return "A component that displays a DOOCS value.";
        }
        if (name.equalsIgnoreCase("Dial")) {
            return "A dial for setting a DOOCS value.";
        }
        if (name.equalsIgnoreCase("ProgressBar")) {
            return "A progress bar for setting a DOOCS value.";
        }
        if (name.equalsIgnoreCase("Slider")) {
            return "A slider for setting a DOOCS value.";
        }
        if (name.equalsIgnoreCase("CheckBox")) {
            return "A checkbox for setting a boolean DOOCS value.";
        }
        if (name.equalsIgnoreCase("Line")) {
            return "A component that displays a line.";
        }
        if (name.equalsIgnoreCase("Oval")) {
            return "A component that displays an oval.";
        }
        if (name.equalsIgnoreCase("Rectangle")) {
            return "A component that displays a rectangle.";
        }
        if (name.equalsIgnoreCase("Triangle")) {
            return "A component that displays a triangle.";
        }
        if (name.equalsIgnoreCase("StatusRegister")) {
            return "A status register for a DOOCS status value.";
        }
        if (name.equalsIgnoreCase("PlotSpectrum")) {
            return "A spectrum type plot of DOOCS data.";
        }
        if (name.equalsIgnoreCase("PlotHist")) {
            return "A history type plot of DOOCS data.";
        }
        if (name.equalsIgnoreCase("PlotLocation")) {
            return "A location type plot of DOOCS data.";
        }
        if (name.equalsIgnoreCase("PlotXY")) {
            return "A X/Y type plot of DOOCS data.";
        }
        if (name.equalsIgnoreCase("Icon")) {
            return "Image icon loaded from a file.";
        }
        if (name.equalsIgnoreCase("Audio")) {
            return "A component that plays an audio file.";
        }
        if (name.equalsIgnoreCase("Switch")) {
            return "A Switch statement with 2 Cases. Additional Cases can be added.";
        }
        if (name.equalsIgnoreCase("Case")) {
            return "A Case for the Switch statement.";
        }
        if (name.equalsIgnoreCase("If")) {
            return "An If statement.";
        }
        if (name.equalsIgnoreCase("ColouredIndicator")) {
            return "A component with a color depending on a DOOCS value.";
        }
        if (name.equalsIgnoreCase("ComboBox")) {
            return "A combobox to display and set predefined DOOCS text values.";
        }
        if (name.equalsIgnoreCase("LocationChooser")) {
            return "A combobox to choose the DOOCS location of the underlying LayeredPane.";
        }
        if (name.equalsIgnoreCase("CameraImage")) {
            return "A display for a camera image.";
        }
        if (name.equalsIgnoreCase("TextField")) {
            return "A text field for displaying and changing DOOCS text values.";
        }
        if (name.equalsIgnoreCase("TextArea")) {
            return "A text area for displaying log files.";
        }
        if (name.equalsIgnoreCase("PropertiesTable")) {
            return "A table containing all location properties.";
        }
        if (name.equalsIgnoreCase("DeviceTree")) {
            return "A tree of all control system devices.";
        }
        if (name.equalsIgnoreCase("DynamicList")) {
            return "A scrollable LayeredPane for listing components.";
        }
        if (name.equalsIgnoreCase("Alive")) {
            return "A LayeredPane which contains movable components.";
        }
        return null;
    }

    @Override
    public void DOOCSObjectSelected(DOOCSComponent[] comp) {
        this.clearSelection();
    }

    public void addDOOCSAddListener(DOOCSAddEvent dae) {
        this.addListener.add(dae);
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent evt) {
        if (this.dragOK) {
            StringSelection t = new StringSelection("transfer component");
            this.dragSource.startDrag(evt, DragSource.DefaultCopyDrop, t, this);
        }
    }

    @Override
    public void dragEnter(DragSourceDragEvent evt) {
    }

    @Override
    public void dragOver(DragSourceDragEvent evt) {
    }

    @Override
    public void dragExit(DragSourceEvent evt) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent evt) {
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent evt) {
    }
}

