/*
 * Decompiled with CFR 0.152.
 */
package editor;

import editor.CloseTabIcon;
import editor.events.DOOCSCloseTabEvent;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JTabbedPane;

public class JTabbedPaneWithCloseIcons
extends JTabbedPane
implements MouseListener,
MouseMotionListener {
    public Vector<DOOCSCloseTabEvent> closeTabListener;

    public JTabbedPaneWithCloseIcons() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.closeTabListener = new Vector();
    }

    @Override
    public void addTab(String title, Component component) {
        this.addTab(title, component, null, null);
    }

    public void addTab(String title, Component component, String tooltip) {
        this.addTab(title, component, null, tooltip);
    }

    public void addTab(String title, Component component, Icon extraIcon, String tooltip) {
        super.addTab(title, new CloseTabIcon(extraIcon, false), component, tooltip);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int tabNumber = this.getUI().tabForCoordinate(this, e.getX(), e.getY());
        if (tabNumber < 0) {
            return;
        }
        Rectangle rect = ((CloseTabIcon)this.getIconAt(tabNumber)).getBounds();
        if (rect.contains(e.getX(), e.getY())) {
            for (int i = 0; i < this.closeTabListener.size(); ++i) {
                this.closeTabListener.get(i).DOOCSTabClosed(tabNumber);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int tabNumber = this.getUI().tabForCoordinate(this, e.getX(), e.getY());
        if (tabNumber < 0) {
            return;
        }
        CloseTabIcon selIcon = (CloseTabIcon)this.getIconAt(tabNumber);
        Rectangle rect = selIcon.getBounds();
        if (rect.contains(e.getX(), e.getY()) && !selIcon.isSelected()) {
            selIcon.setSelected(true);
            this.repaint();
        }
        if (!rect.contains(e.getX(), e.getY()) && selIcon.isSelected()) {
            selIcon.setSelected(false);
            this.repaint();
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            CloseTabIcon selIcon = (CloseTabIcon)this.getIconAt(i);
            selIcon.setSelected(false);
        }
        this.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public void addDOOCSCloseTabListener(DOOCSCloseTabEvent dce) {
        this.closeTabListener.add(dce);
    }
}

