/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot.utils;

import DOOCSPlot.DOOCSPlot;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.LineBorder;

public class EventNumberDialog
extends JDialog {
    DOOCSPlot plot;
    private boolean isRunning = false;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JProgressBar jProgressMem;
    private JSlider jSliderAct;
    private JTextField jTextEvt;
    private JTextField jTextTact;
    private JTextField jTextTstart;
    private JTextField jTextTstop;

    public EventNumberDialog(Frame parent, boolean modal, DOOCSPlot pl) {
        super(parent, modal);
        this.plot = pl;
        this.initComponents();
    }

    private void initComponents() {
        this.jSliderAct = new JSlider();
        this.jTextTstart = new JTextField();
        this.jTextTstop = new JTextField();
        this.jLabel2 = new JLabel();
        this.jButton4 = new JButton();
        this.jButton1 = new JButton();
        this.jLabel3 = new JLabel();
        this.jTextTact = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextEvt = new JTextField();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jProgressMem = new JProgressBar();
        this.jLabel1 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.jSliderAct.setForeground(new Color(51, 51, 255));
        this.jSliderAct.setPaintLabels(true);
        this.jSliderAct.setPaintTicks(true);
        this.jSliderAct.setToolTipText("Event number");
        this.jSliderAct.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent evt) {
                EventNumberDialog.this.sliderDraged(evt);
            }
        });
        this.jTextTstart.setEditable(false);
        this.jTextTstart.setText("T start");
        this.jTextTstart.setText(this.plot.doocsPlotSelection.getGlobalTimeRangeMinString());
        this.jTextTstop.setEditable(false);
        this.jTextTstop.setText("T stop");
        this.jTextTstop.setText(this.plot.doocsPlotSelection.getGlobalTimeRangeMaxString());
        this.jLabel2.setText("Time range in cache:");
        this.jButton4.setText("-10");
        this.jButton4.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                EventNumberDialog.this.jButton4addToEventNo(evt);
            }
        });
        this.jButton1.setText("-1");
        this.jButton1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                EventNumberDialog.this.jButton1addToEventNo(evt);
            }
        });
        this.jLabel3.setText("Actual T:");
        this.jTextTact.setEditable(false);
        this.jTextTact.setText("T act");
        this.jTextTact.setText(this.plot.doocsPlotSelection.getGlobalTimeActualString());
        this.jLabel4.setText("Event No.:");
        this.jTextEvt.setEditable(false);
        this.jTextEvt.setText("evt");
        this.jTextEvt.setText(this.plot.doocsPlotSelection.getEventActualString());
        this.jButton2.setText("+1");
        this.jButton2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                EventNumberDialog.this.jButton2addToEventNo(evt);
            }
        });
        this.jButton3.setText("+10");
        this.jButton3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent evt) {
                EventNumberDialog.this.jButton3addToEventNo(evt);
            }
        });
        this.jProgressMem.setFont(new Font("Arial", 0, 10));
        this.jProgressMem.setForeground(new Color(153, 204, 255));
        this.jProgressMem.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.jLabel1.setForeground(new Color(153, 153, 153));
        this.jLabel1.setText("Memory:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSliderAct, -1, 419, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.jButton4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel3, -2, 55, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextTact, -2, 180, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(14, 14, 14).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextEvt, -1, 104, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3)))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextTstart, -2, 175, -2).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 65, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jProgressMem, -1, -1, Short.MAX_VALUE).addComponent(this.jTextTstop, -1, 179, Short.MAX_VALUE)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(26, 26, 26).addComponent(this.jLabel2)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jProgressMem, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextTstart, -2, -1, -2).addComponent(this.jTextTstop, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSliderAct, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jTextEvt, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.jTextTact, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2).addComponent(this.jButton3).addComponent(this.jButton4)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void addEvt(int a) {
        int i = this.plot.doocsPlotSelection.getEventActual() + a;
        this.plot.doocsPlotSelection.setEventActual(i);
    }

    public void updateData() {
        if (this.plot == null) {
            return;
        }
        this.jTextTstart.setText(this.plot.doocsPlotSelection.getGlobalTimeRangeMinString());
        this.jTextTstop.setText(this.plot.doocsPlotSelection.getGlobalTimeRangeMaxString());
        this.jTextTact.setText(this.plot.doocsPlotSelection.getGlobalTimeActualString());
        this.jTextEvt.setText(this.plot.doocsPlotSelection.getEventActualString());
        int e1 = this.plot.doocsPlotSelection.getEventFirst();
        int e2 = this.plot.doocsPlotSelection.getEventLast();
        int e = this.plot.doocsPlotSelection.getEventActual();
        this.jSliderAct.setMinimum(e1);
        this.jSliderAct.setMaximum(e2);
        this.jSliderAct.setValue(e);
        long memMax = Runtime.getRuntime().maxMemory() / 1000000L;
        long memAct = Runtime.getRuntime().totalMemory() / 1000000L;
        this.jProgressMem.setMaximum((int)memMax);
        this.jProgressMem.setValue((int)memAct);
        String tmp = String.format("%d MB", memAct);
        this.jProgressMem.setStringPainted(true);
        this.jProgressMem.setString(tmp);
    }

    private void jButton4addToEventNo(MouseEvent evt) {
        String tmp = evt.paramString();
        this.addEvt(-10);
    }

    private void jButton1addToEventNo(MouseEvent evt) {
        String tmp = evt.paramString();
        this.addEvt(-1);
    }

    private void jButton2addToEventNo(MouseEvent evt) {
        String tmp = evt.paramString();
        this.addEvt(1);
    }

    private void jButton3addToEventNo(MouseEvent evt) {
        String tmp = evt.paramString();
        this.addEvt(10);
    }

    private void sliderDraged(MouseEvent evt) {
        Component comp = evt.getComponent();
        if (comp instanceof JSlider) {
            int evtNo = ((JSlider)comp).getValue();
            int e1 = this.plot.doocsPlotSelection.getEventFirst();
            int e2 = this.plot.doocsPlotSelection.getEventLast();
            if (evtNo >= e1 && evtNo <= e2) {
                this.plot.doocsPlotSelection.setEventActual(evtNo);
            }
        }
    }

    @Override
    public void setVisible(boolean vis) {
        super.setVisible(vis);
        if (vis) {
            if (!this.isRunning) {
                this.isRunning = true;
            }
        } else {
            this.isRunning = false;
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                final EventNumberDialog dialog = new EventNumberDialog((Frame)new JFrame(), true, null);
                dialog.isRunning = true;
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        dialog.isRunning = false;
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

