/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSComponents.DOOCSParameter;
import DOOCSPlot.DOOCSPlot;

public class DOOCSPlotXY
extends DOOCSPlot {
    public void setTimeRangeFrom(double timeRangeFrom) {
        this.timeRangeFrom = timeRangeFrom;
    }

    public void setTimeRangeTo(double timeRangeTo) {
        this.timeRangeTo = timeRangeTo;
    }

    public double getTimeRangeFrom() {
        return this.timeRangeFrom;
    }

    public double getTimeRangeTo() {
        return this.timeRangeTo;
    }

    public DOOCSPlotXY() {
        super(DOOCSPlot.PlotType.PLOTXY);
        this.timeRangeTo = System.currentTimeMillis() / 1000L;
        this.timeRangeFrom = this.timeRangeTo - 3600.0;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameterOwn = new DOOCSParameter[]{new DOOCSParameter("timeRangeDuration", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.NORMAL, "the relative duration [sec] shown to now"), new DOOCSParameter("useGlobalTimeRange", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL, "uses the global time range if set by user")};
        DOOCSParameter[] parameter1 = super.getDOOCSParameterList();
        DOOCSParameter[] parameter1a = this.doocsAdrList.getDOOCSParameterList();
        DOOCSParameter[] parameter2 = this.doocsPlotAxisX.getDOOCSParameterList();
        DOOCSParameter[] parameter3 = this.doocsPlotAxisY.getDOOCSParameterList();
        DOOCSParameter[] parameters = new DOOCSParameter[parameter1.length + parameterOwn.length + parameter1a.length + parameter2.length + parameter3.length];
        System.arraycopy(parameter1, 0, parameters, 0, parameter1.length);
        System.arraycopy(parameterOwn, 0, parameters, parameter1.length, parameterOwn.length);
        System.arraycopy(parameter1a, 0, parameters, parameter1.length + parameterOwn.length, parameter1a.length);
        System.arraycopy(parameter2, 0, parameters, parameter1.length + parameterOwn.length + parameter1a.length, parameter2.length);
        System.arraycopy(parameter3, 0, parameters, parameter1.length + parameterOwn.length + parameter1a.length + parameter2.length, parameter3.length);
        return parameters;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSPlotXY ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">\n");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">\n");
        }
        xmlStructure.append("</DOOCSPlotXY>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        super.setDOOCSParameter(parameter, value);
        if (parameter.equalsIgnoreCase("timeRangeFrom")) {
            this.setTimeRangeFrom(Double.parseDouble(value));
            this.doocsPlotSelection.setTimeRange(this.timeRangeFrom, this.timeRangeTo);
        }
        if (parameter.equalsIgnoreCase("timeRangeTo")) {
            this.setTimeRangeTo(Double.parseDouble(value));
            this.doocsPlotSelection.setTimeRange(this.timeRangeFrom, this.timeRangeTo);
        }
        if (parameter.equalsIgnoreCase("useGlobalTimeRange")) {
            this.useGlobalTimeRange = Boolean.parseBoolean(value);
        }
        if (parameter.equalsIgnoreCase("timeRangeDuration")) {
            double t = (double)System.currentTimeMillis() / 1000.0;
            this.setTimeRangeTo(t);
            this.setTimeRangeFrom(t - Double.parseDouble(value));
            this.doocsPlotSelection.setTimeRange(this.timeRangeFrom, this.timeRangeTo);
        }
        this.doocsPlotAxisX.setDOOCSParameter(parameter, value);
        this.doocsAdrList.setDOOCSParameter(parameter, value);
        this.doocsPlotAxisY.setDOOCSParameter(parameter, value);
        this.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        Object ret = super.getDOOCSParameter(parameter);
        if (ret != null) {
            return ret;
        }
        ret = this.doocsAdrList.getDOOCSParameter(parameter);
        if (ret != null) {
            return ret;
        }
        ret = this.doocsPlotAxisX.getDOOCSParameter(parameter);
        if (ret != null) {
            return ret;
        }
        ret = this.doocsPlotAxisY.getDOOCSParameter(parameter);
        if (parameter.equalsIgnoreCase("timeRangeTo")) {
            return this.getTimeRangeTo();
        }
        if (parameter.equalsIgnoreCase("timeRangeFrom")) {
            return this.getTimeRangeFrom();
        }
        if (parameter.equalsIgnoreCase("useGlobalTimeRange")) {
            return this.useGlobalTimeRange;
        }
        if (parameter.equalsIgnoreCase("timeRangeDuration")) {
            return this.getTimeRangeTo() - this.getTimeRangeFrom();
        }
        if (ret != null) {
            return ret;
        }
        return null;
    }
}

