/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSPlot.DOOCSPlot;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import ttf.doocs.clnt.EqData;
import ttf.doocs.clnt.USTR;
import ttf.doocs.clnt.time_t;

public class DOOCSInfoTip {
    public EqData list;
    private List<Rectangle> listArea;
    private ImageIcon icon;
    private DOOCSPlot plot;
    private int xOffset;
    private int yOffset;

    public DOOCSInfoTip(DOOCSPlot p) {
        this.plot = p;
        this.list = new EqData();
        this.icon = new ImageIcon(this.getClass().getResource("icons/dataTip16.gif"));
        this.xOffset = this.plot.getX();
        this.yOffset = this.plot.getY() - this.icon.getIconHeight();
        this.listArea = new ArrayList<Rectangle>();
    }

    public void add(double x, double y, String str) {
        EqData entry = new EqData();
        entry.set(0, (float)x, (float)y, new time_t(), str, 0);
        this.list.add_from(entry);
        this.listArea.add(new Rectangle(0, 0, 0, 0));
    }

    public int length() {
        return this.listArea.size();
    }

    public String getText(int idx) {
        if (idx < this.list.array_length() && idx >= 0) {
            return this.list.get_string_arg(idx);
        }
        return null;
    }

    public Point getPosition(int idx) {
        Point pt = null;
        if (idx < this.list.array_length() && idx >= 0) {
            pt = this.listArea.get(idx).getLocation();
            pt.y += this.listArea.get((int)idx).height;
        }
        return pt;
    }

    public int isOnIndex(int x, int y) {
        int length = this.list.array_length();
        for (int i = 0; i < length; ++i) {
            if (!this.listArea.get(i).contains(x, y)) continue;
            return i;
        }
        return -1;
    }

    public void paintComponent(Graphics g) {
        if (this.icon != null) {
            AffineTransform tr = this.plot.doocsAdrList.transformer;
            int length = this.list.array_length();
            for (int i = 0; i < length; ++i) {
                USTR ustr = this.list.get_ustr(i);
                Point2D.Double pt_s = new Point2D.Double();
                Point2D.Double pt = new Point2D.Double();
                ((Point2D)pt_s).setLocation(ustr.f1_data, ustr.f2_data);
                tr.transform(pt_s, pt);
                int ix = (int)((Point2D)pt).getX();
                int iy = (int)((Point2D)pt).getY() - this.icon.getIconHeight();
                this.icon.paintIcon(this.plot, g, ix, iy);
                this.listArea.get(i).setBounds(ix, iy, this.icon.getIconWidth(), this.icon.getIconHeight());
            }
        }
    }
}

