/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSPlot.DOOCSChannel;

public class DOOCSFindDataPoint {
    int mouseX;
    int mouseY;
    int dispX;
    int dispY;
    double delta;
    double dataX;
    double dataY;
    String adrString;
    String descrString;
    String adrFullString;
    DOOCSChannel channel;

    public DOOCSFindDataPoint(int x, int y) {
        this.mouseX = x;
        this.mouseY = y;
        this.delta = 1.0E10;
        this.dataX = 0.0;
        this.dataY = 0.0;
        this.dispX = 0;
        this.dispY = 0;
        this.adrString = null;
        this.descrString = null;
        this.channel = null;
    }

    void find(int ix, int iy, double x, double y, String aStr, String dStr, DOOCSChannel ch) {
        int i2;
        if (ix == 0 || iy == 0) {
            return;
        }
        int i1 = Math.abs(this.mouseX - ix);
        double d = i1 * i1 + (i2 = Math.abs(this.mouseY - iy)) * i2;
        if (d != 0.0) {
            d = Math.sqrt(d);
        }
        if (d < this.delta) {
            this.delta = d;
            this.dataX = x;
            this.dataY = y;
            this.dispX = ix;
            this.dispY = iy;
            if (aStr != null) {
                this.adrString = aStr;
            }
            if (dStr != null) {
                this.descrString = dStr;
            }
            if (ch != null) {
                this.channel = ch;
                this.adrFullString = this.channel.doocsAdr;
            }
        }
    }

    public String getText() {
        if (this.channel != null) {
            return this.channel.getToolTipText(this.dataX, this.dataY, this.descrString);
        }
        return "";
    }

    public String getDescription() {
        return this.descrString;
    }

    public String getLocationAdr() {
        return this.adrString;
    }

    public int getX() {
        return this.dispX;
    }

    public int getY() {
        return this.dispY;
    }

    public DOOCSChannel getChannel() {
        return this.channel;
    }
}

