/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSLabelUI;
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.DOOCSValueDialog;
import DOOCSComponents.DOOCSValueShowHist;
import DOOCSComponents.StringTransferHandler;
import editor.EditorPanel;
import editor.undo.SetProperty;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.TransferHandler;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.LabelUI;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqCallback;
import ttf.doocs.clnt.EqData;
import xmlparser.IntegerParser;

public class DOOCSValue
extends JLabel
implements DOOCSComponent,
EqCallback {
    private MouseAdapter listenerHist;
    private MouseMotionAdapter listenerDrag;
    private String errorMessage = null;
    private String doocsAddress = null;
    private String fullDoocsAddress = null;
    private String doocsToolTipText = null;
    private int doocsIndex = 0;
    private float doocsUpdateTime = 2.0f;
    private int doocsPrecision = 2;
    private int doocsMaxLength = 80;
    private String doocsRepresentation = "String";
    private String doocsAddressView = "0010";
    private boolean doocsBorder = false;
    private boolean doocsEnablePlot = true;
    private boolean doocsReadEGU = false;
    private boolean doocsScale = true;
    private int doocsClipX = 2;
    private int doocsClipY = 2;
    private String doocsRotate = "0";
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private Rectangle m_initialBounds;
    private LabelUI defaultUI;
    private static final int isData = 1;
    private static final int isEGU = 2;
    private EqCall eq = new EqCall();
    private EqData ed = new EqData();
    private EqData dataMon = new EqData();
    private EqData dataEgu = new EqData();
    private EqAdr adrData = null;
    private EqAdr adrEGU = null;
    String value = "";
    String valueData = "";
    String valueEgu = "";
    private Cursor myCursor;

    public DOOCSValue() {
        this.setHorizontalAlignment(2);
        this.setVerticalAlignment(3);
        this.setAlignmentX(0.0f);
        this.setText("Value");
        this.setEnabled(this.doocsRunMode);
        this.myCursor = this.getToolkit().createCustomCursor(new ImageIcon(this.getClass().getResource("icons/cursorHist.gif")).getImage(), new Point(0, 0), "Cursor");
        this.setTransferHandler(new StringTransferHandler());
        this.listenerDrag = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                JComponent c = (JComponent)e.getSource();
                TransferHandler th = c.getTransferHandler();
                th.exportAsDrag(c, e, 1);
            }
        };
        this.listenerHist = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.isMetaDown()) {
                    if (DOOCSValue.this.adrEGU.isValidAdr()) {
                        DOOCSValueDialog vdialog;
                        String[] tmp;
                        EqData data = new EqData();
                        DOOCSValue.this.eq.get(DOOCSValue.this.adrEGU, DOOCSValue.this.ed, data);
                        if (data.error() == 0 && !(tmp = (vdialog = new DOOCSValueDialog(data.get_string_arg().trim(), data.get_float(1), data.get_float(2), data.get_int(0))).showDialog((JComponent)e.getSource()))[0].equalsIgnoreCase("CANCEL")) {
                            int time = Math.round(System.currentTimeMillis() / 1000L);
                            DOOCSValue.this.ed.set(Integer.parseInt(tmp[3]), Float.parseFloat(tmp[1]), Float.parseFloat(tmp[2]), time, tmp[0], 0);
                            DOOCSValue.this.eq.set(DOOCSValue.this.adrEGU, DOOCSValue.this.ed, data);
                        }
                    }
                } else {
                    DOOCSValue.this.showHist();
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (DOOCSValue.this.doocsEnablePlot) {
                    DOOCSValue.this.setCursor(DOOCSValue.this.myCursor);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (DOOCSValue.this.doocsEnablePlot) {
                    DOOCSValue.this.setCursor(new Cursor(0));
                }
            }
        };
        this.defaultUI = this.getUI();
    }

    private void showHist() {
        DOOCSValueShowHist.showHist(this.fullDoocsAddress, this);
    }

    private void startMonitors() {
        if (!this.doocsRepresentation.equalsIgnoreCase("Adr")) {
            if (this.adrData != null) {
                if ((double)this.doocsUpdateTime == 0.0) {
                    this.eq.get_monitor(this.adrData, this.ed, this.dataMon, 1, this.doocsUpdateTime, (EqCallback)this, (Object)1);
                } else {
                    this.eq.get_monitor(this.adrData, this.ed, this.dataMon, 3, this.doocsUpdateTime, (EqCallback)this, (Object)1);
                }
            }
            if (this.dataMon.error() != 0 && this.adrData != null || this.adrData == null) {
                String setValue = this.adrData == null ? "ill. Adr" : this.dataMon.get_string();
                this.errorMessage = setValue;
                Color colRed = new Color(1.0f, 0.5f, 0.5f);
                this.setBackground(colRed);
                this.setText(setValue);
            }
            this.adrEGU = new EqAdr(this.fullDoocsAddress + ".EGU");
            if (this.doocsReadEGU) {
                this.eq.get_monitor(this.adrEGU, this.ed, this.dataEgu, 3, this.doocsUpdateTime * 10.0f, (EqCallback)this, (Object)2);
            }
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void setDoocsAddress(String address) {
        this.doocsAddress = address;
    }

    public String getDoocsAddress() {
        return this.doocsAddress;
    }

    @Override
    public void setFullDoocsAddress(String address) {
        if (address == null) {
            return;
        }
        if (this.fullDoocsAddress == null || !this.fullDoocsAddress.startsWith(address)) {
            this.fullDoocsAddress = address;
            this.value = "...";
            this.setText("...");
            if (this.adrData != null) {
                this.eq.clear_monitor(this.adrData);
            }
            if (this.doocsRepresentation.equalsIgnoreCase("Adr")) {
                int i;
                this.value = "";
                String temp = this.fullDoocsAddress;
                int counter = 0;
                for (i = 0; i < 4; ++i) {
                    if (!this.doocsAddressView.substring(i, i + 1).equalsIgnoreCase("1")) continue;
                    ++counter;
                }
                for (i = 0; i < 3; ++i) {
                    int slash = temp.indexOf("/");
                    if (slash < 0) continue;
                    if (this.doocsAddressView.substring(i, i + 1).equalsIgnoreCase("1")) {
                        this.value = this.value + temp.substring(0, slash);
                    }
                    if (this.doocsAddressView.substring(i, i + 1).equalsIgnoreCase("1") && counter > 1) {
                        this.value = this.value + "/";
                    }
                    temp = temp.substring(slash + 1);
                }
                if (this.doocsAddressView.substring(3).equalsIgnoreCase("1")) {
                    this.value = this.value + temp;
                }
                if (this.value.length() > this.doocsMaxLength) {
                    this.value = this.value.substring(0, this.doocsMaxLength);
                }
                this.setText(this.value);
            } else {
                this.adrData = new EqAdr(this.fullDoocsAddress);
                if (this.doocsReadEGU) {
                    if (this.adrEGU != null) {
                        this.eq.clear_monitor(this.adrEGU);
                    }
                    this.adrEGU = new EqAdr(this.fullDoocsAddress + ".EGU");
                }
                if (!EqAdr.isValidAdr((String)this.fullDoocsAddress)) {
                    this.adrData = null;
                } else if (this.doocsRunMode) {
                    this.startMonitors();
                }
            }
        }
    }

    @Override
    public String getFullDoocsAddress() {
        return this.fullDoocsAddress;
    }

    @Override
    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    @Override
    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    @Override
    public void setDnDText(String str) {
    }

    @Override
    public String getDnDText() {
        return this.fullDoocsAddress;
    }

    public void setDoocsIndex(int index) {
        this.doocsIndex = index;
    }

    public int getDoocsIndex() {
        return this.doocsIndex;
    }

    public void setDoocsUpdateTime(float time) {
        if ((double)time != 0.0 && (double)time < 0.1) {
            time = 0.1f;
        }
        this.doocsUpdateTime = time;
    }

    public float getDoocsUpdateTime() {
        return this.doocsUpdateTime;
    }

    public void setDoocsPrecision(int precision) {
        this.doocsPrecision = precision;
    }

    public int getDoocsPrecision() {
        return this.doocsPrecision;
    }

    public void setDoocsMaxLength(int length) {
        this.doocsMaxLength = length;
    }

    public int getDoocsMaxLength() {
        return this.doocsMaxLength;
    }

    public void setDoocsRepresentation(String representation) {
        this.doocsRepresentation = representation;
        if (representation.equalsIgnoreCase("Time") || representation.equalsIgnoreCase("Adr")) {
            this.doocsEnablePlot = false;
        }
    }

    public String getDoocsRepresentation() {
        return this.doocsRepresentation;
    }

    public void setDoocsAddressView(String view) {
        if (view.matches("^-?[0-1]{4}$")) {
            this.doocsAddressView = view;
        }
    }

    public String getDoocsAddressView() {
        return this.doocsAddressView;
    }

    public void setDoocsBorder(boolean border) {
        this.doocsBorder = border;
        if (border) {
            this.setBorder(BorderFactory.createBevelBorder(1));
        } else {
            this.setBorder(null);
        }
    }

    public boolean getDoocsBorder() {
        return this.doocsBorder;
    }

    public void setDoocsEnablePlot(boolean plot) {
        this.doocsEnablePlot = plot;
    }

    public boolean getDoocsEnablePlot() {
        return this.doocsEnablePlot;
    }

    public void setDoocsReadEGU(boolean egu) {
        this.doocsReadEGU = egu;
    }

    public boolean getDoocsReadEGU() {
        return this.doocsReadEGU;
    }

    @Override
    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    @Override
    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    public void setDoocsClipX(int clip) {
        this.doocsClipX = clip;
    }

    public int getDoocsClipX() {
        return this.doocsClipX;
    }

    public void setDoocsClipY(int clip) {
        this.doocsClipY = clip;
    }

    public int getDoocsClipY() {
        return this.doocsClipY;
    }

    public void setDoocsRotate(String rotate) {
        if ((rotate.equalsIgnoreCase("0") || rotate.equalsIgnoreCase("180")) && this.getHeight() > this.getWidth() || !rotate.equalsIgnoreCase("0") && !rotate.equalsIgnoreCase("180") && this.getHeight() < this.getWidth()) {
            this.setPreferredSize(new Dimension(this.getHeight(), this.getWidth()));
            this.setSize(this.getHeight(), this.getWidth());
            Container parent = this.getParent();
            if (!(parent == null || parent instanceof EditorPanel && parent.getWidth() == 100 && parent.getHeight() == 100)) {
                if (this.getX() < 0) {
                    this.setLocation(0, this.getY());
                }
                if (this.getY() < 0) {
                    this.setLocation(this.getX(), 0);
                }
                if (this.getX() + this.getWidth() > parent.getWidth()) {
                    this.setLocation(parent.getWidth() - this.getWidth(), this.getY());
                }
                if (this.getY() + this.getHeight() > parent.getHeight()) {
                    this.setLocation(this.getX(), parent.getHeight() - this.getHeight());
                }
            }
        }
        this.doocsRotate = rotate;
        if (rotate.equalsIgnoreCase("270")) {
            this.setUI(new DOOCSLabelUI(270));
        } else if (rotate.equalsIgnoreCase("90")) {
            this.setUI(new DOOCSLabelUI(90));
        } else {
            this.setUI(this.defaultUI);
        }
    }

    public String getDoocsRotate() {
        return this.doocsRotate;
    }

    @Override
    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    @Override
    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    @Override
    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        this.setEnabled(bRun);
        if (bRun) {
            this.addMouseMotionListener(this.listenerDrag);
            if (this.doocsEnablePlot) {
                this.addMouseListener(this.listenerHist);
            }
            this.startMonitors();
        } else {
            if (this.adrData != null) {
                this.eq.clear_monitor(this.adrData);
            }
            if (this.adrEGU != null) {
                this.eq.clear_monitor(this.adrEGU);
            }
            if (this.doocsEnablePlot) {
                this.removeMouseListener(this.listenerHist);
            }
            this.removeMouseMotionListener(this.listenerDrag);
        }
    }

    @Override
    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    @Override
    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    @Override
    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        if (this.doocsRepresentation.equalsIgnoreCase("Adr")) {
            DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("representation", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("addressView", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("updateTime", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("maxLength", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textFont", DOOCSParameter.ParameterTypes.FONT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bgColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bgTransparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("border", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("clipX", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.SCALE), new DOOCSParameter("clipY", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.SCALE), new DOOCSParameter("rotate", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("alignX", DOOCSParameter.ParameterTypes.ALIGNX, DOOCSParameter.Levels.SCALE), new DOOCSParameter("alignY", DOOCSParameter.ParameterTypes.ALIGNY, DOOCSParameter.Levels.SCALE), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
            return parameters;
        }
        if (this.doocsRepresentation.equalsIgnoreCase("Time")) {
            DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("representation", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("dataIndex", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("updateTime", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("maxLength", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textFont", DOOCSParameter.ParameterTypes.FONT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bgColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bgTransparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("border", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("clipX", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.SCALE), new DOOCSParameter("clipY", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.SCALE), new DOOCSParameter("rotate", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("alignX", DOOCSParameter.ParameterTypes.ALIGNX, DOOCSParameter.Levels.SCALE), new DOOCSParameter("alignY", DOOCSParameter.ParameterTypes.ALIGNY, DOOCSParameter.Levels.SCALE), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
            return parameters;
        }
        if (this.doocsRepresentation.equalsIgnoreCase("String")) {
            DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("representation", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("updateTime", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("maxLength", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textFont", DOOCSParameter.ParameterTypes.FONT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bgColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bgTransparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("border", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("clipX", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.SCALE), new DOOCSParameter("clipY", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.SCALE), new DOOCSParameter("rotate", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("alignX", DOOCSParameter.ParameterTypes.ALIGNX, DOOCSParameter.Levels.SCALE), new DOOCSParameter("alignY", DOOCSParameter.ParameterTypes.ALIGNY, DOOCSParameter.Levels.SCALE), new DOOCSParameter("enablePlot", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
            return parameters;
        }
        if (this.doocsRepresentation.equalsIgnoreCase("Int")) {
            DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("representation", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("dataIndex", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("updateTime", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("maxLength", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textFont", DOOCSParameter.ParameterTypes.FONT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bgColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bgTransparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("border", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("clipX", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.SCALE), new DOOCSParameter("clipY", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.SCALE), new DOOCSParameter("rotate", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("alignX", DOOCSParameter.ParameterTypes.ALIGNX, DOOCSParameter.Levels.SCALE), new DOOCSParameter("alignY", DOOCSParameter.ParameterTypes.ALIGNY, DOOCSParameter.Levels.SCALE), new DOOCSParameter("enablePlot", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("readEGU", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
            return parameters;
        }
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("representation", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("dataIndex", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("updateTime", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("precision", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("maxLength", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textFont", DOOCSParameter.ParameterTypes.FONT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bgColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bgTransparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("border", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("clipX", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.SCALE), new DOOCSParameter("clipY", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.SCALE), new DOOCSParameter("rotate", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("alignX", DOOCSParameter.ParameterTypes.ALIGNX, DOOCSParameter.Levels.SCALE), new DOOCSParameter("alignY", DOOCSParameter.ParameterTypes.ALIGNY, DOOCSParameter.Levels.SCALE), new DOOCSParameter("enablePlot", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("readEGU", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        if (parameter.equalsIgnoreCase("rotate")) {
            String[] allowedValues = new String[]{"0", "90", "180", "270"};
            return allowedValues;
        }
        if (parameter.equalsIgnoreCase("representation")) {
            String[] allowedValues = new String[]{"String", "Fixed", "Float", "Int", "IntAsTime", "Bool", "Hex", "Adr", "Time"};
            return allowedValues;
        }
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSValue ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSValue>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.equalsIgnoreCase("dataIndex")) {
            this.setDoocsIndex(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("updateTime")) {
            this.setDoocsUpdateTime(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("precision")) {
            this.setDoocsPrecision(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("maxLength")) {
            this.setDoocsMaxLength(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("representation")) {
            this.setDoocsRepresentation(value);
        } else if (parameter.equalsIgnoreCase("addressView")) {
            this.setDoocsAddressView(value);
        } else if (parameter.equalsIgnoreCase("textFont")) {
            this.setFont(DOOCSParameter.convertToFont(value));
        } else if (parameter.equalsIgnoreCase("textColor")) {
            this.setForeground(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("bgColor")) {
            this.setBackground(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("bgTransparent")) {
            this.setOpaque(!Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("border")) {
            this.setDoocsBorder(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("rotate")) {
            this.setDoocsRotate(value);
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("clipX")) {
            this.setDoocsClipX(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("clipY")) {
            this.setDoocsClipY(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("alignX")) {
            this.setHorizontalAlignment(DOOCSParameter.convertToAlignX(value));
        } else if (parameter.equalsIgnoreCase("alignY")) {
            this.setVerticalAlignment(DOOCSParameter.convertToAlignY(value));
        } else if (parameter.equalsIgnoreCase("enablePlot")) {
            this.setDoocsEnablePlot(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("readEGU")) {
            this.setDoocsReadEGU(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSValue.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.equalsIgnoreCase("dataIndex")) {
            return this.getDoocsIndex();
        }
        if (parameter.equalsIgnoreCase("updateTime")) {
            return Float.valueOf(this.getDoocsUpdateTime());
        }
        if (parameter.equalsIgnoreCase("precision")) {
            return this.getDoocsPrecision();
        }
        if (parameter.equalsIgnoreCase("maxLength")) {
            return this.getDoocsMaxLength();
        }
        if (parameter.equalsIgnoreCase("representation")) {
            return this.getDoocsRepresentation();
        }
        if (parameter.equalsIgnoreCase("addressView")) {
            return this.getDoocsAddressView();
        }
        if (parameter.equalsIgnoreCase("textFont")) {
            return DOOCSParameter.getDoocsFont(this.getFont());
        }
        if (parameter.equalsIgnoreCase("textColor")) {
            return DOOCSParameter.getDoocsColor(this.getForeground());
        }
        if (parameter.equalsIgnoreCase("bgColor")) {
            return DOOCSParameter.getDoocsColor(this.getBackground());
        }
        if (parameter.equalsIgnoreCase("bgTransparent")) {
            return !this.isOpaque();
        }
        if (parameter.equalsIgnoreCase("border")) {
            return this.getDoocsBorder();
        }
        if (parameter.equalsIgnoreCase("rotate")) {
            return this.getDoocsRotate();
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("clipX")) {
            return this.getDoocsClipX();
        }
        if (parameter.equalsIgnoreCase("clipY")) {
            return this.getDoocsClipY();
        }
        if (parameter.equalsIgnoreCase("alignX")) {
            return DOOCSParameter.getAlignX(this.getHorizontalAlignment());
        }
        if (parameter.equalsIgnoreCase("alignY")) {
            return DOOCSParameter.getAlignY(this.getVerticalAlignment());
        }
        if (parameter.equalsIgnoreCase("enablePlot")) {
            return this.getDoocsEnablePlot();
        }
        if (parameter.equalsIgnoreCase("readEGU")) {
            return this.getDoocsReadEGU();
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        System.out.println("DOOCSValue.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    @Override
    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
    }

    @Override
    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        String oldValue = this.getDoocsRotate();
        if (oldValue.equalsIgnoreCase("90")) {
            this.setDoocsRotate("270");
        }
        if (oldValue.equalsIgnoreCase("270")) {
            this.setDoocsRotate("90");
        }
        if (!oldValue.equalsIgnoreCase(this.getDoocsRotate())) {
            change.add(new SetProperty(this, "rotate", oldValue, this.getDoocsRotate()));
        }
        if ((oldValue = DOOCSParameter.getAlignX(this.getHorizontalAlignment())).equalsIgnoreCase("LEFT")) {
            this.setHorizontalAlignment(4);
        }
        if (oldValue.equalsIgnoreCase("RIGHT")) {
            this.setHorizontalAlignment(2);
        }
        if (!oldValue.equalsIgnoreCase(DOOCSParameter.getAlignX(this.getHorizontalAlignment()))) {
            change.add(new SetProperty(this, "alignX", oldValue, DOOCSParameter.getAlignX(this.getHorizontalAlignment())));
        }
        return change;
    }

    @Override
    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        if (this.getDoocsRotate().equalsIgnoreCase("0") || this.getDoocsRotate().equalsIgnoreCase("180")) {
            String oldValue = DOOCSParameter.getAlignY(this.getVerticalAlignment());
            if (oldValue.equalsIgnoreCase("TOP")) {
                this.setVerticalAlignment(3);
            }
            if (oldValue.equalsIgnoreCase("BOTTOM")) {
                this.setVerticalAlignment(1);
            }
            if (!oldValue.equalsIgnoreCase(DOOCSParameter.getAlignY(this.getVerticalAlignment()))) {
                change.add(new SetProperty(this, "alignY", oldValue, DOOCSParameter.getAlignY(this.getVerticalAlignment())));
            }
        } else {
            String oldValue = DOOCSParameter.getAlignX(this.getHorizontalAlignment());
            if (oldValue.equalsIgnoreCase("LEFT")) {
                this.setHorizontalAlignment(4);
            }
            if (oldValue.equalsIgnoreCase("RIGHT")) {
                this.setHorizontalAlignment(2);
            }
            if (!oldValue.equalsIgnoreCase(DOOCSParameter.getAlignX(this.getHorizontalAlignment()))) {
                change.add(new SetProperty(this, "alignX", oldValue, DOOCSParameter.getAlignX(this.getHorizontalAlignment())));
            }
        }
        return change;
    }

    @Override
    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        String oldValue = this.getDoocsRotate();
        if (oldValue.equalsIgnoreCase("0")) {
            this.setDoocsRotate("270");
        }
        if (oldValue.equalsIgnoreCase("90")) {
            this.setDoocsRotate("0");
        }
        if (oldValue.equalsIgnoreCase("180")) {
            this.setDoocsRotate("90");
        }
        if (oldValue.equalsIgnoreCase("270")) {
            this.setDoocsRotate("180");
        }
        change.add(new SetProperty(this, "rotate", oldValue, this.getDoocsRotate()));
        if (this.getDoocsRotate().equalsIgnoreCase("90") || this.getDoocsRotate().equalsIgnoreCase("180")) {
            oldValue = DOOCSParameter.getAlignX(this.getHorizontalAlignment());
            if (oldValue.equalsIgnoreCase("LEFT")) {
                this.setHorizontalAlignment(4);
            }
            if (oldValue.equalsIgnoreCase("RIGHT")) {
                this.setHorizontalAlignment(2);
            }
            if (!oldValue.equalsIgnoreCase(DOOCSParameter.getAlignX(this.getHorizontalAlignment()))) {
                change.add(new SetProperty(this, "alignX", oldValue, DOOCSParameter.getAlignX(this.getHorizontalAlignment())));
            }
            if ((oldValue = DOOCSParameter.getAlignY(this.getVerticalAlignment())).equalsIgnoreCase("TOP")) {
                this.setVerticalAlignment(3);
            }
            if (oldValue.equalsIgnoreCase("BOTTOM")) {
                this.setVerticalAlignment(1);
            }
            if (!oldValue.equalsIgnoreCase(DOOCSParameter.getAlignY(this.getVerticalAlignment()))) {
                change.add(new SetProperty(this, "alignY", oldValue, DOOCSParameter.getAlignY(this.getVerticalAlignment())));
            }
        }
        return change;
    }

    @Override
    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        String oldValue = this.getDoocsRotate();
        if (oldValue.equalsIgnoreCase("0")) {
            this.setDoocsRotate("90");
        }
        if (oldValue.equalsIgnoreCase("90")) {
            this.setDoocsRotate("180");
        }
        if (oldValue.equalsIgnoreCase("180")) {
            this.setDoocsRotate("270");
        }
        if (oldValue.equalsIgnoreCase("270")) {
            this.setDoocsRotate("0");
        }
        change.add(new SetProperty(this, "rotate", oldValue, this.getDoocsRotate()));
        if (this.getDoocsRotate().equalsIgnoreCase("180") || this.getDoocsRotate().equalsIgnoreCase("270")) {
            oldValue = DOOCSParameter.getAlignX(this.getHorizontalAlignment());
            if (oldValue.equalsIgnoreCase("LEFT")) {
                this.setHorizontalAlignment(4);
            }
            if (oldValue.equalsIgnoreCase("RIGHT")) {
                this.setHorizontalAlignment(2);
            }
            if (!oldValue.equalsIgnoreCase(DOOCSParameter.getAlignX(this.getHorizontalAlignment()))) {
                change.add(new SetProperty(this, "alignX", oldValue, DOOCSParameter.getAlignX(this.getHorizontalAlignment())));
            }
            if ((oldValue = DOOCSParameter.getAlignY(this.getVerticalAlignment())).equalsIgnoreCase("TOP")) {
                this.setVerticalAlignment(3);
            }
            if (oldValue.equalsIgnoreCase("BOTTOM")) {
                this.setVerticalAlignment(1);
            }
            if (!oldValue.equalsIgnoreCase(DOOCSParameter.getAlignY(this.getVerticalAlignment()))) {
                change.add(new SetProperty(this, "alignY", oldValue, DOOCSParameter.getAlignY(this.getVerticalAlignment())));
            }
        }
        return change;
    }

    public void dataCallback(EqData dataOut, Object userData) {
        switch ((Integer)userData) {
            case 1: {
                if (dataOut.error() == 0) {
                    this.errorMessage = null;
                    if (this.doocsRepresentation.equalsIgnoreCase("Time")) {
                        this.valueData = dataOut.get_time_string(this.doocsIndex);
                        break;
                    }
                    if (this.doocsRepresentation.equalsIgnoreCase("IntAsTime")) {
                        Date date = new Date((long)dataOut.get_int(this.doocsIndex) * 1000L);
                        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                        this.valueData = formatter.format((Object)date);
                        break;
                    }
                    if (this.doocsRepresentation.equalsIgnoreCase("Adr")) {
                        System.out.println("Value dataCallback:Should not be");
                        break;
                    }
                    if (this.doocsRepresentation.equalsIgnoreCase("String")) {
                        if (dataOut.array_length() > 1) {
                            this.valueData = dataOut.get_string_arg(this.doocsIndex);
                            break;
                        }
                        this.valueData = dataOut.get_string_arg();
                        break;
                    }
                    if (dataOut.type() == 2 || dataOut.type() == 6 || dataOut.type() == 100 || dataOut.type() == 110) {
                        double dvalue = dataOut.get_float(this.doocsIndex);
                        String tmpvalue = Double.toString(dataOut.get_float(this.doocsIndex));
                        if (tmpvalue.contains("E") && !this.doocsRepresentation.equalsIgnoreCase("Fixed")) {
                            int exponent = IntegerParser.parseInt(tmpvalue.substring(tmpvalue.indexOf("E") + 1));
                            double tmp = Math.pow(10.0, this.doocsPrecision - exponent);
                            dvalue = Math.rint(dvalue * tmp) / tmp;
                            this.valueData = Double.toString(dvalue);
                            int komma = this.valueData.indexOf(".");
                            int Esize = this.valueData.length() - this.valueData.indexOf("E");
                            for (int i = 0; i < this.doocsPrecision; ++i) {
                                if (this.valueData.substring(komma + 1).length() - Esize >= this.doocsPrecision) continue;
                                this.valueData = this.valueData.substring(0, this.valueData.indexOf("E")) + "0" + this.valueData.substring(this.valueData.indexOf("E"));
                            }
                        } else {
                            double tmp = Math.pow(10.0, this.doocsPrecision);
                            dvalue = Math.rint(dvalue * tmp) / tmp;
                            this.valueData = Double.toString(dvalue);
                            int komma = this.valueData.indexOf(".");
                            for (int i = 0; i < this.doocsPrecision; ++i) {
                                if (this.valueData.substring(komma + 1).length() >= this.doocsPrecision) continue;
                                this.valueData = this.valueData + "0";
                            }
                        }
                        if (this.doocsPrecision == 0 || this.doocsRepresentation.equalsIgnoreCase("Int")) {
                            this.valueData = Integer.toString(Math.round((float)dvalue));
                        }
                        if (!this.doocsRepresentation.equalsIgnoreCase("Hex")) break;
                        this.valueData = Integer.toHexString((int)dvalue);
                        break;
                    }
                    if (dataOut.type() == 1 || dataOut.type() == 105 || dataOut.type() == 115 || dataOut.type() == 8) {
                        int ivalue = dataOut.get_int(this.doocsIndex);
                        this.valueData = Integer.toString(ivalue);
                        if (!this.doocsRepresentation.equalsIgnoreCase("Hex")) break;
                        this.valueData = Integer.toHexString(ivalue);
                        break;
                    }
                    if (dataOut.type() == 4 || dataOut.type() == 119) {
                        int ivalue = dataOut.get_int(this.doocsIndex);
                        this.valueData = Integer.toString(ivalue);
                        if (!this.doocsRepresentation.equalsIgnoreCase("Bool")) break;
                        if (ivalue == 0) {
                            this.valueData = "false";
                            break;
                        }
                        this.valueData = "true";
                        break;
                    }
                    if (dataOut.type() == 103) {
                        int ivalue = dataOut.get_int(this.doocsIndex);
                        this.valueData = Integer.toString(ivalue);
                        break;
                    }
                    if (dataOut.type() == 18) {
                        this.valueData = dataOut.get_time_string();
                        break;
                    }
                    if (dataOut.type() == 0) break;
                    this.valueData = dataOut.get_string(this.doocsIndex);
                    break;
                }
                this.valueData = dataOut.get_string_arg();
                if (this.errorMessage != null) break;
                this.errorMessage = this.value;
                System.out.println(DOOCSParameter.getFullName(this) + ": " + this.fullDoocsAddress + ": " + this.errorMessage);
                break;
            }
            case 2: {
                if (this.doocsReadEGU && dataOut.type() != 0) {
                    if (this.dataEgu.error() == 0) {
                        this.valueEgu = dataOut.get_string_arg().trim();
                        break;
                    }
                    this.valueEgu = "[]";
                    break;
                }
                this.valueEgu = "";
                break;
            }
        }
        this.value = this.doocsReadEGU ? this.valueData + " " + this.valueEgu : this.valueData;
        if (this.value.length() > this.doocsMaxLength) {
            this.value = this.value.substring(0, this.doocsMaxLength);
        }
        if (this.value != null && !this.value.equalsIgnoreCase(this.getText())) {
            String setValue = this.value;
            this.setText(setValue);
        }
    }
}

