/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSParameter;
import editor.undo.SetProperty;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.event.MouseInputListener;

public class DOOCSTriangle
extends JComponent
implements DOOCSComponent {
    private String doocsOrientation = "NORTH";
    private Color doocsLineColor = Color.BLACK;
    private int doocsStrokeSize = 1;
    private Color doocsFillColor = Color.WHITE;
    private boolean doocsLineTransparent = false;
    private boolean doocsFillTransparent = false;
    private String doocsToolTipText = null;
    private boolean doocsScale = true;
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private Rectangle m_initialBounds;

    public DOOCSTriangle() {
        this.setEnabled(this.doocsRunMode);
        this.setPreferredSize(new Dimension(50, 50));
        this.setSize(new Dimension(50, 50));
    }

    @Override
    public void setDnDText(String str) {
    }

    @Override
    public String getDnDText() {
        return null;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void setDoocsOrientation(String orientation) {
        this.doocsOrientation = orientation;
    }

    public String getDoocsOrientation() {
        return this.doocsOrientation;
    }

    public void setDoocsLineColor(Color lineColor) {
        this.doocsLineColor = lineColor;
    }

    public Color getDoocsLineColor() {
        return this.doocsLineColor;
    }

    public void setDoocsLineTransparent(Boolean lineTransparent) {
        this.doocsLineTransparent = lineTransparent;
    }

    public Boolean getDoocsLineTransparent() {
        return this.doocsLineTransparent;
    }

    public void setDoocsStrokeSize(int strokeSize) {
        this.doocsStrokeSize = strokeSize;
    }

    public int getDoocsStrokeSize() {
        return this.doocsStrokeSize;
    }

    public void setDoocsFillColor(Color fillColor) {
        this.doocsFillColor = fillColor;
    }

    public Color getDoocsFillColor() {
        return this.doocsFillColor;
    }

    public void setDoocsFillTransparent(Boolean fillTransparent) {
        this.doocsFillTransparent = fillTransparent;
    }

    public Boolean getDoocsFillTransparent() {
        return this.doocsFillTransparent;
    }

    @Override
    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    @Override
    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    @Override
    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    @Override
    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    @Override
    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        this.setEnabled(bRun);
    }

    @Override
    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    @Override
    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    @Override
    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    @Override
    public void setFullDoocsAddress(String address) {
    }

    @Override
    public String getFullDoocsAddress() {
        return null;
    }

    @Override
    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    @Override
    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("orientation", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("lineColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("lineTransparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("strokeSize", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("fillColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("fillTransparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        if (parameter.equalsIgnoreCase("orientation")) {
            String[] allowedValues = new String[]{"NORTH", "EAST", "SOUTH", "WEST", "NORTHWEST", "NORTHEAST", "SOUTHWEST", "SOUTHEAST"};
            return allowedValues;
        }
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSTriangle ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSTriangle>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("orientation")) {
            this.setDoocsOrientation(value);
        } else if (parameter.equalsIgnoreCase("lineColor")) {
            this.setDoocsLineColor(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("lineTransparent")) {
            this.setDoocsLineTransparent(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("strokeSize")) {
            this.setDoocsStrokeSize(Math.round(Float.parseFloat(value)));
        } else if (parameter.equalsIgnoreCase("fillColor")) {
            this.setDoocsFillColor(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("fillTransparent")) {
            this.setDoocsFillTransparent(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSTriangle.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("orientation")) {
            return this.getDoocsOrientation();
        }
        if (parameter.equalsIgnoreCase("lineColor")) {
            return DOOCSParameter.getDoocsColor(this.getDoocsLineColor());
        }
        if (parameter.equalsIgnoreCase("lineTransparent")) {
            return this.getDoocsLineTransparent();
        }
        if (parameter.equalsIgnoreCase("strokeSize")) {
            return this.getDoocsStrokeSize();
        }
        if (parameter.equalsIgnoreCase("fillColor")) {
            return DOOCSParameter.getDoocsColor(this.getDoocsFillColor());
        }
        if (parameter.equalsIgnoreCase("fillTransparent")) {
            return this.getDoocsFillTransparent();
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return null;
        }
        System.out.println("DOOCSTriangle.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    @Override
    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        Polygon poli = new Polygon();
        int width = this.getSize().width - 1;
        int height = this.getSize().height - 1;
        if (this.doocsOrientation.equalsIgnoreCase("NORTH")) {
            poli.addPoint(width / 2, 0);
            poli.addPoint(0, height);
            poli.addPoint(width, height);
        } else if (this.doocsOrientation.equalsIgnoreCase("EAST")) {
            poli.addPoint(0, 0);
            poli.addPoint(0, height);
            poli.addPoint(width, height / 2);
        } else if (this.doocsOrientation.equalsIgnoreCase("SOUTH")) {
            poli.addPoint(0, 0);
            poli.addPoint(width, 0);
            poli.addPoint(width / 2, height);
        } else if (this.doocsOrientation.equalsIgnoreCase("WEST")) {
            poli.addPoint(width, 0);
            poli.addPoint(width, height);
            poli.addPoint(0, height / 2);
        } else if (this.doocsOrientation.equalsIgnoreCase("NORTHWEST")) {
            poli.addPoint(0, 0);
            poli.addPoint(width, 0);
            poli.addPoint(0, height);
        } else if (this.doocsOrientation.equalsIgnoreCase("NORTHEAST")) {
            poli.addPoint(0, 0);
            poli.addPoint(width, 0);
            poli.addPoint(width, height);
        } else if (this.doocsOrientation.equalsIgnoreCase("SOUTHWEST")) {
            poli.addPoint(0, 0);
            poli.addPoint(0, height);
            poli.addPoint(width, height);
        } else if (this.doocsOrientation.equalsIgnoreCase("SOUTHEAST")) {
            poli.addPoint(0, height);
            poli.addPoint(width, height);
            poli.addPoint(width, 0);
        } else {
            return;
        }
        g2d.setColor(this.doocsFillColor);
        if (!this.doocsFillTransparent) {
            g2d.fillPolygon(poli);
        }
        BasicStroke myStroke = new BasicStroke(this.doocsStrokeSize);
        g2d.setStroke(myStroke);
        g2d.setColor(this.doocsLineColor);
        if (!this.doocsLineTransparent) {
            g2d.drawPolygon(poli);
        }
    }

    @Override
    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        String oldValue = this.getDoocsOrientation();
        this.doFlipHorizontal();
        if (!oldValue.equalsIgnoreCase(this.getDoocsOrientation())) {
            change.add(new SetProperty(this, "orientation", oldValue, this.getDoocsOrientation()));
        }
        return change;
    }

    @Override
    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        String oldValue = this.getDoocsOrientation();
        this.doFlipVertical();
        if (!oldValue.equalsIgnoreCase(this.getDoocsOrientation())) {
            change.add(new SetProperty(this, "orientation", oldValue, this.getDoocsOrientation()));
        }
        return change;
    }

    private void doFlipVertical() {
        if (this.doocsOrientation.equalsIgnoreCase("NORTH")) {
            this.doocsOrientation = "SOUTH";
        } else if (this.doocsOrientation.equalsIgnoreCase("SOUTH")) {
            this.doocsOrientation = "NORTH";
        } else if (this.doocsOrientation.equalsIgnoreCase("NORTHWEST")) {
            this.doocsOrientation = "SOUTHWEST";
        } else if (this.doocsOrientation.equalsIgnoreCase("NORTHEAST")) {
            this.doocsOrientation = "SOUTHEAST";
        } else if (this.doocsOrientation.equalsIgnoreCase("SOUTHWEST")) {
            this.doocsOrientation = "NORTHWEST";
        } else if (this.doocsOrientation.equalsIgnoreCase("SOUTHEAST")) {
            this.doocsOrientation = "NORTHEAST";
        } else {
            return;
        }
    }

    private void doFlipHorizontal() {
        if (this.doocsOrientation.equalsIgnoreCase("EAST")) {
            this.doocsOrientation = "WEST";
        } else if (this.doocsOrientation.equalsIgnoreCase("WEST")) {
            this.doocsOrientation = "EAST";
        } else if (this.doocsOrientation.equalsIgnoreCase("NORTHWEST")) {
            this.doocsOrientation = "NORTHEAST";
        } else if (this.doocsOrientation.equalsIgnoreCase("NORTHEAST")) {
            this.doocsOrientation = "NORTHWEST";
        } else if (this.doocsOrientation.equalsIgnoreCase("SOUTHWEST")) {
            this.doocsOrientation = "SOUTHEAST";
        } else if (this.doocsOrientation.equalsIgnoreCase("SOUTHEAST")) {
            this.doocsOrientation = "SOUTHWEST";
        } else {
            return;
        }
    }

    @Override
    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        String oldValue = this.getDoocsOrientation();
        if (this.doocsOrientation.equalsIgnoreCase("NORTH")) {
            this.doocsOrientation = "WEST";
        } else if (this.doocsOrientation.equalsIgnoreCase("SOUTH")) {
            this.doocsOrientation = "EAST";
        } else if (this.doocsOrientation.equalsIgnoreCase("EAST")) {
            this.doocsOrientation = "NORTH";
        } else if (this.doocsOrientation.equalsIgnoreCase("WEST")) {
            this.doocsOrientation = "SOUTH";
        } else if (this.doocsOrientation.equalsIgnoreCase("NORTHWEST")) {
            this.doocsOrientation = "SOUTHWEST";
        } else if (this.doocsOrientation.equalsIgnoreCase("NORTHEAST")) {
            this.doocsOrientation = "NORTHWEST";
        } else if (this.doocsOrientation.equalsIgnoreCase("SOUTHWEST")) {
            this.doocsOrientation = "SOUTHEAST";
        } else if (this.doocsOrientation.equalsIgnoreCase("SOUTHEAST")) {
            this.doocsOrientation = "NORTHEAST";
        } else {
            return change;
        }
        change.add(new SetProperty(this, "orientation", oldValue, this.getDoocsOrientation()));
        return change;
    }

    @Override
    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        String oldValue = this.getDoocsOrientation();
        if (this.doocsOrientation.equalsIgnoreCase("NORTH")) {
            this.doocsOrientation = "EAST";
        } else if (this.doocsOrientation.equalsIgnoreCase("SOUTH")) {
            this.doocsOrientation = "WEST";
        } else if (this.doocsOrientation.equalsIgnoreCase("EAST")) {
            this.doocsOrientation = "SOUTH";
        } else if (this.doocsOrientation.equalsIgnoreCase("WEST")) {
            this.doocsOrientation = "NORTH";
        } else if (this.doocsOrientation.equalsIgnoreCase("NORTHWEST")) {
            this.doocsOrientation = "NORTHEAST";
        } else if (this.doocsOrientation.equalsIgnoreCase("NORTHEAST")) {
            this.doocsOrientation = "SOUTHEAST";
        } else if (this.doocsOrientation.equalsIgnoreCase("SOUTHWEST")) {
            this.doocsOrientation = "NORTHWEST";
        } else if (this.doocsOrientation.equalsIgnoreCase("SOUTHEAST")) {
            this.doocsOrientation = "SOUTHWEST";
        } else {
            return change;
        }
        change.add(new SetProperty(this, "orientation", oldValue, this.getDoocsOrientation()));
        return change;
    }
}

