/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.DOOCSValueShowHist;
import editor.EditorPanel;
import editor.undo.SetProperty;
import java.awt.Color;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.BitSet;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.event.MouseInputListener;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqCallback;
import ttf.doocs.clnt.EqData;
import xmlparser.IntegerParser;

public class DOOCSStatusRegister
extends JComponent
implements DOOCSComponent,
EqCallback {
    private BitSet bits = new BitSet();
    private MouseAdapter listenerHist;
    private String errorMessage = null;
    private String doocsAddress = null;
    private String fullDoocsAddress = null;
    private int doocsIndex = 0;
    private int doocsLength = 16;
    private float doocsUpdateTime = 2.0f;
    private Color doocsLineColor = Color.BLACK;
    private Color doocsTrueColor = Color.GREEN;
    private Color doocsFalseColor = Color.WHITE;
    private boolean doocsLineTransparent = false;
    private boolean doocsFalseTransparent = true;
    private String doocsRotate = "0";
    private String doocsToolTipText = null;
    private boolean doocsEnablePlot = true;
    private boolean doocsScale = true;
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private Rectangle m_initialBounds;
    private EqCall eq = new EqCall();
    private EqData ed = new EqData();
    private EqData data = new EqData();
    private EqAdr adrData = null;
    private Cursor myCursor;

    public DOOCSStatusRegister() {
        this.setEnabled(this.doocsRunMode);
        this.setPreferredSize(new Dimension(150, 15));
        this.setSize(new Dimension(150, 15));
        this.myCursor = this.getToolkit().createCustomCursor(new ImageIcon(this.getClass().getResource("icons/cursorHist.gif")).getImage(), new Point(0, 0), "Cursor");
        this.listenerHist = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DOOCSStatusRegister.this.showHist();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                if (DOOCSStatusRegister.this.doocsEnablePlot) {
                    DOOCSStatusRegister.this.setCursor(DOOCSStatusRegister.this.myCursor);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                if (DOOCSStatusRegister.this.doocsEnablePlot) {
                    DOOCSStatusRegister.this.setCursor(new Cursor(0));
                }
            }
        };
    }

    private void showHist() {
        DOOCSValueShowHist.showStatusRegisterHist(this.fullDoocsAddress, this);
    }

    @Override
    public void setDnDText(String str) {
    }

    @Override
    public String getDnDText() {
        return null;
    }

    private void startMonitors() {
        if (this.adrData == null) {
            return;
        }
        if ((double)this.doocsUpdateTime == 0.0) {
            this.eq.get_monitor(this.adrData, this.ed, this.data, 1, this.doocsUpdateTime, (EqCallback)this, null);
        } else {
            this.eq.get_monitor(this.adrData, this.ed, this.data, 3, this.doocsUpdateTime, (EqCallback)this, null);
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void setDoocsAddress(String address) {
        this.doocsAddress = address;
    }

    public String getDoocsAddress() {
        return this.doocsAddress;
    }

    @Override
    public void setFullDoocsAddress(String address) {
        if (address == null) {
            return;
        }
        if (this.fullDoocsAddress == null || !address.startsWith(this.fullDoocsAddress)) {
            this.fullDoocsAddress = address;
            if (this.adrData != null) {
                this.eq.clear_monitor(this.adrData);
            }
            this.adrData = new EqAdr(this.fullDoocsAddress);
            if (!EqAdr.isValidAdr((String)this.fullDoocsAddress)) {
                this.adrData = null;
            } else if (this.doocsRunMode) {
                this.startMonitors();
            }
        }
    }

    @Override
    public String getFullDoocsAddress() {
        return this.fullDoocsAddress;
    }

    public void setDoocsIndex(int index) {
        this.doocsIndex = index;
    }

    public int getDoocsIndex() {
        return this.doocsIndex;
    }

    public void setDoocsUpdateTime(float time) {
        if ((double)time != 0.0 && (double)time < 0.1) {
            time = 0.1f;
        }
        this.doocsUpdateTime = time;
    }

    public float getDoocsUpdateTime() {
        return this.doocsUpdateTime;
    }

    public void setDoocsLength(int l) {
        this.doocsLength = l;
    }

    public int getDoocsLength() {
        return this.doocsLength;
    }

    public void setDoocsLineColor(Color lineColor) {
        this.doocsLineColor = lineColor;
    }

    public Color getDoocsLineColor() {
        return this.doocsLineColor;
    }

    public void setDoocsTrueColor(Color trueColor) {
        this.doocsTrueColor = trueColor;
    }

    public Color getDoocsTrueColor() {
        return this.doocsTrueColor;
    }

    public void setDoocsFalseColor(Color falseColor) {
        this.doocsFalseColor = falseColor;
    }

    public Color getDoocsFalseColor() {
        return this.doocsFalseColor;
    }

    public void setDoocsLineTransparent(Boolean lineTransparent) {
        this.doocsLineTransparent = lineTransparent;
    }

    public Boolean getDoocsLineTransparent() {
        return this.doocsLineTransparent;
    }

    public void setDoocsFalseTransparent(Boolean falseTransparent) {
        this.doocsFalseTransparent = falseTransparent;
    }

    public Boolean getDoocsFalseTransparent() {
        return this.doocsFalseTransparent;
    }

    public void setDoocsEnablePlot(boolean plot) {
        this.doocsEnablePlot = plot;
    }

    public boolean getDoocsEnablePlot() {
        return this.doocsEnablePlot;
    }

    public void setDoocsRotate(String rotate) {
        if ((rotate.equalsIgnoreCase("0") || rotate.equalsIgnoreCase("180")) && this.getHeight() > this.getWidth() || !rotate.equalsIgnoreCase("0") && !rotate.equalsIgnoreCase("180") && this.getHeight() < this.getWidth()) {
            this.setPreferredSize(new Dimension(this.getHeight(), this.getWidth()));
            this.setSize(this.getHeight(), this.getWidth());
            this.checkBounds();
        }
        this.doocsRotate = rotate;
    }

    public String getDoocsRotate() {
        return this.doocsRotate;
    }

    @Override
    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    @Override
    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    @Override
    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    @Override
    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    @Override
    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        this.setEnabled(bRun);
        if (bRun) {
            if (this.doocsEnablePlot) {
                this.addMouseListener(this.listenerHist);
            }
            this.startMonitors();
        } else {
            if (this.adrData != null) {
                this.eq.clear_monitor(this.adrData);
            }
            if (this.doocsEnablePlot) {
                this.removeMouseListener(this.listenerHist);
            }
        }
    }

    @Override
    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    @Override
    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    @Override
    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    @Override
    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    @Override
    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("dataIndex", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("length", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("updateTime", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("lineColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("lineTransparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("falseColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("falseTransparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("trueColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("rotate", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("enablePlot", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        if (parameter.equalsIgnoreCase("rotate")) {
            String[] allowedValues = new String[]{"0", "90", "180", "270"};
            return allowedValues;
        }
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSStatusRegister ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSStatusRegister>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.equalsIgnoreCase("dataIndex")) {
            this.setDoocsIndex(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("length")) {
            this.setDoocsLength(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("updateTime")) {
            this.setDoocsUpdateTime(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("lineColor")) {
            this.setDoocsLineColor(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("lineTransparent")) {
            this.setDoocsLineTransparent(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("falseColor")) {
            this.setDoocsFalseColor(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("falseTransparent")) {
            this.setDoocsFalseTransparent(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("trueColor")) {
            this.setDoocsTrueColor(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("rotate")) {
            this.setDoocsRotate(value);
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("enablePlot")) {
            this.setDoocsEnablePlot(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSStatusRegister.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.equalsIgnoreCase("dataIndex")) {
            return this.getDoocsIndex();
        }
        if (parameter.equalsIgnoreCase("length")) {
            return this.getDoocsLength();
        }
        if (parameter.equalsIgnoreCase("updateTime")) {
            return Float.valueOf(this.getDoocsUpdateTime());
        }
        if (parameter.equalsIgnoreCase("lineColor")) {
            return DOOCSParameter.getDoocsColor(this.getDoocsLineColor());
        }
        if (parameter.equalsIgnoreCase("lineTransparent")) {
            return this.getDoocsLineTransparent();
        }
        if (parameter.equalsIgnoreCase("falseColor")) {
            return DOOCSParameter.getDoocsColor(this.getDoocsFalseColor());
        }
        if (parameter.equalsIgnoreCase("falseTransparent")) {
            return this.getDoocsFalseTransparent();
        }
        if (parameter.equalsIgnoreCase("trueColor")) {
            return DOOCSParameter.getDoocsColor(this.getDoocsTrueColor());
        }
        if (parameter.equalsIgnoreCase("rotate")) {
            return this.getDoocsRotate();
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("enablePlot")) {
            return this.getDoocsEnablePlot();
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return null;
        }
        System.out.println("DOOCSStatusRegister.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    public void checkBounds() {
        Container parent = this.getParent();
        if (!(parent == null || parent instanceof EditorPanel && parent.getWidth() == 100 && parent.getHeight() == 100)) {
            if (this.getX() < 0) {
                this.setLocation(0, this.getY());
            }
            if (this.getY() < 0) {
                this.setLocation(this.getX(), 0);
            }
            if (this.getX() + this.getWidth() > parent.getWidth()) {
                this.setLocation(parent.getWidth() - this.getWidth() - 1, this.getY());
            }
            if (this.getY() + this.getHeight() > parent.getHeight()) {
                this.setLocation(this.getX(), parent.getHeight() - this.getHeight() - 1);
            }
        }
    }

    @Override
    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
    }

    public void dataCallback(EqData dataOut, Object userData) {
        int value = 0;
        if (dataOut.error() == 0) {
            if (dataOut.type() == 1 || dataOut.type() == 105 || dataOut.type() == 8 || dataOut.type() == 115) {
                this.errorMessage = null;
                value = dataOut.get_int(this.doocsIndex);
                String binary = Integer.toBinaryString(value);
                this.bits.clear();
                if (this.doocsLength > binary.length()) {
                    for (int i = 0; i < binary.length(); ++i) {
                        this.bits.set(i + this.doocsLength - binary.length(), binary.charAt(i) == '1');
                    }
                } else {
                    for (int i = 0; i < this.doocsLength; ++i) {
                        this.bits.set(i, binary.charAt(i + binary.length() - this.doocsLength) == '1');
                    }
                }
                this.repaint();
            } else if (this.errorMessage == null) {
                this.errorMessage = "Wrong data type!";
                System.out.println(DOOCSParameter.getFullName(this) + ": " + this.errorMessage);
            }
        } else if (this.errorMessage == null) {
            this.errorMessage = dataOut.get_string_arg();
            System.out.println(DOOCSParameter.getFullName(this) + ": " + this.fullDoocsAddress + ": " + this.errorMessage);
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        int xpos;
        int i;
        int height;
        int width;
        Graphics2D g2d = (Graphics2D)g.create();
        if (this.doocsRotate.equalsIgnoreCase("90")) {
            g2d.rotate(1.5707963267948966);
            g2d.translate(0, -this.getWidth() + 1);
        }
        if (this.doocsRotate.equalsIgnoreCase("180")) {
            g2d.rotate(Math.PI);
            g2d.translate(-this.getWidth() + 1, -this.getHeight() + 1);
        }
        if (this.doocsRotate.equalsIgnoreCase("270")) {
            g2d.rotate(-1.5707963267948966);
            g2d.translate(-this.getHeight() + 1, 0);
        }
        int x = 0;
        int y = 0;
        if (this.doocsRotate.equalsIgnoreCase("0") || this.doocsRotate.equalsIgnoreCase("180")) {
            width = this.getSize().width - 1;
            height = this.getSize().height - 1;
        } else {
            width = this.getSize().height - 1;
            height = this.getSize().width - 1;
        }
        for (i = 0; i < this.doocsLength; ++i) {
            xpos = Math.round((float)width / (float)this.doocsLength * (float)i);
            if (this.bits.get(i)) {
                g2d.setColor(this.doocsTrueColor);
                g2d.fillRect(xpos, y + 2, Math.round((float)width / (float)this.doocsLength * (float)(i + 1)) - xpos, height - 1);
                continue;
            }
            g2d.setColor(this.doocsFalseColor);
            if (this.doocsFalseTransparent) continue;
            g2d.fillRect(xpos, y + 2, Math.round((float)width / (float)this.doocsLength * (float)(i + 1)) - xpos, height - 1);
        }
        g2d.setColor(this.doocsLineColor);
        if (!this.doocsLineTransparent) {
            g2d.drawRect(x, y + 2, width, height - 2);
            for (i = this.doocsLength; i > 0; --i) {
                xpos = Math.round((float)width / (float)this.doocsLength * (float)i);
                if ((this.doocsLength - i) % 4 == 0 && i != this.doocsLength) {
                    g2d.drawLine(xpos, y, xpos, height);
                    continue;
                }
                g2d.drawLine(xpos, y + 2, xpos, height - 1);
            }
        }
        if (this.doocsLineTransparent && !this.doocsRunMode) {
            g2d.setColor(Color.LIGHT_GRAY);
            g2d.drawRect(x, y + 2, width, height - 2);
            for (i = this.doocsLength; i > 0; --i) {
                xpos = Math.round((float)width / (float)this.doocsLength * (float)i);
                if (i % 4 == 0 && i != this.doocsLength) {
                    g2d.drawLine(xpos, y, xpos, height);
                    continue;
                }
                g2d.drawLine(xpos, y + 2, xpos, height - 1);
            }
        }
        g2d.dispose();
    }

    @Override
    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        String oldValue = this.getDoocsRotate();
        if (oldValue.equalsIgnoreCase("90")) {
            this.setDoocsRotate("270");
        }
        if (oldValue.equalsIgnoreCase("270")) {
            this.setDoocsRotate("90");
        }
        if (!oldValue.equalsIgnoreCase(this.getDoocsRotate())) {
            change.add(new SetProperty(this, "rotate", oldValue, this.getDoocsRotate()));
        }
        return change;
    }

    @Override
    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        String oldValue = this.getDoocsRotate();
        if (oldValue.equalsIgnoreCase("0")) {
            this.setDoocsRotate("180");
        }
        if (oldValue.equalsIgnoreCase("180")) {
            this.setDoocsRotate("0");
        }
        if (!oldValue.equalsIgnoreCase(this.getDoocsRotate())) {
            change.add(new SetProperty(this, "rotate", oldValue, this.getDoocsRotate()));
        }
        return change;
    }

    @Override
    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        String oldValue = this.getDoocsRotate();
        if (oldValue.equalsIgnoreCase("0")) {
            this.setDoocsRotate("270");
        }
        if (oldValue.equalsIgnoreCase("90")) {
            this.setDoocsRotate("0");
        }
        if (oldValue.equalsIgnoreCase("180")) {
            this.setDoocsRotate("90");
        }
        if (oldValue.equalsIgnoreCase("270")) {
            this.setDoocsRotate("180");
        }
        change.add(new SetProperty(this, "rotate", oldValue, this.getDoocsRotate()));
        return change;
    }

    @Override
    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        String oldValue = this.getDoocsRotate();
        if (oldValue.equalsIgnoreCase("0")) {
            this.setDoocsRotate("90");
        }
        if (oldValue.equalsIgnoreCase("90")) {
            this.setDoocsRotate("180");
        }
        if (oldValue.equalsIgnoreCase("180")) {
            this.setDoocsRotate("270");
        }
        if (oldValue.equalsIgnoreCase("270")) {
            this.setDoocsRotate("0");
        }
        change.add(new SetProperty(this, "rotate", oldValue, this.getDoocsRotate()));
        return change;
    }
}

