/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSParameter;
import editor.undo.SetProperty;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.event.MouseInputListener;
import xmlparser.IntegerParser;

public class DOOCSOval
extends JComponent
implements DOOCSComponent {
    private Color doocsLineColor = Color.BLACK;
    private int doocsStrokeSize = 1;
    private Color doocsFillColor = Color.WHITE;
    private String doocsToolTipText = null;
    private boolean doocsScale = true;
    private boolean doocsKeepCircle = false;
    private boolean doocsLineTransparent = false;
    private boolean doocsFillTransparent = false;
    private String doocsArcAngles = null;
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private Rectangle m_initialBounds;

    public DOOCSOval() {
        this.setEnabled(this.doocsRunMode);
        this.setPreferredSize(new Dimension(50, 50));
        this.setSize(new Dimension(50, 50));
    }

    @Override
    public void setDnDText(String str) {
    }

    @Override
    public String getDnDText() {
        return null;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void setDoocsLineColor(Color lineColor) {
        this.doocsLineColor = lineColor;
    }

    public Color getDoocsLineColor() {
        return this.doocsLineColor;
    }

    public void setDoocsLineTransparent(Boolean lineTransparent) {
        this.doocsLineTransparent = lineTransparent;
    }

    public Boolean getDoocsLineTransparent() {
        return this.doocsLineTransparent;
    }

    public void setDoocsStrokeSize(int strokeSize) {
        this.doocsStrokeSize = strokeSize;
    }

    public int getDoocsStrokeSize() {
        return this.doocsStrokeSize;
    }

    public void setDoocsFillColor(Color fillColor) {
        this.doocsFillColor = fillColor;
    }

    public Color getDoocsFillColor() {
        return this.doocsFillColor;
    }

    public void setDoocsFillTransparent(Boolean fillTransparent) {
        this.doocsFillTransparent = fillTransparent;
    }

    public Boolean getDoocsFillTransparent() {
        return this.doocsFillTransparent;
    }

    public void setDoocsKeepCircle(boolean circle) {
        this.doocsKeepCircle = circle;
    }

    public boolean getDoocsKeepCircle() {
        return this.doocsKeepCircle;
    }

    public void setDoocsArcAngles(String angles) {
        if (angles != null && angles.contains(",")) {
            this.doocsArcAngles = angles;
        }
    }

    public String getDoocsArcAngles() {
        return this.doocsArcAngles;
    }

    @Override
    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    @Override
    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    @Override
    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    @Override
    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    @Override
    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        this.setEnabled(bRun);
    }

    @Override
    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    @Override
    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    @Override
    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    @Override
    public void setFullDoocsAddress(String address) {
    }

    @Override
    public String getFullDoocsAddress() {
        return null;
    }

    @Override
    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    @Override
    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("lineColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("lineTransparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("strokeSize", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("fillColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("fillTransparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("arcAngles", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL, "startAngle, stopAngle"), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("keepCircle", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSOval ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSOval>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("lineColor")) {
            this.setDoocsLineColor(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("lineTransparent")) {
            this.setDoocsLineTransparent(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("strokeSize")) {
            this.setDoocsStrokeSize(Math.round(Float.parseFloat(value)));
        } else if (parameter.equalsIgnoreCase("fillColor")) {
            this.setDoocsFillColor(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("fillTransparent")) {
            this.setDoocsFillTransparent(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("arcAngles")) {
            this.setDoocsArcAngles(value);
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("keepCircle")) {
            this.setDoocsKeepCircle(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSOval.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("lineColor")) {
            return DOOCSParameter.getDoocsColor(this.getDoocsLineColor());
        }
        if (parameter.equalsIgnoreCase("lineTransparent")) {
            return this.getDoocsLineTransparent();
        }
        if (parameter.equalsIgnoreCase("strokeSize")) {
            return this.getDoocsStrokeSize();
        }
        if (parameter.equalsIgnoreCase("fillColor")) {
            return DOOCSParameter.getDoocsColor(this.getDoocsFillColor());
        }
        if (parameter.equalsIgnoreCase("fillTransparent")) {
            return this.getDoocsFillTransparent();
        }
        if (parameter.equalsIgnoreCase("arcAngles")) {
            return this.getDoocsArcAngles();
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("keepCircle")) {
            return this.getDoocsKeepCircle();
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return null;
        }
        System.out.println("DOOCSOval.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    @Override
    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
    }

    public boolean isSelected(int x, int y) {
        int a = this.getWidth() / 2;
        int b = this.getHeight() / 2;
        int myx = Math.abs(x - a);
        int myy = -(y - b);
        int calcx = Math.round((float)Math.sqrt((1.0 - (double)myy * (double)myy / (double)(b * b)) * (double)a * (double)a));
        return this.doocsFillTransparent ? myx - this.doocsStrokeSize - 2 < calcx && calcx < myx + this.doocsStrokeSize + 2 : myx < calcx + this.doocsStrokeSize;
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        int x = 0;
        int y = 0;
        int width = this.getSize().width - 1;
        int height = this.getSize().height - 1;
        if (this.doocsKeepCircle && width > height) {
            width = height;
            x = Math.round((float)(this.getSize().width - width) / 2.0f);
        }
        if (this.doocsKeepCircle && width < height) {
            height = width;
            y = Math.round((float)(this.getSize().height - height) / 2.0f);
        }
        boolean arc = false;
        int arcStart = 0;
        int arcExtends = 360;
        if (this.doocsArcAngles != null) {
            try {
                int komma = this.doocsArcAngles.indexOf(",");
                arcStart = -IntegerParser.parseInt(this.doocsArcAngles.substring(0, komma).trim()) + 90;
                arcExtends = IntegerParser.parseInt(this.doocsArcAngles.substring(0, komma).trim()) - IntegerParser.parseInt(this.doocsArcAngles.substring(komma + 1).trim());
                arc = true;
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
        }
        g2d.setColor(this.doocsFillColor);
        if (!this.doocsFillTransparent && !arc) {
            g2d.fillOval(x, y, width, height);
        }
        if (!this.doocsFillTransparent && arc) {
            g2d.fillArc(x, y, width, height, arcStart, arcExtends);
        }
        BasicStroke myStroke = new BasicStroke(this.doocsStrokeSize);
        g2d.setStroke(myStroke);
        g2d.setColor(this.doocsLineColor);
        if (!this.doocsLineTransparent && !arc) {
            g2d.drawOval(x, y, width, height);
        }
        if (!this.doocsLineTransparent && arc) {
            g2d.drawArc(x, y, width, height, arcStart, arcExtends);
        }
    }

    @Override
    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        return change;
    }
}

