/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSLinePoints;
import DOOCSComponents.DOOCSParameter;
import editor.undo.SetProperty;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.event.MouseInputListener;
import xmlparser.IntegerParser;

public class DOOCSLine
extends JComponent
implements DOOCSComponent {
    private Color doocsLineColor = Color.BLACK;
    private int doocsStrokeSize = 1;
    private DOOCSLinePoints doocsPoints = new DOOCSLinePoints();
    private String doocsToolTipText = null;
    private boolean doocsScale = true;
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    public boolean adjust = false;
    public boolean recalc = false;
    private Rectangle m_initialBounds;

    public DOOCSLine() {
        this.setEnabled(this.doocsRunMode);
        this.setPreferredSize(new Dimension(50, 50));
        this.setSize(new Dimension(50, 50));
    }

    @Override
    public void setDnDText(String str) {
    }

    @Override
    public String getDnDText() {
        return null;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void setDoocsPoints(Rectangle points) {
        if (this.recalc) {
            this.recalc = false;
            this.doocsPoints.setNewPoints(points);
        } else {
            this.adjustBounds(points.x, points.y, points.width, points.height);
        }
    }

    public void setDoocsPoints(int x1, int y1, int x2, int y2) {
        if (this.recalc) {
            this.recalc = false;
            this.doocsPoints.setNewPoints(x1, y1, x2, y2);
        } else {
            this.adjustBounds(x1, y1, x2, y2);
        }
    }

    public void adjustBounds(int x1, int y1, int x2, int y2) {
        int b;
        int a;
        this.adjust = true;
        int x = this.getBounds().x;
        int y = this.getBounds().y;
        int width = this.getBounds().width;
        int height = this.getBounds().height;
        int x1abs = x + x1;
        int y1abs = y + y1;
        int x2abs = x + x2;
        int y2abs = y + y2;
        float s = (float)this.doocsStrokeSize / 2.0f;
        if (x1 < x2 && y1 < y2) {
            a = x2 - x1;
            b = y2 - y1;
            x = x1abs - DOOCSLine.round((float)b * s / (float)Math.sqrt(a * a + b * b));
            y = y1abs - DOOCSLine.round((float)a * s / (float)Math.sqrt(a * a + b * b));
            width = x2 - x1 + DOOCSLine.round((float)(2 * b) * s / (float)Math.sqrt(a * a + b * b));
            height = y2 - y1 + DOOCSLine.round((float)(2 * a) * s / (float)Math.sqrt(a * a + b * b));
        }
        if (x1 < x2 && y1 > y2) {
            a = x2 - x1;
            b = y1 - y2;
            x = x1abs - DOOCSLine.round((float)b * s / (float)Math.sqrt(a * a + b * b));
            y = y2abs - DOOCSLine.round((float)a * s / (float)Math.sqrt(a * a + b * b));
            width = x2 - x1 + DOOCSLine.round((float)(2 * b) * s / (float)Math.sqrt(a * a + b * b));
            height = y1 - y2 + DOOCSLine.round((float)(2 * a) * s / (float)Math.sqrt(a * a + b * b));
        }
        if (x1 > x2 && y1 < y2) {
            a = x1 - x2;
            b = y2 - y1;
            x = x2abs - DOOCSLine.round((float)b * s / (float)Math.sqrt(a * a + b * b));
            y = y1abs - DOOCSLine.round((float)a * s / (float)Math.sqrt(a * a + b * b));
            width = x1 - x2 + DOOCSLine.round((float)(2 * b) * s / (float)Math.sqrt(a * a + b * b));
            height = y2 - y1 + DOOCSLine.round((float)(2 * a) * s / (float)Math.sqrt(a * a + b * b));
        }
        if (x1 > x2 && y1 > y2) {
            a = x1 - x2;
            b = y1 - y2;
            x = x2abs - DOOCSLine.round((float)b * s / (float)Math.sqrt(a * a + b * b));
            y = y2abs - DOOCSLine.round((float)a * s / (float)Math.sqrt(a * a + b * b));
            width = x1 - x2 + DOOCSLine.round((float)(2 * b) * s / (float)Math.sqrt(a * a + b * b));
            height = y1 - y2 + DOOCSLine.round((float)(2 * a) * s / (float)Math.sqrt(a * a + b * b));
        }
        if (x1 == x2 && y1 < y2) {
            x = x1abs - (int)Math.floor(s);
            y = y1abs;
            width = this.doocsStrokeSize;
            height = y2 - y1;
        }
        if (x1 == x2 && y1 > y2) {
            x = x1abs - (int)Math.floor(s);
            y = y2abs;
            width = this.doocsStrokeSize;
            height = y1 - y2;
        }
        if (x1 < x2 && y1 == y2) {
            x = x1abs;
            y = y1abs - (int)Math.floor(s);
            width = x2 - x1;
            height = this.doocsStrokeSize;
        }
        if (x1 > x2 && y1 == y2) {
            x = x2abs;
            y = y1abs - (int)Math.floor(s);
            width = x1 - x2;
            height = this.doocsStrokeSize;
        }
        this.setBounds(x, y, width, height);
        this.doocsPoints.setNewPoints(x1abs - x, y1abs - y, x2abs - x, y2abs - y);
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (width == 0) {
            width = 1;
        }
        if (height == 0) {
            height = 1;
        }
        int oldWidth = this.getWidth();
        int oldHeight = this.getHeight();
        super.setBounds(x, y, width, height);
        if (this.adjust) {
            this.adjust = false;
        } else if (oldWidth != 0 && oldHeight != 0) {
            this.recalc = true;
            if (oldWidth != width || oldHeight != height) {
                this.recalcPoints();
            }
        }
    }

    public void recalcPoints() {
        int x1 = this.doocsPoints.x1;
        int y1 = this.doocsPoints.y1;
        int x2 = this.doocsPoints.x2;
        int y2 = this.doocsPoints.y2;
        int width = this.getBounds().width;
        int height = this.getBounds().height;
        int s = this.doocsStrokeSize;
        if (x1 < x2 && y1 < y2) {
            x1 = DOOCSLine.round((float)(s * height) / ((float)Math.sqrt(height * height + width * width) * 2.0f));
            y1 = DOOCSLine.round((float)(s * width) / ((float)Math.sqrt(height * height + width * width) * 2.0f));
            x2 = width - DOOCSLine.round((float)(s * height) / ((float)Math.sqrt(height * height + width * width) * 2.0f));
            y2 = height - DOOCSLine.round((float)(s * width) / ((float)Math.sqrt(height * height + width * width) * 2.0f));
        }
        if (x1 < x2 && y1 > y2) {
            x1 = DOOCSLine.round((float)(s * height) / ((float)Math.sqrt(height * height + width * width) * 2.0f));
            y1 = height - DOOCSLine.round((float)(s * width) / ((float)Math.sqrt(height * height + width * width) * 2.0f));
            x2 = width - DOOCSLine.round((float)(s * height) / ((float)Math.sqrt(height * height + width * width) * 2.0f));
            y2 = DOOCSLine.round((float)(s * width) / ((float)Math.sqrt(height * height + width * width) * 2.0f));
        }
        if (x1 > x2 && y1 < y2) {
            x1 = width - DOOCSLine.round((float)(s * height) / ((float)Math.sqrt(height * height + width * width) * 2.0f));
            y1 = DOOCSLine.round((float)(s * width) / ((float)Math.sqrt(height * height + width * width) * 2.0f));
            x2 = DOOCSLine.round((float)(s * height) / ((float)Math.sqrt(height * height + width * width) * 2.0f));
            y2 = height - DOOCSLine.round((float)(s * width) / ((float)Math.sqrt(height * height + width * width) * 2.0f));
        }
        if (x1 > x2 && y1 > y2) {
            x1 = width - DOOCSLine.round((float)(s * height) / ((float)Math.sqrt(height * height + width * width) * 2.0f));
            y1 = height - DOOCSLine.round((float)(s * width) / ((float)Math.sqrt(height * height + width * width) * 2.0f));
            x2 = DOOCSLine.round((float)(s * height) / ((float)Math.sqrt(height * height + width * width) * 2.0f));
            y2 = DOOCSLine.round((float)(s * width) / ((float)Math.sqrt(height * height + width * width) * 2.0f));
        }
        if (x1 == x2 && y1 < y2) {
            x1 = DOOCSLine.round((float)width / 2.0f);
            y1 = DOOCSLine.round((float)(s * width) / ((float)Math.sqrt(height * height + width * width) * 2.0f));
            x2 = DOOCSLine.round((float)width / 2.0f);
            y2 = height - DOOCSLine.round((float)(s * width) / ((float)Math.sqrt(height * height + width * width) * 2.0f));
        }
        if (x1 == x2 && y1 > y2) {
            x1 = DOOCSLine.round((float)width / 2.0f);
            y1 = height - DOOCSLine.round((float)(s * width) / ((float)Math.sqrt(height * height + width * width) * 2.0f));
            x2 = DOOCSLine.round((float)width / 2.0f);
            y2 = DOOCSLine.round((float)(s * width) / ((float)Math.sqrt(height * height + width * width) * 2.0f));
        }
        if (x1 < x2 && y1 == y2) {
            x1 = DOOCSLine.round((float)(s * height) / ((float)Math.sqrt(height * height + width * width) * 2.0f));
            y1 = DOOCSLine.round((float)height / 2.0f);
            x2 = width - DOOCSLine.round((float)(s * height) / ((float)Math.sqrt(height * height + width * width) * 2.0f));
            y2 = DOOCSLine.round((float)height / 2.0f);
        }
        if (x1 > x2 && y1 == y2) {
            x1 = width - DOOCSLine.round((float)(s * height) / ((float)Math.sqrt(height * height + width * width) * 2.0f));
            y1 = DOOCSLine.round((float)height / 2.0f);
            x2 = DOOCSLine.round((float)(s * height) / ((float)Math.sqrt(height * height + width * width) * 2.0f));
            y2 = DOOCSLine.round((float)height / 2.0f);
        }
        this.setDoocsPoints(x1, y1, x2, y2);
    }

    private static int round(float f) {
        return (int)Math.floor(f + 0.4449f);
    }

    public DOOCSLinePoints getDoocsPoints() {
        return this.doocsPoints;
    }

    public void setDoocsLineColor(Color lineColor) {
        this.doocsLineColor = lineColor;
    }

    public Color getDoocsLineColor() {
        return this.doocsLineColor;
    }

    public void setDoocsStrokeSize(int strokeSize) {
        this.doocsStrokeSize = strokeSize;
        this.adjustBounds(this.doocsPoints.x1, this.doocsPoints.y1, this.doocsPoints.x2, this.doocsPoints.y2);
    }

    public int getDoocsStrokeSize() {
        return this.doocsStrokeSize;
    }

    @Override
    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    @Override
    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    @Override
    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    @Override
    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    @Override
    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        this.setEnabled(bRun);
    }

    @Override
    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    @Override
    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    @Override
    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    @Override
    public void setFullDoocsAddress(String address) {
    }

    @Override
    public String getFullDoocsAddress() {
        return null;
    }

    @Override
    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    @Override
    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("points", DOOCSParameter.ParameterTypes.POINTS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("lineColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("strokeSize", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSLine ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSLine>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("points")) {
            this.setDoocsPoints(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("lineColor")) {
            this.setDoocsLineColor(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("strokeSize")) {
            this.setDoocsStrokeSize(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSLine.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("points")) {
            return this.doocsPoints.toString();
        }
        if (parameter.equalsIgnoreCase("lineColor")) {
            return DOOCSParameter.getDoocsColor(this.getDoocsLineColor());
        }
        if (parameter.equalsIgnoreCase("strokeSize")) {
            return this.getDoocsStrokeSize();
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return null;
        }
        System.out.println("DOOCSLine.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    @Override
    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
    }

    public boolean isSelected(int x, int y) {
        double a = (double)(this.doocsPoints.y2 - this.doocsPoints.y1) / (double)(this.doocsPoints.x2 - this.doocsPoints.x1);
        double b = (double)this.doocsPoints.y1 - a * (double)this.doocsPoints.x1;
        if ((double)y > a * (double)x + b - (double)this.doocsStrokeSize && (double)y < a * (double)x + b + (double)this.doocsStrokeSize) {
            return true;
        }
        if ((double)x > ((double)y - b) / a - (double)this.doocsStrokeSize && (double)x < ((double)y - b) / a + (double)this.doocsStrokeSize) {
            return true;
        }
        if (this.doocsStrokeSize == 1 && (double)y > a * (double)x + b - 2.0 && (double)y < a * (double)x + b + 2.0) {
            return true;
        }
        if (this.doocsStrokeSize == 1 && (double)x > ((double)y - b) / a - 2.0 && (double)x < ((double)y - b) / a + 2.0) {
            return true;
        }
        if (this.doocsPoints.y1 == this.doocsPoints.y2 && x >= 0 && x <= this.getWidth() && y >= 0 && y <= this.getHeight()) {
            return true;
        }
        return this.doocsPoints.x1 == this.doocsPoints.x2 && x >= 0 && x <= this.getWidth() && y >= 0 && y <= this.getHeight();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        int x1 = this.doocsPoints.x1;
        int y1 = this.doocsPoints.y1;
        int x2 = this.doocsPoints.x2;
        int y2 = this.doocsPoints.y2;
        BasicStroke myStroke = new BasicStroke(this.doocsStrokeSize, 0, 2);
        g2d.setStroke(myStroke);
        g2d.setColor(this.doocsLineColor);
        g2d.drawLine(x1, y1, x2, y2);
    }

    @Override
    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        String oldValue = this.getDoocsPoints().toString();
        int dummy = this.doocsPoints.x1;
        this.doocsPoints.x1 = this.doocsPoints.x2;
        this.doocsPoints.x2 = dummy;
        this.repaint();
        change.add(new SetProperty(this, "points", oldValue, this.getDoocsPoints().toString()));
        return change;
    }

    @Override
    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        String oldValue = this.getDoocsPoints().toString();
        int dummy = this.doocsPoints.y1;
        this.doocsPoints.y1 = this.doocsPoints.y2;
        this.doocsPoints.y2 = dummy;
        this.repaint();
        change.add(new SetProperty(this, "points", oldValue, this.getDoocsPoints().toString()));
        return change;
    }

    @Override
    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        String oldValue = this.getDoocsPoints().toString();
        int x1 = this.doocsPoints.x1;
        int y1 = this.doocsPoints.y1;
        int x2 = this.doocsPoints.x2;
        int y2 = this.doocsPoints.y2;
        if (x1 < x2 && y1 < y2) {
            this.doocsPoints.x1 = y1;
            this.doocsPoints.y1 = x2;
            this.doocsPoints.x2 = y2;
            this.doocsPoints.y2 = x1;
        }
        if (x1 > x2 && y1 < y2) {
            this.doocsPoints.x2 = y2;
            this.doocsPoints.y2 = x1;
            this.doocsPoints.x1 = y1;
            this.doocsPoints.y1 = x2;
        }
        if (x1 > x2 && y1 > y2) {
            this.doocsPoints.x1 = y1;
            this.doocsPoints.y1 = x2;
            this.doocsPoints.x2 = y2;
            this.doocsPoints.y2 = x1;
        }
        if (x1 < x2 && y1 > y2) {
            this.doocsPoints.x2 = y2;
            this.doocsPoints.y2 = x1;
            this.doocsPoints.x1 = y1;
            this.doocsPoints.y1 = x2;
        }
        if (y1 == y2 || x1 == x2) {
            this.doocsPoints.x2 = y1;
            this.doocsPoints.y2 = x1;
            this.doocsPoints.x1 = y2;
            this.doocsPoints.y1 = x2;
        }
        change.add(new SetProperty(this, "points", oldValue, this.getDoocsPoints().toString()));
        return change;
    }

    @Override
    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        String oldValue = this.getDoocsPoints().toString();
        int x1 = this.doocsPoints.x1;
        int y1 = this.doocsPoints.y1;
        int x2 = this.doocsPoints.x2;
        int y2 = this.doocsPoints.y2;
        if (x1 < x2 && y1 < y2) {
            this.doocsPoints.x2 = y1;
            this.doocsPoints.y2 = x2;
            this.doocsPoints.x1 = y2;
            this.doocsPoints.y1 = x1;
        }
        if (x1 > x2 && y1 < y2) {
            this.doocsPoints.x1 = y2;
            this.doocsPoints.y1 = x1;
            this.doocsPoints.x2 = y1;
            this.doocsPoints.y2 = x2;
        }
        if (x1 > x2 && y1 > y2) {
            this.doocsPoints.x2 = y1;
            this.doocsPoints.y2 = x2;
            this.doocsPoints.x1 = y2;
            this.doocsPoints.y1 = x1;
        }
        if (x1 < x2 && y1 > y2) {
            this.doocsPoints.x1 = y2;
            this.doocsPoints.y1 = x1;
            this.doocsPoints.x2 = y1;
            this.doocsPoints.y2 = x2;
        }
        if (y1 == y2 || x1 == x2) {
            this.doocsPoints.x1 = y1;
            this.doocsPoints.y1 = x1;
            this.doocsPoints.x2 = y2;
            this.doocsPoints.y2 = x2;
        }
        change.add(new SetProperty(this, "points", oldValue, this.getDoocsPoints().toString()));
        return change;
    }
}

