/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSLabelUI;
import DOOCSComponents.DOOCSParameter;
import editor.EditorPanel;
import editor.undo.SetProperty;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.LabelUI;
import ttf.doocs.clnt.EqAdr;
import xmlparser.IntegerParser;

public class DOOCSLabel
extends JLabel
implements DOOCSComponent {
    private String doocsToolTipText = null;
    private String doocsText = null;
    private boolean doocsScale = true;
    private int doocsClipX = 2;
    private int doocsClipY = 2;
    private String doocsRotate = "0";
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private Rectangle m_initialBounds;
    private LabelUI defaultUI;

    public DOOCSLabel() {
        this.setHorizontalAlignment(2);
        this.setVerticalAlignment(3);
        this.setText("Label");
        this.defaultUI = this.getUI();
    }

    @Override
    public void setDnDText(String str) {
    }

    @Override
    public String getDnDText() {
        return null;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    @Override
    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    @Override
    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    @Override
    public void setFullDoocsAddress(String address) {
        if (!DOOCSParameter.getLastLayeredPane(this).isEditMode()) {
            String text = this.doocsText;
            if (address != null && this.doocsText != null) {
                EqAdr ea = new EqAdr(address);
                if (EqAdr.isValidAdr((String)address)) {
                    text = text.replace("$f", ea.facility());
                    text = text.replace("$d", ea.device());
                    text = text.replace("$l", ea.location());
                    text = text.replace("$p", ea.property());
                }
                this.setText(text);
            }
        }
    }

    @Override
    public String getFullDoocsAddress() {
        return null;
    }

    @Override
    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    @Override
    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    public void setDoocsText(String ttt) {
        this.doocsText = ttt;
        this.setText(ttt);
    }

    public String getDoocsText() {
        return this.doocsText;
    }

    public void setDoocsClipX(int clip) {
        this.doocsClipX = clip;
    }

    public int getDoocsClipX() {
        return this.doocsClipX;
    }

    public void setDoocsClipY(int clip) {
        this.doocsClipY = clip;
    }

    public int getDoocsClipY() {
        return this.doocsClipY;
    }

    public void setDoocsRotate(String rotate) {
        if ((rotate.equalsIgnoreCase("0") || rotate.equalsIgnoreCase("180")) && this.getHeight() > this.getWidth() || !rotate.equalsIgnoreCase("0") && !rotate.equalsIgnoreCase("180") && this.getHeight() < this.getWidth()) {
            this.setPreferredSize(new Dimension(this.getHeight(), this.getWidth()));
            this.setSize(this.getHeight(), this.getWidth());
            Container parent = this.getParent();
            if (!(parent == null || parent instanceof EditorPanel && parent.getWidth() == 100 && parent.getHeight() == 100)) {
                if (this.getX() < 0) {
                    this.setLocation(0, this.getY());
                }
                if (this.getY() < 0) {
                    this.setLocation(this.getX(), 0);
                }
                if (this.getX() + this.getWidth() > parent.getWidth()) {
                    this.setLocation(parent.getWidth() - this.getWidth(), this.getY());
                }
                if (this.getY() + this.getHeight() > parent.getHeight()) {
                    this.setLocation(this.getX(), parent.getHeight() - this.getHeight());
                }
            }
        }
        this.doocsRotate = rotate;
        if (rotate.equalsIgnoreCase("270")) {
            this.setUI(new DOOCSLabelUI(270));
        } else if (rotate.equalsIgnoreCase("90")) {
            this.setUI(new DOOCSLabelUI(90));
        } else {
            this.setUI(this.defaultUI);
        }
    }

    public String getDoocsRotate() {
        return this.doocsRotate;
    }

    @Override
    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    @Override
    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    @Override
    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
    }

    @Override
    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    @Override
    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    @Override
    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("text", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textFont", DOOCSParameter.ParameterTypes.FONT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bgColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bgTransparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("clipX", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.SCALE), new DOOCSParameter("clipY", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.SCALE), new DOOCSParameter("rotate", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("alignX", DOOCSParameter.ParameterTypes.ALIGNX, DOOCSParameter.Levels.SCALE), new DOOCSParameter("alignY", DOOCSParameter.ParameterTypes.ALIGNY, DOOCSParameter.Levels.SCALE), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        if (parameter.equalsIgnoreCase("rotate")) {
            String[] allowedValues = new String[]{"0", "90", "180", "270"};
            return allowedValues;
        }
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSLabel ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSLabel>\n");
        return xmlStructure;
    }

    @Override
    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("text")) {
            this.setDoocsText(value);
        } else if (parameter.equalsIgnoreCase("textColor")) {
            this.setForeground(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("textFont")) {
            this.setFont(DOOCSParameter.convertToFont(value));
        } else if (parameter.equalsIgnoreCase("rotate")) {
            this.setDoocsRotate(value);
        } else if (parameter.equalsIgnoreCase("bgTransparent")) {
            this.setOpaque(!Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bgColor")) {
            this.setBackground(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("clipX")) {
            this.setDoocsClipX(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("clipY")) {
            this.setDoocsClipY(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("alignX")) {
            this.setHorizontalAlignment(DOOCSParameter.convertToAlignX(value));
        } else if (parameter.equalsIgnoreCase("alignY")) {
            this.setVerticalAlignment(DOOCSParameter.convertToAlignY(value));
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSLabel.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("text")) {
            return this.getDoocsText();
        }
        if (parameter.equalsIgnoreCase("textColor")) {
            return DOOCSParameter.getDoocsColor(this.getForeground());
        }
        if (parameter.equalsIgnoreCase("textFont")) {
            return DOOCSParameter.getDoocsFont(this.getFont());
        }
        if (parameter.equalsIgnoreCase("rotate")) {
            return this.getDoocsRotate();
        }
        if (parameter.equalsIgnoreCase("bgTransparent")) {
            return !this.isOpaque();
        }
        if (parameter.equalsIgnoreCase("bgColor")) {
            return DOOCSParameter.getDoocsColor(this.getBackground());
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("clipX")) {
            return this.getDoocsClipX();
        }
        if (parameter.equalsIgnoreCase("clipY")) {
            return this.getDoocsClipY();
        }
        if (parameter.equalsIgnoreCase("alignX")) {
            return DOOCSParameter.getAlignX(this.getHorizontalAlignment());
        }
        if (parameter.equalsIgnoreCase("alignY")) {
            return DOOCSParameter.getAlignY(this.getVerticalAlignment());
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return null;
        }
        System.out.println("DOOCSLabel.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    @Override
    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        String oldValue = this.getDoocsRotate();
        if (oldValue.equalsIgnoreCase("90")) {
            this.setDoocsRotate("270");
        }
        if (oldValue.equalsIgnoreCase("270")) {
            this.setDoocsRotate("90");
        }
        if (!oldValue.equalsIgnoreCase(this.getDoocsRotate())) {
            change.add(new SetProperty(this, "rotate", oldValue, this.getDoocsRotate()));
        }
        if ((oldValue = DOOCSParameter.getAlignX(this.getHorizontalAlignment())).equalsIgnoreCase("LEFT")) {
            this.setHorizontalAlignment(4);
        }
        if (oldValue.equalsIgnoreCase("RIGHT")) {
            this.setHorizontalAlignment(2);
        }
        if (!oldValue.equalsIgnoreCase(DOOCSParameter.getAlignX(this.getHorizontalAlignment()))) {
            change.add(new SetProperty(this, "alignX", oldValue, DOOCSParameter.getAlignX(this.getHorizontalAlignment())));
        }
        return change;
    }

    @Override
    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        if (this.getDoocsRotate().equalsIgnoreCase("0") || this.getDoocsRotate().equalsIgnoreCase("180")) {
            String oldValue = DOOCSParameter.getAlignY(this.getVerticalAlignment());
            if (oldValue.equalsIgnoreCase("TOP")) {
                this.setVerticalAlignment(3);
            }
            if (oldValue.equalsIgnoreCase("BOTTOM")) {
                this.setVerticalAlignment(1);
            }
            if (!oldValue.equalsIgnoreCase(DOOCSParameter.getAlignY(this.getVerticalAlignment()))) {
                change.add(new SetProperty(this, "alignY", oldValue, DOOCSParameter.getAlignY(this.getVerticalAlignment())));
            }
        } else {
            String oldValue = DOOCSParameter.getAlignX(this.getHorizontalAlignment());
            if (oldValue.equalsIgnoreCase("LEFT")) {
                this.setHorizontalAlignment(4);
            }
            if (oldValue.equalsIgnoreCase("RIGHT")) {
                this.setHorizontalAlignment(2);
            }
            if (!oldValue.equalsIgnoreCase(DOOCSParameter.getAlignX(this.getHorizontalAlignment()))) {
                change.add(new SetProperty(this, "alignX", oldValue, DOOCSParameter.getAlignX(this.getHorizontalAlignment())));
            }
        }
        return change;
    }

    @Override
    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        String oldValue = this.getDoocsRotate();
        if (oldValue.equalsIgnoreCase("0")) {
            this.setDoocsRotate("270");
        }
        if (oldValue.equalsIgnoreCase("90")) {
            this.setDoocsRotate("0");
        }
        if (oldValue.equalsIgnoreCase("180")) {
            this.setDoocsRotate("90");
        }
        if (oldValue.equalsIgnoreCase("270")) {
            this.setDoocsRotate("180");
        }
        change.add(new SetProperty(this, "rotate", oldValue, this.getDoocsRotate()));
        if (this.getDoocsRotate().equalsIgnoreCase("90") || this.getDoocsRotate().equalsIgnoreCase("180")) {
            oldValue = DOOCSParameter.getAlignX(this.getHorizontalAlignment());
            if (oldValue.equalsIgnoreCase("LEFT")) {
                this.setHorizontalAlignment(4);
            }
            if (oldValue.equalsIgnoreCase("RIGHT")) {
                this.setHorizontalAlignment(2);
            }
            if (!oldValue.equalsIgnoreCase(DOOCSParameter.getAlignX(this.getHorizontalAlignment()))) {
                change.add(new SetProperty(this, "alignX", oldValue, DOOCSParameter.getAlignX(this.getHorizontalAlignment())));
            }
            if ((oldValue = DOOCSParameter.getAlignY(this.getVerticalAlignment())).equalsIgnoreCase("TOP")) {
                this.setVerticalAlignment(3);
            }
            if (oldValue.equalsIgnoreCase("BOTTOM")) {
                this.setVerticalAlignment(1);
            }
            if (!oldValue.equalsIgnoreCase(DOOCSParameter.getAlignY(this.getVerticalAlignment()))) {
                change.add(new SetProperty(this, "alignY", oldValue, DOOCSParameter.getAlignY(this.getVerticalAlignment())));
            }
        }
        return change;
    }

    @Override
    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        String oldValue = this.getDoocsRotate();
        if (oldValue.equalsIgnoreCase("0")) {
            this.setDoocsRotate("90");
        }
        if (oldValue.equalsIgnoreCase("90")) {
            this.setDoocsRotate("180");
        }
        if (oldValue.equalsIgnoreCase("180")) {
            this.setDoocsRotate("270");
        }
        if (oldValue.equalsIgnoreCase("270")) {
            this.setDoocsRotate("0");
        }
        change.add(new SetProperty(this, "rotate", oldValue, this.getDoocsRotate()));
        if (this.getDoocsRotate().equalsIgnoreCase("180") || this.getDoocsRotate().equalsIgnoreCase("270")) {
            oldValue = DOOCSParameter.getAlignX(this.getHorizontalAlignment());
            if (oldValue.equalsIgnoreCase("LEFT")) {
                this.setHorizontalAlignment(4);
            }
            if (oldValue.equalsIgnoreCase("RIGHT")) {
                this.setHorizontalAlignment(2);
            }
            if (!oldValue.equalsIgnoreCase(DOOCSParameter.getAlignX(this.getHorizontalAlignment()))) {
                change.add(new SetProperty(this, "alignX", oldValue, DOOCSParameter.getAlignX(this.getHorizontalAlignment())));
            }
            if ((oldValue = DOOCSParameter.getAlignY(this.getVerticalAlignment())).equalsIgnoreCase("TOP")) {
                this.setVerticalAlignment(3);
            }
            if (oldValue.equalsIgnoreCase("BOTTOM")) {
                this.setVerticalAlignment(1);
            }
            if (!oldValue.equalsIgnoreCase(DOOCSParameter.getAlignY(this.getVerticalAlignment()))) {
                change.add(new SetProperty(this, "alignY", oldValue, DOOCSParameter.getAlignY(this.getVerticalAlignment())));
            }
        }
        return change;
    }
}

