/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSAlive;
import DOOCSComponents.DOOCSAudio;
import DOOCSComponents.DOOCSButton;
import DOOCSComponents.DOOCSButtonAdrList;
import DOOCSComponents.DOOCSCameraImage;
import DOOCSComponents.DOOCSCheckBox;
import DOOCSComponents.DOOCSColouredIndicator;
import DOOCSComponents.DOOCSComboBox;
import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSDial;
import DOOCSComponents.DOOCSGroup;
import DOOCSComponents.DOOCSIcon;
import DOOCSComponents.DOOCSIf;
import DOOCSComponents.DOOCSIfCase;
import DOOCSComponents.DOOCSIncludeComponent;
import DOOCSComponents.DOOCSLabel;
import DOOCSComponents.DOOCSLayeredPane;
import DOOCSComponents.DOOCSLine;
import DOOCSComponents.DOOCSLocationChooser;
import DOOCSComponents.DOOCSOval;
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.DOOCSProgressBar;
import DOOCSComponents.DOOCSPropertiesTable;
import DOOCSComponents.DOOCSRect;
import DOOCSComponents.DOOCSSlider;
import DOOCSComponents.DOOCSStatusRegister;
import DOOCSComponents.DOOCSSwitch;
import DOOCSComponents.DOOCSSwitchCase;
import DOOCSComponents.DOOCSTab;
import DOOCSComponents.DOOCSTabbedPane;
import DOOCSComponents.DOOCSTextArea;
import DOOCSComponents.DOOCSTextField;
import DOOCSComponents.DOOCSToggleButton;
import DOOCSComponents.DOOCSTriangle;
import DOOCSComponents.DOOCSValue;
import DOOCSPlot.DOOCSPlotSpectrum;
import editor.undo.SetProperty;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.event.MouseInputListener;
import layoutmanager.ScaleConstraints;
import layoutmanager.ScaleLayout;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqData;
import xmlparser.DOOCSParser;
import xmlparser.IntegerParser;

public class DOOCSDynamicList
extends JScrollPane
implements DOOCSComponent {
    private String doocsAddress = null;
    private String fullDoocsAddress = null;
    private int doocsSysMask = 0;
    private String doocsToolTipText = null;
    public DOOCSLayeredPane layeredPane = new DOOCSLayeredPane();
    private boolean doocsScale = true;
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private Rectangle m_initialBounds;
    private boolean init = true;
    private int numberOfAddedComponents = 0;
    private Color defaultBgColor;

    public DOOCSDynamicList() {
        this.setViewportView(this.layeredPane);
        this.setPreferredSize(new Dimension(250, 150));
        this.setSize(new Dimension(250, 150));
        this.setEnabled(this.doocsRunMode);
    }

    @Override
    public void add(Component comp, Object constraints) {
        if (comp instanceof JViewport || comp instanceof JScrollBar) {
            super.add(comp, constraints);
        } else {
            this.layeredPane.add(comp, constraints);
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.layeredPane.setSize(width, height);
    }

    @Override
    public void setDnDText(String str) {
    }

    @Override
    public String getDnDText() {
        return null;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void setDoocsAddress(String address) {
        this.doocsAddress = address;
        this.refillList();
    }

    public String getDoocsAddress() {
        return this.doocsAddress;
    }

    @Override
    public void setFullDoocsAddress(String address) {
        if (!address.equalsIgnoreCase(this.fullDoocsAddress)) {
            this.fullDoocsAddress = address;
            this.refillList();
        }
    }

    @Override
    public String getFullDoocsAddress() {
        return this.fullDoocsAddress;
    }

    private void refillList() {
        if (this.isRunMode()) {
            this.setRunMode(false);
            int n = this.layeredPane.getComponentCount();
            for (int i = n - this.numberOfAddedComponents; i < n; ++i) {
                if (this.layeredPane.getComponentCount() <= 0) continue;
                this.layeredPane.remove(this.layeredPane.getComponentCount() - 1);
            }
            this.paintImmediately(0, 0, this.getWidth(), this.getHeight());
            DOOCSParser.inherit((DOOCSComponent)((Object)this.getParent()));
            this.init = true;
            this.setRunMode(true);
            if (this.layeredPane.showToolTip) {
                this.layeredPane.showToolTipText(true);
            }
        }
    }

    public void setDoocsSysMask(int msk) {
        this.doocsSysMask = msk;
    }

    public int getDoocsSysMask() {
        return this.doocsSysMask;
    }

    @Override
    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    @Override
    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    @Override
    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    @Override
    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    @Override
    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    @Override
    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    @Override
    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        this.setEnabled(bRun);
        EqData ed = new EqData();
        if (bRun && this.init) {
            this.init = false;
            if (this.fullDoocsAddress != null) {
                int slash1 = this.fullDoocsAddress.indexOf("/");
                int slash2 = this.fullDoocsAddress.indexOf("/", slash1 + 1);
                int slash3 = this.fullDoocsAddress.indexOf("/", slash2 + 1);
                String location = this.fullDoocsAddress.substring(slash2 + 1, slash3);
                String path = this.fullDoocsAddress.substring(0, slash2 + 1);
                path = location.length() > 0 && location.contains("*") ? path + location + "/" : path + "*/";
                EqAdr ea = new EqAdr(path);
                int ymin = this.layeredPane.getHeight();
                int ymax = 0;
                for (int j = 0; j < this.layeredPane.getComponentCount(); ++j) {
                    Component comp = this.layeredPane.getComponent(j);
                    if (comp.getY() < ymin) {
                        ymin = comp.getY();
                    }
                    if (comp.getY() + comp.getHeight() <= ymax) continue;
                    ymax = comp.getY() + comp.getHeight();
                }
                EqCall ec = new EqCall();
                EqData data = new EqData();
                if (this.doocsSysMask == 0) {
                    data = ec.names(ea);
                } else {
                    ed.set(this.doocsSysMask);
                    ea.merge("///NAME");
                    ec.get(ea, ed, data);
                }
                if (data.error() == 0) {
                    this.layeredPane.setBackground(this.defaultBgColor);
                    int dataLength = 0;
                    for (int i = 0; i < data.length(); ++i) {
                        if (data.get_string_arg(i).trim().contains("_SVR")) continue;
                        ++dataLength;
                    }
                    this.layeredPane.setSize(this.getViewport().getWidth(), ymax * dataLength + ymin);
                    this.layeredPane.setPreferredSize(new Dimension(this.getViewport().getWidth(), ymax * dataLength + ymin));
                    this.numberOfAddedComponents = 0;
                    int compCount = this.layeredPane.getComponentCount();
                    for (int i = 1; i < dataLength; ++i) {
                        for (int j = 0; j < compCount; ++j) {
                            DOOCSComponent clone = this.doClone((DOOCSComponent)((Object)this.layeredPane.getComponent(j)));
                            int x = this.layeredPane.getComponent(j).getX();
                            int y = this.layeredPane.getComponent(j).getY() + i * ymax;
                            int width = this.layeredPane.getComponent(j).getWidth();
                            int height = this.layeredPane.getComponent(j).getHeight();
                            ScaleConstraints constr = new ScaleConstraints(x, y, width, height);
                            this.layeredPane.add((Component)((JComponent)((Object)clone)), constr);
                            ++this.numberOfAddedComponents;
                            if (clone instanceof DOOCSButton || clone instanceof DOOCSToggleButton) {
                                clone.setDOOCSParameter("rotateText", clone.getDOOCSParameter("rotate").toString());
                            }
                            if (!(clone instanceof DOOCSCheckBox)) continue;
                            clone.setDOOCSParameter("rotate", "0");
                        }
                    }
                    Component[] subcomp = this.layeredPane.getComponents();
                    for (int i = 0; i < dataLength; ++i) {
                        for (int j = 0; j < compCount; ++j) {
                            DOOCSComponent dcomp = (DOOCSComponent)((Object)subcomp[j + i * compCount]);
                            String sadr = null;
                            if (dcomp.getDOOCSParameter("adr") != null) {
                                sadr = dcomp.getDOOCSParameter("adr").toString();
                            }
                            EqAdr adr = new EqAdr(DOOCSParser.inheritDoocsAddress(this, sadr));
                            if (dataLength < data.length()) {
                                adr.set_location(data.get_string_arg(i + 1).trim());
                            } else {
                                adr.set_location(data.get_string_arg(i).trim());
                            }
                            dcomp.setFullDoocsAddress(adr.show_adr());
                            if (dcomp instanceof DOOCSButton) {
                                DOOCSButtonAdrList list = ((DOOCSButton)dcomp).doocsAdrList;
                                for (int k = 0; k < list.size(); ++k) {
                                    adr = new EqAdr(list.getDoocsAddress(k));
                                    if (dataLength < data.length()) {
                                        adr.set_location(data.get_string_arg(i + 1).trim());
                                    } else {
                                        adr.set_location(data.get_string_arg(i).trim());
                                    }
                                    list.setFullDoocsAddress(k, DOOCSParser.inheritDoocsAddress(this.layeredPane, adr.show_adr()));
                                }
                            }
                            if (dcomp instanceof DOOCSSwitch) {
                                for (int k = 0; k < dcomp.getComponentCount(); ++k) {
                                    ((DOOCSComponent)((Object)dcomp.getComponent(k))).setFullDoocsAddress(adr.show_adr());
                                    DOOCSParser.inherit((DOOCSComponent)((Object)dcomp.getComponent(k)));
                                }
                            }
                            if (dcomp instanceof DOOCSSwitch || dcomp.getComponentCount() <= 0) continue;
                            DOOCSParser.inherit(dcomp);
                        }
                    }
                } else {
                    this.layeredPane.setBackground(Color.RED);
                    System.out.println(DOOCSParameter.getFullName(this) + ": " + this.fullDoocsAddress + ": " + data.get_string_arg());
                }
            }
        }
        this.layeredPane.setRunMode(bRun);
    }

    public DOOCSComponent doClone(DOOCSComponent comp) {
        int j;
        JComponent newcomp = null;
        if (comp instanceof DOOCSLabel) {
            newcomp = new DOOCSLabel();
        }
        if (comp instanceof DOOCSValue) {
            newcomp = new DOOCSValue();
        }
        if (comp instanceof DOOCSDial) {
            newcomp = new DOOCSDial();
        }
        if (comp instanceof DOOCSCheckBox) {
            newcomp = new DOOCSCheckBox();
        }
        if (comp instanceof DOOCSProgressBar) {
            newcomp = new DOOCSProgressBar();
        }
        if (comp instanceof DOOCSSlider) {
            newcomp = new DOOCSSlider();
        }
        if (comp instanceof DOOCSButton) {
            newcomp = new DOOCSButton();
        }
        if (comp instanceof DOOCSToggleButton) {
            newcomp = new DOOCSToggleButton();
        }
        if (comp instanceof DOOCSPlotSpectrum) {
            newcomp = new DOOCSPlotSpectrum();
        }
        if (comp instanceof DOOCSIcon) {
            newcomp = new DOOCSIcon();
        }
        if (comp instanceof DOOCSCameraImage) {
            newcomp = new DOOCSCameraImage();
        }
        if (comp instanceof DOOCSTextField) {
            newcomp = new DOOCSTextField();
        }
        if (comp instanceof DOOCSTextArea) {
            newcomp = new DOOCSTextArea();
        }
        if (comp instanceof DOOCSPropertiesTable) {
            newcomp = new DOOCSPropertiesTable();
        }
        if (comp instanceof DOOCSDynamicList) {
            newcomp = new DOOCSDynamicList();
        }
        if (comp instanceof DOOCSAlive) {
            newcomp = new DOOCSAlive();
        }
        if (comp instanceof DOOCSAudio) {
            newcomp = new DOOCSAudio();
        }
        if (comp instanceof DOOCSLine) {
            newcomp = new DOOCSLine();
        }
        if (comp instanceof DOOCSRect) {
            newcomp = new DOOCSRect();
        }
        if (comp instanceof DOOCSTriangle) {
            newcomp = new DOOCSTriangle();
        }
        if (comp instanceof DOOCSOval) {
            newcomp = new DOOCSOval();
        }
        if (comp instanceof DOOCSStatusRegister) {
            newcomp = new DOOCSStatusRegister();
        }
        if (comp instanceof DOOCSColouredIndicator) {
            newcomp = new DOOCSColouredIndicator();
        }
        if (comp instanceof DOOCSComboBox) {
            newcomp = new DOOCSComboBox();
        }
        if (comp instanceof DOOCSLocationChooser) {
            newcomp = new DOOCSLocationChooser();
        }
        if (comp instanceof DOOCSSwitch) {
            newcomp = new DOOCSSwitch();
        }
        if (comp instanceof DOOCSSwitchCase) {
            newcomp = new DOOCSSwitchCase();
            newcomp.setLayout(new ScaleLayout(new Dimension(comp.getWidth(), comp.getHeight())));
        }
        if (comp instanceof DOOCSIfCase) {
            newcomp = new DOOCSIfCase();
            newcomp.setLayout(new ScaleLayout(new Dimension(comp.getWidth(), comp.getHeight())));
            newcomp.setName(comp.getName());
        }
        if (comp instanceof DOOCSIf) {
            newcomp = new DOOCSIf();
        }
        if (comp instanceof DOOCSTabbedPane) {
            newcomp = new DOOCSTabbedPane();
        }
        if (comp instanceof DOOCSTab) {
            newcomp = new DOOCSTab();
        }
        if (comp instanceof DOOCSIncludeComponent) {
            newcomp = new DOOCSIncludeComponent();
        }
        if (comp instanceof DOOCSGroup) {
            newcomp = new DOOCSGroup();
        }
        if (!(!(comp instanceof DOOCSLayeredPane) || comp instanceof DOOCSGroup || comp instanceof DOOCSAlive || comp instanceof DOOCSIf || comp instanceof DOOCSIfCase || comp instanceof DOOCSSwitch || comp instanceof DOOCSSwitchCase || comp instanceof DOOCSIncludeComponent || comp instanceof DOOCSTab)) {
            newcomp = new DOOCSLayeredPane();
        }
        DOOCSParameter[] paramList = comp.getDOOCSParameterList();
        for (j = 0; j < paramList.length; ++j) {
            String param = paramList[j].parameter;
            String value = null;
            if (comp.getDOOCSParameter(param) != null) {
                value = comp.getDOOCSParameter(param).toString();
            }
            if (value == null) continue;
            newcomp.setDOOCSParameter(param, value);
        }
        if (!(comp.getComponentCount() <= 0 || comp instanceof DOOCSDial || comp instanceof DOOCSSlider || comp instanceof JComboBox || comp instanceof DOOCSTextArea || comp instanceof DOOCSPropertiesTable)) {
            for (j = 0; j < comp.getComponentCount(); ++j) {
                DOOCSComponent childComp = this.doClone((DOOCSComponent)((Object)comp.getComponent(j)));
                int x = childComp.getX();
                int y = childComp.getY();
                int width = childComp.getWidth();
                int height = childComp.getHeight();
                ScaleConstraints constr = new ScaleConstraints(x, y, width, height);
                newcomp.add((Component)((JComponent)((Object)childComp)), constr);
            }
        }
        return newcomp;
    }

    @Override
    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    @Override
    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    @Override
    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("sysMask", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bgColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("transparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("grid", DOOCSParameter.ParameterTypes.GRID, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSDynamicList ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("\n");
        DOOCSLayeredPane dlp = (DOOCSLayeredPane)this.getViewport().getComponent(0);
        Component[] subcomp = dlp.getComponents();
        for (int i = 0; i < subcomp.length; ++i) {
            DOOCSComponent dcomp = (DOOCSComponent)((Object)subcomp[i]);
            xmlStructure.append(dcomp.getDOOCSXmlStructure());
        }
        xmlStructure.append("</DOOCSDynamicList>\n");
        return xmlStructure;
    }

    @Override
    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
        this.layeredPane.addDOOCSMouseListener(ml);
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.equalsIgnoreCase("sysMask")) {
            this.setDoocsSysMask(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("bgColor")) {
            this.defaultBgColor = DOOCSParameter.convertToColor(value);
            this.layeredPane.setBackground(this.defaultBgColor);
        } else if (parameter.equalsIgnoreCase("transparent")) {
            this.layeredPane.setOpaque(!Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("grid")) {
            this.layeredPane.setDoocsGrid(value);
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSDynamicList.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.equalsIgnoreCase("sysMask")) {
            return this.getDoocsSysMask();
        }
        if (parameter.equalsIgnoreCase("bgColor")) {
            return DOOCSParameter.getDoocsColor(this.layeredPane.getBackground());
        }
        if (parameter.equalsIgnoreCase("transparent")) {
            return !this.layeredPane.isOpaque();
        }
        if (parameter.equalsIgnoreCase("grid")) {
            return this.layeredPane.getDoocsGrid();
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        System.out.println("DOOCSDynamicList.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    public boolean isSelected(int x, int y) {
        if (x < 5 || x > this.getSize().width - 5) {
            return true;
        }
        return y < 5 || y > this.getSize().height - 5;
    }

    @Override
    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        return change;
    }
}

