/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import java.io.Serializable;
import java.util.Locale;
import javax.swing.AbstractSpinnerModel;

public class DOOCSDialNumberModel
extends AbstractSpinnerModel
implements Serializable {
    private String value;
    private int minimum;
    private int maximum;
    private double stepSize;
    private int precision;
    private boolean komma;

    public DOOCSDialNumberModel() {
        this("no value", 0, 0, 1.0, 1, false);
    }

    public DOOCSDialNumberModel(String value, int minimum, int maximum, double stepSize, int precision, boolean komma) {
        this.value = value;
        this.minimum = minimum;
        this.maximum = maximum;
        this.stepSize = stepSize;
        this.precision = precision;
    }

    @Override
    public void setValue(Object value) {
        if (!value.equals(this.value)) {
            this.value = value.toString();
            this.fireStateChanged();
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    public void setMinimum(int min) {
        this.minimum = min;
    }

    public int getMinimum() {
        return this.minimum;
    }

    public void setMaximum(int max) {
        this.maximum = max;
    }

    public int getMaximum() {
        return this.maximum;
    }

    public void setStepSize(double step) {
        this.stepSize = step;
    }

    public double getStepSize() {
        return this.stepSize;
    }

    public void setPrecision(int pre) {
        this.precision = pre;
    }

    public int getPrecision() {
        return this.precision;
    }

    public void setKomma(boolean kom) {
        this.komma = kom;
    }

    public boolean getKomma() {
        return this.komma;
    }

    @Override
    public Object getPreviousValue() {
        return this.incrValue(-1);
    }

    @Override
    public Object getNextValue() {
        return this.incrValue(1);
    }

    private Object incrValue(int dir) {
        String newValue = this.value;
        double v = 0.0;
        if (this.value instanceof String) {
            if (this.komma) {
                v = (double)Float.parseFloat(this.value) + this.stepSize * (double)dir;
                double tmp = Math.pow(10.0, this.precision);
                v = Math.rint(v * tmp) / tmp;
                String fmt = String.format("%%2.%df", this.precision);
                newValue = String.format(Locale.ENGLISH, fmt, v);
                if (!newValue.contains("E")) {
                    while (newValue.substring(newValue.indexOf(".") + 1).length() < this.precision) {
                        newValue = newValue + "0";
                    }
                }
            } else {
                v = Float.parseFloat(this.value) + (float)((int)this.stepSize * dir);
                newValue = Integer.toString((int)v);
            }
        }
        if (this.maximum != 0 && (double)this.maximum < v) {
            return null;
        }
        if (this.minimum != 0 && (double)this.minimum > v) {
            return null;
        }
        return newValue;
    }
}

