/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSDialNumberModel;
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.ShowException;
import DOOCSComponents.StringTransferHandler;
import editor.undo.SetProperty;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import java.util.Locale;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MouseInputListener;
import javax.swing.text.DefaultFormatter;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqCallback;
import ttf.doocs.clnt.EqData;
import ttf.doocs.clnt.IIII;
import xmlparser.IntegerParser;

public class DOOCSDial
extends JSpinner
implements EqCallback,
ChangeListener,
DOOCSComponent,
MouseListener {
    private JFormattedTextField tf;
    private DOOCSDialNumberModel model;
    private int caretPosition = -1;
    private int kommaPosition = -1;
    private MouseMotionAdapter listenerDrag;
    private String errorMessage = null;
    private boolean init = true;
    private boolean mouseEnteredInTextField = false;
    private String doocsAddress = null;
    private String fullDoocsAddress = null;
    private String doocsToolTipText = null;
    private int doocsIndex = 0;
    private float doocsUpdateTime = 10.0f;
    private double doocsMin = 0.0;
    private double doocsMax = 0.0;
    private int doocsPrecision = 2;
    private boolean doocsScale = true;
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private Rectangle m_initialBounds;
    private EqCall eq = new EqCall();
    private EqData ed = new EqData();
    private EqData data = new EqData();
    private EqAdr adrData = null;
    private boolean valueChanging = false;

    public DOOCSDial() {
        this.model = new DOOCSDialNumberModel();
        this.setModel(this.model);
        this.addChangeListener(this);
        this.tf = ((JSpinner.DefaultEditor)this.getEditor()).getTextField();
        this.tf.setHorizontalAlignment(4);
        this.tf.setSelectedTextColor(Color.YELLOW);
        this.tf.setEditable(true);
        ((DefaultFormatter)this.tf.getFormatter()).setOverwriteMode(false);
        this.setEnabled(this.doocsRunMode);
        this.removeOldMouseListeners(this.getComponent(0));
        this.removeOldMouseListeners(this.getComponent(1));
        this.addKeyStrokes();
        this.setPreferredSize(new Dimension(80, 20));
        this.setSize(new Dimension(80, 20));
        this.setTransferHandler(new StringTransferHandler());
        this.listenerDrag = new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                JComponent c = (JComponent)e.getSource();
                TransferHandler th = c.getTransferHandler();
                th.exportAsDrag(c, e, 1);
            }
        };
    }

    @Override
    public void setFont(Font f) {
        super.setFont(f);
        if (this.tf != null && f != null) {
            this.tf.setFont(f);
        }
    }

    private void removeOldMouseListeners(Component comp) {
        MouseListener[] mls = (MouseListener[])comp.getListeners(MouseListener.class);
        for (int i = 0; i < mls.length; ++i) {
            if (!mls[i].toString().contains("Button")) continue;
            comp.removeMouseListener(mls[i]);
        }
    }

    private void startMonitors() {
        if (this.adrData == null) {
            return;
        }
        if ((double)this.doocsUpdateTime == 0.0) {
            this.eq.get_monitor(this.adrData, this.ed, this.data, 1, this.doocsUpdateTime, (EqCallback)this, null);
        } else {
            this.eq.get_monitor(this.adrData, this.ed, this.data, 3, this.doocsUpdateTime, (EqCallback)this, null);
        }
    }

    @Override
    public void setDnDText(String str) {
    }

    @Override
    public String getDnDText() {
        return this.fullDoocsAddress;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (!this.mouseEnteredInTextField) {
            this.caretPosition = this.tf.getCaretPosition();
        }
        if (this.kommaPosition != -1 && this.kommaPosition == this.caretPosition - 1) {
            --this.caretPosition;
        }
        if (this.caretPosition == 0) {
            ++this.caretPosition;
        }
        if (this.tf.getText().startsWith("-") && this.caretPosition == 1) {
            ++this.caretPosition;
        }
        this.calculateStepSize();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DOOCSDial.this.tf.select(DOOCSDial.this.caretPosition - 1, DOOCSDial.this.caretPosition);
            }
        });
        this.mouseEnteredInTextField = false;
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.tf.requestFocusInWindow();
        this.mouseEnteredInTextField = true;
        this.mouseClicked(e);
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    public void mouseMoved(MouseEvent e) {
    }

    private void addKeyStrokes() {
        this.tf.getInputMap().put(KeyStroke.getKeyStroke("LEFT"), "leftActionName");
        this.tf.getActionMap().put("leftActionName", new AbstractAction("leftActionName"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (DOOCSDial.this.tf.getText().length() > 0 && DOOCSDial.this.caretPosition > 1) {
                    DOOCSDial.this.caretPosition--;
                    if (DOOCSDial.this.kommaPosition == DOOCSDial.this.caretPosition - 1) {
                        DOOCSDial.this.caretPosition--;
                    }
                    if (DOOCSDial.this.tf.getText().startsWith("-") && DOOCSDial.this.caretPosition == 1) {
                        DOOCSDial.this.caretPosition++;
                    }
                    DOOCSDial.this.calculateStepSize();
                }
            }
        });
        this.tf.getInputMap().put(KeyStroke.getKeyStroke("RIGHT"), "rightActionName");
        this.tf.getActionMap().put("rightActionName", new AbstractAction("rightActionName"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (DOOCSDial.this.tf.getText().length() > 0 && DOOCSDial.this.caretPosition < DOOCSDial.this.tf.getText().length()) {
                    DOOCSDial.this.caretPosition++;
                    if (DOOCSDial.this.kommaPosition == DOOCSDial.this.caretPosition - 1) {
                        DOOCSDial.this.caretPosition++;
                    }
                    DOOCSDial.this.calculateStepSize();
                }
            }
        });
        this.tf.getInputMap().put(KeyStroke.getKeyStroke("UP"), "upActionName");
        this.tf.getActionMap().put("upActionName", new AbstractAction("upActionName"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DOOCSDial.this.upActionPerformed();
            }
        });
        this.tf.getInputMap().put(KeyStroke.getKeyStroke("DOWN"), "downActionName");
        this.tf.getActionMap().put("downActionName", new AbstractAction("downActionName"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DOOCSDial.this.downActionPerformed();
            }
        });
    }

    private void upActionPerformed() {
        if (this.doocsRunMode && this.adrData != null) {
            this.valueChanging = true;
            if (this.model.getValue().toString().length() < this.model.getNextValue().toString().length()) {
                ++this.caretPosition;
            }
            this.model.setValue(this.model.getNextValue());
            if (this.kommaPosition == this.caretPosition - 1) {
                --this.caretPosition;
            }
            if (this.caretPosition > this.model.getValue().toString().length()) {
                this.caretPosition = this.model.getValue().toString().length();
            }
            this.calculateStepSize();
            this.valueChanging = false;
        }
    }

    private void downActionPerformed() {
        if (this.doocsRunMode && this.adrData != null) {
            this.valueChanging = true;
            if (this.model.getValue().toString().length() > this.model.getPreviousValue().toString().length() && this.caretPosition > 1) {
                --this.caretPosition;
            }
            this.model.setValue(this.model.getPreviousValue());
            if (this.kommaPosition == this.caretPosition - 1) {
                --this.caretPosition;
            }
            if (this.caretPosition > this.model.getValue().toString().length()) {
                this.caretPosition = this.model.getValue().toString().length();
            }
            if (this.tf.getText().startsWith("-") && this.caretPosition == 1) {
                ++this.caretPosition;
            }
            this.calculateStepSize();
            this.valueChanging = false;
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void setDoocsAddress(String address) {
        this.doocsAddress = address;
    }

    public String getDoocsAddress() {
        return this.doocsAddress;
    }

    @Override
    public void setFullDoocsAddress(String address) {
        if (address == null) {
            return;
        }
        if (this.fullDoocsAddress == null || !address.startsWith(this.fullDoocsAddress)) {
            this.fullDoocsAddress = address;
            if (this.adrData != null) {
                this.eq.clear_monitor(this.adrData);
            }
            this.adrData = new EqAdr(this.fullDoocsAddress);
            if (!EqAdr.isValidAdr((String)this.fullDoocsAddress)) {
                this.adrData = null;
            } else if (this.doocsRunMode) {
                this.startMonitors();
            }
        }
    }

    @Override
    public String getFullDoocsAddress() {
        return this.fullDoocsAddress;
    }

    public void setDoocsIndex(int index) {
        this.doocsIndex = index;
    }

    public int getDoocsIndex() {
        return this.doocsIndex;
    }

    @Override
    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    @Override
    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    public void setDoocsUpdateTime(float time) {
        this.doocsUpdateTime = time;
    }

    public float getDoocsUpdateTime() {
        return this.doocsUpdateTime;
    }

    public void setDoocsMin(double min) {
        this.doocsMin = min;
    }

    public double getDoocsMin() {
        return this.doocsMin;
    }

    public void setDoocsMax(double max) {
        this.doocsMax = max;
    }

    public double getDoocsMax() {
        return this.doocsMax;
    }

    public void setDoocsPrecision(int precision) {
        this.doocsPrecision = precision;
        this.model.setPrecision(precision);
    }

    public int getDoocsPrecision() {
        return this.doocsPrecision;
    }

    @Override
    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    @Override
    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    @Override
    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    @Override
    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    @Override
    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        this.setEnabled(bRun);
        if (bRun) {
            this.startMonitors();
            this.tf.addMouseListener(this);
            this.addMouseMotionListener(this.listenerDrag);
            ((JButton)this.getComponent(0)).addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    DOOCSDial.this.upActionPerformed();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
            ((JButton)this.getComponent(1)).addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    DOOCSDial.this.downActionPerformed();
                }

                @Override
                public void mousePressed(MouseEvent e) {
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                }

                @Override
                public void mouseEntered(MouseEvent e) {
                }

                @Override
                public void mouseExited(MouseEvent e) {
                }
            });
        } else {
            if (this.adrData != null) {
                this.eq.clear_monitor(this.adrData);
            }
            this.tf.removeMouseListener(this);
            this.removeMouseMotionListener(this.listenerDrag);
            this.removeOldMouseListeners(this.getComponent(0));
            this.removeOldMouseListeners(this.getComponent(1));
        }
    }

    @Override
    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    @Override
    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    @Override
    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("index", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("updateTime", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("min", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("max", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("precision", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textFont", DOOCSParameter.ParameterTypes.FONT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bgColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSDial ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSDial>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.equalsIgnoreCase("index")) {
            this.setDoocsIndex(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("updateTime")) {
            this.setDoocsUpdateTime(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("min")) {
            this.setDoocsMin(Double.parseDouble(value));
        } else if (parameter.equalsIgnoreCase("max")) {
            this.setDoocsMax(Double.parseDouble(value));
        } else if (parameter.equalsIgnoreCase("precision")) {
            this.setDoocsPrecision(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("textFont")) {
            this.setFont(DOOCSParameter.convertToFont(value));
            this.checkBoundsForNewFont();
        } else if (parameter.equalsIgnoreCase("textColor")) {
            this.tf.setForeground(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("bgColor")) {
            this.tf.setBackground(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSDial.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.equalsIgnoreCase("index")) {
            return this.getDoocsIndex();
        }
        if (parameter.equalsIgnoreCase("updateTime")) {
            return Float.valueOf(this.getDoocsUpdateTime());
        }
        if (parameter.equalsIgnoreCase("min")) {
            return this.getDoocsMin();
        }
        if (parameter.equalsIgnoreCase("max")) {
            return this.getDoocsMax();
        }
        if (parameter.equalsIgnoreCase("precision")) {
            return this.getDoocsPrecision();
        }
        if (parameter.equalsIgnoreCase("textFont")) {
            return DOOCSParameter.getDoocsFont(this.getFont());
        }
        if (parameter.equalsIgnoreCase("textColor")) {
            return DOOCSParameter.getDoocsColor(this.tf.getForeground());
        }
        if (parameter.equalsIgnoreCase("bgColor")) {
            return DOOCSParameter.getDoocsColor(this.tf.getBackground());
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        System.out.println("DOOCSDial.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    @Override
    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.getComponent(0).addMouseListener(ml);
        this.getComponent(0).addMouseMotionListener(ml);
        this.getComponent(1).addMouseListener(ml);
        this.getComponent(1).addMouseMotionListener(ml);
        this.tf.addMouseListener(ml);
        this.tf.addMouseMotionListener(ml);
    }

    private void calculateStepSize() {
        if (this.kommaPosition == -1) {
            this.model.setKomma(false);
            this.model.setStepSize(Math.pow(10.0, this.tf.getText().length() - this.caretPosition));
        } else {
            this.model.setKomma(true);
            if (this.kommaPosition < this.caretPosition) {
                this.model.setStepSize(Math.pow(10.0, this.kommaPosition - this.caretPosition + 1));
            }
            if (this.kommaPosition >= this.caretPosition) {
                this.model.setStepSize(Math.pow(10.0, this.kommaPosition - this.caretPosition));
            }
        }
        this.tf.select(this.caretPosition - 1, this.caretPosition);
    }

    public void dataCallback(EqData dataOut, Object userData) {
        if (dataOut.error() == 0 && !this.valueChanging) {
            String value;
            this.errorMessage = null;
            if (dataOut.type() == 2 || dataOut.type() == 6 || dataOut.type() == 100 || dataOut.type() == 110) {
                double val = dataOut.get_float(this.doocsIndex);
                String fmt = String.format("%%2.%df", this.doocsPrecision);
                value = String.format(Locale.ENGLISH, fmt, val);
                if (!value.contains("E")) {
                    while (value.substring(value.indexOf(".") + 1).length() < this.doocsPrecision) {
                        value = value + "0";
                    }
                }
                if (this.doocsPrecision == 0) {
                    value = Integer.toString(Math.round((float)val));
                }
            } else {
                value = dataOut.type() == 1 || dataOut.type() == 14 || dataOut.type() == 105 || dataOut.type() == 8 || dataOut.type() == 115 ? Integer.toString(dataOut.get_int(this.doocsIndex)) : dataOut.get_string(this.doocsIndex);
            }
            if (!value.equals(this.model.getValue())) {
                this.init = true;
                this.model.setValue(value);
                this.kommaPosition = value.indexOf(46);
                if (this.caretPosition != -1 && this.caretPosition > value.length()) {
                    this.caretPosition = value.length();
                }
                if (this.caretPosition == -1) {
                    this.caretPosition = value.length();
                    this.calculateStepSize();
                }
            }
        } else if (this.errorMessage == null) {
            this.errorMessage = dataOut.get_string_arg();
            System.out.println(DOOCSParameter.getFullName(this) + ": " + this.fullDoocsAddress + ": " + this.errorMessage);
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.init) {
            this.init = false;
            return;
        }
        if (this.doocsRunMode && this.adrData != null) {
            this.data.init();
            this.eq.get(this.adrData, this.ed, this.data);
            if (this.data.error() == 0) {
                if (this.data.type() == 2 || this.data.type() == 100) {
                    float doocsValue = Float.parseFloat(this.getValue().toString());
                    float value = this.data.get_float(this.doocsIndex);
                    if (value != doocsValue) {
                        if (this.doocsMax > this.doocsMin && ((double)doocsValue < this.doocsMin || (double)doocsValue > this.doocsMax)) {
                            new ShowException(null, this.getName(), "Float value outside allowed range");
                            return;
                        }
                        this.ed.set(doocsValue);
                        this.eq.set(this.adrData, this.ed, this.data);
                        if (this.data.error() != 0) {
                            new ShowException(null, this.getName(), this.data.get_string_arg());
                        }
                    }
                    this.kommaPosition = this.getValue().toString().indexOf(46);
                } else if (this.data.type() == 6 || this.data.type() == 110) {
                    double doocsValueD = Double.parseDouble(this.getValue().toString());
                    double valueD = this.data.get_double(this.doocsIndex);
                    if (valueD != doocsValueD) {
                        if (this.doocsMax > this.doocsMin && (doocsValueD < this.doocsMin || doocsValueD > this.doocsMax)) {
                            new ShowException(null, this.getName(), "Doiuble value outside allowed range");
                            return;
                        }
                        this.ed.set(doocsValueD);
                        this.eq.set(this.adrData, this.ed, this.data);
                        if (this.data.error() != 0) {
                            new ShowException(null, this.getName(), this.data.get_string_arg());
                        }
                    }
                    this.kommaPosition = this.getValue().toString().indexOf(46);
                } else if (this.data.type() == 1 || this.data.type() == 105 || this.data.type() == 8 || this.data.type() == 115) {
                    int doocsValue = IntegerParser.parseInt(this.getValue().toString());
                    int value = this.data.get_int(this.doocsIndex);
                    if (value != doocsValue) {
                        if (this.doocsMax > this.doocsMin && ((double)doocsValue < this.doocsMin || (double)doocsValue > this.doocsMax)) {
                            new ShowException(null, this.getName(), "Int value outside allowed range");
                            return;
                        }
                        if (this.data.type() == 1 || this.data.type() == 105) {
                            this.ed.set(doocsValue);
                        } else {
                            this.ed.set((short)doocsValue);
                        }
                        this.eq.set(this.adrData, this.ed, this.data);
                        if (this.data.error() != 0) {
                            new ShowException(null, this.getName(), this.data.get_string_arg());
                        }
                    }
                    this.kommaPosition = -1;
                } else if (this.data.type() == 14) {
                    int doocsValue;
                    IIII iiiivalue = this.data.get_iiii();
                    int value = 0;
                    if (this.doocsIndex == 0) {
                        value = iiiivalue.i1_data;
                    }
                    if (this.doocsIndex == 1) {
                        value = iiiivalue.i2_data;
                    }
                    if (this.doocsIndex == 2) {
                        value = iiiivalue.i3_data;
                    }
                    if (this.doocsIndex == 3) {
                        value = iiiivalue.i4_data;
                    }
                    if (value != (doocsValue = IntegerParser.parseInt(this.getValue().toString()))) {
                        if (this.doocsMax > this.doocsMin && ((double)doocsValue < this.doocsMin || (double)doocsValue > this.doocsMax)) {
                            new ShowException(null, this.getName(), "IIII value outside allowed range");
                            return;
                        }
                        if (this.doocsIndex == 0) {
                            iiiivalue.i1_data = doocsValue;
                        }
                        if (this.doocsIndex == 1) {
                            iiiivalue.i2_data = doocsValue;
                        }
                        if (this.doocsIndex == 2) {
                            iiiivalue.i3_data = doocsValue;
                        }
                        if (this.doocsIndex == 3) {
                            iiiivalue.i4_data = doocsValue;
                        }
                        this.ed.set(iiiivalue);
                        this.eq.set(this.adrData, this.ed, this.data);
                        if (this.data.error() != 0) {
                            new ShowException(null, this.getName(), this.data.get_string_arg());
                        }
                    }
                } else if (this.data.type() == 103) {
                    String doocsValue = this.getValue().toString();
                    String value = this.data.get_string(this.doocsIndex);
                    if (!value.equalsIgnoreCase(doocsValue)) {
                        this.ed.set(doocsValue);
                        this.eq.set(this.adrData, this.ed, this.data);
                        if (this.data.error() != 0) {
                            new ShowException(null, this.getName(), this.data.get_string_arg());
                        }
                    }
                } else if (this.data.type() == 5) {
                    String doocsValue = this.getValue().toString();
                    String value = this.data.get_string(this.doocsIndex);
                    if (!value.equalsIgnoreCase(doocsValue)) {
                        this.ed.set(doocsValue);
                        this.eq.set(this.adrData, this.ed, this.data);
                        if (this.data.error() != 0) {
                            new ShowException(null, this.getName(), this.data.get_string_arg());
                        }
                    }
                } else {
                    new ShowException(null, "DOOCSButton", "to Elke: insert new Data type " + this.data.type() + " in DOOCSDial.java");
                }
            } else {
                new ShowException(null, this.getName(), this.data.get_string_arg());
            }
        }
    }

    private void checkBoundsForNewFont() {
        Font f = this.getFont();
        int fontHeight = (int)f.getStringBounds("ABCT", this.getFontMetrics(f).getFontRenderContext()).getHeight();
        if (this.getBounds().getHeight() < (double)fontHeight) {
            Rectangle rbounds = this.getBounds();
            rbounds.setSize(rbounds.width, fontHeight);
            this.setBounds(rbounds);
        }
    }

    @Override
    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        return change;
    }
}

