/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.ShowException;
import editor.undo.SetProperty;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.metal.MetalComboBoxButton;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqCallback;
import ttf.doocs.clnt.EqData;
import xmlparser.IntegerParser;

public class DOOCSComboBox
extends JComboBox
implements DOOCSComponent,
ActionListener,
EqCallback {
    private EqCall eq = new EqCall();
    private EqData ed = new EqData();
    private EqData data = new EqData();
    private EqAdr adrData = null;
    private String errorMessage = null;
    private boolean init = true;
    private String value;
    private String doocsAddress = null;
    private float doocsUpdateTime = 0.0f;
    private String doocsText = null;
    private String doocsToolTipText = null;
    private boolean doocsScale = true;
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private Rectangle m_initialBounds;
    private String fullDoocsAddress = null;
    private MouseListener buttonMouseListener;
    private boolean valueChanging = false;

    public DOOCSComboBox() {
        this.setPreferredSize(new Dimension(100, 20));
        this.setEnabled(this.doocsRunMode);
        this.addActionListener(this);
        this.buttonMouseListener = ((MetalComboBoxButton)this.getComponent(0)).getMouseListeners()[0];
        ((MetalComboBoxButton)this.getComponent(0)).removeMouseListener(this.buttonMouseListener);
    }

    private void startMonitors() {
        if (this.adrData == null) {
            return;
        }
        if ((double)this.doocsUpdateTime == 0.0) {
            this.eq.get_monitor(this.adrData, this.ed, this.data, 1, this.doocsUpdateTime, (EqCallback)this, null);
        } else {
            this.eq.get_monitor(this.adrData, this.ed, this.data, 3, this.doocsUpdateTime, (EqCallback)this, null);
        }
    }

    @Override
    public void setDnDText(String str) {
    }

    @Override
    public String getDnDText() {
        return null;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void setDoocsText(String text) {
        this.doocsText = text;
        if (text != null) {
            this.removeAllItems();
            StringTokenizer st = new StringTokenizer(text, ";");
            while (st.hasMoreTokens()) {
                this.init = true;
                String token = st.nextToken();
                if (token.contains("|")) {
                    this.addItem(token.substring(0, token.indexOf("|")));
                    continue;
                }
                this.addItem(token);
            }
        }
    }

    public String getDoocsText() {
        return this.doocsText;
    }

    public void setDoocsAddress(String address) {
        this.doocsAddress = address;
    }

    public String getDoocsAddress() {
        return this.doocsAddress;
    }

    @Override
    public void setFullDoocsAddress(String address) {
        if (address == null) {
            return;
        }
        if (this.fullDoocsAddress == null || !address.startsWith(this.fullDoocsAddress)) {
            this.fullDoocsAddress = address;
            if (this.adrData != null) {
                this.eq.clear_monitor(this.adrData);
            }
            this.adrData = new EqAdr(this.fullDoocsAddress);
            if (!EqAdr.isValidAdr((String)this.fullDoocsAddress)) {
                this.adrData = null;
            } else if (this.doocsRunMode) {
                this.startMonitors();
            }
        }
    }

    @Override
    public String getFullDoocsAddress() {
        return this.fullDoocsAddress;
    }

    public void setDoocsUpdateTime(float time) {
        this.doocsUpdateTime = time;
    }

    public float getDoocsUpdateTime() {
        return this.doocsUpdateTime;
    }

    @Override
    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    @Override
    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    @Override
    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    @Override
    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    @Override
    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    @Override
    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    @Override
    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        this.setEnabled(bRun);
        if (bRun) {
            ((MetalComboBoxButton)this.getComponent(0)).addMouseListener(this.buttonMouseListener);
            this.startMonitors();
        } else {
            ((MetalComboBoxButton)this.getComponent(0)).removeMouseListener(this.buttonMouseListener);
            if (this.adrData != null) {
                this.eq.clear_monitor(this.adrData);
            }
        }
    }

    @Override
    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    @Override
    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    @Override
    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("updateTime", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("text", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL, "<html>item1;item2;item3<br>or<br>text1|item1;text2|item2;text3|item3</html>"), new DOOCSParameter("textFont", DOOCSParameter.ParameterTypes.FONT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSComboBox ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSComboBox>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.equalsIgnoreCase("updateTime")) {
            this.setDoocsUpdateTime(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("text")) {
            this.setDoocsText(value);
        } else if (parameter.equalsIgnoreCase("textFont")) {
            this.setFont(DOOCSParameter.convertToFont(value));
            this.checkBoundsForNewFont();
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSComboBox.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.equalsIgnoreCase("updateTime")) {
            return Float.valueOf(this.getDoocsUpdateTime());
        }
        if (parameter.equalsIgnoreCase("text")) {
            return this.getDoocsText();
        }
        if (parameter.equalsIgnoreCase("textFont")) {
            return DOOCSParameter.getDoocsFont(this.getFont());
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return null;
        }
        System.out.println("DOOCSComboBox.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    @Override
    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
        this.getComponent(0).addMouseListener(ml);
        this.getComponent(0).addMouseMotionListener(ml);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.init) {
            this.init = false;
            return;
        }
        if (this.doocsRunMode) {
            this.valueChanging = true;
            if (this.fullDoocsAddress != null && this.fullDoocsAddress.length() > 5) {
                EqAdr ea = new EqAdr(this.fullDoocsAddress);
                this.data.init();
                this.eq.get(ea, this.ed, this.data);
                if (this.data.error() == 0) {
                    String selectedValue = this.getSelectedItem().toString();
                    String doocsValue = null;
                    StringTokenizer st = new StringTokenizer(this.getDoocsText(), ";");
                    while (st.hasMoreTokens()) {
                        String token;
                        String tokenText = token = st.nextToken();
                        String tokenItem = token;
                        if (token.contains("|")) {
                            tokenText = token.substring(0, token.indexOf("|"));
                            tokenItem = token.substring(token.indexOf("|") + 1);
                        }
                        if (!selectedValue.equalsIgnoreCase(tokenText)) continue;
                        doocsValue = tokenItem;
                    }
                    try {
                        switch (this.data.type()) {
                            case 1: 
                            case 105: {
                                this.ed.set(IntegerParser.parseInt(doocsValue));
                                break;
                            }
                            case 2: 
                            case 100: {
                                this.ed.set(Float.parseFloat(doocsValue));
                                break;
                            }
                            case 3: 
                            case 5: 
                            case 7: 
                            case 103: {
                                this.ed.set_type(this.data.type());
                                this.ed.set_from_string(doocsValue);
                                break;
                            }
                            default: {
                                new ShowException(null, "DOOCSComboBox", "to Elke: insert new Data type " + this.data.type() + " in DOOCSComboBox.java");
                            }
                        }
                        this.eq.set(ea, this.ed, this.data);
                        if (this.data.error() != 0) {
                            new ShowException(null, this.getName(), this.data.get_string_arg());
                        }
                    }
                    catch (NumberFormatException nfe) {
                        new ShowException(null, DOOCSParameter.getFullName(this) + ": " + this.fullDoocsAddress, nfe);
                    }
                } else {
                    new ShowException(null, this.getName(), this.data.get_string_arg());
                }
            }
            this.valueChanging = false;
        }
    }

    public void dataCallback(EqData dataOut, Object userData) {
        if (dataOut.error() == 0 && !this.valueChanging) {
            this.errorMessage = null;
            this.value = dataOut.array_length() > 1 ? dataOut.get_string(0) : dataOut.get_string();
            if (!this.value.equalsIgnoreCase(this.getSelectedItem().toString())) {
                this.init = true;
                boolean containsValue = false;
                for (int i = 0; i < this.getItemCount(); ++i) {
                    if (!this.value.equalsIgnoreCase(this.getItemAt(i).toString())) continue;
                    this.setSelectedIndex(i);
                    containsValue = true;
                }
                if (!containsValue) {
                    this.addItem(this.value);
                }
            }
        } else {
            this.value = dataOut.get_string_arg();
            if (this.errorMessage == null) {
                this.errorMessage = this.value;
                System.out.println(DOOCSParameter.getFullName(this) + ": " + this.fullDoocsAddress + ": " + this.errorMessage);
            }
        }
    }

    private void checkBoundsForNewFont() {
        Font f = this.getFont();
        int fontHeight = (int)f.getStringBounds("ABCT", this.getFontMetrics(f).getFontRenderContext()).getHeight();
        if (this.getBounds().getHeight() < (double)fontHeight) {
            Rectangle rbounds = this.getBounds();
            rbounds.setSize(rbounds.width, fontHeight);
            this.setBounds(rbounds);
        }
    }

    @Override
    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        return change;
    }
}

