/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSCheckBoxUI;
import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.ShowException;
import editor.EditorPanel;
import editor.undo.SetProperty;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ButtonUI;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqCallback;
import ttf.doocs.clnt.EqData;
import xmlparser.IntegerParser;

public class DOOCSCheckBox
extends JCheckBox
implements DOOCSComponent,
EqCallback,
ActionListener {
    private EqCall eq = new EqCall();
    private EqData ed = new EqData();
    private EqData data = new EqData();
    private EqAdr adrData = null;
    private String errorMessage = null;
    private String value;
    private String doocsAddress = null;
    private String fullDoocsAddress = null;
    private String doocsToolTipText = null;
    private float doocsUpdateTime = 1.0f;
    private String doocsHorizontalTextPosition = "Right";
    private String doocsRotate = "0";
    private boolean doocsScale = true;
    private int doocsClipX = 2;
    private int doocsClipY = 2;
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private Rectangle m_initialBounds;
    private ButtonUI defaultUI;
    private Cursor myCursor;
    private MouseAdapter listener;

    public DOOCSCheckBox() {
        this.setHorizontalAlignment(2);
        this.setVerticalAlignment(0);
        this.setText("Checkbox");
        this.setEnabled(this.doocsRunMode);
        this.setOpaque(false);
        this.setSelected(true);
        this.addActionListener(this);
        this.defaultUI = this.getUI();
        this.myCursor = this.getToolkit().createCustomCursor(new ImageIcon(this.getClass().getResource("icons/lightning.gif")).getImage(), new Point(0, 0), "Cursor");
        this.listener = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                DOOCSCheckBox.this.setCursor(DOOCSCheckBox.this.myCursor);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DOOCSCheckBox.this.setCursor(new Cursor(0));
            }
        };
    }

    private void startMonitors() {
        if (this.adrData == null) {
            return;
        }
        if ((double)this.doocsUpdateTime == 0.0) {
            this.eq.get_monitor(this.adrData, this.ed, this.data, 1, this.doocsUpdateTime, (EqCallback)this, null);
        } else {
            this.eq.get_monitor(this.adrData, this.ed, this.data, 3, this.doocsUpdateTime, (EqCallback)this, null);
        }
    }

    @Override
    public void setDnDText(String str) {
    }

    @Override
    public String getDnDText() {
        return null;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void setDoocsAddress(String address) {
        this.doocsAddress = address;
    }

    public String getDoocsAddress() {
        return this.doocsAddress;
    }

    @Override
    public void setFullDoocsAddress(String address) {
        if (address == null) {
            return;
        }
        if (this.fullDoocsAddress == null || !address.startsWith(this.fullDoocsAddress)) {
            this.fullDoocsAddress = address;
            if (this.adrData != null) {
                this.eq.clear_monitor(this.adrData);
            }
            this.adrData = new EqAdr(this.fullDoocsAddress);
            if (!EqAdr.isValidAdr((String)this.fullDoocsAddress)) {
                this.adrData = null;
            } else if (this.doocsRunMode) {
                this.startMonitors();
            }
        }
    }

    @Override
    public String getFullDoocsAddress() {
        return this.fullDoocsAddress;
    }

    @Override
    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    @Override
    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    public void setDoocsUpdateTime(float time) {
        this.doocsUpdateTime = time;
    }

    public float getDoocsUpdateTime() {
        return this.doocsUpdateTime;
    }

    public void setDoocsHorizontalTextPosition(String position) {
        this.doocsHorizontalTextPosition = position;
        if (position.equalsIgnoreCase("Left")) {
            this.setHorizontalTextPosition(2);
        } else {
            this.setHorizontalTextPosition(4);
        }
    }

    public String getDoocsHorizontalTextPosition() {
        return this.doocsHorizontalTextPosition;
    }

    public void setDoocsRotate(String rotate) {
        if ((rotate.equalsIgnoreCase("0") || rotate.equalsIgnoreCase("180")) && this.getHeight() > this.getWidth() || !rotate.equalsIgnoreCase("0") && !rotate.equalsIgnoreCase("180") && this.getHeight() < this.getWidth()) {
            this.setPreferredSize(new Dimension(this.getHeight(), this.getWidth()));
            this.setSize(this.getHeight(), this.getWidth());
            Container parent = this.getParent();
            if (!(parent == null || parent instanceof EditorPanel && parent.getWidth() == 100 && parent.getHeight() == 100)) {
                if (this.getX() < 0) {
                    this.setLocation(0, this.getY());
                }
                if (this.getY() < 0) {
                    this.setLocation(this.getX(), 0);
                }
                if (this.getX() + this.getWidth() > parent.getWidth()) {
                    this.setLocation(parent.getWidth() - this.getWidth(), this.getY());
                }
                if (this.getY() + this.getHeight() > parent.getHeight()) {
                    this.setLocation(this.getX(), parent.getHeight() - this.getHeight());
                }
            }
        }
        this.doocsRotate = rotate;
        if (rotate.equalsIgnoreCase("270")) {
            this.setUI(new DOOCSCheckBoxUI(270));
        } else if (rotate.equalsIgnoreCase("90")) {
            this.setUI(new DOOCSCheckBoxUI(90));
        } else {
            this.setUI(this.defaultUI);
        }
    }

    public String getDoocsRotate() {
        return this.doocsRotate;
    }

    @Override
    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    @Override
    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    public void setDoocsClipX(int clip) {
        this.doocsClipX = clip;
    }

    public int getDoocsClipX() {
        return this.doocsClipX;
    }

    public void setDoocsClipY(int clip) {
        this.doocsClipY = clip;
    }

    public int getDoocsClipY() {
        return this.doocsClipY;
    }

    @Override
    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    @Override
    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    @Override
    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        this.setEnabled(bRun);
        if (bRun) {
            this.addMouseListener(this.listener);
            this.startMonitors();
        } else {
            this.removeMouseListener(this.listener);
            if (this.adrData != null) {
                this.eq.clear_monitor(this.adrData);
            }
        }
    }

    @Override
    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    @Override
    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    @Override
    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("updateTime", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("text", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textFont", DOOCSParameter.ParameterTypes.FONT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("iconTextGap", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bgColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bgTransparent", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("clipX", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.SCALE), new DOOCSParameter("clipY", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.SCALE), new DOOCSParameter("horizontalTextPosition", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("rotate", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("alignX", DOOCSParameter.ParameterTypes.ALIGNX, DOOCSParameter.Levels.SCALE), new DOOCSParameter("alignY", DOOCSParameter.ParameterTypes.ALIGNY, DOOCSParameter.Levels.SCALE), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        if (parameter.equalsIgnoreCase("horizontalTextPosition")) {
            String[] allowedValues = new String[]{"Right", "Left"};
            return allowedValues;
        }
        if (parameter.equalsIgnoreCase("rotate")) {
            String[] allowedValues = new String[]{"0", "90", "180", "270"};
            return allowedValues;
        }
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSCheckBox ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSCheckBox>\n");
        return xmlStructure;
    }

    @Override
    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.equalsIgnoreCase("updateTime")) {
            this.setDoocsUpdateTime(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("text")) {
            this.setText(value);
        } else if (parameter.equalsIgnoreCase("textColor")) {
            this.setForeground(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("textFont")) {
            this.setFont(DOOCSParameter.convertToFont(value));
        } else if (parameter.equalsIgnoreCase("horizontalTextPosition")) {
            this.setDoocsHorizontalTextPosition(value);
        } else if (parameter.equalsIgnoreCase("rotate")) {
            this.setDoocsRotate(value);
        } else if (parameter.equalsIgnoreCase("iconTextGap")) {
            this.setIconTextGap(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("bgTransparent")) {
            this.setOpaque(!Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bgColor")) {
            this.setBackground(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("clipX")) {
            this.setDoocsClipX(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("clipY")) {
            this.setDoocsClipY(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("alignX")) {
            this.setHorizontalAlignment(DOOCSParameter.convertToAlignX(value));
        } else if (parameter.equalsIgnoreCase("alignY")) {
            this.setVerticalAlignment(DOOCSParameter.convertToAlignY(value));
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSCheckBox.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.equalsIgnoreCase("updateTime")) {
            return Float.valueOf(this.getDoocsUpdateTime());
        }
        if (parameter.equalsIgnoreCase("text")) {
            return this.getText();
        }
        if (parameter.equalsIgnoreCase("textColor")) {
            return DOOCSParameter.getDoocsColor(this.getForeground());
        }
        if (parameter.equalsIgnoreCase("textFont")) {
            return DOOCSParameter.getDoocsFont(this.getFont());
        }
        if (parameter.equalsIgnoreCase("horizontalTextPosition")) {
            return this.getDoocsHorizontalTextPosition();
        }
        if (parameter.equalsIgnoreCase("rotate")) {
            return this.getDoocsRotate();
        }
        if (parameter.equalsIgnoreCase("iconTextGap")) {
            return this.getIconTextGap();
        }
        if (parameter.equalsIgnoreCase("bgTransparent")) {
            return !this.isOpaque();
        }
        if (parameter.equalsIgnoreCase("bgColor")) {
            return DOOCSParameter.getDoocsColor(this.getBackground());
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("clipX")) {
            return this.getDoocsClipX();
        }
        if (parameter.equalsIgnoreCase("clipY")) {
            return this.getDoocsClipY();
        }
        if (parameter.equalsIgnoreCase("alignX")) {
            return DOOCSParameter.getAlignX(this.getHorizontalAlignment());
        }
        if (parameter.equalsIgnoreCase("alignY")) {
            return DOOCSParameter.getAlignY(this.getVerticalAlignment());
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        System.out.println("DOOCSCheckBox.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        int doocsValue = 0;
        if (this.isSelected()) {
            doocsValue = 1;
        }
        this.ed.set(doocsValue);
        this.eq.set(this.adrData, this.ed, this.data);
        if (this.data.error() != 0) {
            new ShowException(null, this.getName(), this.data.get_string_arg());
        }
    }

    public void dataCallback(EqData dataOut, Object userData) {
        if (dataOut.error() == 0) {
            this.errorMessage = null;
            this.value = dataOut.array_length() > 1 ? dataOut.get_string(0) : dataOut.get_string();
            if (this.value.equalsIgnoreCase("1") && !this.isSelected() || this.value.equalsIgnoreCase("0") && this.isSelected()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!DOOCSCheckBox.this.isSelected()) {
                            DOOCSCheckBox.this.setSelected(true);
                        } else {
                            DOOCSCheckBox.this.setSelected(false);
                        }
                    }
                });
            }
        } else if (this.errorMessage == null) {
            this.errorMessage = dataOut.get_string_arg();
            System.out.println(DOOCSParameter.getFullName(this) + ": " + this.fullDoocsAddress + ": " + this.errorMessage);
        }
    }

    private void checkBounds() {
        Font f = this.getFont();
        int fontHeight = (int)f.getStringBounds(this.getText(), this.getFontMetrics(f).getFontRenderContext()).getHeight() + this.getInsets().bottom + this.getInsets().top;
        int fontWidth = (int)f.getStringBounds(this.getText(), this.getFontMetrics(f).getFontRenderContext()).getWidth() + this.getInsets().right + this.getInsets().left + this.getIconTextGap() + 16;
        Rectangle rbounds = this.getBounds();
        if (this.doocsRotate.equalsIgnoreCase("0") || this.doocsRotate.equalsIgnoreCase("180")) {
            if (this.getBounds().getHeight() < (double)fontHeight) {
                rbounds.setSize(rbounds.width, fontHeight);
                this.setBounds(rbounds);
            }
            if (this.getBounds().getWidth() < (double)fontWidth) {
                rbounds.setSize(fontWidth, rbounds.height);
                this.setBounds(rbounds);
            }
        } else {
            if (this.getBounds().getWidth() < (double)fontHeight) {
                rbounds.setSize(fontHeight, rbounds.height);
                this.setBounds(rbounds);
            }
            if (this.getBounds().getHeight() < (double)fontWidth) {
                rbounds.setSize(rbounds.width, fontWidth);
                this.setBounds(rbounds);
            }
        }
    }

    @Override
    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        String oldValue = this.getDoocsHorizontalTextPosition();
        if (oldValue.equalsIgnoreCase("Right")) {
            this.setDoocsHorizontalTextPosition("Left");
        }
        if (oldValue.equalsIgnoreCase("Left")) {
            this.setDoocsHorizontalTextPosition("Right");
        }
        if (!oldValue.equalsIgnoreCase(this.getDoocsHorizontalTextPosition())) {
            change.add(new SetProperty(this, "horizontalTextPosition", oldValue, this.getDoocsHorizontalTextPosition()));
        }
        if ((oldValue = DOOCSParameter.getAlignX(this.getHorizontalAlignment())).equalsIgnoreCase("LEFT")) {
            this.setHorizontalAlignment(4);
        }
        if (oldValue.equalsIgnoreCase("RIGHT")) {
            this.setHorizontalAlignment(2);
        }
        if (!oldValue.equalsIgnoreCase(DOOCSParameter.getAlignX(this.getHorizontalAlignment()))) {
            change.add(new SetProperty(this, "alignX", oldValue, DOOCSParameter.getAlignX(this.getHorizontalAlignment())));
        }
        if ((oldValue = this.getDoocsRotate()).equalsIgnoreCase("90")) {
            this.setDoocsRotate("270");
        }
        if (oldValue.equalsIgnoreCase("270")) {
            this.setDoocsRotate("90");
        }
        if (!oldValue.equalsIgnoreCase(this.getDoocsRotate())) {
            change.add(new SetProperty(this, "rotate", oldValue, this.getDoocsRotate()));
        }
        return change;
    }

    @Override
    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        if (this.getDoocsRotate().equalsIgnoreCase("0") || this.getDoocsRotate().equalsIgnoreCase("180")) {
            String oldValue = DOOCSParameter.getAlignY(this.getVerticalAlignment());
            if (oldValue.equalsIgnoreCase("TOP")) {
                this.setVerticalAlignment(3);
            }
            if (oldValue.equalsIgnoreCase("BOTTOM")) {
                this.setVerticalAlignment(1);
            }
            if (!oldValue.equalsIgnoreCase(DOOCSParameter.getAlignY(this.getVerticalAlignment()))) {
                change.add(new SetProperty(this, "alignY", oldValue, DOOCSParameter.getAlignY(this.getVerticalAlignment())));
            }
        } else {
            String oldValue = this.getDoocsHorizontalTextPosition();
            if (oldValue.equalsIgnoreCase("Right")) {
                this.setDoocsHorizontalTextPosition("Left");
            }
            if (oldValue.equalsIgnoreCase("Left")) {
                this.setDoocsHorizontalTextPosition("Right");
            }
            if (!oldValue.equalsIgnoreCase(this.getDoocsHorizontalTextPosition())) {
                change.add(new SetProperty(this, "horizontalTextPosition", oldValue, this.getDoocsHorizontalTextPosition()));
            }
            if ((oldValue = DOOCSParameter.getAlignX(this.getHorizontalAlignment())).equalsIgnoreCase("LEFT")) {
                this.setHorizontalAlignment(4);
            }
            if (oldValue.equalsIgnoreCase("RIGHT")) {
                this.setHorizontalAlignment(2);
            }
            if (!oldValue.equalsIgnoreCase(DOOCSParameter.getAlignX(this.getHorizontalAlignment()))) {
                change.add(new SetProperty(this, "alignX", oldValue, DOOCSParameter.getAlignX(this.getHorizontalAlignment())));
            }
        }
        return change;
    }

    @Override
    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        String oldValue = this.getDoocsRotate();
        if (oldValue.equalsIgnoreCase("0")) {
            this.setDoocsRotate("270");
        }
        if (oldValue.equalsIgnoreCase("90")) {
            this.setDoocsRotate("0");
        }
        if (oldValue.equalsIgnoreCase("180")) {
            this.setDoocsRotate("90");
        }
        if (oldValue.equalsIgnoreCase("270")) {
            this.setDoocsRotate("180");
        }
        change.add(new SetProperty(this, "rotate", oldValue, this.getDoocsRotate()));
        if (this.getDoocsRotate().equalsIgnoreCase("90") || this.getDoocsRotate().equalsIgnoreCase("180")) {
            oldValue = DOOCSParameter.getAlignX(this.getHorizontalAlignment());
            if (oldValue.equalsIgnoreCase("LEFT")) {
                this.setHorizontalAlignment(4);
            }
            if (oldValue.equalsIgnoreCase("RIGHT")) {
                this.setHorizontalAlignment(2);
            }
            if (!oldValue.equalsIgnoreCase(DOOCSParameter.getAlignX(this.getHorizontalAlignment()))) {
                change.add(new SetProperty(this, "alignX", oldValue, DOOCSParameter.getAlignX(this.getHorizontalAlignment())));
            }
            if ((oldValue = DOOCSParameter.getAlignY(this.getVerticalAlignment())).equalsIgnoreCase("TOP")) {
                this.setVerticalAlignment(3);
            }
            if (oldValue.equalsIgnoreCase("BOTTOM")) {
                this.setVerticalAlignment(1);
            }
            if (!oldValue.equalsIgnoreCase(DOOCSParameter.getAlignY(this.getVerticalAlignment()))) {
                change.add(new SetProperty(this, "alignY", oldValue, DOOCSParameter.getAlignY(this.getVerticalAlignment())));
            }
            if ((oldValue = this.getDoocsHorizontalTextPosition()).equalsIgnoreCase("Right")) {
                this.setDoocsHorizontalTextPosition("Left");
            }
            if (oldValue.equalsIgnoreCase("Left")) {
                this.setDoocsHorizontalTextPosition("Right");
            }
            if (!oldValue.equalsIgnoreCase(this.getDoocsHorizontalTextPosition())) {
                change.add(new SetProperty(this, "horizontalTextPosition", oldValue, this.getDoocsHorizontalTextPosition()));
            }
        }
        return change;
    }

    @Override
    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        String oldValue = this.getDoocsRotate();
        if (oldValue.equalsIgnoreCase("0")) {
            this.setDoocsRotate("90");
        }
        if (oldValue.equalsIgnoreCase("90")) {
            this.setDoocsRotate("180");
        }
        if (oldValue.equalsIgnoreCase("180")) {
            this.setDoocsRotate("270");
        }
        if (oldValue.equalsIgnoreCase("270")) {
            this.setDoocsRotate("0");
        }
        change.add(new SetProperty(this, "rotate", oldValue, this.getDoocsRotate()));
        if (this.getDoocsRotate().equalsIgnoreCase("270") || this.getDoocsRotate().equalsIgnoreCase("180")) {
            oldValue = DOOCSParameter.getAlignX(this.getHorizontalAlignment());
            if (oldValue.equalsIgnoreCase("LEFT")) {
                this.setHorizontalAlignment(4);
            }
            if (oldValue.equalsIgnoreCase("RIGHT")) {
                this.setHorizontalAlignment(2);
            }
            if (!oldValue.equalsIgnoreCase(DOOCSParameter.getAlignX(this.getHorizontalAlignment()))) {
                change.add(new SetProperty(this, "alignX", oldValue, DOOCSParameter.getAlignX(this.getHorizontalAlignment())));
            }
            if ((oldValue = DOOCSParameter.getAlignY(this.getVerticalAlignment())).equalsIgnoreCase("TOP")) {
                this.setVerticalAlignment(3);
            }
            if (oldValue.equalsIgnoreCase("BOTTOM")) {
                this.setVerticalAlignment(1);
            }
            if (!oldValue.equalsIgnoreCase(DOOCSParameter.getAlignY(this.getVerticalAlignment()))) {
                change.add(new SetProperty(this, "alignY", oldValue, DOOCSParameter.getAlignY(this.getVerticalAlignment())));
            }
            if ((oldValue = this.getDoocsHorizontalTextPosition()).equalsIgnoreCase("Right")) {
                this.setDoocsHorizontalTextPosition("Left");
            }
            if (oldValue.equalsIgnoreCase("Left")) {
                this.setDoocsHorizontalTextPosition("Right");
            }
            if (!oldValue.equalsIgnoreCase(this.getDoocsHorizontalTextPosition())) {
                change.add(new SetProperty(this, "horizontalTextPosition", oldValue, this.getDoocsHorizontalTextPosition()));
            }
        }
        return change;
    }
}

