/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.xmlUtils;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TineConfigTreeItem {
    private String name;
    private Object value;
    private Class type;
    private ArrayList<Field> fields;

    public TineConfigTreeItem(Class type, String name, Object value) {
        this.name = name;
        this.value = value;
        this.type = type;
        this.fields = new ArrayList();
        if (value == null) {
            return;
        }
        if (type.isPrimitive() || type.isArray() || type.equals(String.class)) {
            return;
        }
        if (value == null) {
            return;
        }
        AccessibleObject[] f = value.getClass().getDeclaredFields();
        AccessibleObject.setAccessible(f, true);
        for (AccessibleObject fi : f) {
            if ((((Field)fi).getModifiers() & 8) != 0) continue;
            this.fields.add((Field)fi);
        }
    }

    public Object getValue() {
        return this.value;
    }

    public ArrayList<Field> getFields() {
        return this.fields;
    }

    public String toString() {
        String r = this.name;
        if (this.value == null) {
            r = r + " = null";
            return r;
        }
        if (this.type.isPrimitive()) {
            r = r + " = " + this.value;
        } else if (this.type.equals(String.class)) {
            r = r + " = " + this.value;
        }
        return r;
    }
}

