/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.types;

import de.desy.tine.endianUtils.Swap;
import de.desy.tine.server.logger.MsgLog;
import de.desy.tine.types.TCompoundDataObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class NAME16II
implements TCompoundDataObject {
    public String name;
    public int i1val;
    public int i2val;
    public static final int sizeInBytes = 24;
    public static final short dFormat = 42;
    ByteArrayOutputStream dBuffer = new ByteArrayOutputStream(24);
    public byte[] hByteArray;

    public double getDoubleValue() {
        return this.i1val;
    }

    public int getIntegerValue() {
        return this.i2val;
    }

    public void setValues(String newName, int newI1Value, int newI2Value) {
        this.name = newName;
        this.i1val = newI1Value;
        this.i2val = newI2Value;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getName() {
        return this.name;
    }

    public int getSizeInBytes() {
        return 24;
    }

    public short getFormat() {
        return 42;
    }

    public void setByteArray(byte[] byteArray) {
        this.hByteArray = byteArray;
    }

    public byte[] getByteArray() {
        return this.hByteArray;
    }

    public NAME16II() {
        this.name = new String(new StringBuffer(16));
        this.i2val = 0;
        this.i1val = 0;
    }

    public NAME16II(String Name2) {
        this.name = Name2;
        this.i2val = 0;
        this.i1val = 0;
    }

    public NAME16II(String Name2, int i) {
        this.name = Name2;
        this.i1val = i;
        this.i2val = 0;
    }

    public NAME16II(String Name2, int i1, int i2) {
        this.name = Name2;
        this.i2val = i2;
        this.i1val = i1;
    }

    public NAME16II(NAME16II instance) {
        this.name = instance.name == null ? new String(new StringBuffer(16)) : new String(instance.name);
        this.i1val = instance.i1val;
        this.i2val = instance.i2val;
    }

    public String toString() {
        return "[" + this.name + this.i1val + "," + this.i2val + "]";
    }

    public boolean equals(NAME16II instance) {
        if (instance.name == null || this.name == null) {
            return false;
        }
        if (instance.name.compareTo(this.name) != 0) {
            return false;
        }
        if (instance.i1val != this.i1val) {
            return false;
        }
        return instance.i2val == this.i2val;
    }

    public byte[] toByteArray() {
        if (this.name == null) {
            this.name = new String(new StringBuffer(16));
        }
        try {
            this.dBuffer.reset();
            DataOutputStream ds = new DataOutputStream(this.dBuffer);
            byte[] bname = this.name.getBytes();
            byte[] b = new byte[16];
            for (int i = 0; i < 16 && i < bname.length; ++i) {
                b[i] = bname[i];
            }
            ds.write(b, 0, b.length);
            ds.writeInt(Swap.Long(this.i1val));
            ds.writeInt(Swap.Long(this.i2val));
            ds.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MsgLog.log("NAME16II", "could not prepare byte stream", 66, e, 0);
            return null;
        }
        this.hByteArray = this.dBuffer.toByteArray();
        return this.hByteArray;
    }

    public void toStruct() {
        try {
            ByteArrayInputStream dis = new ByteArrayInputStream(this.hByteArray);
            DataInputStream ds = new DataInputStream(dis);
            byte[] b = new byte[24];
            ds.read(b, 0, 16);
            int len = 0;
            int i = 0;
            while (i < 16 && b[i] != 0) {
                ++i;
                ++len;
            }
            this.name = new String(b, 0, len);
            this.i1val = Swap.Long(ds.readInt());
            this.i2val = Swap.Long(ds.readInt());
            ds.close();
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MsgLog.log("NAME16II", "could not prepare byte stream", 66, e, 0);
        }
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.i1val;
        result = 31 * result + this.i2val;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NAME16II other = (NAME16II)obj;
        return this.equals(other);
    }
}

