/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.types;

import de.desy.tine.endianUtils.Swap;
import de.desy.tine.types.TCompoundDataObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class LNGINT
implements TCompoundDataObject {
    public int lval;
    public int ival;
    public static int sizeInBytes = 8;
    public static short dFormat = (short)15;
    ByteArrayOutputStream dBuffer = new ByteArrayOutputStream(sizeInBytes);
    public byte[] hByteArray;

    public double getDoubleValue() {
        return this.lval;
    }

    public int getIntegerValue() {
        return this.ival;
    }

    public void setValues(int newI1Value, int newI2Value) {
        this.lval = newI1Value;
        this.ival = newI2Value;
    }

    public int getSizeInBytes() {
        return sizeInBytes;
    }

    public short getFormat() {
        return dFormat;
    }

    public void setByteArray(byte[] byteArray) {
        this.hByteArray = byteArray;
    }

    public byte[] getByteArray() {
        return this.hByteArray;
    }

    public LNGINT() {
        this.lval = 0;
        this.ival = 0;
    }

    public LNGINT(int l) {
        this.lval = l;
        this.ival = 0;
    }

    public LNGINT(int l, int i) {
        this.lval = l;
        this.ival = i;
    }

    public LNGINT(LNGINT instance) {
        this.ival = instance.ival;
        this.lval = instance.lval;
    }

    public String toString() {
        return "[" + this.lval + ", " + this.ival + "]";
    }

    public boolean equals(LNGINT instance) {
        if (instance.lval != this.lval) {
            return false;
        }
        return instance.ival == this.ival;
    }

    public byte[] toByteArray() {
        try {
            this.dBuffer.reset();
            DataOutputStream ds = new DataOutputStream(this.dBuffer);
            ds.writeInt(Swap.Long(this.lval));
            ds.writeInt(Swap.Long(this.ival));
            ds.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.hByteArray = this.dBuffer.toByteArray();
        return this.hByteArray;
    }

    public void toStruct() {
        try {
            ByteArrayInputStream dis = new ByteArrayInputStream(this.hByteArray);
            DataInputStream ds = new DataInputStream(dis);
            this.lval = Swap.Long(ds.readInt());
            this.ival = Swap.Long(ds.readInt());
            ds.close();
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.ival;
        result = 31 * result + this.lval;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LNGINT other = (LNGINT)obj;
        return this.equals(other);
    }
}

