/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.types;

import de.desy.tine.endianUtils.Swap;
import de.desy.tine.types.TCompoundDataObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class FLTINT
implements TCompoundDataObject {
    public float fval;
    public int ival;
    public static final int sizeInBytes = 8;
    public static final short dFormat = 14;
    ByteArrayOutputStream dBuffer = new ByteArrayOutputStream(8);
    public byte[] hByteArray;

    public double getDoubleValue() {
        return this.fval;
    }

    public int getIntegerValue() {
        return this.ival;
    }

    public int getSizeInBytes() {
        return 8;
    }

    public void setValues(float newFValue, int newIValue) {
        this.ival = newIValue;
        this.fval = newFValue;
    }

    public short getFormat() {
        return 14;
    }

    public void setByteArray(byte[] byteArray) {
        this.hByteArray = byteArray;
    }

    public byte[] getByteArray() {
        return this.hByteArray;
    }

    public FLTINT() {
        this.fval = 0.0f;
        this.ival = 0;
    }

    public FLTINT(float f) {
        this.fval = f;
        this.ival = 0;
    }

    public FLTINT(int i) {
        this.ival = i;
    }

    public FLTINT(float f, int i) {
        this.fval = f;
        this.ival = i;
    }

    public FLTINT(FLTINT instance) {
        this.fval = instance.fval;
        this.ival = instance.ival;
    }

    public String toString() {
        return "[" + this.fval + ", " + this.ival + "]";
    }

    public boolean equals(FLTINT instance) {
        if (instance.ival != this.ival) {
            return false;
        }
        return instance.fval == this.fval;
    }

    public byte[] toByteArray() {
        try {
            this.dBuffer.reset();
            DataOutputStream ds = new DataOutputStream(this.dBuffer);
            byte[] b = Swap.Float(this.fval);
            ds.write(b, 0, 4);
            ds.writeInt(Swap.Long(this.ival));
            ds.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.hByteArray = this.dBuffer.toByteArray();
        return this.hByteArray;
    }

    public void toStruct() {
        try {
            ByteArrayInputStream dis = new ByteArrayInputStream(this.hByteArray);
            DataInputStream ds = new DataInputStream(dis);
            byte[] b = new byte[4];
            ds.read(b, 0, 4);
            this.fval = Swap.Float(b);
            this.ival = Swap.Long(ds.readInt());
            ds.close();
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.fval);
        result = 31 * result + this.ival;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FLTINT other = (FLTINT)obj;
        return this.equals(other);
    }
}

