/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.types;

import de.desy.tine.endianUtils.Swap;
import de.desy.tine.types.TCompoundDataObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class DBLDBL
implements TCompoundDataObject {
    public double d1val;
    public double d2val;
    public static final int sizeInBytes = 16;
    public static final short dFormat = 40;
    ByteArrayOutputStream dBuffer = new ByteArrayOutputStream(16);
    public byte[] hByteArray;

    public double getDoubleValue() {
        return this.d1val;
    }

    public int getIntegerValue() {
        return (int)this.d2val;
    }

    public void setValues(double newD1Value, double newD2Value) {
        this.d1val = newD1Value;
        this.d2val = newD2Value;
    }

    public int getSizeInBytes() {
        return 16;
    }

    public short getFormat() {
        return 40;
    }

    public void setByteArray(byte[] byteArray) {
        this.hByteArray = byteArray;
    }

    public byte[] getByteArray() {
        return this.hByteArray;
    }

    public DBLDBL() {
        this.d1val = 0.0;
        this.d2val = 0.0;
    }

    public DBLDBL(double d) {
        this.d1val = d;
        this.d2val = d;
    }

    public DBLDBL(double d1, double d2) {
        this.d1val = d1;
        this.d2val = d2;
    }

    public DBLDBL(DBLDBL instance) {
        this.d1val = instance.d1val;
        this.d2val = instance.d2val;
    }

    public String toString() {
        return "[" + this.d1val + ", " + this.d2val + "]";
    }

    public boolean equals(DBLDBL instance) {
        if (instance.d1val != this.d1val) {
            return false;
        }
        return instance.d2val == this.d2val;
    }

    public byte[] toByteArray() {
        try {
            this.dBuffer.reset();
            DataOutputStream ds = new DataOutputStream(this.dBuffer);
            byte[] b = Swap.Double(this.d1val);
            ds.write(b, 0, 8);
            b = Swap.Double(this.d2val);
            ds.write(b, 0, 8);
            ds.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.hByteArray = this.dBuffer.toByteArray();
        return this.hByteArray;
    }

    public void toStruct() {
        try {
            ByteArrayInputStream dis = new ByteArrayInputStream(this.hByteArray);
            DataInputStream ds = new DataInputStream(dis);
            byte[] b = new byte[8];
            ds.read(b, 0, 8);
            this.d1val = Swap.Double(b);
            ds.read(b, 0, 8);
            this.d2val = Swap.Double(b);
            ds.close();
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.d1val);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.d2val);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DBLDBL other = (DBLDBL)obj;
        return this.equals(other);
    }
}

