/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.test.classes;

import de.desy.tine.client.TCallback;
import de.desy.tine.client.TLink;
import de.desy.tine.client.TLinkFactory;
import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.definitions.TErrorList;
import de.desy.tine.types.INTINT;
import de.desy.tine.types.TCompoundDataObject;

public class MWTest
implements TCallback {
    static final long TIME = System.currentTimeMillis();
    private INTINT _injPhase = new INTINT(0, 0);

    public static void main(String[] args_) {
        new MWTest();
        try {
            MWTest.printActiveLinks(1);
            MWTest.setPhase(140);
            MWTest.printActiveLinks(2);
            Thread.sleep(4000L);
            MWTest.setPhase(120);
            MWTest.printActiveLinks(3);
            Thread.sleep(3000L);
            if (MWTest.getPhase() != 120) {
                System.out.println("ERROR: there is a difference between the current and the before set injection phase.");
            }
            MWTest.printActiveLinks(4);
            Thread.sleep(120000L);
            MWTest.printActiveLinks(5);
            MWTest.printActiveThreads(6);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void printActiveLinks(int count_) {
        System.out.println((double)(System.currentTimeMillis() - TIME) / 1000.0 + " sec.,  active TINE links are:");
        for (TLink lnk : TLinkFactory.getInstance().getActiveLinks()) {
            System.out.println("\t" + lnk.getFullDeviceName());
        }
        System.out.println();
    }

    private static void printActiveThreads(int count_) {
        System.out.println((double)(System.currentTimeMillis() - TIME) / 1000.0 + " sec., active threads are:");
        Thread[] tarray = new Thread[Thread.activeCount()];
        Thread.enumerate(tarray);
        for (Thread thread : tarray) {
            System.out.println("\t" + thread.getName());
        }
        System.out.println();
    }

    private static void closeActiveLinks() {
        System.out.println("Closing all active links...");
        for (TLink lnk : TLinkFactory.getInstance().getActiveLinks()) {
            lnk.close();
        }
    }

    public static int getPhase() {
        TCompoundDataObject[] values = new INTINT[]{new INTINT(0, 0)};
        TDataType output = new TDataType(values);
        TLink link = new TLink("/DESY2/Timing/Timing", "injPhase", output, null, 1);
        if (link == null) {
            throw new RuntimeException("Cannot create a TINE link.");
        }
        link.removeOnClose = true;
        int result = link.execute();
        link.close();
        if (result != 0) {
            throw new RuntimeException("The execution results in an error: " + TErrorList.getErrorString(result) + " (" + result + ')');
        }
        return ((INTINT)values[0]).i1val;
    }

    public static void setPhase(int phase_) {
        TCompoundDataObject[] values = new INTINT[]{new INTINT(phase_, 0)};
        TDataType input = new TDataType(values);
        TLink link = new TLink("/DESY2/Timing/Timing", "injPhase", null, input, 2);
        if (link == null) {
            throw new RuntimeException("Cannot create a TINE link.");
        }
        int result = link.execute();
        link.close();
        if (result != 0) {
            throw new RuntimeException("The execution results in an error: " + TErrorList.getErrorString(result) + " (" + result + ')');
        }
    }

    public MWTest() {
        TDataType output = new TDataType(new INTINT[]{this._injPhase});
        TLink lnk = new TLink("/DESY2/Timing/Timing", "injPhase", output, null, 1);
        lnk.attach((short)3, (TCallback)this);
    }

    public void callback(int lnkIndex_, int lnkStatus_) {
        if (lnkStatus_ != 0) {
            System.out.println("CALLBACK - TINE error occurred: " + TErrorList.getErrorString(lnkStatus_));
        } else {
            System.out.println("CALLBACK - current injection phase is " + this._injPhase.i1val);
        }
    }

    public synchronized int getCurrentPhase() {
        return this._injPhase.i1val;
    }
}

