/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.structUtils;

import de.desy.tine.structUtils.TStructDescription;
import de.desy.tine.types.NAME16II;
import java.util.HashMap;

public final class TStructRegistry {
    private static HashMap<String, TStructDescription> myRegistry = new HashMap();
    public static int numRegisteredStructs = 0;

    public static NAME16II[] getRegisteredStructure(String tag) {
        NAME16II[] rv = null;
        TStructDescription dsc = myRegistry.get(tag);
        if (dsc != null) {
            rv = dsc.toNameIntIntArray();
        }
        return rv;
    }

    public static void fill(String tag, short fmt, int siz) {
        TStructDescription sd = myRegistry.get(tag);
        if (sd == null) {
            sd = new TStructDescription(tag);
            myRegistry.put(sd.getTagName(), sd);
            sd.beginDefinition();
        }
        if (fmt % 512 == 255) {
            sd.setArraySize(siz);
            sd.endDefinition();
        } else {
            sd.addField(fmt, siz);
        }
    }

    public static void fill(String tag, String name, short fmt, int siz) {
        TStructDescription sd = myRegistry.get(tag);
        if (sd == null) {
            sd = new TStructDescription(tag);
            myRegistry.put(sd.getTagName(), sd);
            sd.beginDefinition();
        }
        if (fmt % 512 == 255) {
            sd.setArraySize(siz);
            sd.endDefinition();
        } else {
            sd.addField(name, fmt, siz);
        }
    }

    public static String toString(String tag, byte[] data) {
        if (data == null) {
            return "";
        }
        return TStructRegistry.toString(tag, data, data.length);
    }

    public static String toString(String tag, byte[] data, int length) {
        String rv = "";
        StringBuffer buffer = new StringBuffer();
        TStructDescription sd = myRegistry.get(tag);
        if (sd == null) {
            rv = new String("Structure " + tag + " not registered");
        } else if (data == null || data.length == 0) {
            rv = "";
        } else {
            int nStructs = length / sd.getRawLength();
            for (int i = 0; i < nStructs; ++i) {
                buffer.append(sd.convertBytesToString(data, i * sd.getRawLength()));
            }
            rv = buffer.toString();
        }
        return rv;
    }

    public static int getSizeInBytes(String tag) {
        TStructDescription s = myRegistry.get(tag);
        return s == null ? -1 : s.getRawLength();
    }

    public static synchronized void add(TStructDescription newStruct) {
        if (!TStructRegistry.contains(newStruct.getTagName())) {
            myRegistry.put(newStruct.getTagName(), newStruct);
        }
    }

    public static TStructDescription get(String structName) {
        return myRegistry.get(structName);
    }

    public static boolean contains(String structName) {
        return myRegistry.containsKey(structName);
    }
}

