/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.stringUtils;

public class WildcardMatch {
    private String[] parts;
    private boolean startFixed = true;
    private boolean endFixed = true;
    private boolean matchAll;
    private boolean matchSingle;
    private boolean valid = true;
    private boolean caseSensitive = false;

    public WildcardMatch(String pattern) {
        boolean bl = this.valid = pattern != null && pattern.length() > 0;
        if (this.valid) {
            this.matchAll = pattern.equals("*");
            boolean bl2 = this.matchSingle = pattern.indexOf("*") < 0;
            if (this.matchAll) {
                this.parts = null;
            } else if (this.matchSingle) {
                this.parts = new String[1];
                this.parts[0] = pattern;
            } else {
                this.startFixed = !pattern.startsWith("*");
                this.endFixed = !pattern.endsWith("*");
                this.parts = pattern.split("\\*");
                this.valid = this.parts != null;
            }
        }
    }

    public boolean matches(String comparedText) {
        boolean rv = this.valid;
        String portion = null;
        String text = comparedText;
        if (this.caseSensitive) {
            text = text.toLowerCase();
        }
        int restLength = text.length();
        if (!this.valid) {
            rv = false;
        } else if (this.matchAll) {
            rv = true;
        } else if (this.matchSingle) {
            rv = text.equals(this.parts[0]);
        } else {
            if (this.startFixed) {
                rv = rv && text.startsWith(this.parts[0]);
            }
            int startIndex = 0;
            for (int i = 0; i < this.parts.length && rv; ++i) {
                int foundIndex;
                if (this.parts[i].length() <= 0) continue;
                portion = this.parts[i];
                if (this.caseSensitive) {
                    portion = portion.toLowerCase();
                }
                if ((foundIndex = text.indexOf(portion, startIndex)) >= 0) {
                    startIndex = foundIndex + portion.length();
                    restLength = text.length() - startIndex;
                    rv = restLength >= 0;
                    continue;
                }
                rv = false;
            }
            if (rv && this.endFixed) {
                rv = restLength == 0;
            }
        }
        return rv;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean value) {
        this.caseSensitive = value;
    }
}

