/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.server.properties;

import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.definitions.TAccess;
import de.desy.tine.definitions.TFormat;
import de.desy.tine.server.equipment.TEquipmentModule;
import de.desy.tine.server.logger.DbgLog;
import de.desy.tine.server.properties.TExportProperty;
import de.desy.tine.server.properties.TPropertyHandler;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TPropertyList {
    private int debugLevel = 0;
    private TEquipmentModule eqm = null;
    private TreeMap<String, LinkedList<PropertyData>> myPropertyData = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    private boolean deviceOriented = false;

    public boolean isDeviceOriented() {
        return this.deviceOriented;
    }

    public void setDeviceOriented(boolean value) {
        this.deviceOriented = value;
    }

    public LinkedList getEqualProperties(String propertyName) {
        LinkedList<TExportProperty> rv = new LinkedList<TExportProperty>();
        LinkedList<PropertyData> datalist = this.myPropertyData.get(propertyName);
        if (datalist != null) {
            Iterator it = datalist.iterator();
            while (it.hasNext()) {
                rv.add(((PropertyData)it.next()).getProperty());
            }
        }
        return rv;
    }

    public int getNumInstances(String propertyName) {
        int rv = 0;
        LinkedList<PropertyData> propList = this.myPropertyData.get(propertyName);
        if (propList != null) {
            rv = propList.size();
        }
        return rv;
    }

    public int getNumOverloads(String propertyName) {
        return this.getNumInstances(propertyName) - 1;
    }

    public int countUniqueProperties() {
        return this.myPropertyData.size();
    }

    public int countAllProperties() {
        int rv = 0;
        for (LinkedList<PropertyData> currentData : this.myPropertyData.values()) {
            if (currentData == null) continue;
            rv += currentData.size();
        }
        return rv;
    }

    public LinkedList<PropertyData> getPropertyDataList(String propertyName) {
        return this.myPropertyData.get(propertyName);
    }

    public TExportProperty getFirstProperty(String propertyName) {
        PropertyData theData;
        TExportProperty rv = null;
        LinkedList<PropertyData> lst = this.myPropertyData.get(propertyName);
        if (lst != null && (theData = lst.getFirst()) != null) {
            rv = theData.property;
        }
        return rv;
    }

    public int setHandler(String propertyName, TPropertyHandler handler) {
        LinkedList<PropertyData> lst = this.myPropertyData.get(propertyName);
        if (lst == null) {
            return 36;
        }
        PropertyData pData = lst.getFirst();
        if (pData == null) {
            return 66;
        }
        pData.setHandler(handler);
        return 0;
    }

    public TPropertyHandler getFirstPropertyHandler(String propertyName) {
        TPropertyHandler rv = null;
        LinkedList<PropertyData> lst = this.getPropertyDataList(propertyName);
        PropertyData theData = lst.getFirst();
        if (theData != null) {
            rv = theData.handler;
        }
        return rv;
    }

    public TPropertyHandler findPropertyHandler(String propertyName, short outputFormat, short inputFormat) {
        TPropertyHandler rv = null;
        LinkedList<PropertyData> propList = this.getPropertyDataList(propertyName);
        if (propList != null) {
            Iterator it = propList.iterator();
            while (it.hasNext() && rv == null) {
                boolean inputOK;
                PropertyData currentData = (PropertyData)it.next();
                boolean outputOK = outputFormat == 255 || TFormat.formatsCanMap(currentData.getProperty().getOutputFormat(), outputFormat, false);
                boolean bl = inputOK = inputFormat == 255 || TFormat.formatsCanMap(currentData.getProperty().getInputFormat(), inputFormat, true);
                if (outputOK && inputOK) {
                    rv = currentData.getHandler();
                    if (this.debugLevel > 1) {
                        DbgLog.log("findPropertyHandler", "Output Format: " + currentData.getProperty().getOutputFormat() + "==" + outputFormat);
                    }
                    break;
                }
                if (this.debugLevel <= 1) continue;
                DbgLog.log("findPropertyHandler", "Output Format: " + currentData.getProperty().getOutputFormat() + "!=" + outputFormat);
            }
        } else {
            DbgLog.log("findPropertyHandler", "Property not found");
        }
        return rv;
    }

    public boolean hasProperty(String propertyName) {
        return this.myPropertyData.containsKey(propertyName);
    }

    public Set<String> getPropertyNames() {
        return this.myPropertyData.keySet();
    }

    public void addProperty(TExportProperty newProperty, TPropertyHandler newHandler) {
        this.addProperty(null, newProperty, newHandler);
    }

    public void addProperty(TEquipmentModule parentEqm, TExportProperty newProperty, TPropertyHandler newHandler) {
        String propertyName;
        if (this.eqm == null) {
            this.eqm = parentEqm;
        }
        if (this.myPropertyData.containsKey(propertyName = newProperty.getName())) {
            LinkedList<PropertyData> propertyList = this.getPropertyDataList(propertyName);
            if (propertyList != null) {
                propertyList.add(new PropertyData(newProperty, newHandler));
            }
        } else {
            LinkedList<PropertyData> propertyList = new LinkedList<PropertyData>();
            propertyList.add(new PropertyData(newProperty, newHandler));
            this.myPropertyData.put(propertyName, propertyList);
            if (this.eqm != null) {
                this.eqm.getRegisteredNamesFromPropertyFile(newProperty.getName());
            }
        }
    }

    public short callPropertyHandler(String propertyName, String devName, TDataType dout, TDataType din, TAccess devAccess) {
        short inputFormat;
        short cc = 0;
        short outputFormat = dout == null ? (short)255 : (short)dout.getFormat();
        TPropertyHandler theHandler = this.findPropertyHandler(propertyName, outputFormat, inputFormat = din == null ? (short)255 : (short)din.getFormat());
        if (theHandler != null) {
            if (this.debugLevel > 1) {
                DbgLog.log("callPropertyHandler", "Calling Property Handler for [" + propertyName + "]");
            }
            try {
                cc = (short)theHandler.callHandler(devName, dout, din, devAccess);
            }
            catch (Exception e) {
                cc = 66;
            }
        } else if (this.hasProperty(propertyName)) {
            if (this.debugLevel > 1) {
                DbgLog.log("callPropertyHandler", "handler not implemented for [" + propertyName + "]");
            }
            cc = 38;
        } else {
            if (this.debugLevel > 1) {
                DbgLog.log("callPropertyHandler", "Illegal Property [" + propertyName + "]");
            }
            cc = 36;
        }
        return cc;
    }

    public class PropertyData {
        private TExportProperty property;
        private TPropertyHandler handler = null;

        public PropertyData(TExportProperty property, TPropertyHandler propertyHandler) {
            this.property = property;
            this.handler = propertyHandler;
        }

        public TPropertyHandler getHandler() {
            return this.handler;
        }

        public TExportProperty getProperty() {
            return this.property;
        }

        public void setHandler(TPropertyHandler handler) {
            this.handler = handler;
        }
    }
}

