/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.server.histories;

import de.desy.tine.server.histories.THistorySpecification;
import de.desy.tine.structUtils.TTaggedStructure;

public class THistoryRecordStruct
extends TTaggedStructure {
    private String devString = null;
    private String prpString = null;
    private char[] prp = new char[64];
    private char[] dev = new char[64];
    private int[] siz = new int[1];
    private int[] fmt = new int[1];
    private int[] pRate = new int[1];
    private int[] aRate = new int[1];
    private int[] depthShort = new int[1];
    private int[] depthLong = new int[1];
    private int[] heartbeat = new int[1];
    private float[] pTolerance = new float[1];
    private float[] aTolerance = new float[1];

    private void pushString(String s, char[] c) {
        if (s != null) {
            int len = s.length();
            if (len > c.length) {
                len = c.length;
            }
            s.getChars(0, len, c, 0);
        }
    }

    private void initStructure() {
        this.addField(this.prp, "property");
        this.addField(this.dev, "device");
        this.addField(this.siz, "dataSize");
        this.addField(this.fmt, "dataFormat");
        this.addField(this.pRate, "pollingRate");
        this.addField(this.aRate, "archiveRate");
        this.addField(this.depthShort, "depthShort");
        this.addField(this.depthLong, "depthLong");
        this.addField(this.heartbeat, "heartbeat");
        this.addField(this.pTolerance, "pTolerance");
        this.addField(this.aTolerance, "aTolerance");
        this.initDone();
    }

    public THistoryRecordStruct() {
        super("HRSr4");
        this.initStructure();
    }

    public THistoryRecordStruct(String devName, String devProperty, int size, int format, THistorySpecification hsp) {
        super("HRSr4");
        this.initStructure();
        this.pushString(devName, this.dev);
        this.pushString(devProperty, this.prp);
        this.siz[0] = size;
        this.fmt[0] = format;
        this.pRate[0] = hsp.getPollngRate();
        this.aRate[0] = hsp.getArchiveRate();
        this.depthShort[0] = hsp.getDepthShort();
        this.depthLong[0] = hsp.getDepthLong();
        this.heartbeat[0] = hsp.getHeartbeat();
        this.pTolerance[0] = hsp.getPercentTolerance();
        this.aTolerance[0] = hsp.getAbsoluteTolerance();
    }

    public int getArchiveRate() {
        return this.aRate[0];
    }

    public float getAbsoluteTolerance() {
        return this.aTolerance[0];
    }

    public int getDepthLong() {
        return this.depthLong[0];
    }

    public int getDepthShort() {
        return this.depthShort[0];
    }

    public String getDevice() {
        if (this.devString == null) {
            this.devString = new String(this.dev);
        }
        return this.devString;
    }

    public String getProperty() {
        if (this.prpString == null) {
            this.prpString = new String(this.prp);
        }
        return this.prpString;
    }

    public int getFormat() {
        return this.fmt[0];
    }

    public int getHeartbeat() {
        return this.heartbeat[0];
    }

    public int getPollingRate() {
        return this.pRate[0];
    }

    public float getPercentTolerance() {
        return this.pTolerance[0];
    }

    public int getSize() {
        return this.siz[0];
    }
}

