/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.server.histories;

import de.desy.tine.client.TLinkFactory;
import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.definitions.TArrayType;
import de.desy.tine.definitions.TFormat;
import de.desy.tine.server.equipment.TEquipmentModule;
import de.desy.tine.server.histories.THistorySpecification;
import de.desy.tine.server.logger.DbgLog;
import de.desy.tine.server.logger.TFecLog;
import de.desy.tine.server.properties.TPropertyDescription;
import de.desy.tine.server.properties.TPropertyList;
import de.desy.tine.startup.TInitializerFactory;
import de.desy.tine.types.DBLDBL;
import de.desy.tine.types.DBLDBLDBL;
import de.desy.tine.types.FLTFLT;
import de.desy.tine.types.FLTINT;
import de.desy.tine.types.FLTINTINT;
import de.desy.tine.types.HISTORY;
import de.desy.tine.types.INTFLTINT;
import de.desy.tine.types.INTINT;
import de.desy.tine.types.NAME;
import de.desy.tine.types.NAME16;
import de.desy.tine.types.NAME16DBLDBL;
import de.desy.tine.types.NAME16FI;
import de.desy.tine.types.NAME16I;
import de.desy.tine.types.NAME16II;
import de.desy.tine.types.NAME32;
import de.desy.tine.types.NAME32DBLDBL;
import de.desy.tine.types.NAME32I;
import de.desy.tine.types.NAME64;
import de.desy.tine.types.NAME64DBL;
import de.desy.tine.types.NAME64DBLDBL;
import de.desy.tine.types.NAME64I;
import de.desy.tine.types.NAMEINT;
import de.desy.tine.types.TCompoundDataObject;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Calendar;

public class THistoryRecord {
    private static final long msecondsInMonth = 2678400000L;
    private static final int AS_STATE_SIZE = 16;
    private TEquipmentModule eqm;
    private String prp;
    private String dev;
    private int siz;
    private byte fmt;
    private String tag = null;
    private int aType;
    private THistorySpecification hspec;
    private int rngPtr;
    private int rcdIdx;
    private int rngBufferSize;
    private float range = 0.0f;
    private long lastArchiveTime;
    private String ArchiveFileName;
    private int lastArchivedDayOfTheMonth = -1;
    private boolean useMonthlyHistoryFiles = false;
    private boolean useMinimalStorage = false;
    private boolean useStandardFileSet = false;
    private Calendar calendar;
    private long[] timestamp;
    private int[] sysstamp;
    private int[] usrstamp;
    private long lastReadTimestamp = 0L;
    private boolean isScheduled = false;
    private boolean keepPointsOfInterest = false;
    private static String fileHome = TInitializerFactory.getInstance().getInitializer().getHistoryHome();
    Object rngBuffer;
    private static double poiRangeFactor = 0.1;
    private static double poiToleranceFactor = 10.0;

    public void setScheduled(boolean value) {
        this.isScheduled = value;
    }

    private int getRecordPrefixLength() {
        return this.useMinimalStorage ? 4 : 16;
    }

    public static boolean isAllowableFormat(String fmt) {
        return THistoryRecord.isAllowableFormat(TFormat.getFormatCode(fmt));
    }

    public static boolean isAllowableFormat(short fmt) {
        switch (fmt) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 31: 
            case 36: 
            case 37: 
            case 40: 
            case 41: 
            case 44: 
            case 45: {
                return true;
            }
        }
        return false;
    }

    private THistoryRecord(THistoryRecord reference) {
        this.eqm = reference.eqm;
        this.prp = reference.prp;
        this.dev = reference.dev;
        this.siz = reference.siz;
        this.fmt = reference.fmt;
        this.aType = reference.aType;
        this.rcdIdx = reference.rcdIdx;
        this.hspec = reference.hspec;
        this.rngBufferSize = reference.rngBufferSize;
        this.rngBuffer = reference.rngBuffer;
        this.rngPtr = reference.rngPtr;
        this.timestamp = reference.timestamp;
        this.sysstamp = reference.sysstamp;
        this.usrstamp = reference.usrstamp;
        this.useMinimalStorage = reference.useMinimalStorage;
        this.useMonthlyHistoryFiles = reference.useMonthlyHistoryFiles;
    }

    public THistoryRecord(TEquipmentModule equipmentModule, String devName, String devProperty, int size, int format, int arrayType, int recordIndex, THistorySpecification hstSpecification) {
        TPropertyList plst;
        TPropertyDescription dsc;
        this.rngPtr = -1;
        this.eqm = equipmentModule;
        this.prp = devProperty;
        this.dev = devName;
        this.siz = size;
        this.fmt = (byte)format;
        this.aType = arrayType;
        this.rcdIdx = recordIndex;
        this.hspec = hstSpecification;
        if (this.eqm == null) {
            TFecLog.log("THistoryRecord: equipment module null pointer!");
            return;
        }
        if (!this.eqm.hasProperty(this.prp)) {
            TFecLog.log("THistoryRecord: equipment module does not have property " + this.prp + "!");
            return;
        }
        if (this.siz == 1) {
            this.keepPointsOfInterest = true;
        }
        if ((dsc = (plst = this.eqm.getPropertyList()).getFirstProperty(this.prp).getDescription()) != null) {
            if (TArrayType.isChannel(dsc.getArrayType())) {
                this.keepPointsOfInterest = true;
            }
            this.range = dsc.getYRange().getMaxValue() - dsc.getYRange().getMinValue();
        }
        if (this.hspec.getPollngRate() <= 0) {
            TFecLog.log("THistoryRecord: polling interval " + this.hspec.getPollngRate() + " for property " + this.prp + " is not allowed");
            return;
        }
        TFecLog.log("keep history of " + devName + " " + devProperty);
        this.rngBufferSize = this.siz * this.hspec.getDepthShort();
        switch (this.fmt) {
            case 2: {
                this.rngBuffer = new byte[this.rngBufferSize];
                break;
            }
            case 1: {
                this.rngBuffer = new short[this.rngBufferSize];
                break;
            }
            case 3: {
                this.rngBuffer = new int[this.rngBufferSize];
                break;
            }
            case 6: {
                this.rngBuffer = new long[this.rngBufferSize];
                break;
            }
            case 5: {
                this.rngBuffer = new float[this.rngBufferSize];
                break;
            }
            case 0: {
                this.rngBuffer = new double[this.rngBufferSize];
                break;
            }
            case 9: {
                this.rngBuffer = new NAME16[this.rngBufferSize];
                for (int i = 0; i < this.rngBufferSize; ++i) {
                    ((NAME16[])this.rngBuffer)[i] = new NAME16();
                }
                break;
            }
            case 13: {
                this.rngBuffer = new NAME32[this.rngBufferSize];
                for (int i = 0; i < this.rngBufferSize; ++i) {
                    ((NAME32[])this.rngBuffer)[i] = new NAME32();
                }
                break;
            }
            case 36: {
                this.rngBuffer = new NAME64[this.rngBufferSize];
                for (int i = 0; i < this.rngBufferSize; ++i) {
                    ((NAME64[])this.rngBuffer)[i] = new NAME64();
                }
                break;
            }
            case 14: {
                this.rngBuffer = new FLTINT[this.rngBufferSize];
                for (int i = 0; i < this.rngBufferSize; ++i) {
                    ((FLTINT[])this.rngBuffer)[i] = new FLTINT();
                }
                break;
            }
            case 31: {
                this.rngBuffer = new FLTFLT[this.rngBufferSize];
                for (int i = 0; i < this.rngBufferSize; ++i) {
                    ((FLTFLT[])this.rngBuffer)[i] = new FLTFLT();
                }
                break;
            }
            case 15: {
                this.rngBuffer = new INTINT[this.rngBufferSize];
                for (int i = 0; i < this.rngBufferSize; ++i) {
                    ((INTINT[])this.rngBuffer)[i] = new INTINT();
                }
                break;
            }
            case 40: {
                this.rngBuffer = new DBLDBL[this.rngBufferSize];
                for (int i = 0; i < this.rngBufferSize; ++i) {
                    ((DBLDBL[])this.rngBuffer)[i] = new DBLDBL();
                }
                break;
            }
            case 21: {
                this.rngBuffer = new NAME16I[this.rngBufferSize];
                for (int i = 0; i < this.rngBufferSize; ++i) {
                    ((NAME16I[])this.rngBuffer)[i] = new NAME16I();
                }
                break;
            }
            case 22: {
                this.rngBuffer = new NAME32I[this.rngBufferSize];
                for (int i = 0; i < this.rngBufferSize; ++i) {
                    ((NAME32I[])this.rngBuffer)[i] = new NAME32I();
                }
                break;
            }
            case 37: {
                this.rngBuffer = new NAME64I[this.rngBufferSize];
                for (int i = 0; i < this.rngBufferSize; ++i) {
                    ((NAME64I[])this.rngBuffer)[i] = new NAME64I();
                }
                break;
            }
            case 54: {
                this.rngBuffer = new NAME64DBL[this.rngBufferSize];
                for (int i = 0; i < this.rngBufferSize; ++i) {
                    ((NAME64DBL[])this.rngBuffer)[i] = new NAME64DBL();
                }
                break;
            }
            case 10: {
                this.rngBuffer = new NAME16FI[this.rngBufferSize];
                for (int i = 0; i < this.rngBufferSize; ++i) {
                    ((NAME16FI[])this.rngBuffer)[i] = new NAME16FI();
                }
                break;
            }
            case 42: {
                this.rngBuffer = new NAME16II[this.rngBufferSize];
                for (int i = 0; i < this.rngBufferSize; ++i) {
                    ((NAME16II[])this.rngBuffer)[i] = new NAME16II();
                }
                break;
            }
            case 41: {
                this.rngBuffer = new NAME16DBLDBL[this.rngBufferSize];
                for (int i = 0; i < this.rngBufferSize; ++i) {
                    ((NAME16DBLDBL[])this.rngBuffer)[i] = new NAME16DBLDBL();
                }
                break;
            }
            case 44: {
                this.rngBuffer = new NAME32DBLDBL[this.rngBufferSize];
                for (int i = 0; i < this.rngBufferSize; ++i) {
                    ((NAME32DBLDBL[])this.rngBuffer)[i] = new NAME32DBLDBL();
                }
                break;
            }
            case 45: {
                this.rngBuffer = new NAME64DBLDBL[this.rngBufferSize];
                for (int i = 0; i < this.rngBufferSize; ++i) {
                    ((NAME64DBLDBL[])this.rngBuffer)[i] = new NAME64DBLDBL();
                }
                break;
            }
            default: {
                TFecLog.log("history record of format type " + TFormat.toString(this.fmt) + " not allowed!");
                return;
            }
        }
        this.timestamp = new long[this.rngBufferSize];
        this.sysstamp = new int[this.rngBufferSize];
        this.usrstamp = new int[this.rngBufferSize];
    }

    public int writeRecordToPIF(TDataType dout) {
        THistoryRecord thr = new THistoryRecord(this);
        char[] afn = this.ArchiveFileName.toCharArray();
        "pi".getChars(0, 2, afn, 0);
        thr.ArchiveFileName = new String(afn);
        thr.useStandardFileSet = false;
        thr.writeRecordToLTS(dout);
        return 0;
    }

    public int writeRecordToLTS(TDataType dout) {
        Object values = dout.getDataObject();
        long ts = dout.getDataTimeStamp();
        short fmt = this.getFmt();
        if (ts < 1000L) {
            DbgLog.log("writeRecordToLTS", "invalid timestamp " + ts + " refused");
            return 0;
        }
        try {
            File d = new File(fileHome);
            if (!d.exists()) {
                d.mkdirs();
            }
            int nsiz = TFormat.formatSizeOf(fmt);
            ByteArrayOutputStream baos = new ByteArrayOutputStream(this.getRecordPrefixLength() + this.siz * nsiz);
            DataOutputStream os = new DataOutputStream(baos);
            if (!this.useMinimalStorage) {
                os.writeDouble((double)ts / 1000.0);
                os.writeInt(dout.getSystemDataStamp());
                os.writeInt(dout.getUserDataStamp());
            } else {
                os.writeInt((int)(ts / 1000L));
            }
            switch (fmt) {
                case 2: {
                    int i;
                    for (i = 0; i < this.siz; ++i) {
                        os.writeByte(((byte[])values)[i]);
                    }
                    break;
                }
                case 1: {
                    int i;
                    for (i = 0; i < this.siz; ++i) {
                        os.writeShort(((short[])values)[i]);
                    }
                    break;
                }
                case 3: {
                    int i;
                    for (i = 0; i < this.siz; ++i) {
                        os.writeInt(((int[])values)[i]);
                    }
                    break;
                }
                case 6: {
                    int i;
                    for (i = 0; i < this.siz; ++i) {
                        os.writeLong(((long[])values)[i]);
                    }
                    break;
                }
                case 5: {
                    int i;
                    for (i = 0; i < this.siz; ++i) {
                        os.writeFloat(((float[])values)[i]);
                    }
                    break;
                }
                case 0: {
                    int i;
                    for (i = 0; i < this.siz; ++i) {
                        os.writeDouble(((double[])values)[i]);
                    }
                    break;
                }
                case 9: 
                case 13: 
                case 36: {
                    int i;
                    for (i = 0; i < this.siz; ++i) {
                        os.write(((NAME[])values)[i].toByteArray(), 0, nsiz);
                    }
                    break;
                }
                default: {
                    int i;
                    if (!(values instanceof TCompoundDataObject[])) break;
                    for (i = 0; i < this.siz; ++i) {
                        os.write(((TCompoundDataObject[])values)[i].toByteArray(), 0, nsiz);
                    }
                }
            }
            String fileName = fileHome + "/" + this.ArchiveFileName;
            RandomAccessFile raf = new RandomAccessFile(fileName, "rw");
            int p = this.getFilePosition(raf);
            raf.seek(p);
            raf.write(baos.toByteArray());
            this.setFilePosition(raf, p + this.getRecordLength());
            raf.close();
            this.lastArchiveTime = ts;
        }
        catch (Exception e) {
            TFecLog.log("HST: cannot write record " + this.getDev() + " " + this.getPrp());
        }
        return 0;
    }

    public long getLastReadTimestamp() {
        return this.lastReadTimestamp;
    }

    public int getNumDaysInMonth(int year, int month) {
        boolean isLeapYear = false;
        if (year % 4 == 0) {
            isLeapYear = true;
        }
        switch (month) {
            case 0: 
            case 2: 
            case 4: 
            case 6: 
            case 7: 
            case 9: 
            case 11: {
                return 31;
            }
            case 1: {
                return isLeapYear ? 29 : 28;
            }
        }
        return 30;
    }

    public int getNumDaysInTimeSpan(long t1, long t2) {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance();
        }
        int n = 0;
        this.calendar.setTimeInMillis(t1);
        int y1 = this.calendar.get(1);
        int m1 = this.calendar.get(2);
        int d1 = this.calendar.get(5);
        this.calendar.setTimeInMillis(t2);
        int y2 = this.calendar.get(1);
        int m2 = this.calendar.get(2);
        int d2 = this.calendar.get(5);
        int d = this.getNumDaysInMonth(y2, m2);
        int nx = d1 + (d - d2 - 1);
        for (int y = y1; y < y2 + 1; ++y) {
            int ms = y == y1 ? m1 : 0;
            int me = y == y2 ? m2 : 11;
            for (int i = ms; i < me + 1; ++i) {
                n += this.getNumDaysInMonth(y, i);
            }
        }
        return n - nx;
    }

    public int getDataFromLTS(int index, long starttime, long endtime, float lwrLimit, float uprLimit, Object dataTarget, int arraysize, int arrayOffset, int sample) {
        int asize;
        int recsread = 0;
        int recsfound = 0;
        int rnumber = 0;
        boolean finalPass = false;
        long t = System.currentTimeMillis();
        long itime = 0L;
        THistorySpecification spc = this.getHspec();
        if (index < 0 || index > this.siz) {
            return -37;
        }
        if (arraysize < 1) {
            return -25;
        }
        if (spc.getDepthShort() <= 0) {
            return -121;
        }
        long stsTime = spc.getDepthShort() * spc.getPollngRate();
        if (spc.getDepthLong() <= 0) {
            if (endtime < t - stsTime) {
                return -121;
            }
            return 0;
        }
        if (starttime >= t - stsTime) {
            return 0;
        }
        if (endtime < t - (long)spc.getDepthLong() * 2678400000L) {
            return -121;
        }
        short targetFmt = TDataType.getObjectFormat(dataTarget);
        if (targetFmt == 255) {
            return -2;
        }
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance();
        }
        this.calendar.setTimeInMillis(endtime);
        int ye = this.calendar.get(1);
        int de = this.calendar.get(5);
        int me = this.calendar.get(2);
        this.calendar.setTimeInMillis(starttime);
        int ys = this.calendar.get(1);
        int ds = this.calendar.get(5);
        int ms = this.calendar.get(2);
        if (me == ms && de == ds) {
            asize = arraysize;
            finalPass = true;
        } else {
            asize = arraysize == 1 ? arraysize : 0;
        }
        int daystotal = this.getNumDaysInTimeSpan(starttime, endtime);
        while (recsread < arraysize) {
            String fn;
            int ps;
            if (asize < arraysize || arraysize == 1) {
                int yi = ys;
                int mi = ms;
                int di = ds;
                if (yi == ye && mi == me && (di == de || this.useMonthlyHistoryFiles)) {
                    asize = arraysize;
                    finalPass = true;
                } else {
                    if ((di = (di + 1) % (this.getNumDaysInMonth(yi, mi) + 1)) == 0) {
                        ++di;
                        if ((mi = (mi + 1) % 12) == 0) {
                            ++yi;
                        }
                    }
                    this.calendar.set(yi, mi, di, 0, 0, 0);
                    itime = this.calendar.getTimeInMillis();
                    int daysinmonth = 1;
                    daysinmonth = (int)((itime - starttime) / 86400000L);
                    if (daysinmonth < 1) {
                        daysinmonth = 1;
                    }
                    if (arraysize > 1) {
                        if (targetFmt <= 5) {
                            asize = arraysize;
                        } else {
                            int add = arraysize * daysinmonth / daystotal;
                            if (add < 1) {
                                add = 1;
                            }
                            asize += add;
                        }
                        if (asize >= arraysize) {
                            finalPass = true;
                        }
                    }
                }
            }
            if (asize > arraysize) {
                asize = arraysize;
            }
            if ((ps = this.loadLTSData(fn = this.makeFileNameFromTime(starttime), index, starttime, endtime, lwrLimit, uprLimit, dataTarget, asize, recsread, sample)) < 0) {
                return ps;
            }
            if (asize == 1) {
                recsfound += ps;
            } else {
                recsread += ps;
            }
            if (finalPass) break;
            starttime = itime;
            this.calendar.setTimeInMillis(starttime);
            ys = this.calendar.get(1);
            ds = this.calendar.get(5);
            ms = this.calendar.get(2);
        }
        int n = rnumber = recsfound > 0 ? recsfound : recsread;
        if (arraysize == 1) {
            recsread = recsfound;
        }
        if (arraysize < 2) {
            this.assignNumberOfPoints(dataTarget, rnumber);
        }
        return rnumber;
    }

    private String makeFileNameFromTime(long time) {
        int dd;
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance();
        }
        this.calendar.setTimeInMillis(time);
        this.lastArchivedDayOfTheMonth = dd = this.calendar.get(5);
        int yy = this.calendar.get(1) % 100;
        int mm = this.calendar.get(2) + 1;
        if (this.useMonthlyHistoryFiles) {
            dd = 1;
        }
        return this.getFilePrefix() + this.twoDigitString(yy) + this.twoDigitString(mm) + this.twoDigitString(dd) + "." + Integer.toHexString(this.rcdIdx);
    }

    private int getFilePosition(RandomAccessFile raf) {
        int fpos = -1;
        try {
            if (this.useStandardFileSet) {
                raf.seek(0L);
                fpos = raf.readInt() + 16;
            } else {
                fpos = (int)raf.length();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return fpos;
    }

    private int setFilePosition(RandomAccessFile raf, int fpos) {
        int cc = 0;
        try {
            if (this.useStandardFileSet) {
                raf.seek(0L);
                raf.writeInt(fpos - 16);
                raf.writeInt((int)(System.currentTimeMillis() / 1000L));
            }
        }
        catch (IOException e) {
            cc = -1;
        }
        return cc;
    }

    private int getNumberOfRecords(RandomAccessFile raf) {
        int nrecs = 0;
        try {
            int fpos = 0;
            int rsiz = this.getRecordLength();
            if (this.useStandardFileSet) {
                raf.seek(0L);
                fpos = raf.readInt();
                raf.readInt();
                int sz = raf.readInt();
                if (rsiz != sz) {
                    if (TLinkFactory.debugLevel > 0) {
                        DbgLog.log("getNumberOfRecords", "stored record size is invalid : " + rsiz + " vs " + sz);
                    }
                    nrecs = -1;
                }
            } else {
                fpos = (int)raf.length();
            }
            nrecs = fpos / rsiz;
        }
        catch (IOException e) {
            nrecs = -1;
        }
        return nrecs;
    }

    private double readTimeStamp(RandomAccessFile raf) throws IOException {
        double dt;
        if (!this.useMinimalStorage) {
            dt = raf.readDouble();
            int sstamp = raf.readInt();
            int ustamp = raf.readInt();
        } else {
            dt = raf.readInt();
        }
        return dt;
    }

    private int locateRecordFromLTS(String fileName, double dt) {
        int lts_offset;
        int p1 = lts_offset = this.useStandardFileSet ? 16 : 0;
        int it = 0;
        int rlen = this.getRecordLength();
        if (fileName.startsWith("pi")) {
            lts_offset = 0;
        }
        try {
            String fn = fileHome + "/" + fileName;
            RandomAccessFile raf = new RandomAccessFile(fn, "r");
            int nrecs = this.getNumberOfRecords(raf);
            if (nrecs <= 0) {
                nrecs = 0;
            }
            int p0 = p1 = lts_offset;
            int p2 = (nrecs - 1) * rlen + lts_offset;
            raf.seek(p0);
            double dt0 = this.readTimeStamp(raf);
            if (dt < dt0) {
                p2 = 0;
            }
            raf.seek(p2);
            double dt2 = this.readTimeStamp(raf);
            while (p2 > p0 + rlen) {
                double f;
                double d;
                double dt1 = dt2;
                if (dt > d) {
                    p1 = p2;
                    break;
                }
                while (dt1 > dt0 && (p1 = p0 + rlen * (int)(f = (dt - dt0) / (dt1 - dt0) * ((double)(p2 - p0) / (double)rlen))) < p2) {
                    raf.seek(p1);
                    dt1 = this.readTimeStamp(raf);
                    if (dt1 < dt) break;
                    p2 = p1;
                    dt2 = dt1;
                    ++it;
                }
                dt0 = dt1;
                p0 = p1;
                while (dt2 > dt1 && (p1 = p2 - rlen * (int)(f = (dt2 - dt) / (dt2 - dt1) * ((double)(p2 - p0) / (double)rlen))) > p0) {
                    raf.seek(p1);
                    dt1 = this.readTimeStamp(raf);
                    if (dt1 > dt) break;
                    p0 = p1;
                    dt0 = dt1;
                    ++it;
                }
                p2 = p1;
                dt2 = dt1;
            }
            raf.close();
        }
        catch (Exception e) {
            DbgLog.log("locateRecordFromLTS", e.toString());
        }
        return p1;
    }

    private int getFormattedHistoryDataPoint(Object dataTarget, int position, Object dataSource, int index, double tstmp, int sstmp, int ustmp) {
        if (dataSource instanceof double[]) {
            double[] v = (double[])dataSource;
            return this.getFormattedHistoryDataPoint(dataTarget, position, v[index], tstmp, sstmp, ustmp);
        }
        if (dataSource instanceof float[]) {
            float[] v = (float[])dataSource;
            return this.getFormattedHistoryDataPoint(dataTarget, position, v[index], tstmp, sstmp, ustmp);
        }
        if (dataSource instanceof int[]) {
            int[] v = (int[])dataSource;
            return this.getFormattedHistoryDataPoint(dataTarget, position, v[index], tstmp, sstmp, ustmp);
        }
        if (dataSource instanceof short[]) {
            short[] v = (short[])dataSource;
            return this.getFormattedHistoryDataPoint(dataTarget, position, v[index], tstmp, sstmp, ustmp);
        }
        if (dataSource instanceof byte[]) {
            byte[] v = (byte[])dataSource;
            return this.getFormattedHistoryDataPoint(dataTarget, position, v[index], tstmp, sstmp, ustmp);
        }
        if (dataSource instanceof long[]) {
            long[] v = (long[])dataSource;
            return this.getFormattedHistoryDataPoint(dataTarget, position, v[index], tstmp, sstmp, ustmp);
        }
        if (dataSource instanceof NAME[]) {
            NAME[] n = (NAME[])dataSource;
            return this.getFormattedHistoryDataPoint(dataTarget, position, n[index].getName(), tstmp, sstmp, ustmp);
        }
        if (dataSource instanceof TCompoundDataObject[]) {
            TCompoundDataObject[] cdo = (TCompoundDataObject[])dataSource;
            return this.getFormattedHistoryDataPoint(dataTarget, position, cdo[index], tstmp, sstmp, ustmp);
        }
        return 2;
    }

    private int getFormattedHistoryDataPoint(Object dataTarget, int number, double[] v, NAME[] n, TCompoundDataObject[] cdo, int index, double tstmp, int sstmp, int ustmp) {
        if (v != null) {
            return this.getFormattedHistoryDataPoint(dataTarget, number, v[index], tstmp, sstmp, ustmp);
        }
        if (n != null) {
            return this.getFormattedHistoryDataPoint(dataTarget, number, n[index].getName(), tstmp, sstmp, ustmp);
        }
        if (cdo != null) {
            return this.getFormattedHistoryDataPoint(dataTarget, number, cdo[index], tstmp, sstmp, ustmp);
        }
        return 2;
    }

    private int getFormattedHistoryDataPoint(Object dataTarget, int number, double v, double tstmp, int sstmp, int ustmp) {
        int fmt = dataTarget instanceof HISTORY[] ? 56 : (int)TDataType.getObjectFormat(dataTarget);
        block0 : switch (fmt) {
            case 56: {
                switch (((HISTORY[])dataTarget)[0].getCarriedFormat()) {
                    case 5: {
                        ((HISTORY[])dataTarget)[number] = new HISTORY(tstmp, (float)v, sstmp, ustmp);
                        break block0;
                    }
                    case 0: {
                        ((HISTORY[])dataTarget)[number] = new HISTORY(tstmp, v, sstmp, ustmp);
                        break block0;
                    }
                    case 3: {
                        ((HISTORY[])dataTarget)[number] = new HISTORY(tstmp, (int)v, sstmp, ustmp);
                        break block0;
                    }
                    case 6: {
                        ((HISTORY[])dataTarget)[number] = new HISTORY(tstmp, (long)v, sstmp, ustmp);
                        break block0;
                    }
                }
                return -2;
            }
            case 5: {
                ((float[])dataTarget)[number] = (float)v;
                break;
            }
            case 14: {
                if (((FLTINT[])dataTarget)[number] == null) {
                    ((FLTINT[])dataTarget)[number] = new FLTINT();
                }
                ((FLTINT[])dataTarget)[number].ival = (int)tstmp;
                ((FLTINT[])dataTarget)[number].fval = (float)v;
                break;
            }
            case 18: {
                if (((INTFLTINT[])dataTarget)[number] == null) {
                    ((INTFLTINT[])dataTarget)[number] = new INTFLTINT();
                }
                ((INTFLTINT[])dataTarget)[number].i1val = (int)tstmp;
                ((INTFLTINT[])dataTarget)[number].fval = (float)v;
                break;
            }
            case 3: {
                ((int[])dataTarget)[number] = (int)v;
                break;
            }
            case 6: {
                ((long[])dataTarget)[number] = (long)v;
                break;
            }
            case 15: {
                if (((INTINT[])dataTarget)[number] == null) {
                    ((INTINT[])dataTarget)[number] = new INTINT();
                }
                ((INTINT[])dataTarget)[number].i2val = (int)tstmp;
                ((INTINT[])dataTarget)[number].i1val = (int)v;
                break;
            }
            case 0: {
                ((double[])dataTarget)[number] = v;
                break;
            }
            case 40: {
                if (((DBLDBL[])dataTarget)[number] == null) {
                    ((DBLDBL[])dataTarget)[number] = new DBLDBL();
                }
                ((DBLDBL[])dataTarget)[number].d2val = tstmp;
                ((DBLDBL[])dataTarget)[number].d1val = v;
                break;
            }
            case 26: 
            case 45: 
            case 48: 
            case 49: {
                break;
            }
            default: {
                return -2;
            }
        }
        return 0;
    }

    private int getFormattedHistoryDataPoint(Object dataTarget, int number, String n, double tstmp, int sstmp, int ustmp) {
        block0 : switch (TDataType.getObjectFormat(dataTarget)) {
            case 56: {
                switch (((HISTORY[])dataTarget)[0].getCarriedFormat()) {
                    case 9: {
                        NAME16 n16 = new NAME16(n);
                        ((HISTORY[])dataTarget)[number] = new HISTORY(tstmp, n16, sstmp, ustmp);
                        break block0;
                    }
                    case 13: {
                        NAME32 n32 = new NAME32(n);
                        ((HISTORY[])dataTarget)[number] = new HISTORY(tstmp, n32, sstmp, ustmp);
                        break block0;
                    }
                    case 36: {
                        NAME64 n64 = new NAME64(n);
                        ((HISTORY[])dataTarget)[number] = new HISTORY(tstmp, n64, sstmp, ustmp);
                        break block0;
                    }
                }
                return -2;
            }
            case 21: {
                if (((NAME16I[])dataTarget)[number] == null) {
                    ((NAME16I[])dataTarget)[number] = new NAME16I();
                }
                ((NAME16I[])dataTarget)[number].ival = (int)tstmp;
                ((NAME16I[])dataTarget)[number].name = n;
                break;
            }
            case 22: {
                if (((NAME32I[])dataTarget)[number] == null) {
                    ((NAME32I[])dataTarget)[number] = new NAME32I();
                }
                ((NAME32I[])dataTarget)[number].ival = (int)tstmp;
                ((NAME32I[])dataTarget)[number].name = n;
                break;
            }
            case 37: {
                if (((NAME64I[])dataTarget)[number] == null) {
                    ((NAME64I[])dataTarget)[number] = new NAME64I();
                }
                ((NAME64I[])dataTarget)[number].ival = (int)tstmp;
                ((NAME64I[])dataTarget)[number].name = n;
                break;
            }
            case 45: 
            case 49: {
                break;
            }
            default: {
                return -2;
            }
        }
        return 0;
    }

    private int getFormattedHistoryDataPoint(Object dataTarget, int number, TCompoundDataObject cdo, double tstmp, int sstmp, int ustmp) {
        float f = 0.0f;
        double d1 = 0.0;
        String n = "";
        switch (TDataType.getObjectFormat(dataTarget)) {
            case 56: {
                short dfmt;
                if (cdo == null) break;
                short sfmt = cdo.getFormat();
                if (sfmt != (dfmt = ((HISTORY[])dataTarget)[0].getCarriedFormat())) {
                    return -2;
                }
                ((HISTORY[])dataTarget)[number] = new HISTORY(tstmp, cdo, sstmp, ustmp);
                break;
            }
            case 26: {
                if (cdo != null) {
                    if (cdo instanceof FLTINT) {
                        FLTINT d = (FLTINT)cdo;
                        f = d.fval;
                    } else if (cdo instanceof INTINT) {
                        INTINT d = (INTINT)cdo;
                        f = d.i1val;
                    } else if (cdo instanceof DBLDBL) {
                        DBLDBL d = (DBLDBL)cdo;
                        f = (float)d.d1val;
                    }
                } else {
                    return -2;
                }
                if (((FLTINTINT[])dataTarget)[number] == null) {
                    ((FLTINTINT[])dataTarget)[number] = new FLTINTINT();
                }
                ((FLTINTINT[])dataTarget)[number].setValues(f, (int)tstmp, sstmp);
                break;
            }
            case 48: {
                if (cdo != null) {
                    TCompoundDataObject d;
                    if (cdo instanceof FLTINT) {
                        d = (FLTINT)cdo;
                        d1 = d.fval;
                    }
                    if (cdo instanceof FLTFLT) {
                        d = (FLTFLT)cdo;
                        d1 = ((FLTFLT)d).f1val;
                    } else if (cdo instanceof INTINT) {
                        d = (INTINT)cdo;
                        d1 = ((INTINT)d).i1val;
                    } else if (cdo instanceof DBLDBL) {
                        d = (DBLDBL)cdo;
                        d1 = ((DBLDBL)d).d1val;
                    }
                } else {
                    return -2;
                }
                if (((DBLDBLDBL[])dataTarget)[number] == null) {
                    ((DBLDBLDBL[])dataTarget)[number] = new DBLDBLDBL();
                }
                ((DBLDBLDBL[])dataTarget)[number].setValues(d1, tstmp, sstmp);
                break;
            }
            case 45: {
                if (cdo != null) {
                    if (cdo instanceof NAMEINT) {
                        NAMEINT d = (NAMEINT)((Object)cdo);
                        n = d.name;
                        d1 = d.ival;
                    } else if (cdo instanceof NAME64DBL) {
                        NAME64DBL d = (NAME64DBL)cdo;
                        n = d.name;
                        d1 = d.dval;
                    }
                } else {
                    return -2;
                }
                if (((NAME64DBLDBL[])dataTarget)[number] == null) {
                    ((NAME64DBLDBL[])dataTarget)[number] = new NAME64DBLDBL();
                }
                ((NAME64DBLDBL[])dataTarget)[number].setValues(n, tstmp, sstmp);
            }
        }
        return 0;
    }

    private int getFormattedHistoryDataSet(Object dataTarget, double[] v, NAME[] n, TCompoundDataObject[] cdo, double tstmp, int sstmp, int ustmp) {
        if (v != null) {
            return this.getFormattedHistoryDataSet(dataTarget, v, tstmp, sstmp, ustmp);
        }
        if (n != null) {
            return this.getFormattedHistoryDataSet(dataTarget, n, tstmp, sstmp, ustmp);
        }
        return this.getFormattedHistoryDataSet(dataTarget, cdo, tstmp, sstmp, ustmp);
    }

    private int getFormattedHistoryDataSet(Object dataTarget, double[] v, double tstmp, int sstmp, int ustmp) {
        int number = TDataType.getObjectSize(dataTarget);
        if (number > v.length) {
            number = v.length;
        }
        switch (TDataType.getObjectFormat(dataTarget)) {
            case 5: {
                for (int i = 0; i < number; ++i) {
                    ((float[])dataTarget)[i] = (float)v[i];
                }
                return number;
            }
            case 3: {
                for (int i = 0; i < number; ++i) {
                    ((int[])dataTarget)[i] = (int)v[i];
                }
                return number;
            }
            case 6: {
                for (int i = 0; i < number; ++i) {
                    ((long[])dataTarget)[i] = (long)v[i];
                }
                return number;
            }
            case 0: {
                for (int i = 0; i < number; ++i) {
                    ((double[])dataTarget)[i] = v[i];
                }
                return number;
            }
        }
        return 0;
    }

    private int getFormattedHistoryDataSet(Object dataTarget, NAME[] n, double tstmp, int sstmp, int ustmp) {
        int number = TDataType.getObjectSize(dataTarget);
        if (number > n.length) {
            number = n.length;
        }
        if (TDataType.getObjectFormat(dataTarget) != TDataType.getObjectFormat(n)) {
            return -2;
        }
        for (int i = 0; i < number; ++i) {
            ((NAME[])dataTarget)[i] = n[i];
        }
        return number;
    }

    private int getFormattedHistoryDataSet(Object dataTarget, TCompoundDataObject[] cdo, double tstmp, int sstmp, int ustmp) {
        int number = TDataType.getObjectSize(dataTarget);
        if (number > cdo.length) {
            number = cdo.length;
        }
        if (TDataType.getObjectFormat(dataTarget) != TDataType.getObjectFormat(cdo)) {
            return -2;
        }
        for (int i = 0; i < number; ++i) {
            ((TCompoundDataObject[])dataTarget)[i] = cdo[i];
        }
        return number;
    }

    private int loadLTSData(String fileName, int index, long timestampStart, long timestampEnd, float lwrLimit, float uprLimit, Object dataTarget, int arraysize, int arrayoffset, int sample) {
        short targetFmt;
        int pstart;
        int depth = this.hspec.getDepthLong();
        if (arraysize < 1) {
            return 0;
        }
        if (depth <= 0) {
            return 0;
        }
        long tnow = System.currentTimeMillis();
        if (tnow - timestampStart < (long)this.hspec.getDepthShort()) {
            return 0;
        }
        if (index < 0 || index >= this.getArraySize()) {
            return -63;
        }
        double dstarttime = (double)timestampStart / 1000.0;
        double dendtime = (double)timestampEnd / 1000.0;
        double dtnow = (double)tnow / 1000.0;
        double datatime = 0.0;
        double dlaststamp = -1.0;
        int raster = 1;
        boolean timebin = true;
        int number = 0;
        int sstamp = 0;
        int ustamp = 0;
        boolean isSnapshot = false;
        boolean hasPointsOfInterest = false;
        boolean isPointsOfInterestFile = false;
        String poiName = null;
        if (!fileName.startsWith("pi")) {
            poiName = fileName.replace(fileName.substring(0, 2), "pi");
            if (new File(fileHome + "/" + poiName).exists()) {
                hasPointsOfInterest = true;
            }
        } else {
            isPointsOfInterestFile = true;
        }
        if (dendtime < dstarttime) {
            dendtime = dtnow;
        }
        if ((pstart = this.locateRecordFromLTS(fileName, dstarttime)) < 0) {
            return number;
        }
        int pstop = this.locateRecordFromLTS(fileName, dendtime);
        if (pstop < 0) {
            return number;
        }
        isSnapshot = dendtime - dstarttime < 0.01;
        int rlen = this.getRecordLength();
        int hlen = this.getRecordPrefixLength();
        int nrecs = (pstop - pstart) / rlen;
        if (arraysize == 1) {
            if (isPointsOfInterestFile) {
                return 0;
            }
            this.lastReadTimestamp = timestampEnd;
            return nrecs > 0 ? nrecs : 0;
        }
        if ((arraysize -= arrayoffset) < nrecs) {
            raster += nrecs / (arraysize + 1);
        }
        if (raster > 1 && isPointsOfInterestFile) {
            return 0;
        }
        if (sample > 0) {
            raster = sample;
        }
        if (raster == 1) {
            hasPointsOfInterest = false;
        }
        if ((targetFmt = TDataType.getObjectFormat(dataTarget)) == 255) {
            return -2;
        }
        if (isSnapshot) {
            index = 0;
            datatime = dstarttime - (double)timebin;
        } else if (nrecs == 0) {
            return 0;
        }
        try {
            int cnt = 0;
            double dts = 0.0;
            short sourceFmt = this.getFmt();
            String sourceTag = this.getTag();
            double[] dv = null;
            NAME[] nv = null;
            TCompoundDataObject[] cdo = null;
            int nsiz = TFormat.formatSizeOf(sourceFmt);
            String fn = fileHome + "/" + fileName;
            RandomAccessFile raf = new RandomAccessFile(fn, "r");
            long flen = raf.length();
            raf.seek(pstart);
            while (raf.getFilePointer() < flen) {
                if (!this.useMinimalStorage) {
                    dts = raf.readDouble();
                    sstamp = raf.readInt();
                    ustamp = raf.readInt();
                } else {
                    dts = raf.readInt();
                }
                if (hasPointsOfInterest && dlaststamp > 0.0 && dts > dlaststamp - 2.0) {
                    long poiStart = (long)(dlaststamp * 1000.0) + 500L;
                    long poiStop = (long)(dts * 1000.0) - 500L;
                    int poisize = arraysize < 2 ? arraysize : 2;
                    int n = this.loadLTSData(poiName, index, poiStart, poiStop, lwrLimit, uprLimit, dataTarget, poisize, arrayoffset + number, 1);
                    if (n > 0) {
                        number += n;
                    }
                    if (number >= arraysize) break;
                }
                ++cnt;
                if (isSnapshot && dts > dendtime) {
                    dendtime = dts;
                }
                if (dts > dendtime) {
                    return number;
                }
                if (dts < datatime + (double)timebin / 1000.0) {
                    raf.seek(raf.getFilePointer() + (long)rlen - (long)hlen);
                    continue;
                }
                datatime = dts;
                switch (sourceFmt) {
                    case 0: {
                        int i;
                        if (dv == null) {
                            dv = new double[this.siz];
                        }
                        for (i = 0; i < this.siz; ++i) {
                            dv[i] = raf.readDouble();
                        }
                        break;
                    }
                    case 5: {
                        int i;
                        if (dv == null) {
                            dv = new double[this.siz];
                        }
                        for (i = 0; i < this.siz; ++i) {
                            dv[i] = raf.readFloat();
                        }
                        break;
                    }
                    case 6: {
                        int i;
                        if (dv == null) {
                            dv = new double[this.siz];
                        }
                        for (i = 0; i < this.siz; ++i) {
                            dv[i] = raf.readLong();
                        }
                        break;
                    }
                    case 3: {
                        int i;
                        if (dv == null) {
                            dv = new double[this.siz];
                        }
                        for (i = 0; i < this.siz; ++i) {
                            dv[i] = raf.readInt();
                        }
                        break;
                    }
                    case 1: {
                        int i;
                        if (dv == null) {
                            dv = new double[this.siz];
                        }
                        for (i = 0; i < this.siz; ++i) {
                            dv[i] = raf.readShort();
                        }
                        break;
                    }
                    case 2: {
                        int i;
                        if (dv == null) {
                            dv = new double[this.siz];
                        }
                        for (i = 0; i < this.siz; ++i) {
                            dv[i] = raf.readByte();
                        }
                        break;
                    }
                    case 9: 
                    case 13: 
                    case 36: {
                        if (nv == null) {
                            nv = new NAME[this.siz];
                        }
                        byte[] b = new byte[nsiz];
                        for (int i = 0; i < this.siz; ++i) {
                            nv[i] = new NAME(nsiz);
                            raf.read(b, 0, nsiz);
                            nv[i].setName(b);
                        }
                        break;
                    }
                    default: {
                        if (cdo != null) break;
                        cdo = TFormat.makeCompoundDataObjectArray(sourceFmt, sourceTag, this.siz);
                    }
                }
                if (cdo != null) {
                    for (int i = 0; i < this.siz; ++i) {
                        raf.read(cdo[i].getByteArray(), 0, nsiz);
                        cdo[i].toStruct();
                    }
                }
                if (isSnapshot) {
                    number = this.getFormattedHistoryDataSet(dataTarget, dv, nv, cdo, dts, sstamp, ustamp);
                    break;
                }
                int cc = this.getFormattedHistoryDataPoint(dataTarget, number + arrayoffset, dv, nv, cdo, index, dts, sstamp, ustamp);
                if (cc < 0) {
                    number = cc;
                    break;
                }
                if (sample < 0 && dv != null && !this.isInRange((float)dv[index], lwrLimit, uprLimit)) continue;
                if (++number >= arraysize) break;
                if (raster > 1) {
                    raf.seek(raf.getFilePointer() + (long)(rlen * (raster - 1)));
                }
                dlaststamp = dts;
            }
            raf.close();
            if (datatime > 0.0) {
                this.lastReadTimestamp = (long)(datatime * 1000.0);
            }
            return number;
        }
        catch (Exception e) {
            TFecLog.log("Error reading history record : " + e.toString());
            return -21;
        }
    }

    public int getDataFromSTS(int index, long starttime, long endtime, float lwrLimit, float uprLimit, Object targetData, int arraysize, int arrayOffset, int sample) {
        int num;
        int depth = this.hspec.getDepthShort();
        int raster = 1;
        int rnumber = 0;
        int prate = this.hspec.getPollngRate();
        this.lastReadTimestamp = 0L;
        if (prate == 0) {
            return 0;
        }
        if (depth == 0) {
            return -12;
        }
        if (index >= this.siz) {
            return -37;
        }
        if (arraysize < 1) {
            return -25;
        }
        if (starttime < endtime - (long)(depth * prate)) {
            starttime = endtime - (long)(depth * prate);
        }
        if ((raster = (int)((endtime - starttime) / (long)(prate * arraysize))) < 1) {
            raster = 1;
        }
        if (arraysize == 1) {
            raster = 1;
        }
        boolean isSnapshot = starttime == endtime;
        int n = this.rngPtr;
        n = (n + raster + depth) % depth;
        if ((long)arraysize == endtime - starttime && arraysize <= (num = depth)) {
            n = (n + (num - arraysize) + depth) % depth;
            starttime = this.timestamp[n];
            endtime = System.currentTimeMillis();
        }
        this.lastReadTimestamp = starttime;
        int number = arrayOffset;
        for (int cnt = 0; number < arraysize && number <= depth && cnt < depth; cnt += raster) {
            long thistimestamp = this.timestamp[n];
            n = (n + raster + depth) % depth;
            if (thistimestamp < this.lastReadTimestamp || thistimestamp > endtime) continue;
            this.lastReadTimestamp = thistimestamp;
            ++rnumber;
            if (arraysize < 2) continue;
            double[] dv = this.getDoubleArrayAtPosition(n);
            NAME[] nv = this.getNAMEArrayAtPosition(n);
            TCompoundDataObject[] cdo = this.getCompoundArrayAtPosition(n);
            double dts = (double)thistimestamp / 1000.0;
            if (isSnapshot) {
                number = this.getFormattedHistoryDataSet(targetData, dv, nv, cdo, dts, this.sysstamp[n], this.usrstamp[n]);
                break;
            }
            int cc = this.getFormattedHistoryDataPoint(targetData, number, dv, nv, cdo, index, dts, this.sysstamp[n], this.usrstamp[n]);
            if (cc < 0) {
                number = cc;
                break;
            }
            if (sample < 0 && dv != null && !this.isInRange((float)dv[index], lwrLimit, uprLimit)) continue;
            ++number;
        }
        if (!isSnapshot && arraysize < 2) {
            this.assignNumberOfPoints(targetData, rnumber);
        }
        return number;
    }

    private void assignNumberOfPoints(Object data, int numberOfPoints) {
        if (data instanceof float[]) {
            ((float[])data)[0] = numberOfPoints;
        } else if (data instanceof FLTINT[]) {
            if (((FLTINT[])data)[0] == null) {
                ((FLTINT[])data)[0] = new FLTINT();
            }
            ((FLTINT[])data)[0].ival = numberOfPoints;
            ((FLTINT[])data)[0].fval = numberOfPoints;
        } else if (data instanceof INTFLTINT[]) {
            if (((INTFLTINT[])data)[0] == null) {
                ((INTFLTINT[])data)[0] = new INTFLTINT();
            }
            ((INTFLTINT[])data)[0].i1val = numberOfPoints;
            ((INTFLTINT[])data)[0].fval = numberOfPoints;
            ((INTFLTINT[])data)[0].i2val = numberOfPoints;
        } else if (data instanceof FLTINTINT[]) {
            if (((FLTINTINT[])data)[0] == null) {
                ((FLTINTINT[])data)[0] = new FLTINTINT();
            }
            ((FLTINTINT[])data)[0].i1val = numberOfPoints;
            ((FLTINTINT[])data)[0].i2val = numberOfPoints;
            ((FLTINTINT[])data)[0].f1val = numberOfPoints;
        } else if (data instanceof int[]) {
            ((int[])data)[0] = numberOfPoints;
        } else if (data instanceof INTINT[]) {
            if (((INTINT[])data)[0] == null) {
                ((INTINT[])data)[0] = new INTINT();
            }
            ((INTINT[])data)[0].i2val = numberOfPoints;
            ((INTINT[])data)[0].i1val = numberOfPoints;
        } else if (data instanceof double[]) {
            ((double[])data)[0] = numberOfPoints;
        } else if (data instanceof DBLDBL[]) {
            if (((DBLDBL[])data)[0] == null) {
                ((DBLDBL[])data)[0] = new DBLDBL();
            }
            ((DBLDBL[])data)[0].d2val = numberOfPoints;
            ((DBLDBL[])data)[0].d1val = numberOfPoints;
        } else if (data instanceof NAME16I[]) {
            if (((NAME16I[])data)[0] == null) {
                ((NAME16I[])data)[0] = new NAME16I();
            }
            ((NAME16I[])data)[0].ival = numberOfPoints;
            ((NAME16I[])data)[0].name = "";
        } else if (data instanceof NAME32I[]) {
            if (((NAME32I[])data)[0] == null) {
                ((NAME32I[])data)[0] = new NAME32I();
            }
            ((NAME32I[])data)[0].ival = numberOfPoints;
            ((NAME32I[])data)[0].name = "";
        } else if (data instanceof NAME64I[]) {
            if (((NAME64I[])data)[0] == null) {
                ((NAME64I[])data)[0] = new NAME64I();
            }
            ((NAME64I[])data)[0].ival = numberOfPoints;
            ((NAME64I[])data)[0].name = "";
        }
    }

    private boolean isInRange(float value, float lower, float upper) {
        if (value < lower) {
            return false;
        }
        return !(value > upper);
    }

    public float getFloatValueAtPosition(int ptr, int index) {
        if (index < 0 || index >= this.siz) {
            return -1.0f;
        }
        if (ptr < 0 || ptr >= this.hspec.getDepthShort()) {
            return -1.0f;
        }
        if (this.rngBuffer instanceof float[]) {
            return ((float[])this.rngBuffer)[ptr * this.siz + index];
        }
        if (this.rngBuffer instanceof byte[]) {
            return ((byte[])this.rngBuffer)[ptr * this.siz + index];
        }
        if (this.rngBuffer instanceof short[]) {
            return ((short[])this.rngBuffer)[ptr * this.siz + index];
        }
        if (this.rngBuffer instanceof int[]) {
            return ((int[])this.rngBuffer)[ptr * this.siz + index];
        }
        if (this.rngBuffer instanceof double[]) {
            return (float)((double[])this.rngBuffer)[ptr * this.siz + index];
        }
        return -1.0f;
    }

    public double getDoubleValueAtPosition(int ptr, int index) {
        if (index < 0 || index >= this.siz) {
            return -1.0;
        }
        if (ptr < 0 || ptr >= this.hspec.getDepthShort()) {
            return -1.0;
        }
        if (this.rngBuffer instanceof double[]) {
            return ((double[])this.rngBuffer)[ptr * this.siz + index];
        }
        if (this.rngBuffer instanceof byte[]) {
            return ((byte[])this.rngBuffer)[ptr * this.siz + index];
        }
        if (this.rngBuffer instanceof short[]) {
            return ((short[])this.rngBuffer)[ptr * this.siz + index];
        }
        if (this.rngBuffer instanceof int[]) {
            return ((int[])this.rngBuffer)[ptr * this.siz + index];
        }
        if (this.rngBuffer instanceof float[]) {
            return ((float[])this.rngBuffer)[ptr * this.siz + index];
        }
        return -1.0;
    }

    public int getLongValueAtPosition(int ptr, int index) {
        if (index < 0 || index >= this.siz) {
            return -1;
        }
        if (ptr < 0 || ptr >= this.hspec.getDepthShort()) {
            return -1;
        }
        if (this.rngBuffer instanceof int[]) {
            return ((int[])this.rngBuffer)[ptr * this.siz + index];
        }
        if (this.rngBuffer instanceof byte[]) {
            return ((byte[])this.rngBuffer)[ptr * this.siz + index];
        }
        if (this.rngBuffer instanceof short[]) {
            return ((short[])this.rngBuffer)[ptr * this.siz + index];
        }
        if (this.rngBuffer instanceof double[]) {
            return (int)((double[])this.rngBuffer)[ptr * this.siz + index];
        }
        if (this.rngBuffer instanceof float[]) {
            return (int)((float[])this.rngBuffer)[ptr * this.siz + index];
        }
        return -1;
    }

    public short getShortValueAtPosition(int ptr, int index) {
        if (index < 0 || index >= this.siz) {
            return -1;
        }
        if (ptr < 0 || ptr >= this.hspec.getDepthShort()) {
            return -1;
        }
        if (this.rngBuffer instanceof byte[]) {
            return ((byte[])this.rngBuffer)[ptr * this.siz + index];
        }
        if (this.rngBuffer instanceof short[]) {
            return ((short[])this.rngBuffer)[ptr * this.siz + index];
        }
        if (this.rngBuffer instanceof int[]) {
            return (short)((int[])this.rngBuffer)[ptr * this.siz + index];
        }
        if (this.rngBuffer instanceof double[]) {
            return (short)((double[])this.rngBuffer)[ptr * this.siz + index];
        }
        if (this.rngBuffer instanceof float[]) {
            return (short)((float[])this.rngBuffer)[ptr * this.siz + index];
        }
        return -1;
    }

    public NAME16 getNAME16ValueAtPosition(int ptr, int index) {
        if (index < 0 || index >= this.siz) {
            return null;
        }
        if (ptr < 0 || ptr >= this.hspec.getDepthShort()) {
            return null;
        }
        if (this.rngBuffer instanceof NAME16[]) {
            return ((NAME16[])this.rngBuffer)[ptr * this.siz + index];
        }
        if (this.rngBuffer instanceof NAME32[]) {
            return new NAME16(((NAME32[])this.rngBuffer)[ptr * this.siz + index].toString());
        }
        if (this.rngBuffer instanceof NAME64[]) {
            return new NAME16(((NAME64[])this.rngBuffer)[ptr * this.siz + index].toString());
        }
        return null;
    }

    public NAME32 getNAME32ValueAtPosition(int ptr, int index) {
        if (index < 0 || index >= this.siz) {
            return null;
        }
        if (ptr < 0 || ptr >= this.hspec.getDepthShort()) {
            return null;
        }
        if (this.rngBuffer instanceof NAME32[]) {
            return ((NAME32[])this.rngBuffer)[ptr * this.siz + index];
        }
        if (this.rngBuffer instanceof NAME16[]) {
            return new NAME32(((NAME16[])this.rngBuffer)[ptr * this.siz + index].toString());
        }
        if (this.rngBuffer instanceof NAME64[]) {
            return new NAME32(((NAME64[])this.rngBuffer)[ptr * this.siz + index].toString());
        }
        return null;
    }

    public NAME64 getNAME64ValueAtPosition(int ptr, int index) {
        if (index < 0 || index >= this.siz) {
            return null;
        }
        if (ptr < 0 || ptr >= this.hspec.getDepthShort()) {
            return null;
        }
        if (this.rngBuffer instanceof NAME64[]) {
            return ((NAME64[])this.rngBuffer)[ptr * this.siz + index];
        }
        if (this.rngBuffer instanceof NAME16[]) {
            return new NAME64(((NAME16[])this.rngBuffer)[ptr * this.siz + index].toString());
        }
        if (this.rngBuffer instanceof NAME32[]) {
            return new NAME64(((NAME32[])this.rngBuffer)[ptr * this.siz + index].toString());
        }
        return null;
    }

    public TCompoundDataObject[] getCompoundArrayAtPosition(int ptr) {
        TCompoundDataObject[] values = new TCompoundDataObject[this.siz];
        if (this.rngBuffer instanceof TCompoundDataObject[]) {
            for (int i = 0; i < this.siz; ++i) {
                values[i] = ((TCompoundDataObject[])this.rngBuffer)[ptr * this.siz + i];
            }
            return values;
        }
        return null;
    }

    public NAME[] getNAMEArrayAtPosition(int ptr) {
        NAME[] values = new NAME[this.siz];
        if (this.rngBuffer instanceof NAME64[]) {
            for (int i = 0; i < this.siz; ++i) {
                values[i] = ((NAME64[])this.rngBuffer)[ptr * this.siz + i];
            }
            return values;
        }
        if (this.rngBuffer instanceof NAME16[]) {
            for (int i = 0; i < this.siz; ++i) {
                values[i] = ((NAME16[])this.rngBuffer)[ptr * this.siz + i];
            }
            return values;
        }
        if (this.rngBuffer instanceof NAME32[]) {
            for (int i = 0; i < this.siz; ++i) {
                values[i] = ((NAME32[])this.rngBuffer)[ptr * this.siz + i];
            }
            return values;
        }
        return null;
    }

    public float[] getFloatArrayAtPosition(int ptr) {
        float[] values = new float[this.siz];
        if (this.rngBuffer instanceof float[]) {
            System.arraycopy((float[])this.rngBuffer, ptr * this.siz, values, 0, this.siz);
        } else if (this.rngBuffer instanceof byte[]) {
            for (int i = 0; i < this.siz; ++i) {
                values[i] = ((byte[])this.rngBuffer)[ptr * this.siz + i];
            }
        } else if (this.rngBuffer instanceof short[]) {
            for (int i = 0; i < this.siz; ++i) {
                values[i] = ((short[])this.rngBuffer)[ptr * this.siz + i];
            }
        } else if (this.rngBuffer instanceof int[]) {
            for (int i = 0; i < this.siz; ++i) {
                values[i] = ((int[])this.rngBuffer)[ptr * this.siz + i];
            }
        } else if (this.rngBuffer instanceof double[]) {
            for (int i = 0; i < this.siz; ++i) {
                values[i] = (float)((double[])this.rngBuffer)[ptr * this.siz + i];
            }
        } else {
            return null;
        }
        return values;
    }

    public double[] getDoubleArrayAtPosition(int ptr) {
        double[] values = new double[this.siz];
        if (this.rngBuffer instanceof double[]) {
            System.arraycopy((double[])this.rngBuffer, ptr * this.siz, values, 0, this.siz);
        } else if (this.rngBuffer instanceof byte[]) {
            for (int i = 0; i < this.siz; ++i) {
                values[i] = ((byte[])this.rngBuffer)[ptr * this.siz + i];
            }
        } else if (this.rngBuffer instanceof short[]) {
            for (int i = 0; i < this.siz; ++i) {
                values[i] = ((short[])this.rngBuffer)[ptr * this.siz + i];
            }
        } else if (this.rngBuffer instanceof int[]) {
            for (int i = 0; i < this.siz; ++i) {
                values[i] = ((int[])this.rngBuffer)[ptr * this.siz + i];
            }
        } else if (this.rngBuffer instanceof float[]) {
            for (int i = 0; i < this.siz; ++i) {
                values[i] = ((float[])this.rngBuffer)[ptr * this.siz + i];
            }
        } else if (this.rngBuffer instanceof TCompoundDataObject[]) {
            for (int i = 0; i < this.siz; ++i) {
                values[i] = ((TCompoundDataObject[])this.rngBuffer)[ptr * this.siz + i].getDoubleValue();
            }
        } else {
            return null;
        }
        return values;
    }

    public int[] getLongArrayAtPosition(int ptr) {
        int[] values = new int[this.siz];
        if (this.rngBuffer instanceof int[]) {
            System.arraycopy((int[])this.rngBuffer, ptr * this.siz, values, 0, this.siz);
        } else if (this.rngBuffer instanceof short[]) {
            for (int i = 0; i < this.siz; ++i) {
                values[i] = ((short[])this.rngBuffer)[ptr * this.siz + i];
            }
        } else if (this.rngBuffer instanceof byte[]) {
            for (int i = 0; i < this.siz; ++i) {
                values[i] = ((byte[])this.rngBuffer)[ptr * this.siz + i];
            }
        } else if (this.rngBuffer instanceof double[]) {
            for (int i = 0; i < this.siz; ++i) {
                values[i] = (int)((double[])this.rngBuffer)[ptr * this.siz + i];
            }
        } else if (this.rngBuffer instanceof float[]) {
            for (int i = 0; i < this.siz; ++i) {
                values[i] = (int)((float[])this.rngBuffer)[ptr * this.siz + i];
            }
        } else {
            return null;
        }
        return values;
    }

    public short[] getShortArrayAtPosition(int ptr) {
        short[] values = new short[this.siz];
        if (this.rngBuffer instanceof short[]) {
            System.arraycopy((short[])this.rngBuffer, ptr * this.siz, values, 0, this.siz);
        } else if (this.rngBuffer instanceof byte[]) {
            for (int i = 0; i < this.siz; ++i) {
                values[i] = ((byte[])this.rngBuffer)[ptr * this.siz + i];
            }
        } else if (this.rngBuffer instanceof int[]) {
            for (int i = 0; i < this.siz; ++i) {
                values[i] = (short)((int[])this.rngBuffer)[ptr * this.siz + i];
            }
        } else if (this.rngBuffer instanceof double[]) {
            for (int i = 0; i < this.siz; ++i) {
                values[i] = (short)((double[])this.rngBuffer)[ptr * this.siz + i];
            }
        } else if (this.rngBuffer instanceof float[]) {
            for (int i = 0; i < this.siz; ++i) {
                values[i] = (short)((float[])this.rngBuffer)[ptr * this.siz + i];
            }
        } else {
            return null;
        }
        return values;
    }

    public NAME16[] getNAME16ArrayAtPosition(int ptr) {
        int i;
        NAME16[] values = new NAME16[this.siz];
        if (this.rngBuffer instanceof NAME16[]) {
            for (i = 0; i < this.siz; ++i) {
                values[i] = new NAME16(((NAME16[])this.rngBuffer)[i].toString());
            }
        }
        if (this.rngBuffer instanceof NAME32[]) {
            for (i = 0; i < this.siz; ++i) {
                values[i] = new NAME16(((NAME32[])this.rngBuffer)[i].toString());
            }
        }
        if (this.rngBuffer instanceof NAME64[]) {
            for (i = 0; i < this.siz; ++i) {
                values[i] = new NAME16(((NAME64[])this.rngBuffer)[i].toString());
            }
        }
        return values;
    }

    public NAME32[] getNAME32ArrayAtPosition(int ptr) {
        int i;
        NAME32[] values = new NAME32[this.siz];
        if (this.rngBuffer instanceof NAME16[]) {
            for (i = 0; i < this.siz; ++i) {
                values[i] = new NAME32(((NAME16[])this.rngBuffer)[ptr * this.siz + i].toString());
            }
        }
        if (this.rngBuffer instanceof NAME32[]) {
            for (i = 0; i < this.siz; ++i) {
                values[i] = new NAME32(((NAME32[])this.rngBuffer)[ptr * this.siz + i].toString());
            }
        }
        if (this.rngBuffer instanceof NAME64[]) {
            for (i = 0; i < this.siz; ++i) {
                values[i] = new NAME32(((NAME64[])this.rngBuffer)[ptr * this.siz + i].toString());
            }
        }
        return values;
    }

    public NAME64[] getNAME64ArrayAtPosition(int ptr) {
        int i;
        NAME64[] values = new NAME64[this.siz];
        if (this.rngBuffer instanceof NAME16[]) {
            for (i = 0; i < this.siz; ++i) {
                values[i] = new NAME64(((NAME16[])this.rngBuffer)[ptr * this.siz + i].toString());
            }
        }
        if (this.rngBuffer instanceof NAME32[]) {
            for (i = 0; i < this.siz; ++i) {
                values[i] = new NAME64(((NAME32[])this.rngBuffer)[ptr * this.siz + i].toString());
            }
        }
        if (this.rngBuffer instanceof NAME64[]) {
            for (i = 0; i < this.siz; ++i) {
                values[i] = new NAME64(((NAME64[])this.rngBuffer)[ptr * this.siz + i].toString());
            }
        }
        return values;
    }

    public int writeRecordToSTS(TDataType d) {
        Object values = d.getDataObject();
        this.rngPtr = (this.rngPtr + 1) % this.hspec.getDepthShort();
        if (values instanceof byte[]) {
            if (!(this.rngBuffer instanceof byte[])) {
                return 2;
            }
            int len = ((byte[])values).length;
            if (len > this.siz) {
                len = this.siz;
            }
            System.arraycopy(values, 0, (byte[])this.rngBuffer, this.rngPtr * this.siz, len);
        } else if (values instanceof short[]) {
            if (!(this.rngBuffer instanceof short[])) {
                return 2;
            }
            int len = ((short[])values).length;
            if (len > this.siz) {
                len = this.siz;
            }
            System.arraycopy(values, 0, (short[])this.rngBuffer, this.rngPtr * this.siz, len);
        } else if (values instanceof int[]) {
            if (!(this.rngBuffer instanceof int[])) {
                return 2;
            }
            int len = ((int[])values).length;
            if (len > this.siz) {
                len = this.siz;
            }
            System.arraycopy(values, 0, (int[])this.rngBuffer, this.rngPtr * this.siz, len);
        } else if (values instanceof float[]) {
            if (!(this.rngBuffer instanceof float[])) {
                return 2;
            }
            int len = ((float[])values).length;
            if (len > this.siz) {
                len = this.siz;
            }
            System.arraycopy(values, 0, (float[])this.rngBuffer, this.rngPtr * this.siz, len);
        } else if (values instanceof double[]) {
            if (!(this.rngBuffer instanceof double[])) {
                return 2;
            }
            int len = ((double[])values).length;
            if (len > this.siz) {
                len = this.siz;
            }
            System.arraycopy(values, 0, (double[])this.rngBuffer, this.rngPtr * this.siz, len);
        } else if (values instanceof TCompoundDataObject[]) {
            if (!(this.rngBuffer instanceof TCompoundDataObject[])) {
                return 2;
            }
            if (((TCompoundDataObject[])values)[0].getFormat() != ((TCompoundDataObject[])this.rngBuffer)[0].getFormat()) {
                return 2;
            }
            int len = ((TCompoundDataObject[])values).length;
            if (len > this.siz) {
                len = this.siz;
            }
            System.arraycopy(values, 0, this.rngBuffer, this.rngPtr * this.siz, len);
        } else {
            return 2;
        }
        this.timestamp[this.rngPtr] = d.getDataTimeStamp();
        this.sysstamp[this.rngPtr] = d.getSystemDataStamp();
        this.usrstamp[this.rngPtr] = d.getUserDataStamp();
        return 0;
    }

    private String twoDigitString(int n) {
        return n < 10 ? "0" + n : "" + n;
    }

    public void setArchiveFileName(long cycleTime) {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance();
        }
        this.calendar.setTimeInMillis(cycleTime);
        int dd = this.calendar.get(5);
        if (dd == this.lastArchivedDayOfTheMonth) {
            return;
        }
        this.lastArchivedDayOfTheMonth = dd;
        int yy = this.calendar.get(1) % 100;
        int mm = this.calendar.get(2) + 1;
        if (this.useMonthlyHistoryFiles) {
            dd = 1;
        }
        this.ArchiveFileName = this.getFilePrefix() + this.twoDigitString(yy) + this.twoDigitString(mm) + this.twoDigitString(dd) + "." + Integer.toHexString(this.rcdIdx);
        if (this.useStandardFileSet) {
            int mm0 = (mm + 12 - (this.hspec.getDepthLong() + 1) % 12) % 12;
            yy -= this.hspec.getDepthLong() / 12;
            if (mm0 > mm) {
                --yy;
            }
            String rmvFileName = this.getFilePrefix() + this.twoDigitString(yy) + this.twoDigitString(mm0) + this.twoDigitString(dd) + "." + Integer.toHexString(this.rcdIdx);
            this.rotateHistoryFile(rmvFileName, this.ArchiveFileName);
        } else {
            this.removeOutdatedLTSFiles(cycleTime);
        }
    }

    public void removeOutdatedLTSFiles(long cycleTime) {
        String fileName = null;
        String poiName = null;
        String pfix = this.getFilePrefix();
        this.calendar.setTimeInMillis(cycleTime);
        int yy = this.calendar.get(1) % 100;
        int mm0 = this.calendar.get(2) + 1;
        int mm = (mm0 + 12 - (this.hspec.getDepthLong() + 1) % 12) % 12;
        yy -= this.hspec.getDepthLong() / 12;
        if (mm > mm0) {
            --yy;
        }
        fileName = pfix + this.twoDigitString(yy) + this.twoDigitString(mm) + "*." + Integer.toHexString(this.rcdIdx);
        poiName = new String(fileName);
        poiName.replace(pfix, "pi");
        File f = null;
        try {
            f = new File(fileHome + "/" + fileName);
            f.delete();
            f = new File(fileHome + "/" + poiName);
            if (f.exists()) {
                f.delete();
            }
        }
        catch (Exception e) {
            TFecLog.log("unable to delete file " + f != null ? f.getName() : "(null file)");
        }
    }

    private String getFilePrefix() {
        if (this.useStandardFileSet) {
            return "ts";
        }
        return this.useMinimalStorage ? "ar" : "ta";
    }

    private void rotateHistoryFile(String src, String dst) {
        File fdst = new File(fileHome + "/" + dst);
        if (fdst.exists()) {
            return;
        }
        File fsrc = new File(fileHome + "/" + src);
        fsrc.renameTo(fdst);
        TFecLog.log("rotate history file " + src + " to " + dst);
    }

    public String getArchiveFileName() {
        return this.ArchiveFileName;
    }

    public int getArrayType() {
        return this.aType;
    }

    public int getRingBufferPointer() {
        return this.rngPtr;
    }

    public String getDev() {
        return this.dev;
    }

    public TEquipmentModule getEqm() {
        return this.eqm;
    }

    public byte getFmt() {
        return this.fmt;
    }

    public String getTag() {
        return this.tag;
    }

    public String getRemoteHistoryServer() {
        return this.hspec.getRemoteServerSpecification();
    }

    public THistorySpecification getHspec() {
        return this.hspec;
    }

    public long getLastArchiveTime() {
        return this.lastArchiveTime;
    }

    public String getPrp() {
        return this.prp;
    }

    public int getRcdIdx() {
        return this.rcdIdx;
    }

    public int getRngBufferSize() {
        return this.rngBufferSize;
    }

    public int getArraySize() {
        return this.siz;
    }

    public int getRecordLength() {
        return this.siz * TFormat.formatSizeOf(this.fmt) + this.getRecordPrefixLength();
    }

    public long getTimestamp() {
        return this.rngPtr < 0 ? 0L : this.timestamp[this.rngPtr];
    }

    public int getSystemStamp() {
        return this.rngPtr < 0 ? 0 : this.sysstamp[this.rngPtr];
    }

    public int getUserStamp() {
        return this.rngPtr < 0 ? 0 : this.usrstamp[this.rngPtr];
    }

    public boolean isUseMonthlyHistoryFiles() {
        return this.useMonthlyHistoryFiles;
    }

    public void setUseMonthlyHistoryFiles(boolean useMonthlyHistoryFiles) {
        this.useMonthlyHistoryFiles = useMonthlyHistoryFiles;
    }

    public boolean isUseMinimalStorage() {
        return this.useMinimalStorage;
    }

    public void setUseMinimalStorage(boolean value) {
        this.useMinimalStorage = value;
    }

    public void setUseMsecHistoryTimeStamps(boolean useMsecHistoryTimeStamps) {
        this.useMinimalStorage = !useMsecHistoryTimeStamps;
    }

    public boolean isWithinTolerance() {
        float aTol = this.hspec.getAbsoluteTolerance();
        float pTol = this.hspec.getPercentTolerance();
        int ptr0 = this.rngPtr;
        int ptr1 = (ptr0 + this.rngBufferSize - 1) % this.rngBufferSize;
        switch (this.fmt) {
            case 0: 
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 14: 
            case 31: 
            case 40: {
                for (int p = 0; p < this.siz; ++p) {
                    double d0 = this.getDoubleValueAtPosition(ptr0, p);
                    double d1 = this.getDoubleValueAtPosition(ptr1, p);
                    double t = (double)aTol + (double)pTol * Math.abs(d1);
                    if (!(Math.abs(d0 - d1) > t)) continue;
                    return false;
                }
                break;
            }
            case 9: 
            case 13: 
            case 36: {
                for (int p = 0; p < this.siz; ++p) {
                    String s1;
                    String s0 = this.getNAME64ValueAtPosition(ptr0, p).toString();
                    if (s0.compareTo(s1 = this.getNAME64ValueAtPosition(ptr1, p).toString()) == 0) continue;
                    return false;
                }
                break;
            }
        }
        return true;
    }

    public boolean isPointOfInterest() {
        boolean useRange;
        if (!this.keepPointsOfInterest) {
            return false;
        }
        if (this.rngPtr == 1 && this.timestamp[this.rngBufferSize - 1] == 0L) {
            return false;
        }
        float aTol = this.hspec.getAbsoluteTolerance();
        float pTol = this.hspec.getPercentTolerance();
        boolean bl = useRange = !(pTol > 0.0f);
        if (useRange && this.range <= 0.0f) {
            useRange = false;
            if (aTol == 0.0f) {
                return false;
            }
        }
        int ptr0 = this.rngPtr;
        int ptr1 = (ptr0 + this.rngBufferSize - 1) % this.rngBufferSize;
        switch (this.fmt) {
            case 0: 
            case 1: 
            case 3: 
            case 5: 
            case 6: 
            case 14: 
            case 31: 
            case 40: {
                for (int p = 0; p < this.siz; ++p) {
                    double t;
                    double d0 = this.getDoubleValueAtPosition(ptr0, p);
                    double d1 = this.getDoubleValueAtPosition(ptr1, p);
                    double d = t = useRange ? poiRangeFactor * (double)this.range : poiToleranceFactor * ((double)aTol + (double)pTol * Math.abs(d1));
                    if (!(Math.abs(d0 - d1) > t)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    public static double getPoiRangeFactor() {
        return poiRangeFactor;
    }

    public static void setPointsOfInterestRangeFactor(double poiRangeFactor) {
        THistoryRecord.poiRangeFactor = poiRangeFactor;
    }

    public static double getPoiToleranceFactor() {
        return poiToleranceFactor;
    }

    public static void setPointsOfInterestToleranceFactor(double poiToleranceFactor) {
        THistoryRecord.poiToleranceFactor = poiToleranceFactor;
    }
}

