/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.server.equipment;

import de.desy.tine.client.TLink;
import de.desy.tine.client.TLinkCallback;
import de.desy.tine.dataUtils.TDataTime;
import de.desy.tine.server.equipment.TEquipmentModuleFactory;
import de.desy.tine.server.logger.DbgLog;
import de.desy.tine.server.logger.TFecLog;

public class TSyncCallback
implements TLinkCallback {
    private static TEquipmentModuleFactory f = TEquipmentModuleFactory.getInstance();
    private static final int TIMESYNC_DEPTH = 6;
    private static final double gSyncTolerance = 0.2;
    private static int last_cc = -1;
    private static int last_ptr = 0;
    private static int ncorrections = 0;
    private static double last_timestamp = 0.0;
    private static double last_logged = 0.0;
    private static double last_dataTimeOffset = 0.0;
    private static double largest_correction = 0.0;
    private static double last_correction = 0.0;
    private static double[] last_dataTimeRbDeltas = new double[6];
    private static double[] last_dataTimeDtDeltas = new double[6];
    private static double[] last_dataTimeStamps = new double[6];
    private static double[] last_dataTimeRbTimes = new double[6];

    private void checkTimestamp(double gDataTimeStamp, double gSyncTimeStamp) {
        boolean applyCorrection = false;
        double correction = 0.0;
        double delta_t = 0.0;
        double last_dt = 0.0;
        double last_rb = last_dataTimeRbTimes[last_ptr];
        last_dt = last_dataTimeStamps[last_ptr];
        last_ptr = (last_ptr + 1) % 6;
        TSyncCallback.last_dataTimeRbTimes[TSyncCallback.last_ptr] = gDataTimeStamp;
        TSyncCallback.last_dataTimeRbDeltas[TSyncCallback.last_ptr] = gDataTimeStamp - last_rb;
        TSyncCallback.last_dataTimeStamps[TSyncCallback.last_ptr] = gSyncTimeStamp;
        TSyncCallback.last_dataTimeDtDeltas[TSyncCallback.last_ptr] = gSyncTimeStamp - last_dt;
        for (int i = 0; i < 6; ++i) {
            int k = (last_ptr + i) % 6;
            if (last_dataTimeStamps[k] < 1000.0) {
                return;
            }
            delta_t = last_dataTimeRbDeltas[k] - last_dataTimeDtDeltas[k];
            if (Math.abs(delta_t) > 0.01) {
                return;
            }
            correction += last_dataTimeStamps[k] - last_dataTimeRbTimes[k];
        }
        if ((correction /= 6.0) > gSyncTimeStamp) {
            TFecLog.log("invalid time correction " + correction + " greater than time server clock " + gSyncTimeStamp);
            return;
        }
        if (correction > 0.2 || correction < -0.2) {
            applyCorrection = true;
        } else if (last_correction < 0.2 && correction > 0.1) {
            applyCorrection = true;
        } else if (last_correction > 0.2 && correction < -0.1) {
            applyCorrection = true;
        }
        if (!applyCorrection) {
            return;
        }
        double tsOffset = (double)f.getDataTimeStampOffset() / 1000.0;
        f.setDataTimeStampOffset((long)((tsOffset += correction) * 1000.0));
        last_correction = correction;
        if (TEquipmentModuleFactory.debugLevel > 0) {
            DbgLog.log("checkTimestamp", "global synchronization : " + correction + " sec (current offset " + tsOffset + " sec)");
        }
        ++ncorrections;
        if (Math.abs(correction) > largest_correction) {
            largest_correction = Math.abs(correction);
        }
        if (gDataTimeStamp < last_logged + 3600.0) {
            return;
        }
        last_logged = gDataTimeStamp;
        if (Math.abs(tsOffset - last_dataTimeOffset) < 0.1) {
            return;
        }
        TFecLog.log("global synchronization offset : " + tsOffset + "sec");
        TFecLog.log("largest correction : " + largest_correction + " sec  (nr. corrections " + ncorrections + ")");
        last_logged = gDataTimeStamp;
        ncorrections = 0;
        largest_correction = 0.0;
        last_dataTimeOffset = tsOffset;
    }

    public void callback(TLink link) {
        int cc = link.getLinkStatus();
        if (cc != last_cc) {
            last_cc = cc;
            TFecLog.log("global synchronization : " + link.getLastError());
        }
        if (cc != 0) {
            return;
        }
        double this_timestamp = f.getSyncTimeStamp();
        if (last_timestamp == this_timestamp) {
            if (TEquipmentModuleFactory.debugLevel > 3) {
                DbgLog.log("checkTimestamp", "discard extra synchronization timestamp");
            }
            return;
        }
        last_timestamp = this_timestamp;
        this.checkTimestamp(TDataTime.getDataTimeStamp(), this_timestamp);
    }
}

