/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.server.equipment;

import de.desy.tine.addrUtils.FECAddr;
import de.desy.tine.addrUtils.FECInfo;
import de.desy.tine.addrUtils.SrvAddr;
import de.desy.tine.addrUtils.TSrvEntry;
import de.desy.tine.bitfieldUtils.TBitfield;
import de.desy.tine.bitfieldUtils.TBitfieldRegistry;
import de.desy.tine.bitfieldUtils.TField;
import de.desy.tine.client.TLink;
import de.desy.tine.client.TLinkCallback;
import de.desy.tine.client.TLinkFactory;
import de.desy.tine.csvUtils.FloatFieldHandler;
import de.desy.tine.csvUtils.FormatFieldHandler;
import de.desy.tine.csvUtils.IntFieldHandler;
import de.desy.tine.csvUtils.RowHandler;
import de.desy.tine.csvUtils.StringFieldHandler;
import de.desy.tine.csvUtils.csv;
import de.desy.tine.csvUtils.csvColumn;
import de.desy.tine.csvUtils.csvHandler;
import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.definitions.TAccess;
import de.desy.tine.definitions.TErrorList;
import de.desy.tine.definitions.TFormat;
import de.desy.tine.definitions.TMode;
import de.desy.tine.definitions.TStrings;
import de.desy.tine.definitions.TTransport;
import de.desy.tine.endianUtils.Swap;
import de.desy.tine.headers.TContract;
import de.desy.tine.headers.TPHdr;
import de.desy.tine.headers.TReqHdr;
import de.desy.tine.headers.TSubscription;
import de.desy.tine.io.TBucket;
import de.desy.tine.io.TDataOutputStream;
import de.desy.tine.io.TPacket;
import de.desy.tine.queryUtils.TPropertyQuery;
import de.desy.tine.queryUtils.XPropertyQuery;
import de.desy.tine.server.TServerStatistics;
import de.desy.tine.server.alarms.TAlarmDefinition;
import de.desy.tine.server.alarms.TAlarmWatchEntry;
import de.desy.tine.server.alarms.TAlarmWatchThreshold;
import de.desy.tine.server.connections.TClient;
import de.desy.tine.server.connections.TClientEntry;
import de.desy.tine.server.connections.TClientStatus;
import de.desy.tine.server.connections.TContractTable;
import de.desy.tine.server.devices.TDevice;
import de.desy.tine.server.equipment.TCycleTrigger;
import de.desy.tine.server.equipment.TCycleTriggerCallback;
import de.desy.tine.server.equipment.TEquipmentBackgroundTask;
import de.desy.tine.server.equipment.TEquipmentManifest;
import de.desy.tine.server.equipment.TEquipmentModule;
import de.desy.tine.server.equipment.TEquipmentModuleHook;
import de.desy.tine.server.equipment.TSyncCallback;
import de.desy.tine.server.histories.THistoryRecord;
import de.desy.tine.server.histories.THistorySpecification;
import de.desy.tine.server.logger.DbgLog;
import de.desy.tine.server.logger.MsgLog;
import de.desy.tine.server.logger.TFecLog;
import de.desy.tine.server.properties.TExportProperty;
import de.desy.tine.server.properties.TMetaProperties;
import de.desy.tine.server.properties.TPropertyDescription;
import de.desy.tine.server.properties.TPropertyHandler;
import de.desy.tine.server.properties.TPropertyList;
import de.desy.tine.server.properties.TStockProperties;
import de.desy.tine.startup.TInitializer;
import de.desy.tine.startup.TInitializerFactory;
import de.desy.tine.stringUtils.StringToName;
import de.desy.tine.stringUtils.WildcardMatch;
import de.desy.tine.structUtils.TStructBase;
import de.desy.tine.structUtils.TStructRegistry;
import de.desy.tine.types.INTINT;
import de.desy.tine.types.NAME16FI;
import de.desy.tine.types.NAME16I;
import de.desy.tine.types.NAME16II;
import de.desy.tine.types.NAME32;
import de.desy.tine.types.NAME32DBLDBL;
import de.desy.tine.types.NAME64DBL;
import de.desy.tine.types.NAME64DBLDBL;
import de.desy.tine.types.TCompoundDataObject;
import de.desy.tine.types.USTRING;
import de.desy.tine.xmlUtils.AlarmCfg;
import de.desy.tine.xmlUtils.AliasCfg;
import de.desy.tine.xmlUtils.EqmCfg;
import de.desy.tine.xmlUtils.FecCfg;
import de.desy.tine.xmlUtils.HistoryCfg;
import de.desy.tine.xmlUtils.PropertyCfg;
import de.desy.tine.xmlUtils.TineXMLparser;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.nio.channels.ServerSocketChannel;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class TEquipmentModuleFactory {
    private String gFecContext;
    private String gFecName;
    private String gFecDescription = "unknown";
    private String gFecLocation = "unknown";
    private String gFecSubsystem = "TEST";
    private String gFecHardware = "none";
    private String gFecResponsible = "unknown";
    private FECAddr gFecAddr;
    private FECInfo gFecInfo;
    private TLinkFactory gLinkFactory = null;
    private LinkedList<clnInputData> clnInputDataTable = new LinkedList();
    private LinkedList<AliasTableEntry> gAliasList = new LinkedList();
    private static TInitializer initializer = TInitializerFactory.getInstance().getInitializer();
    private static TEquipmentModuleFactory instance = new TEquipmentModuleFactory();
    private TPacket srvp = null;
    private int sckRcvBufferSize = initializer.getSrvRcvBufferSize();
    private int sckTimeToLive = initializer.getSckTimeToLive();
    private ServerSocket srvs = null;
    private LinkedList<TContractBucket> bucketList = new LinkedList();
    private int gPortOffset = 0;
    static final int maxNumEqmTableEntries = 16;
    private int numEqmTableEntries = 0;
    private TEquipmentModule[] eqmTable = new TEquipmentModule[16];
    private int numExpiredContracts = 0;
    private ArrayList<TContractTable> conTable = new ArrayList();
    private LinkedList<TContractTable> conTableAdd = new LinkedList();
    private ArrayList<TClient> clnTable = new ArrayList();
    private LinkedList<TClient> clnTableAdd = new LinkedList();
    private TContractTable currentContractEntry = null;
    protected HashMap<String, TAlarmDefinition> stkAlarmDefinitions = new HashMap();
    private int gSystemTick = 10;
    private int gStaleData = 0;
    private int gBurstLimit = 1024;
    private int gCycleDelay = 1;
    private int gBurstLimitReachedCount = 0;
    private int gClientReconnects = 0;
    private int gClientRetries = 0;
    private int gContractMisses = 0;
    private int gContractDelays = 0;
    private int gClientMisses = 0;
    private int gSingleLinkCount = 0;
    private long gDataTimeStamp = 0L;
    private long gDataTimeStampOffset = 0L;
    private long gSrvStartupTime = 0L;
    private long gAppCompilationTime = 0L;
    private int gAppVersionMajor = 1;
    private int gAppVersionMinor = 0;
    private int gAppVersionRevision = 0;
    private int[] gSrvStatsBuffer = new int[16];
    private String gLastErrorString;
    private String gLastMessage;
    private long gLastWriteAccessTime = 0L;
    private String gLastWriteAccessUser = null;
    private InetAddress gLastWriteAccessAddr = null;
    private String gLastWriteAccessPrp = null;
    private String gLastWriteAccessDev = null;
    private String gLastWriteAccessEqm = null;
    protected static int debugLevel = 0;
    private int gTotalUdpPackets = 0;
    private int gTotalTcpPackets = 0;
    private TAcceptorThread acceptThrd;
    private TCycleThread cycleThrd;
    private boolean gLinkTablesAccessed = false;
    private boolean gSystemExitCondition = false;
    private boolean isInsideCycle = false;
    public boolean isInitialized = false;
    private boolean isUsingXMLConfig = false;
    public boolean registrationPending = false;
    private long registrationTime = 0L;
    public boolean gSynchronizeContracts = true;
    public boolean gRequireAcknowledgments = true;
    public boolean gEqpFcnBusySemaphore = false;
    public boolean gSystemPresetMemory = false;
    public boolean gRetardSingleContractRemoval = true;
    public boolean gPutCommandsInFeclog = true;
    private static boolean gServerWaiting = false;
    private static boolean gSystemRunningStandAlone = false;
    private int gSystemStamp = 0;
    private static final short ACK_PENDING = Short.MAX_VALUE;
    private static final short SUB_PENDING = 16383;
    private static final short BCAST_ID = 255;
    private static final short PRP_SCHEDULE_SIGNAL = 0;
    private static final short PRP_REQUEST_SIGNAL = 1;
    private static final short PRP_CANCEL_SIGNAL = 2;
    private static final short RENEWAL = 60;
    private static final short REMINDER = 5;
    private static final short ACK_REQUEST = 10;
    private static final short HEARTBEAT = 60;
    private static final short REPLY_PENDING = 3;
    private static final int STD_CYCLE_INTERVAL = 1;
    public static final int MAXIMUM_LOCK_DURATION = 60;
    private static int srvPacketMtu = initializer.getSrvPacketMtu();
    private int gMinPollingRate = 10;
    private int gMaxPollingRate = 60000;
    private int gNumBkgTasks = 0;
    private int gNumEnsErrors = 0;
    private TEquipmentModuleHook tEqmHook = null;
    private FecCfg gFecXmlCfg = null;
    private String tRedirectedServer;
    private TServerStatistics serverStatistics = new TServerStatistics(this);
    TPropertyList stockList = new TPropertyList();
    TMetaProperties metaProps = new TMetaProperties();
    private InetAddress mcastInetAddress = null;
    private byte[] deliveryPayload = new byte[64000];
    private boolean gIsInsideScheduler = false;
    private static boolean[] isNewContract = new boolean[1];
    private byte[] requestBytes = new byte[256];
    private byte[] msgBytes = new byte[1472];
    private boolean exitOnShutdown = true;
    private boolean stockAlarmDefinitionsRegistered = false;
    private LinkedList<TCycleTrigger> gCycTrgLst = new LinkedList();
    private boolean useGlobalSynchronization = true;
    private boolean useCycleTrigger = true;
    private boolean gSynchronizationStarted = false;
    private double[] gSyncTimeStamp = new double[1];
    private boolean gCycleTriggerStarted = false;
    private int[] gCycleNumber = new int[1];
    private static int cycleTriggerDeadBand = 1000;

    public TInitializer getInitializer() {
        return initializer;
    }

    public int getPort() {
        return this.gPortOffset;
    }

    public HashMap getStockAlarmDefinitions() {
        return this.stkAlarmDefinitions;
    }

    public static void setDebugLevel(int level) {
        debugLevel = level;
    }

    public boolean isRunningStandAlone() {
        return gSystemRunningStandAlone;
    }

    public int getSystemStamp() {
        return this.gSystemStamp;
    }

    public void setSystemStamp(int value) {
        this.gSystemStamp = value;
    }

    public static void setServerWaiting(boolean value) {
        gServerWaiting = value;
    }

    public static boolean getServerWaiting() {
        return gServerWaiting;
    }

    public static int getServerPacketMTU() {
        return srvPacketMtu;
    }

    public FecCfg getFecXmlCfg() {
        return this.gFecXmlCfg;
    }

    public void setTEquipmentModuleHook(TEquipmentModuleHook hook) {
        this.tEqmHook = hook;
        if (this.isInitialized) {
            hook.SystemInit();
        }
    }

    public TEquipmentModuleHook getTEquipmentModuleHook() {
        return this.tEqmHook;
    }

    private boolean isDeviceRedirected(String redirString, String devName) {
        if (redirString == null || redirString.length() == 0) {
            return false;
        }
        if (devName == null || devName.length() == 0) {
            return true;
        }
        int idx = redirString.lastIndexOf(47);
        if (idx == -1) {
            return true;
        }
        int edx = redirString.indexOf(91);
        edx = edx == -1 ? redirString.length() : --edx;
        return redirString.substring(idx + 1, edx + 1).compareTo(devName) == 0;
    }

    private byte[] redirectionStringToBytes(String redirString) {
        String srv;
        String s;
        byte[] b = new byte[192];
        String ctx = "";
        String dev = "";
        String prp = "";
        int indx = redirString.indexOf(91);
        if (indx != -1) {
            if (indx == 0) {
                return b;
            }
            s = redirString.substring(0, indx);
            prp = redirString.substring(indx + 1);
            if ((indx = prp.indexOf(93)) == -1) {
                return b;
            }
            prp = indx > 0 ? prp.substring(0, indx) : "";
        } else {
            s = redirString;
        }
        indx = s.indexOf(47);
        if (indx == 0) {
            indx = s.substring(1).indexOf(47);
            if (indx == -1) {
                return b;
            }
            ctx = s.substring(1, indx + 1);
            s = s.substring(indx + 2);
            indx = s.indexOf(47);
        }
        if (indx == -1) {
            srv = s;
            dev = "";
        } else {
            srv = indx > 0 ? s.substring(0, indx) : "";
            dev = s.substring(indx + 1);
        }
        int off = 0;
        int len = ctx.length();
        if (len > 32) {
            len = 32;
        }
        System.arraycopy(ctx.getBytes(), 0, b, off, len);
        off += 32;
        len = srv.length();
        if (len > 32) {
            len = 32;
        }
        System.arraycopy(srv.getBytes(), 0, b, off, len);
        off += 32;
        len = dev.length();
        if (len > 64) {
            len = 64;
        }
        System.arraycopy(dev.getBytes(), 0, b, off, len);
        off += 64;
        len = prp.length();
        if (len > 64) {
            len = 64;
        }
        System.arraycopy(prp.getBytes(), 0, b, off, len);
        return b;
    }

    public int setRedirectionString(String redirectionString) {
        this.tRedirectedServer = redirectionString;
        return 121;
    }

    public TContractTable getCurrentContractEntry() {
        return this.currentContractEntry;
    }

    public TPropertyList getStockList() {
        return this.stockList;
    }

    public int addAliasToList(String name, String alias) {
        if (name == null || name.length() == 0) {
            return 20;
        }
        if (alias == null || alias.length() == 0) {
            return 20;
        }
        this.gAliasList.add(new AliasTableEntry(name, alias));
        return 0;
    }

    void registerStockProperties() {
        this.stockList.addProperty(TStockProperties.NSTOCKPROPS, new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return (short)dout.putData(TStockProperties.getNumStockProperties());
            }
        });
        this.stockList.addProperty(TStockProperties.STOCKPROPS, new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return (short)dout.putData(StringToName.stringSetToName32(TStockProperties.getPropertyNames()));
            }
        });
        this.stockList.addProperty(TStockProperties.STOCKPROPS_USTRING, new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                boolean checkWildCard = devName.compareTo("*") != 0 && devName.indexOf("*") != -1;
                TPropertyList lst = TStockProperties.getPropertyList();
                String[] slst = new String[lst.countUniqueProperties()];
                lst.getPropertyNames().toArray(slst);
                if (checkWildCard) {
                    slst = StringToName.matchStringsInArray(slst, devName);
                }
                TCompoundDataObject[] ustr = new USTRING[slst.length];
                StringBuffer sb = new StringBuffer(80);
                for (int i = 0; i < slst.length; ++i) {
                    ustr[i] = new USTRING();
                    TExportProperty prp = lst.getFirstProperty(slst[i]);
                    if (prp == null) continue;
                    char[] cha = prp.getName().toCharArray();
                    sb.insert(0, cha);
                    for (int c = cha.length; c < 32; ++c) {
                        sb.insert(c, '\u0000');
                    }
                    cha = prp.getDescription().getText().toCharArray();
                    sb.insert(32, cha);
                    ((USTRING)ustr[i]).setValues(prp.getOutputSize(), 0.0f, 0.0f, prp.getOutputFormat(), new String(sb));
                }
                return (short)dout.putData(ustr);
            }
        });
        this.stockList.addProperty(TStockProperties.STOCKPROPS_STRUCT, new TPropertyHandler(){

            protected int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return TEquipmentModuleFactory.this.callPropertyStockProps(devName, dout, din, devAccess);
            }
        });
        this.stockList.addProperty(TStockProperties.SRVSTARTTIME, new TPropertyHandler(){

            protected int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return (short)dout.putData(new Date(TEquipmentModuleFactory.this.getServerStartTime()).toString());
            }
        });
        this.stockList.addProperty(TStockProperties.SRVSTARTTIME_LONG, new TPropertyHandler(){

            protected int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return (short)dout.putData((int)(TEquipmentModuleFactory.this.getServerStartTime() / 1000L));
            }
        });
        this.stockList.addProperty(TStockProperties.STRUCTFORMAT_INTINT, new TPropertyHandler(){

            protected int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return TEquipmentModuleFactory.this.callPropertyStructFormat(devName, dout, din, devAccess);
            }
        });
        this.stockList.addProperty(TStockProperties.STRUCTFORMAT_NDD, new TPropertyHandler(){

            protected int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return TEquipmentModuleFactory.this.callPropertyStructFormat(devName, dout, din, devAccess);
            }
        });
        this.stockList.addProperty(TStockProperties.STRUCTFORMAT, new TPropertyHandler(){

            protected int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return TEquipmentModuleFactory.this.callPropertyStructFormat(devName, dout, din, devAccess);
            }
        });
        this.stockList.addProperty(TStockProperties.BITFIELDFORMAT, new TPropertyHandler(){

            protected int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return TEquipmentModuleFactory.this.callPropertyBitfieldFormat(devName, dout, din, devAccess);
            }
        });
        this.stockList.addProperty(TStockProperties.CONTRACTS, new TPropertyHandler(){

            protected int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return TEquipmentModuleFactory.this.callPropertyContracts(devName, dout, din, devAccess);
            }
        });
        this.stockList.addProperty(TStockProperties.CLIENTS, new TPropertyHandler(){

            protected int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return TEquipmentModuleFactory.this.callPropertyClients(devName, dout, din, devAccess);
            }
        });
        this.stockList.addProperty(TStockProperties.ACTIVITY, new TPropertyHandler(){

            protected int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return TEquipmentModuleFactory.this.callPropertyActivity(devName, dout, din, devAccess);
            }
        });
        this.stockList.addProperty(TStockProperties.SRVDESC, new TPropertyHandler(){

            protected int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return (short)dout.putData(TEquipmentModuleFactory.this.getFecDescription());
            }
        });
        this.stockList.addProperty(TStockProperties.SRVLOCATION, new TPropertyHandler(){

            protected int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return (short)dout.putData(TEquipmentModuleFactory.this.getFecLocation());
            }
        });
        this.stockList.addProperty(TStockProperties.SRVALIASLIST, new TPropertyHandler(){

            protected int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                if (TEquipmentModuleFactory.this.gAliasList == null) {
                    return 38;
                }
                int len = TEquipmentModuleFactory.this.gAliasList.size() * 2;
                if (len == 0) {
                    return 101;
                }
                TCompoundDataObject[] n32 = new NAME32[len];
                for (int i = 0; i < len / 2; ++i) {
                    AliasTableEntry ate = (AliasTableEntry)TEquipmentModuleFactory.this.gAliasList.get(i);
                    n32[2 * i] = new NAME32(ate.name);
                    n32[2 * i + 1] = new NAME32(ate.alias);
                }
                return (short)dout.putData(n32);
            }
        });
        this.stockList.addProperty(TStockProperties.SRVLASTACCESS, new TPropertyHandler(){

            protected int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                TCompoundDataObject[] n32 = new NAME32[dout.dArrayLength];
                String s = null;
                switch (dout.dArrayLength) {
                    case 6: {
                        s = TEquipmentModuleFactory.this.getLastAccessEqm();
                        n32[5] = new NAME32(s != null ? s : "");
                    }
                    case 5: {
                        n32[4] = new NAME32(new Date(TEquipmentModuleFactory.this.getLastAccessTime()).toString());
                    }
                    case 4: {
                        s = TEquipmentModuleFactory.this.getLastAccessDev();
                        n32[3] = new NAME32(s != null ? s : "");
                    }
                    case 3: {
                        s = TEquipmentModuleFactory.this.getLastAccessPrp();
                        n32[2] = new NAME32(s != null ? s : "");
                    }
                    case 2: {
                        InetAddress iaddr = TEquipmentModuleFactory.this.getLastAccessAddress();
                        s = iaddr != null ? TEquipmentModuleFactory.this.getLastAccessAddress().getHostAddress() : "";
                        n32[1] = new NAME32(s);
                    }
                    case 1: {
                        s = TEquipmentModuleFactory.this.getLastAccessUser();
                        n32[0] = new NAME32(s != null ? s : "");
                        break;
                    }
                    default: {
                        return 23;
                    }
                }
                return (short)dout.putData(n32);
            }
        });
        this.stockList.addProperty(TStockProperties.SRVLASTACCESS_LONG, new TPropertyHandler(){

            protected int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return (short)dout.putData((int)(TEquipmentModuleFactory.this.getLastAccessTime() / 100L));
            }
        });
        this.stockList.addProperty(TStockProperties.SRVSTATS, new TPropertyHandler(){

            protected int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return (short)dout.putData(TEquipmentModuleFactory.this.getServerStats());
            }
        });
        this.stockList.addProperty(TStockProperties.SRVEXIT, new TPropertyHandler(){

            protected int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                if (devAccess.isWrite()) {
                    int[] level = new int[]{0};
                    if (din != null) {
                        din.getData(level);
                    }
                    TFecLog.log("Server exit (level " + level[0] + ") from remote caller");
                    TEquipmentModuleFactory.this.shutdown(level[0]);
                    return 0;
                }
                return 73;
            }
        });
        this.stockList.addProperty(TStockProperties.SRVOS, new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return dout.putData(TStockProperties.getStockSrvOS());
            }
        });
        this.stockList.addProperty(TStockProperties.SRVVERSION, new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return dout.putData(TStockProperties.getStockSrvVersion());
            }
        });
        this.stockList.addProperty(TStockProperties.DEBUGLEVEL, new TPropertyHandler(){

            protected int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                int cc = 0;
                short[] dbglvl = new short[1];
                if (din != null && devAccess.isWrite() && (cc = din.getData(dbglvl)) == 0) {
                    debugLevel = dbglvl[0];
                    TLinkFactory.setOutputDebugLevel(debugLevel);
                }
                if (cc == 0 && dout != null) {
                    dbglvl[0] = (short)TLinkFactory.getOutputDebugLevel();
                    cc = dout.putData(dbglvl);
                }
                return cc;
            }
        });
        this.stockList.addProperty(TStockProperties.LOGCOMMANDS, new TPropertyHandler(){

            protected int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                int cc = 0;
                short[] logcmds = new short[1];
                if (din != null && devAccess.isWrite() && (cc = din.getData(logcmds)) == 0) {
                    boolean bl = TEquipmentModuleFactory.this.gPutCommandsInFeclog = logcmds[0] != 0;
                }
                if (cc == 0 && dout != null) {
                    logcmds[0] = (short)(TEquipmentModuleFactory.this.gPutCommandsInFeclog ? -1 : 0);
                    cc = dout.putData(logcmds);
                }
                return cc;
            }
        });
        this.stockList.addProperty(TStockProperties.MESSAGE, new TPropertyHandler(){

            protected int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                int cc = 0;
                char[] msg = new char[128];
                if (din != null && devAccess.isWrite() && (cc = din.getData(msg)) == 0) {
                    TEquipmentModuleFactory.this.gLastMessage = new String(msg).substring(0, din.dCompletionLength);
                    String s = "MSG: " + TEquipmentModuleFactory.this.gLastMessage;
                    System.out.println(s);
                    TFecLog.log(s);
                }
                if (cc == 0 && dout != null) {
                    cc = dout.putData(TEquipmentModuleFactory.this.gLastMessage);
                }
                return cc;
            }
        });
        this.stockList.addProperty(TStockProperties.LOGFILE, new TPropertyHandler(){

            protected int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                if (dout.getFormat() != 4) {
                    return 2;
                }
                int nlines = dout.getArrayLength() / 80;
                return (short)dout.putData(TFecLog.getLines(nlines));
            }
        });
        this.stockList.addProperty(TStockProperties.LOGDEPTH, new TPropertyHandler(){

            protected int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                int cc = 0;
                int[] depth = new int[1];
                if (din != null && devAccess.isWrite() && (cc = din.getData(depth)) == 0) {
                    TFecLog.setLogDepth(depth[0]);
                }
                if (cc == 0 && dout != null) {
                    depth[0] = TFecLog.getLogDepth();
                    cc = dout.putData(depth);
                }
                return cc;
            }
        });
        this.stockList.addProperty(TStockProperties.APPDATE_STRING, new TPropertyHandler(){

            protected int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return (short)dout.putData(new Date(TEquipmentModuleFactory.this.getAppCompilationTime()).toString());
            }
        });
        this.stockList.addProperty(TStockProperties.APPDATE, new TPropertyHandler(){

            protected int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return (short)dout.putData((int)(TEquipmentModuleFactory.this.getAppCompilationTime() / 1000L));
            }
        });
        this.stockList.addProperty(TStockProperties.APPVERSION, new TPropertyHandler(){

            protected int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return (short)dout.putData(TEquipmentModuleFactory.this.getAppVersion());
            }
        });
        this.stockList.addProperty(TStockProperties.SRVLOGFILES, new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return (short)dout.putData(StringToName.stringArrayToName64(TFecLog.getFiles()));
            }
        });
        this.stockList.addProperty(TStockProperties.SRVLOGFILE, new TPropertyHandler(){

            protected int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                String tgtLogFile = null;
                if (din == null || din.getArrayLength() == 0) {
                    tgtLogFile = "fec.log.0";
                } else {
                    char[] fileName = new char[128];
                    int cc = din.getData(fileName);
                    if (cc != 0) {
                        return cc;
                    }
                    tgtLogFile = fileName.toString();
                }
                if (dout.getFormat() != 4) {
                    return 2;
                }
                int nlines = dout.getArrayLength() / 80;
                return (short)dout.putData(TFecLog.getLines(tgtLogFile, nlines));
            }
        });
    }

    private short callPropertyActivity(String devName, TDataType dout, TDataType din, TAccess devAccess) {
        short cc = 0;
        ByteArrayOutputStream bsout = new ByteArrayOutputStream(1024);
        TDataOutputStream dsout = new TDataOutputStream(bsout);
        try {
            this.serverStatistics.setNumTotalContracts((short)this.conTable.size());
            this.serverStatistics.setNumTotalClients((short)this.clnTable.size());
            this.serverStatistics.setNumTargetClients((short)this.getCurrentContractEntry().eqm.numClients);
            this.serverStatistics.setNumTargetContracts((short)this.getCurrentContractEntry().eqm.numContracts);
            this.serverStatistics.setNumBkgTsks((short)this.gNumBkgTasks);
            this.serverStatistics.setNumConnectionTimeouts(TLinkFactory.getInstance().getTotalLinkTimeouts());
            this.serverStatistics.setNumConnectionArrivals(TLinkFactory.getInstance().getTotalConnectionArrivals());
            this.serverStatistics.setNumUdpPkts(this.gTotalUdpPackets);
            this.serverStatistics.setNumTcpPkts(this.gTotalTcpPackets);
            this.serverStatistics.setSystemPollingRate(this.gMinPollingRate);
            this.serverStatistics.writeData(dsout);
            dsout.close();
            cc = (short)dout.putData(bsout.toByteArray(), TServerStatistics.getStructDescription().getTagName());
        }
        catch (IOException e) {
            cc = 66;
        }
        return cc;
    }

    private short callPropertyStockProps(String devName, TDataType dout, TDataType din, TAccess devAccess) {
        ByteArrayOutputStream bsout = new ByteArrayOutputStream(1024);
        TDataOutputStream dsout = new TDataOutputStream(bsout);
        if (dout.getTag().compareTo("PRPQSr4") == 0 || dout.getArrayLength() % 432 == 0) {
            if (din != null) {
                String tgt = din.toString();
                tgt = tgt.replace('\n', '\u0000').trim();
                LinkedList matchingProps = TStockProperties.getPropertyList().getEqualProperties(tgt);
                if (matchingProps == null || matchingProps.size() == 0) {
                    return 116;
                }
                try {
                    TPropertyQuery pqs = null;
                    Iterator it = matchingProps.iterator();
                    while (it.hasNext()) {
                        pqs = new TPropertyQuery((TExportProperty)it.next(), matchingProps.size() - 1);
                        pqs.writeData(dsout);
                    }
                    dsout.close();
                    return (short)dout.putData(bsout.toByteArray(), "PRPQSr4");
                }
                catch (Exception e) {
                    return 66;
                }
            }
            TPropertyList lst = TStockProperties.getPropertyList();
            String[] slst = new String[lst.countUniqueProperties()];
            lst.getPropertyNames().toArray(slst);
            TPropertyQuery[] pqs = new TPropertyQuery[slst.length];
            if (slst.length == 0) {
                return 0;
            }
            byte[] tba = new byte[slst.length * XPropertyQuery.sizeInBytes];
            for (int i = 0; i < slst.length; ++i) {
                TExportProperty prp = lst.getFirstProperty(slst[i]);
                pqs[i] = new TPropertyQuery(prp, 1);
                System.arraycopy(pqs[i].toByteArray(), 0, tba, i * 432, XPropertyQuery.sizeInBytes);
            }
            return (short)dout.putData(tba, "PRPQSr4");
        }
        if (dout.getTag().compareTo("XPQS") == 0 || dout.getArrayLength() % XPropertyQuery.sizeInBytes == 0) {
            if (din != null) {
                String tgt = din.toString();
                tgt = tgt.replace('\n', '\u0000').trim();
                LinkedList matchingProps = TStockProperties.getPropertyList().getEqualProperties(tgt);
                if (matchingProps == null || matchingProps.size() == 0) {
                    return 116;
                }
                try {
                    XPropertyQuery xpq = null;
                    Iterator it = matchingProps.iterator();
                    while (it.hasNext()) {
                        xpq = new XPropertyQuery((TExportProperty)it.next(), matchingProps.size() - 1);
                        xpq.writeData(dsout);
                    }
                    dsout.close();
                    return (short)dout.putData(bsout.toByteArray(), "XPQS");
                }
                catch (Exception e) {
                    return 66;
                }
            }
            TPropertyList lst = TStockProperties.getPropertyList();
            String[] slst = new String[lst.countUniqueProperties()];
            lst.getPropertyNames().toArray(slst);
            XPropertyQuery[] xpq = new XPropertyQuery[slst.length];
            if (slst.length == 0) {
                return 0;
            }
            byte[] tba = new byte[slst.length * XPropertyQuery.sizeInBytes];
            for (int i = 0; i < slst.length; ++i) {
                TExportProperty prp = lst.getFirstProperty(slst[i]);
                xpq[i] = new XPropertyQuery(prp, 1);
                System.arraycopy(xpq[i].toByteArray(), 0, tba, i * XPropertyQuery.sizeInBytes, XPropertyQuery.sizeInBytes);
            }
            return (short)dout.putData(tba, "XPQS");
        }
        return 2;
    }

    private short callPropertyStructFormat(String devName, TDataType dout, TDataType din, TAccess devAccess) {
        if (din == null) {
            MsgLog.log("callPropertyStructFormat", "callPropertyStructFormat, din == null", 66, null, 0);
            return 66;
        }
        int cc = 0;
        String tag = din.toString();
        TCompoundDataObject[] structData = TStructRegistry.getRegisteredStructure(tag = tag.replace('\n', '\u0000').trim());
        if (structData != null && structData.length > 0) {
            switch (dout.getFormat()) {
                case 15: {
                    INTINT[] ii = new INTINT[structData.length];
                    for (int i = 0; i < structData.length; ++i) {
                        ii[i] = new INTINT(((NAME16II)structData[i]).i1val, ((NAME16II)structData[i]).i2val);
                    }
                    cc = (short)dout.putData(ii);
                    break;
                }
                case 42: {
                    cc = (short)dout.putData(structData);
                    break;
                }
                case 45: {
                    TCompoundDataObject[] sd64 = new NAME64DBLDBL[structData.length];
                    for (int i = 0; i < structData.length; ++i) {
                        sd64[i] = new NAME64DBLDBL(((NAME16II)structData[i]).name, ((NAME16II)structData[i]).i1val, ((NAME16II)structData[i]).i2val);
                    }
                    cc = (short)dout.putData(sd64);
                    break;
                }
                default: {
                    cc = 2;
                    break;
                }
            }
        } else {
            cc = 62;
        }
        return (short)cc;
    }

    private short callPropertyBitfieldFormat(String devName, TDataType dout, TDataType din, TAccess devAccess) {
        if (din == null) {
            MsgLog.log("callPropertyBitfieldFormat", "callPropertyBitfieldFormat, din == null", 66, null, 0);
            return 66;
        }
        short cc = 0;
        String tag = din.toString();
        TBitfield tbf = TBitfieldRegistry.getBitfield(tag = tag.replace('\n', '\u0000').trim());
        if (tbf == null) {
            return 62;
        }
        TField[] tbff = tbf.getFields();
        TCompoundDataObject[] ni = new NAME16I[tbff.length + 1];
        for (int i = 0; i < tbff.length; ++i) {
            ni[i] = new NAME16I(tbff[i].getName(), tbff[i].getBitmask());
        }
        ni[tbff.length] = new NAME16I(tag, tbf.getFormat());
        switch (dout.getFormat()) {
            case 21: {
                cc = (short)dout.putData(ni);
                break;
            }
            case 54: {
                TCompoundDataObject[] ni64 = new NAME64DBL[ni.length];
                for (int i = 0; i < ni.length; ++i) {
                    ni64[i] = new NAME64DBL(((NAME16I)ni[i]).name, ((NAME16I)ni[i]).ival);
                }
                cc = (short)dout.putData(ni64);
                break;
            }
            default: {
                cc = 2;
            }
        }
        return cc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private short callPropertyContracts(String devName, TDataType dout, TDataType din, TAccess devAccess) {
        short cc = 0;
        String dTag = dout.getTag();
        if (dTag.length() == 0) {
            int ssz = TStructRegistry.getSizeInBytes("CONQS");
            if (dout.getArrayLength() % ssz != 0) {
                return 153;
            }
            dTag = "CONQS";
        }
        if (dTag.compareTo("CONQS") != 0 && dTag.compareTo("CTQSr4") != 0) {
            return 62;
        }
        ArrayList<TContractTable> arrayList = this.conTable;
        synchronized (arrayList) {
            Iterator<TContractTable> it = this.conTable.iterator();
            ByteArrayOutputStream bsout = new ByteArrayOutputStream(1024);
            TDataOutputStream sdout = new TDataOutputStream(bsout);
            TContractTable contract = null;
            try {
                while (it.hasNext()) {
                    contract = it.next();
                    contract.writeData(dTag, sdout);
                }
                sdout.close();
                dout.putData(bsout.toByteArray(), dTag);
            }
            catch (Exception e) {
                cc = 66;
            }
        }
        return cc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private short callPropertyClients(String devName, TDataType dout, TDataType din, TAccess devAccess) {
        short cc = 0;
        ArrayList<TClient> arrayList = this.clnTable;
        synchronized (arrayList) {
            Iterator<TClient> it = this.clnTable.iterator();
            ByteArrayOutputStream bsout = new ByteArrayOutputStream(1024);
            TDataOutputStream sdout = new TDataOutputStream(bsout);
            TClient element = null;
            try {
                while (it.hasNext()) {
                    element = it.next();
                    element.writeData(sdout);
                }
                sdout.close();
                dout.putData(bsout.toByteArray(), "CLNQS");
            }
            catch (Exception e) {
                cc = 66;
            }
        }
        return cc;
    }

    private InetAddress getMCastAddr() {
        if (this.mcastInetAddress != null) {
            return this.mcastInetAddress;
        }
        try {
            String[] mcaddr = initializer.getMCastAddress().split("\\.");
            InetAddress myip = InetAddress.getLocalHost();
            String[] ipaddr = myip.getHostAddress().split("\\.");
            String ip = mcaddr[0] + "." + mcaddr[1] + "." + ipaddr[2] + "." + ipaddr[3];
            this.mcastInetAddress = InetAddress.getByName(ip);
            return this.mcastInetAddress;
        }
        catch (Exception e) {
            return null;
        }
    }

    private InetAddress getBCastAddr(InetAddress ia) {
        String strAddr = ia.getHostAddress();
        strAddr = strAddr.substring(0, strAddr.lastIndexOf(46)).concat("255");
        try {
            return InetAddress.getByName(strAddr);
        }
        catch (Exception e) {
            return null;
        }
    }

    private int findpoll(int p1, int p2) {
        block6: {
            int p3;
            block5: {
                int p32;
                if (this.gMinPollingRate > this.gMaxPollingRate) {
                    this.gMinPollingRate = this.gMaxPollingRate;
                }
                if (p1 < this.gMinPollingRate) {
                    return p2 <= this.gMinPollingRate ? this.gMinPollingRate : p2;
                }
                if (p2 < this.gMinPollingRate || p1 == p2) {
                    return p1;
                }
                if (p2 >= p1) break block5;
                while ((p32 = p1 % p2) >= this.gMinPollingRate) {
                    p1 = p2;
                    p2 = p32;
                }
                break block6;
            }
            if (p1 >= p2) break block6;
            while ((p3 = p2 % p1) >= this.gMinPollingRate) {
                p2 = p1;
                p1 = p3;
            }
        }
        return p1 > p2 ? p2 : p1;
    }

    private boolean isMemberBcastNets(TClient tc) {
        if (debugLevel > 0) {
            DbgLog.log("IsMemberBcastNets", "non yet implemented");
        }
        return true;
    }

    private boolean isMemberControlNets(TEquipmentModule eqm, TClient tc) {
        if (eqm.gRejectAllNets) {
            return false;
        }
        if (eqm.gRegisteredNetsList == null || eqm.gRegisteredNetsList.size() == 0) {
            return true;
        }
        String tgtAddr = tc.IPaddress.getHostAddress();
        if (eqm.gRegisteredNetsList.contains(tgtAddr)) {
            return true;
        }
        String[] s = tgtAddr.split("\\.");
        if (s.length < 4) {
            return false;
        }
        String netAddr = s[0] + "." + s[1] + "." + s[2] + ".255";
        if (eqm.gRegisteredNetsList.contains(netAddr)) {
            return true;
        }
        netAddr = s[0] + "." + s[1] + ".255.255";
        return eqm.gRegisteredNetsList.contains(netAddr);
    }

    private boolean isMemberUsersList(TEquipmentModule eqm, String userName) {
        if (eqm.gRegisteredUsersList == null || eqm.gRegisteredUsersList.size() == 0) {
            return true;
        }
        return eqm.gRegisteredUsersList.contains(userName.toUpperCase());
    }

    private boolean isMemberLockSet(TEquipmentModule eqm, TClient tc) {
        return eqm.accessLock.clientCanWrite(tc);
    }

    private TEquipmentModule LocateEquipmentModule(TContract tc) {
        for (int i = 0; i < this.numEqmTableEntries; ++i) {
            if (this.eqmTable[i] == null || this.eqmTable[i].getModuleName().length() == 0 || this.eqmTable[i].getModuleName().compareTo(tc.eqmName) != 0) continue;
            return this.eqmTable[i];
        }
        return null;
    }

    private TClientEntry LocateClientInContract(TContractTable tct, TClient tc) {
        TClientEntry tce2 = null;
        for (TClientEntry tce2 : tct.clt) {
            if (!tce2.cln.equals(tc)) continue;
            if (tc.ncontracts == 0) {
                DbgLog.log("LocateClientInContract", "found client in contract list, but client has no contracts!");
                tct.pending = 0;
                if (tct.nclients == 0) {
                    ++tct.nclients;
                }
                tc.ncontracts = (short)(tc.ncontracts + 1);
                tc.addContract(tct);
                if (tc.tineProtocol == 0) {
                    tc.tineProtocol = (short)6;
                }
            }
            if (debugLevel > 2) {
                DbgLog.log("LocateClientInContract", "found client " + tc.IPaddress.getHostAddress() + " in contract list");
            }
            return tce2;
        }
        tce2 = new TClientEntry();
        tce2.cln = tc;
        tce2.cln.ncontracts = (short)(tce2.cln.ncontracts + 1);
        tce2.cln.addContract(tct);
        tce2.sts = new TClientStatus(tc.inetProtocol);
        tce2.sts.statusCode = (short)tct.returnCode;
        tce2.sts.counter = 1;
        tct.clt.add(tce2);
        ++tct.nclients;
        if (debugLevel > 2) {
            DbgLog.log("LocateClientInContract", "added client " + tc.IPaddress.getHostAddress() + " to contract list");
        }
        return tce2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TContractTable LocateContractInList(TContract con, TDataType din, boolean[] isNew) {
        TContractTable tct2 = null;
        int freeContractID = 1;
        isNew[0] = false;
        AbstractList abstractList = this.conTable;
        synchronized (abstractList) {
            for (int i = 0; i < this.conTable.size(); ++i) {
                tct2 = this.conTable.get(i);
                if (tct2.contractID == freeContractID) {
                    ++freeContractID;
                }
                if (!tct2.contract.equals(con) || tct2.din != null && !tct2.din.equals(din)) continue;
                if (debugLevel > 2) {
                    DbgLog.log("LocateContractInList", "found contract in list");
                }
                return tct2;
            }
        }
        abstractList = this.conTableAdd;
        synchronized (abstractList) {
            for (TContractTable tct2 : this.conTableAdd) {
                if (tct2.contractID == freeContractID) {
                    ++freeContractID;
                }
                if (!tct2.contract.equals(con) || tct2.din != null && !tct2.din.equals(din)) continue;
                if (debugLevel > 2) {
                    DbgLog.log("LocateContractInList", "found contract in list");
                }
                return tct2;
            }
            tct2 = new TContractTable();
            if (tct2 != null) {
                int sizeOut = con.dataSizeOut;
                String tagOut = con.dataTagOut;
                if (con.dataFormatOut == 57) {
                    sizeOut = Integer.parseInt(tagOut);
                    tagOut = "";
                }
                tct2.contract = con;
                tct2.contractID = freeContractID;
                tct2.din = din;
                tct2.dout = new TDataType(sizeOut, con.dataFormatOut);
                tct2.dout.setTag(tagOut);
                tct2.drb = new TDataType(sizeOut, con.dataFormatOut);
                tct2.drb.setTag(tagOut);
                tct2.eqm = this.LocateEquipmentModule(con);
                if (debugLevel > 2) {
                    DbgLog.log("LocateContractInList", "added contract to list (ID = " + tct2.contractID + ")");
                }
                this.conTableAdd.add(tct2);
                isNew[0] = true;
            }
        }
        return tct2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TClient LocateClientInList(InetAddress ia, int port) {
        TClient tc2 = null;
        if (debugLevel > 3) {
            DbgLog.log("LocateClientInList", "incoming request from client " + ia.getHostAddress());
        }
        LinkedList<TClient> linkedList = this.clnTableAdd;
        synchronized (linkedList) {
            for (TClient tc2 : this.clnTableAdd) {
                if (!tc2.IPaddress.equals(ia) || tc2.port != port) continue;
                if (debugLevel > 2) {
                    DbgLog.log("LocateClientInList", "found client (not yet appended)" + ia.getHostAddress() + " in client list");
                }
                return tc2;
            }
            ArrayList<TClient> arrayList = this.clnTable;
            synchronized (arrayList) {
                for (int i = 0; i < this.clnTable.size(); ++i) {
                    tc2 = this.clnTable.get(i);
                    if (!tc2.IPaddress.equals(ia) || tc2.port != port) continue;
                    if (debugLevel > 2) {
                        DbgLog.log("LocateClientInList", "found client" + ia.getHostAddress() + " in client list");
                    }
                    return tc2;
                }
            }
            tc2 = new TClient();
            if (tc2 != null) {
                tc2.IPaddress = ia;
                tc2.port = port;
                this.clnTableAdd.add(tc2);
                if (debugLevel > 2) {
                    DbgLog.log("LocateClientInList", "add client" + ia.getHostAddress() + " to client list");
                }
            } else {
                throw new RuntimeException("code error : cannot make new instance of TClient!");
            }
        }
        return tc2;
    }

    private TEquipmentModuleFactory() {
        debugLevel = Integer.parseInt(System.getProperty("debug.level", "0"));
        this.cycleThrd = new TCycleThread();
        this.cycleThrd.start();
        this.acceptThrd = new TAcceptorThread(8);
        this.acceptThrd.start();
        this.acceptThrd = new TAcceptorThread(4);
        this.acceptThrd.start();
        this.registerStockProperties();
        this.getAliasListFromFile();
    }

    public long getServerStartTime() {
        return this.gSrvStartupTime;
    }

    public int[] getServerStats() {
        this.gSrvStatsBuffer[0] = 0;
        this.gSrvStatsBuffer[1] = 0;
        this.gSrvStatsBuffer[2] = 0;
        this.gSrvStatsBuffer[3] = this.gSingleLinkCount;
        this.gSrvStatsBuffer[4] = this.gClientMisses;
        this.gSrvStatsBuffer[5] = this.gClientReconnects;
        this.gSrvStatsBuffer[6] = this.gClientRetries;
        this.gSrvStatsBuffer[7] = this.gContractMisses;
        this.gSrvStatsBuffer[8] = this.gContractDelays;
        this.gSrvStatsBuffer[9] = this.gBurstLimitReachedCount;
        this.gSrvStatsBuffer[10] = (int)this.gDataTimeStampOffset * 1000;
        return this.gSrvStatsBuffer;
    }

    public long getAppCompilationTime() {
        return this.gAppCompilationTime;
    }

    public String getAppVersion() {
        StringBuffer appv = new StringBuffer(32);
        appv.append("" + this.gAppVersionMajor);
        if (this.gAppVersionMinor < 10) {
            appv.append(".0" + this.gAppVersionMinor);
        } else {
            appv.append("." + this.gAppVersionMinor);
        }
        if (this.gAppVersionRevision < 10) {
            appv.append(".000" + this.gAppVersionRevision);
        } else if (this.gAppVersionRevision < 100) {
            appv.append(".00" + this.gAppVersionRevision);
        } else if (this.gAppVersionRevision < 1000) {
            appv.append(".0" + this.gAppVersionRevision);
        } else {
            appv.append("." + this.gAppVersionRevision);
        }
        return appv.toString();
    }

    public int getAppVersionMajor() {
        return this.gAppVersionMajor;
    }

    public int getAppVersionMinor() {
        return this.gAppVersionMinor;
    }

    public int getAppVersionRevision() {
        return this.gAppVersionRevision;
    }

    public void setAppVersionMajor(int major) {
        this.gAppVersionMajor = major;
    }

    public void setAppVersionMinor(int minor) {
        this.gAppVersionMinor = minor;
    }

    public void setAppVersionRevision(int revision) {
        this.gAppVersionRevision = revision;
    }

    public static TEquipmentModuleFactory getInstance() {
        if (instance == null) {
            instance = new TEquipmentModuleFactory();
        }
        return instance;
    }

    public int setFecName(String name) {
        if (name.length() <= 16) {
            this.gFecName = new String(name);
        } else {
            this.gFecName = new String(name.substring(0, 16));
            TFecLog.log("FEC name " + name + " too long; truncating to " + this.gFecName);
            TStrings.validateFecName(this.gFecName);
        }
        return 0;
    }

    public String getFecName() {
        return this.gFecName;
    }

    public int setFecContext(String context) {
        TStrings.validateContextName(context);
        this.gFecContext = new String(context);
        return 0;
    }

    public String getFecContext() {
        return this.gFecContext;
    }

    public void setFecDescription(String description) {
        if (description != null) {
            this.gFecDescription = description;
        }
    }

    public String getFecDescription() {
        return this.gFecDescription;
    }

    public void setFecLocation(String location) {
        if (location != null) {
            this.gFecLocation = location;
        }
    }

    public String getFecLocation() {
        return this.gFecLocation;
    }

    public void setFecSubsystem(String subsystem) {
        if (subsystem != null) {
            TStrings.validateSubSystemName(subsystem);
            this.gFecSubsystem = subsystem;
        }
    }

    public String getFecSubsystem() {
        return this.gFecSubsystem;
    }

    public void setFecHardware(String hardware) {
        if (hardware != null) {
            this.gFecHardware = hardware;
        }
    }

    public String getFecHardware() {
        return this.gFecHardware;
    }

    public void setFecResponsible(String responsible) {
        if (responsible != null) {
            this.gFecResponsible = responsible;
        }
    }

    public String getFecResponsible() {
        return this.gFecResponsible;
    }

    public long getLastAccessTime() {
        return this.gLastWriteAccessTime;
    }

    public String getLastAccessUser() {
        return this.gLastWriteAccessUser;
    }

    public InetAddress getLastAccessAddress() {
        return this.gLastWriteAccessAddr;
    }

    public String getLastAccessEqm() {
        return this.gLastWriteAccessEqm;
    }

    public String getLastAccessPrp() {
        return this.gLastWriteAccessPrp;
    }

    public String getLastAccessDev() {
        return this.gLastWriteAccessDev;
    }

    public String makeModuleName(String suggestedModuleName) {
        int n;
        String eqmName = suggestedModuleName;
        if (eqmName.length() > 6) {
            eqmName = eqmName.substring(0, 6);
            TFecLog.log("Module Name " + suggestedModuleName + " too long; truncating to " + eqmName);
        }
        TStrings.validateLocalName(eqmName);
        for (n = 0; n < this.numEqmTableEntries && this.eqmTable[n].getModuleName().compareTo(eqmName) != 0; ++n) {
        }
        if (n == this.numEqmTableEntries) {
            return eqmName;
        }
        DbgLog.log("makeModuleName", "equipment module name conflict !");
        DbgLog.log("makeModuleName", "Please use a different name for " + suggestedModuleName + " and try again!");
        return null;
    }

    public int addEquipmentBackgroundTask(TEquipmentBackgroundTask tbkg) {
        TBackgroundThread tbt = new TBackgroundThread(tbkg);
        if (tbt == null) {
            return -1;
        }
        TFecLog.log("add Equipment Background task " + tbkg.getClass().getSimpleName());
        tbkg.startup();
        tbt.start();
        ++this.gNumBkgTasks;
        return 0;
    }

    public TEquipmentModule getEquipmentModule(String EqmName) {
        for (int i = 0; i < this.numEqmTableEntries; ++i) {
            String eqm = this.eqmTable[i].getLocalName();
            if (eqm == null || eqm.compareTo(EqmName) != 0) continue;
            return this.eqmTable[i];
        }
        return null;
    }

    public int addEquipmentModule(TEquipmentModule teqm) {
        int i;
        for (i = 0; i < this.numEqmTableEntries; ++i) {
            if (this.eqmTable[i] != teqm) continue;
            return i;
        }
        if (i < 16) {
            TFecLog.log("add Equipment Module (" + i + ") " + teqm.getClass().getSimpleName());
            ++this.numEqmTableEntries;
            this.eqmTable[i] = teqm;
            if (teqm.getLocalName().length() > 0) {
                this.registrationPending = true;
            }
            return i;
        }
        return -1;
    }

    private int maxDeadTime(short mode, int pollingRate) {
        if (mode == 2) {
            return 60 + pollingRate;
        }
        return 2 * pollingRate;
    }

    private int doDelivery() {
        boolean passed = false;
        boolean snddata = false;
        boolean actionTaken = false;
        boolean isLegacy = false;
        int totalsize = 0;
        TContractTable tct = null;
        TClientEntry tce = null;
        TClient tc = null;
        TPHdr pHdr = null;
        byte[] payload = this.deliveryPayload;
        long t_now = System.currentTimeMillis();
        int pkts_sent = 0;
        int npkts = 0;
        int ncnts = 0;
        TContractTable[] ctbl = null;
        if (debugLevel > 0 && this.clnTable.size() == 0) {
            DbgLog.log("doDelivery", "no client table in deliver data !");
        }
        int ipos = 0;
        for (int k = 0; k < this.clnTable.size(); ++k) {
            tc = this.clnTable.get(k);
            if (tc == null) continue;
            isLegacy = tc.tineProtocol < 6;
            int hdrsize = isLegacy ? 24 : 44;
            int extlimit = isLegacy ? 32 : 192;
            passed = true;
            totalsize = 2;
            ctbl = tc.getContractList();
            if (ctbl == null || ctbl.length == 0) {
                MsgLog.log("doDelivery", "remove dangling client " + tc.userName, 88, null, 1);
                this.removeClient(k--);
                continue;
            }
            int n = 0;
            for (int i = ipos; i < ctbl.length && n < tc.ncontracts; ++i) {
                tct = ctbl[i];
                Iterator<TClientEntry> li = tct.clt.iterator();
                boolean found = false;
                while (li.hasNext()) {
                    tce = li.next();
                    if (!tc.equals(tce.cln)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    tct.pending = 0;
                    continue;
                }
                if (debugLevel > 1) {
                    DbgLog.log("doDelivery", "delivering data");
                }
                if (tc.inetProtocol == 4 && tc.output == null) {
                    tce.sts.counter = 0;
                }
                ++n;
                snddata = true;
                int extsize = 0;
                int extptr = 0;
                short basemode = tce.sts.mode;
                if (tce.sts.Stale != 0) {
                    byte[] b;
                    int dptr;
                    int dsize;
                    actionTaken = true;
                    int stepsize = hdrsize;
                    int packetmtu = 2 + stepsize + tce.sts.mtu;
                    boolean bl = snddata = tce.sts.statusCode == 0 || (tce.sts.statusCode & 0x4000) != 0;
                    if (snddata) {
                        dsize = tce.sts.nextDataSize;
                        dptr = tce.sts.nextDataPtr;
                    } else {
                        dsize = extsize = extlimit;
                        dptr = 0;
                    }
                    int msgsize = dsize + stepsize;
                    if (msgsize > packetmtu) {
                        tce.sts.counter = 0;
                        continue;
                    }
                    if (totalsize + msgsize > packetmtu) {
                        passed = false;
                        ipos = i;
                        break;
                    }
                    ++ncnts;
                    pHdr = new TPHdr(msgsize, tce, tct);
                    System.arraycopy(pHdr.dBuffer.toByteArray(), 0, payload, totalsize, stepsize);
                    int fsize = TFormat.formatSizeOf(tct.contract.dataFormatOut);
                    if (snddata && fsize > 0) {
                        if ((tce.sts.statusCode & 0xFFF) != 0) {
                            extsize = tce.sts.nextDataPtr + tce.sts.nextDataSize - tct.contract.dataSizeOut * fsize;
                            if (extsize > extlimit) {
                                extsize = extlimit;
                            }
                            if (extsize > dsize) {
                                extsize = dsize;
                                extptr = extlimit - extsize;
                            }
                            if (extsize > 0) {
                                dsize -= (short)extsize;
                            } else {
                                extsize = 0;
                            }
                        }
                        if (dsize > 0) {
                            b = tct.dout.getDataBuffer();
                            int thissize = b.length - dptr;
                            if (thissize < 0) {
                                thissize = 0;
                            }
                            if (dsize > thissize) {
                                dsize = thissize;
                            }
                            if (debugLevel > 1) {
                                DbgLog.log("doDelivery", "dout size :" + b.length + " payload size : " + payload.length + "  data size : " + dsize);
                            }
                            try {
                                if (b != null && dsize > 0) {
                                    System.arraycopy(b, dptr, payload, totalsize + stepsize, dsize);
                                }
                            }
                            catch (ArrayIndexOutOfBoundsException e) {
                                e.printStackTrace();
                                MsgLog.log("doDelivery", "b len " + b.length + " dptr " + dptr + " payload " + payload.length + " offset " + totalsize + stepsize + " size " + dsize, 23, e, 0);
                            }
                        }
                    }
                    if (passed) {
                        totalsize += msgsize;
                        if (extsize > 0) {
                            b = null;
                            if (tce.sts.statusCode == 121) {
                                this.gLastErrorString = tct.compString;
                                tce.sts.counter = 1;
                                b = this.redirectionStringToBytes(tct.compString);
                            } else if ((tce.sts.statusCode & 0xFFF) < TErrorList.errorString.length) {
                                this.gLastErrorString = TErrorList.getErrorString(tce.sts.statusCode & 0xFF);
                                b = this.gLastErrorString.getBytes();
                            } else if (tct.compString != null) {
                                this.gLastErrorString = tct.compString;
                                b = this.gLastErrorString.getBytes();
                            }
                            if (b == null) {
                                b = "error unknown".getBytes();
                            }
                            Arrays.fill(payload, totalsize - extsize, totalsize - 1, (byte)0);
                            System.arraycopy(b, extptr, payload, totalsize - extsize, b.length);
                        }
                        if (debugLevel > 2) {
                            String dbgstr = "" + totalsize + " bytes to " + tce.cln.userName + " (" + tce.sts.counter + ") <" + tce.sts.statusCode + ">";
                            DbgLog.log("doDelivery", dbgstr);
                        }
                        if (!snddata || tce.sts.numblks == tce.sts.blknum) {
                            if (debugLevel > 2) {
                                DbgLog.log("doDelivery", "data delivery finished");
                            }
                            tce.sts.Stale = 0;
                            if (tce.sts.counter > 0) {
                                tce.sts.counter = (short)(tce.sts.counter - 1);
                            }
                            if (tce.sts.mode == 0) {
                                tce.sts.counter = 0;
                            }
                            tce.sts.blknum = 1;
                            tce.sts.nextDataPtr = 0;
                            tce.sts.BytesRemaining = tce.sts.BytesTotal;
                            --tct.pending;
                            if (t_now - tce.sts.lasttime > (long)this.maxDeadTime(tce.sts.mode, tce.sts.PollingRate)) {
                                ++tce.sts.misses;
                                ++this.gClientMisses;
                            }
                        } else {
                            tce.sts.blknum = (short)(tce.sts.blknum + 1);
                            tce.sts.nextDataPtr += tce.sts.nextDataSize;
                            tce.sts.BytesRemaining = tce.sts.BytesTotal - tce.sts.nextDataPtr;
                            ++this.gStaleData;
                        }
                        int n2 = tce.sts.nextDataSize = tce.sts.mtu < tce.sts.BytesRemaining ? tce.sts.mtu : tce.sts.BytesRemaining;
                    }
                }
                if (passed && tce.sts.counter <= 0) {
                    if (debugLevel > 0) {
                        DbgLog.log("doDelivery", "remove " + tce.cln.userName + " from contract " + tct.contract.eqmProperty);
                    }
                    actionTaken = true;
                    tce.cln.ncontracts = (short)(tce.cln.ncontracts - 1);
                    tce.cln.rmvContract(tct);
                    tct.clt.remove(tce);
                    --tct.nclients;
                    --n;
                    if (debugLevel > 1) {
                        DbgLog.log("doDelivery", " contract " + tct.contract.eqmProperty + " now has " + tct.nclients + " clients");
                    }
                }
                if (!passed || tct.nclients != 0) continue;
                actionTaken = true;
                if (this.gRetardSingleContractRemoval && basemode == 1) {
                    if (debugLevel > 1) {
                        DbgLog.log("doDelivery", "mark contract " + tct.contract.eqmProperty + " as expired");
                    }
                    tct.expired = true;
                    tct.contract.dataAccess = TAccess.removeBits(tct.contract.dataAccess, (short)192);
                    ++this.numExpiredContracts;
                    continue;
                }
                if (debugLevel > 1) {
                    DbgLog.log("doDelivery", "remove contract " + tct.contract.eqmProperty);
                }
                this.removeContract(tct);
            }
            if (totalsize > 2 && tc != null) {
                actionTaken = true;
                payload[0] = (byte)(totalsize & 0xFF);
                payload[1] = (byte)(totalsize >> 8);
                this.sendToPeer(tc, payload, totalsize);
                ++pkts_sent;
                ++npkts;
                if (debugLevel > 2) {
                    DbgLog.log("doDelivery", "client " + k + " sent packet " + npkts + " ncontracts: " + ncnts);
                }
            }
            ncnts = 0;
            if (passed && tc.ncontracts == 0) {
                if (debugLevel > 1) {
                    DbgLog.log("doDelivery", "remove client " + tc.userName);
                }
                this.removeClient(k--);
            }
            if (!passed) {
                --k;
                continue;
            }
            ipos = 0;
            npkts = 0;
        }
        this.gStaleData = this.gStaleData > 0 ? --this.gStaleData : 0;
        if (!actionTaken || pkts_sent == 0) {
            if (debugLevel > 2) {
                DbgLog.log("doDelivery", actionTaken ? "no packets sent in doDelivery()" : "empty pass through doDelivery()");
            }
            this.gStaleData = 0;
        }
        if (debugLevel > 1) {
            DbgLog.log("doDelivery", "sent " + pkts_sent + " packets in " + (System.currentTimeMillis() - t_now) + " msecs");
        }
        return this.gStaleData;
    }

    private void sendToPeer(TClient tc, byte[] payload, int length) {
        if (debugLevel > 1) {
            DbgLog.log("sendToPeer", tc.IPaddress.getHostAddress() + ":" + tc.port);
        }
        try {
            switch (tc.inetProtocol) {
                case 8: {
                    this.srvp.dpOut = new DatagramPacket(payload, length, tc.IPaddress, tc.port);
                    this.srvp.getSocket().send(this.srvp.dpOut);
                    break;
                }
                case 4: {
                    byte[] buf = new byte[length];
                    System.arraycopy(payload, 0, buf, 0, length);
                    tc.output.write(buf);
                }
            }
        }
        catch (Exception e) {
            DbgLog.log("sendToPeer", e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClient(int i) {
        ArrayList<TClient> arrayList = this.clnTable;
        synchronized (arrayList) {
            this.clnTable.remove(i);
            this.serverStatistics.setNumTotalClients((short)this.clnTable.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContract(int i) {
        ArrayList<TContractTable> arrayList = this.conTable;
        synchronized (arrayList) {
            this.conTable.remove(i);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContract(TContractTable tct) {
        ArrayList<TContractTable> arrayList = this.conTable;
        synchronized (arrayList) {
            this.conTable.remove(tct);
            this.serverStatistics.setNumTotalContracts((short)this.conTable.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContract(TContractTable tct) {
        ArrayList<TContractTable> arrayList = this.conTable;
        synchronized (arrayList) {
            this.conTable.add(tct);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpContractTable() {
        System.out.println("\nCurrent Contract Table");
        ArrayList<TContractTable> arrayList = this.conTable;
        synchronized (arrayList) {
            for (int i = 0; i < this.conTable.size(); ++i) {
                TContractTable tct = this.conTable.get(i);
                System.out.println(tct.toString());
            }
        }
        System.out.println("\n(inside scheduler : " + this.gIsInsideScheduler + ")");
        System.out.println("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpClientTable() {
        System.out.println("\nCurrent Client Table");
        ArrayList<TClient> arrayList = this.clnTable;
        synchronized (arrayList) {
            for (int i = 0; i < this.clnTable.size(); ++i) {
                TClient tc = this.clnTable.get(i);
                System.out.println(tc.toString());
            }
        }
        System.out.println("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTables() {
        ArrayList<TStructBase> arrayList;
        TContractTable tct2 = null;
        TClient tc2 = null;
        LinkedList<TStructBase> linkedList = this.clnTableAdd;
        synchronized (linkedList) {
            if (this.clnTableAdd.size() > 0) {
                arrayList = this.clnTable;
                synchronized (arrayList) {
                    for (TClient tc2 : this.clnTableAdd) {
                        this.clnTable.add(tc2);
                    }
                    this.clnTableAdd.clear();
                }
            }
        }
        this.serverStatistics.setNumTotalClients((short)this.clnTable.size());
        linkedList = this.conTableAdd;
        synchronized (linkedList) {
            if (this.conTableAdd.size() > 0) {
                arrayList = this.conTable;
                synchronized (arrayList) {
                    for (TContractTable tct2 : this.conTableAdd) {
                        this.conTable.add(tct2);
                    }
                }
            }
            this.conTableAdd.clear();
        }
        this.serverStatistics.setNumTotalContracts((short)this.conTable.size());
        for (int i = 0; i < this.clnTable.size(); ++i) {
            tc2 = this.clnTable.get(i);
            tc2.appendAddedContracts();
        }
    }

    private void assertClientTableConsistent(TContractTable tct) {
        try {
            if (tct.clt.size() == 0) {
                return;
            }
            Iterator<TClientEntry> li = tct.clt.iterator();
            while (li.hasNext()) {
                TClientEntry tce = li.next();
                for (int i = 0; i < this.clnTable.size(); ++i) {
                    if (!tce.cln.equals(this.clnTable.get(i))) continue;
                    return;
                }
                li.remove();
                if (tct.nclients <= 0) continue;
                --tct.nclients;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isInsideScheduler() {
        return this.gIsInsideScheduler;
    }

    private synchronized void doScheduler() {
        this.gIsInsideScheduler = true;
        try {
            int i;
            TContractTable tct = null;
            TClientEntry tce2 = null;
            int cc = 0;
            int datasize = 0;
            int msec = 0;
            boolean isScheduled = false;
            boolean isCanceled = false;
            boolean stale = false;
            boolean dirty = false;
            boolean hasData = false;
            boolean markedStale = false;
            long delta_t = 0L;
            long t_now = System.currentTimeMillis();
            long t_stamp = 0L;
            this.updateTables();
            block7: for (i = 0; i < this.conTable.size(); ++i) {
                tct = this.conTable.get(i);
                if (debugLevel > 3) {
                    DbgLog.log("doScheduler", "looking at contract " + tct.contract.toString() + " with " + tct.nclients + " clients @ " + new Date(t_now).toString());
                }
                if (tct.clt.size() == 0 && !tct.expired) {
                    if (debugLevel > 3) {
                        DbgLog.log("doScheduler", "contract has no clients");
                    }
                    if (TAccess.isLast(tct.contract.dataAccess)) {
                        this.doContract(tct);
                        this.removeContract(i--);
                    }
                    tct.expired = true;
                    tct.pending = 0;
                    continue;
                }
                this.assertClientTableConsistent(tct);
                isScheduled = false;
                if (tct.isStale) {
                    ++this.gStaleData;
                    markedStale = true;
                }
                cc = 0;
                datasize = tct.contract.getOutputDataSize();
                delta_t = t_now - tct.lasttime;
                if (delta_t < 0L) {
                    tct.lasttime = t_now;
                }
                if (delta_t <= (long)tct.pollingRate - (long)this.gSystemTick) continue;
                if (debugLevel > 2) {
                    DbgLog.log("doScheduler", "contract needs attention : polling interval " + tct.pollingRate + " last accessed : " + tct.lasttime);
                }
                if (tct.expired) {
                    if (delta_t > (long)(3 * tct.pollingRate) && !tct.isStale) {
                        if (debugLevel > 1) {
                            DbgLog.log("doScheduler", "removing expired contract");
                        }
                        this.removeContract(i--);
                        continue;
                    }
                    if (tct.clt.size() == 0) continue;
                }
                if (delta_t < (long)this.gMaxPollingRate && delta_t >= (long)(2 * tct.pollingRate)) {
                    ++tct.misses;
                    ++this.gContractMisses;
                    if (debugLevel > 1) {
                        DbgLog.log("doScheduler", "missed schedule on " + tct.contract.eqmProperty + " " + tct.contract.eqmDeviceName + " : " + delta_t + " vs " + tct.pollingRate);
                    }
                }
                if (tct.pending > 0 && this.clnTable.size() > 0) {
                    if (debugLevel > 2) {
                        DbgLog.log("doScheduler", "still sending out contract to clients");
                    }
                    ++tct.delays;
                    ++this.gContractDelays;
                    if (this.gStaleData == 0) {
                        ++this.gStaleData;
                    }
                    for (TClientEntry tce2 : tct.clt) {
                        tce2.sts.Stale = (byte)tct.pending;
                    }
                    continue;
                }
                if (tct.starttime == 0L) {
                    tct.starttime = t_now;
                }
                t_stamp = t_now;
                msec = (int)(t_now % 100L);
                if (this.gSynchronizeContracts && tct.pollingRate % 100 == 0 && msec < 100 - this.gSystemTick) {
                    t_stamp = t_now - (long)msec;
                }
                long dts = this.gDataTimeStamp = t_now + this.gDataTimeStampOffset;
                int dss = this.gSystemStamp;
                int dus = 0;
                if (tct.nclients == 1) {
                    tce2 = (TClientEntry)tct.clt.element();
                    if (tce2.sts.counter == 1 && !tct.isRepeat) {
                        tct.contract.dataAccess = (byte)(tct.contract.dataAccess | 0x80);
                    }
                }
                hasData = true;
                if (debugLevel > 2) {
                    DbgLog.log("doScheduler", "processing contract");
                }
                cc = this.doContract(tct);
                switch (cc) {
                    case 0: {
                        break;
                    }
                    case 29: {
                        tct.contract.dataAccess = TAccess.removeBits(tct.contract.dataAccess, (short)128);
                        tct.isRepeat = true;
                        if (this.gEqpFcnBusySemaphore && (t_now - tct.starttime >= (long)(tct.pollingRate + 500) || !this.gEqpFcnBusySemaphore)) break;
                        tct.setStale((byte)0);
                        tct.pending = 0;
                        continue block7;
                    }
                    case 121: {
                        tct.compString = new String(this.tRedirectedServer);
                    }
                    default: {
                        if ((cc & 0xF000) != 0) {
                            int rc = 0;
                            rc = tct.renegotiateContract((short)(cc & 0xFFF));
                            cc = rc != 0 ? rc : (cc &= 0xFFFFDFFF);
                            datasize = tct.contract.getOutputDataSize();
                            break;
                        }
                        hasData = false;
                    }
                }
                if ((tct.contract.dataAccess & 2) == 2) {
                    this.gLastWriteAccessTime = System.currentTimeMillis();
                    this.gLastWriteAccessUser = ((TClientEntry)tct.clt.element()).cln.userName;
                    this.gLastWriteAccessAddr = ((TClientEntry)tct.clt.element()).cln.IPaddress;
                    this.gLastWriteAccessPrp = tct.contract.eqmProperty;
                    this.gLastWriteAccessDev = tct.contract.eqmDeviceName;
                    this.gLastWriteAccessEqm = tct.contract.eqmName;
                }
                if (hasData) {
                    if (debugLevel > 3) {
                        DbgLog.log("doScheduler", "Contract has data");
                    }
                    dts = tct.drb.dTimestamp;
                    dss = tct.drb.sysDataStamp;
                    dus = tct.drb.usrDataStamp;
                    if (datasize > 0 && !tct.dout.equals(tct.drb)) {
                        tct.dout.copy(tct.drb);
                        dirty = true;
                        stale = true;
                    } else {
                        if (t_now - tct.lastmarked > 59000L) {
                            stale = true;
                        }
                        dirty = false;
                    }
                }
                if (cc != 0) {
                    stale = true;
                }
                if (stale) {
                    tct.lastmarked = t_stamp;
                }
                if (debugLevel > 2) {
                    DbgLog.log("doScheduler", "contract data is " + (stale ? "stale" : "not stale"));
                }
                if (tct.lasttime == 0L) {
                    isScheduled = true;
                }
                if (tct.lasttime == 2L) {
                    stale = true;
                    isCanceled = true;
                }
                if (cc == 29) {
                    cc = 97;
                } else {
                    tct.starttime = 0L;
                    if (!isCanceled) {
                        tct.lasttime = t_stamp;
                    }
                    tct.compStatus = 129;
                }
                tct.sysstamp = dss;
                tct.dtimestamp = dts;
                tct.usrstamp = dus;
                tct.returnCode = cc;
                for (TClientEntry tce2 : tct.clt) {
                    tce2.sts.statusCode = (short)cc;
                    if (isScheduled) {
                        tce2.sts.lasttime = 0L;
                    }
                    if (cc != 0) {
                        tce2.sts.Stale = 1;
                    }
                    if (tce2.sts.mode == 2 || tce2.sts.mode == 6) {
                        if (stale) {
                            tce2.sts.Stale = 1;
                            if (dirty && this.gRequireAcknowledgments) {
                                tce2.sts.counter = (short)10;
                            }
                        }
                    } else if (t_now - tce2.sts.lasttime > (long)(tce2.sts.PollingRate - this.gSystemTick)) {
                        tce2.sts.Stale = 1;
                    }
                    if (tce2.sts.Stale > 0) {
                        if (debugLevel > 2) {
                            DbgLog.log("doScheduler", "refresh client with new data");
                        }
                        ++tct.pending;
                        tce2.sts.lasttime = t_stamp;
                        if (this.gStaleData == 0) {
                            ++this.gStaleData;
                        }
                    }
                    if (tce2.sts.mode <= 1 || tce2.sts.counter != 10) continue;
                    tce2.sts.mode = Short.MAX_VALUE;
                    tce2.sts.PollingRate = tct.pollingRate;
                }
            }
            if (debugLevel > 2 && this.conTable.size() > 0) {
                DbgLog.log("doScheduler", "processed " + this.conTable.size() + " contracts in " + (System.currentTimeMillis() - t_now) + " msecs");
            }
            for (i = 0; this.gStaleData > 0 && i < this.gBurstLimit; ++i) {
                this.doDelivery();
            }
            if (this.gStaleData > 0) {
                if (debugLevel > 2) {
                    DbgLog.log("doScheduler", "deliverData() : burst limit exceeded");
                }
                ++this.gBurstLimitReachedCount;
            }
            if (markedStale) {
                for (i = 0; i < this.conTable.size(); ++i) {
                    tct = this.conTable.get(i);
                    tct.isStale = false;
                }
            }
        }
        catch (Exception e) {
            TFecLog.log("doScheduler", "unhandled execption " + e.getMessage());
        }
        this.gIsInsideScheduler = false;
    }

    private boolean isWildcardContract(String deviceString) {
        if (deviceString == null) {
            return false;
        }
        return deviceString.indexOf(42) != -1;
    }

    private int doContractWithWildcardDevice(TContractTable tct) {
        int start = 0;
        int len = 0;
        boolean isCont = false;
        int cc = 72;
        TAccess acc = new TAccess(tct.contract.dataAccess);
        int devlistsize = 0;
        String[] devlist = null;
        TEquipmentModule eqm = tct.eqm;
        String devprp = tct.contract.eqmProperty;
        String devnam = tct.contract.eqmDeviceName;
        TExportProperty prp = eqm.propertyList.getFirstProperty(devprp);
        short atype = prp.getDescription().getArrayType();
        if (atype == 32) {
            return 72;
        }
        if (tct.dout == null || tct.dout.dArrayLength < 1) {
            return 72;
        }
        if (!eqm.isDeviceSetLocal(devnam, devprp)) {
            return 133;
        }
        if (prp.getDeviceList() != null) {
            devlistsize = prp.getDeviceList().size();
            devlist = new String[devlistsize];
            prp.getDeviceList().toArray(devlist);
        }
        if (devlistsize == 0) {
            devlist = eqm.getDeviceList().getDeviceNameList();
            devlistsize = devlist.length;
        }
        if ((atype & 0x10) == 16) {
            len = devlistsize;
            int[] endpoints = StringToName.getContiguousEndpoints(devlist, devnam);
            if (endpoints != null) {
                isCont = true;
                start = endpoints[0];
                len = endpoints[1] - endpoints[0] + 1;
            }
        }
        WildcardMatch wc = new WildcardMatch(devnam);
        switch (tct.dout.dFormat) {
            case 10: 
            case 24: 
            case 41: 
            case 44: 
            case 45: {
                NAME16FI[] nfi;
                if (isCont) {
                    int dsiz = tct.contract.dataSizeOut > len ? len : tct.contract.dataSizeOut;
                    nfi = new NAME16FI[dsiz];
                    float[] frb = new float[dsiz];
                    TDataType drdb = new TDataType(frb);
                    cc = tct.eqm.callProperty(devprp, devlist[start], drdb, tct.din, acc);
                    if (cc != 0) {
                        return cc;
                    }
                    for (int i = 0; i < drdb.dArrayLength; ++i) {
                        nfi[i] = new NAME16FI(devlist[start + i], 0, frb[i]);
                    }
                    tct.drb.dArrayLength = drdb.dArrayLength;
                } else {
                    int dsiz = tct.contract.dataSizeOut;
                    nfi = new NAME16FI[dsiz];
                    float[] frb = new float[1];
                    TDataType drdb = new TDataType(frb);
                    int k = 0;
                    for (int i = 0; i < devlistsize && k < tct.dout.dArrayLength; ++i) {
                        if (!wc.matches(devlist[i])) continue;
                        cc = tct.eqm.callProperty(devprp, devlist[i], drdb, tct.din, acc);
                        if (cc == 121) {
                            return 133;
                        }
                        nfi[k] = new NAME16FI(devlist[i], cc, frb[0]);
                        ++k;
                    }
                    tct.drb.dArrayLength = k;
                }
                tct.drb.putData(nfi);
                return 0;
            }
            case 42: {
                TCompoundDataObject[] nii;
                if (isCont) {
                    int dsiz = tct.contract.dataSizeOut > len ? len : tct.contract.dataSizeOut;
                    nii = new NAME16II[dsiz];
                    int[] irb = new int[dsiz];
                    TDataType drdb = new TDataType(irb);
                    cc = tct.eqm.callProperty(devprp, devlist[start], drdb, tct.din, acc);
                    if (cc != 0) {
                        return cc;
                    }
                    for (int i = 0; i < drdb.dArrayLength; ++i) {
                        nii[i] = new NAME16II(devlist[start + i], 0, irb[i]);
                    }
                    tct.drb.dArrayLength = drdb.dArrayLength;
                } else {
                    int dsiz = tct.contract.dataSizeOut;
                    nii = new NAME16II[dsiz];
                    int[] irb = new int[1];
                    TDataType drdb = new TDataType(irb);
                    int k = 0;
                    for (int i = 0; i < devlistsize && k < tct.dout.dArrayLength; ++i) {
                        if (!wc.matches(devlist[i])) continue;
                        cc = tct.eqm.callProperty(devprp, devlist[i], drdb, tct.din, acc);
                        if (cc == 121) {
                            return 133;
                        }
                        nii[k] = new NAME16II(devlist[i], irb[0], cc);
                        ++k;
                    }
                    tct.drb.dArrayLength = k;
                }
                tct.drb.putData(nii);
                return 0;
            }
        }
        if (tct.dout.dFormat <= 13 && devnam.compareTo("*") == 0) {
            int i;
            if (isCont) {
                if (tct.dout.dArrayLength > len) {
                    tct.dout.dArrayLength = len;
                }
                return tct.eqm.callProperty(devprp, devlist[0], tct.dout, tct.din, acc);
            }
            TDataType drdb = new TDataType(1, tct.dout.dFormat);
            for (i = 0; i < devlistsize && i < tct.dout.dArrayLength && (cc = (int)tct.eqm.callProperty(devprp, devlist[i], drdb, tct.din, acc)) == 0; ++i) {
            }
            if (cc == 121) {
                return 133;
            }
            tct.drb.dArrayLength = i;
            tct.drb.putData(drdb);
            return cc;
        }
        return cc;
    }

    private int doContractWithWildcardProperty(TContractTable tct) {
        LinkedList<String> lst = null;
        int cc = 72;
        TAccess acc = new TAccess(tct.contract.dataAccess);
        int prplistsize = 0;
        String[] prplist = null;
        TEquipmentModule eqm = tct.eqm;
        String devprp = tct.contract.eqmProperty;
        String devnam = tct.contract.eqmDeviceName;
        if (tct.dout == null || tct.dout.dArrayLength < 1) {
            return 72;
        }
        int devnr = eqm.getDeviceList().getDeviceNumber(tct.contract.eqmDeviceName);
        if (devnr < 0) {
            return 35;
        }
        lst = eqm.getDeviceList().getDevice(devnr).getPropertyList();
        if (lst != null) {
            prplistsize = lst.size();
            prplist = new String[prplistsize];
            lst.toArray(prplist);
        } else {
            if (eqm.gPropertyNameList == null) {
                lst = eqm.getPropertyNames();
                if (lst == null) {
                    return 66;
                }
                prplistsize = lst.size();
                prplist = new String[prplistsize];
                lst.toArray(prplist);
                eqm.gPropertyNameList = prplist;
            }
            prplistsize = eqm.gPropertyNameList.length;
            prplist = eqm.gPropertyNameList;
        }
        WildcardMatch wc = new WildcardMatch(devprp);
        switch (tct.dout.dFormat) {
            case 10: 
            case 24: 
            case 41: 
            case 42: 
            case 44: 
            case 45: {
                int dsiz = tct.contract.dataSizeOut;
                NAME32DBLDBL[] ndd = new NAME32DBLDBL[dsiz];
                double[] drb = new double[1];
                TDataType drdb = new TDataType(drb);
                int k = 0;
                for (int i = 0; i < prplistsize && k < tct.dout.dArrayLength; ++i) {
                    TExportProperty prp;
                    if (!wc.matches(prplist[i]) || (prp = eqm.propertyList.getFirstProperty(prplist[i])).getDescription().getArrayType() == 32) continue;
                    cc = tct.eqm.callProperty(prplist[i], devnam, drdb, tct.din, acc);
                    if (cc == 121) {
                        return 133;
                    }
                    ndd[k] = new NAME32DBLDBL(prplist[i], drb[0], (double)cc);
                    ++k;
                }
                tct.drb.dArrayLength = k;
                tct.drb.putData(ndd);
                return 0;
            }
        }
        return cc;
    }

    private int doContract(TContractTable tct) {
        if (tct.expired) {
            return tct.returnCode;
        }
        int cc = 86;
        String devnam = new String(tct.contract.eqmDeviceName);
        String devprp = new String(tct.contract.eqmProperty);
        short lclAccess = tct.contract.dataAccess;
        if (tct.isRepeat) {
            lclAccess = (short)(lclAccess | 4);
        }
        TAccess acc = new TAccess(lclAccess);
        int datasize = tct.contract.getOutputDataSize();
        boolean isRegisteredProperty = false;
        int gate = 0;
        int dsize = tct.contract.dataSizeOut;
        if (tct.contract.dataFormatOut == 57) {
            dsize = Integer.parseInt(tct.contract.dataTagOut);
        }
        tct.dout.dArrayLength = tct.drb.dArrayLength = dsize;
        tct.drb.dTimestamp = this.gDataTimeStamp + this.gDataTimeStampOffset;
        tct.drb.sysDataStamp = this.gSystemStamp;
        if (debugLevel > 0) {
            DbgLog.log("doContract", "process " + tct.contract.eqmName + "/" + tct.contract.eqmDeviceName + "[" + tct.contract.eqmProperty + "]");
        }
        this.currentContractEntry = tct;
        tct.compString = null;
        if (tct.contract.extStringSize > 0) {
            devnam = tct.contract.getExtendedDeviceName();
        }
        if (devprp.indexOf("*") != -1) {
            if (TFormat.isSimpleFormat(tct.contract.dataFormatOut)) {
                devnam = devprp;
                devprp = new String("PROPERTIES");
            } else {
                isRegisteredProperty = true;
            }
        }
        if (this.stockList.hasProperty(devprp)) {
            if (debugLevel > 1) {
                DbgLog.log("doContract", "Common Stock Property found: " + tct.contract.eqmProperty);
            }
            this.gDataTimeStamp = this.gSrvStartupTime + this.gDataTimeStampOffset;
            if (datasize > 0) {
                tct.drb.dataFill(0.0);
            }
            cc = this.stockList.callPropertyHandler(devprp, devnam, tct.drb, tct.din, acc);
        } else if (tct.eqm == null) {
            DbgLog.log("doContract", "No Equipment Module found.");
            cc = 86;
        } else if (tct.eqm.hasStockProperty(devprp)) {
            if (debugLevel > 1) {
                DbgLog.log("doContract", "Stock Property found: " + tct.contract.eqmProperty);
            }
            this.gDataTimeStamp = this.gSrvStartupTime + this.gDataTimeStampOffset;
            if (datasize > 0) {
                tct.drb.dataFill(0.0);
            }
            cc = tct.eqm.callStockProperty(devprp, devnam, tct.drb, tct.din, acc);
        } else if (!tct.eqm.propertyList.hasProperty(devprp)) {
            gate = this.metaProps.getGate(tct.contract.eqmProperty);
            if (gate > 0) {
                if (debugLevel > 1) {
                    DbgLog.log("doContract", "Gated Property found: " + tct.contract.eqmProperty);
                }
                devprp = this.metaProps.getTargetProperty(tct.contract.eqmProperty);
                isRegisteredProperty = true;
            } else {
                if (debugLevel > 1) {
                    DbgLog.log("doContract", "Meta Property found: " + tct.contract.eqmProperty);
                }
                cc = tct.eqm.callMetaProperty(devprp, devnam, tct.drb, tct.din, acc);
            }
        } else if (tct.compStatus == 129 && this.gEqpFcnBusySemaphore) {
            if (debugLevel > 1) {
                DbgLog.log("doContract", "equipment module is busy : " + tct.contract.eqmProperty);
            }
            cc = 97;
        } else {
            if (debugLevel > 1) {
                DbgLog.log("doContract", "registered Property found: " + tct.contract.eqmProperty);
            }
            devprp = tct.contract.eqmProperty;
            isRegisteredProperty = true;
        }
        if (isRegisteredProperty) {
            if (tct.eqm.isIdleState()) {
                gate = 0;
                cc = 163;
            } else if (this.isWildcardContract(devnam)) {
                if (debugLevel > 1) {
                    DbgLog.log("doContract", "wildcard device: " + tct.contract.eqmDeviceName + " [" + tct.contract.eqmProperty + "]");
                }
                cc = this.doContractWithWildcardDevice(tct);
            } else if (this.isWildcardContract(devprp)) {
                if (debugLevel > 1) {
                    DbgLog.log("doContract", "wildcard property: " + tct.contract.eqmProperty);
                }
                cc = this.doContractWithWildcardProperty(tct);
            } else {
                if (debugLevel > 1) {
                    DbgLog.log("doContract", "call property handler for " + tct.contract.eqmName + "/" + tct.contract.eqmDeviceName + "[" + tct.contract.eqmProperty + "]");
                }
                this.gEqpFcnBusySemaphore = true;
                cc = tct.eqm.callProperty(devprp, devnam, tct.drb, tct.din, acc);
                this.gEqpFcnBusySemaphore = false;
            }
            if (gate > 0) {
                this.gateOutputData(tct.drb, gate, this.metaProps.getIndex(tct.contract.eqmProperty) != 7);
            }
        }
        if (tct.eqm != null && tct.eqm.propertyList == null && debugLevel > 1) {
            DbgLog.log("doContract", "Module has no property list");
        }
        if (tct.dout.dArrayLength > tct.drb.dArrayLength) {
            if (!this.gSystemPresetMemory) {
                tct.dout.dataFill(0.0, tct.drb.dArrayLength);
            }
            tct.dout.dArrayLength = tct.drb.dArrayLength;
        }
        tct.dout.dTimestamp = tct.drb.dTimestamp;
        tct.dout.sysDataStamp = tct.drb.sysDataStamp;
        tct.dout.usrDataStamp = tct.drb.usrDataStamp;
        if ((tct.contract.dataAccess & 0x40) != 0) {
            tct.contract.dataAccess = TAccess.removeBits(tct.contract.dataAccess, (short)64);
        }
        if (cc < 0) {
            cc = 4;
        }
        if (cc != 29) {
            tct.isRepeat = false;
        }
        tct.dataSizeOut = tct.dout.dArrayLength;
        if (tct.contract.dataSizeOut != tct.dout.dArrayLength) {
            cc |= 0x2000;
        }
        tct.compStatus = cc;
        this.currentContractEntry = null;
        return cc;
    }

    private void gateOutputData(TDataType dout, int gate, boolean outputBoolean) {
        Object hDataObject = dout.getDataObject();
        switch (dout.getFormat()) {
            case 2: {
                byte[] data = (byte[])hDataObject;
                for (int i = 0; i < dout.getArrayLength(); ++i) {
                    int n = i;
                    data[n] = (byte)(data[n] & gate);
                    if (!outputBoolean) continue;
                    data[i] = (byte)(data[i] == (byte)gate ? 1 : 0);
                }
                dout.putData(data);
                break;
            }
            case 1: {
                short[] data = (short[])hDataObject;
                for (int i = 0; i < dout.getArrayLength(); ++i) {
                    int n = i;
                    data[n] = (short)(data[n] & gate);
                    if (!outputBoolean) continue;
                    data[i] = (short)(data[i] == (short)gate ? 1 : 0);
                }
                dout.putData(data);
                break;
            }
            case 3: {
                int[] data = (int[])hDataObject;
                for (int i = 0; i < dout.getArrayLength(); ++i) {
                    int n = i;
                    data[n] = data[n] & gate;
                    if (!outputBoolean) continue;
                    data[i] = data[i] == gate ? 1 : 0;
                }
                dout.putData(data);
                break;
            }
        }
    }

    public static TClient getCaller() {
        TContractTable tct = TEquipmentModuleFactory.getInstance().getCurrentContractEntry();
        return tct != null ? ((TClientEntry)tct.clt.element()).cln : null;
    }

    public static TClientEntry[] getClientList() {
        TContractTable tct = TEquipmentModuleFactory.getInstance().getCurrentContractEntry();
        return tct != null ? tct.clt.toArray(new TClientEntry[0]) : null;
    }

    private boolean assertRedirectionValid(String rdr) {
        int indx = rdr.indexOf(47);
        String cntName = this.gFecContext;
        String expName = null;
        switch (indx) {
            case -1: {
                expName = rdr;
                break;
            }
            case 0: {
                rdr = rdr.substring(1);
                indx = rdr.indexOf(47);
                if (indx == -1) break;
                cntName = rdr.substring(0, indx);
                rdr = rdr.substring(indx + 1);
                indx = rdr.indexOf(47);
            }
            default: {
                String string = expName = indx > 0 ? rdr.substring(0, indx) : rdr;
            }
        }
        if (expName == null) {
            return false;
        }
        for (int i = 0; i < this.numEqmTableEntries; ++i) {
            if (this.eqmTable[i].getContext().compareToIgnoreCase(cntName) != 0 || this.eqmTable[i].getExportName().compareToIgnoreCase(expName) != 0) continue;
            return false;
        }
        return true;
    }

    private short isIllegalProperty(TClient tc, TSubscription ts, byte[] errorData) {
        TDevice td;
        TEquipmentModule eqm = this.LocateEquipmentModule(ts.contract);
        String tgtProperty = ts.contract.eqmProperty;
        String tgtDevice = ts.contract.eqmDeviceName;
        String rdirStr = null;
        if (eqm == null) {
            if (TStockProperties.isFecProperty(tgtProperty)) {
                return 0;
            }
            return 86;
        }
        if (!eqm.hasInitialized) {
            return 152;
        }
        if (ts.contract.eqmProperty.indexOf(".") >= 0) {
            tgtProperty = this.metaProps.getTargetProperty(ts.contract.eqmProperty);
        }
        if ((td = eqm.getDeviceList().getDevice(tgtDevice)) != null && (rdirStr = td.getRedirection()) != null) {
            byte[] rdb = this.redirectionStringToBytes(rdirStr);
            System.arraycopy(rdb, 0, errorData, 0, rdb.length);
            return 121;
        }
        if (eqm.propertyList.hasProperty(tgtProperty)) {
            TPropertyDescription dsc = eqm.propertyList.getFirstProperty(tgtProperty).getDescription();
            rdirStr = dsc.getRedirection();
            if (rdirStr != null && this.isDeviceRedirected(rdirStr, ts.contract.eqmDeviceName)) {
                if (this.assertRedirectionValid(rdirStr)) {
                    byte[] rdb = this.redirectionStringToBytes(rdirStr);
                    System.arraycopy(rdb, 0, errorData, 0, rdb.length);
                    return 121;
                }
                dsc.setRedirection(null);
                TFecLog.log("redirection to " + rdirStr + " is the local process : rejected !");
            }
        } else if (tgtProperty.indexOf("*") == -1 && !this.stockList.hasProperty(tgtProperty) && !eqm.stockList.hasProperty(tgtProperty)) {
            return 36;
        }
        if ((ts.contract.dataAccess & 2) == 2 && tgtProperty.compareTo("MESSAGE") != 0) {
            String cmdString = "COMMAND " + tgtProperty + " called by " + tc.userName + " from addr " + tc.IPaddress.getHostAddress() + " : ";
            if (!this.isMemberUsersList(eqm, tc.userName)) {
                TFecLog.log(cmdString + "user refused access");
                return 105;
            }
            if (!this.isMemberControlNets(eqm, tc)) {
                TFecLog.log(cmdString + "network refused access");
                return 105;
            }
            if (tgtProperty.compareTo("ACCESSLOCK") != 0 && !this.isMemberLockSet(eqm, tc)) {
                TFecLog.log(cmdString + "access lock refused access");
                return 105;
            }
            if (this.gPutCommandsInFeclog) {
                TFecLog.log(cmdString + "accepted");
            }
        }
        return 0;
    }

    private short fixOutputDataTypeAndSize(TSubscription ts) {
        short df;
        TEquipmentModule eqm = this.LocateEquipmentModule(ts.contract);
        if (eqm == null) {
            return 86;
        }
        short s = df = ts.contract.dataFormatOut >= 0 ? (short)ts.contract.dataFormatOut : (short)(256 + ts.contract.dataFormatOut);
        if (df == 254) {
            TExportProperty prop = eqm.propertyList.getFirstProperty(ts.contract.eqmProperty);
            ts.contract.dataFormatOut = (byte)prop.getOutputFormat();
            int fmtsize = TFormat.formatSizeOf(prop.getOutputFormat());
            int datasize = prop.getOutputSize() * fmtsize;
            int hdrsize = TFormat.getFormatHeaderSize(ts.contract.dataFormatOut);
            if (ts.contract.dataSizeOut < (datasize += hdrsize)) {
                return 25;
            }
            ts.contract.dataSizeOut = datasize;
            if (fmtsize != 0) {
                ts.contract.dataSizeOut -= hdrsize;
                ts.contract.dataSizeOut -= ts.contract.dataSizeOut % fmtsize;
                ts.contract.dataSizeOut /= fmtsize;
            }
        }
        return 0;
    }

    private void shrinkInputDataTypeRepository() {
        clnInputData cip = null;
        for (int i = 0; i < this.clnInputDataTable.size(); ++i) {
            cip = this.clnInputDataTable.get(i);
            if (cip.din.blksin != cip.din.numblks) continue;
            this.clnInputDataTable.remove(i--);
        }
    }

    private TDataType getInputDataTypeRepository(TClient tc, TSubscription ts) {
        int sizeIn = ts.contract.dataSizeIn;
        String tagIn = ts.contract.dataTagIn;
        if (ts.contract.dataFormatIn == 57) {
            sizeIn = Integer.parseInt(tagIn);
            tagIn = "";
        }
        if (ts.numblks == 1) {
            TDataType tdt = new TDataType(sizeIn, ts.contract.dataFormatIn);
            tdt.setTag(tagIn);
            return tdt;
        }
        if (debugLevel > 1) {
            DbgLog.log("getInputDataTypeRepository", "in-coming long datagram ...");
        }
        clnInputData cip = null;
        for (int i = 0; i < this.clnInputDataTable.size(); ++i) {
            cip = this.clnInputDataTable.get(i);
            if (!cip.tc.IPaddress.equals(tc.IPaddress) || cip.id != ts.id || cip.starttime != ts.starttime) continue;
            if (debugLevel > 1) {
                DbgLog.log("getInputDataTypeRepository", "found it in list ...");
            }
            return cip.din;
        }
        cip = new clnInputData();
        cip.id = ts.id;
        cip.starttime = ts.starttime;
        cip.tc = tc;
        cip.din = new TDataType(sizeIn, ts.contract.dataFormatIn);
        cip.din.setTag(tagIn);
        this.clnInputDataTable.add(cip);
        if (debugLevel > 1) {
            DbgLog.log("getInputDataTypeRepository", "add it to list ...");
        }
        return cip.din;
    }

    public String getNameFromAlias(String alias) {
        if (this.gAliasList == null) {
            return null;
        }
        for (int i = 0; i < this.gAliasList.size(); ++i) {
            AliasTableEntry ate = this.gAliasList.get(i);
            if (ate.alias.compareToIgnoreCase(alias) != 0) continue;
            return ate.name;
        }
        return null;
    }

    public String getAliasFromName(String name) {
        if (this.gAliasList == null) {
            return null;
        }
        for (int i = 0; i < this.gAliasList.size(); ++i) {
            AliasTableEntry ate = this.gAliasList.get(i);
            if (ate.name.compareToIgnoreCase(name) == 0) {
                return ate.alias;
            }
            if (!this.metaProps.isMetaProperty(ate.name) || this.metaProps.getTargetProperty(ate.name).compareToIgnoreCase(name) != 0) continue;
            return ate.alias;
        }
        return null;
    }

    private void getRequest(TClient tc, byte[] data) {
        Arrays.fill(this.requestBytes, (byte)0);
        byte[] d = this.requestBytes;
        TDataType din = null;
        int offset = 0;
        int datasize = 0;
        short cc = 0;
        boolean isTrueMCast = false;
        boolean isLegacy = false;
        TClientEntry tce = null;
        String astr = null;
        TReqHdr hdr = new TReqHdr(data, 0, 22);
        tc.userName = hdr.getUserName();
        short tineProtocol = hdr.getProtocol();
        if (tineProtocol < 5) {
            this.SendMessageToCaller(tc, null, 94, null);
        }
        tc.tineProtocol = tineProtocol;
        if (tineProtocol < 6) {
            isLegacy = true;
        }
        int totalsize = hdr.getTotalSizeInBytes();
        int hdrSize = isLegacy ? 20 : 24;
        int conSize = isLegacy ? 84 : 180;
        offset += 22;
        if (debugLevel > 3) {
            DbgLog.log("getRequest", hdr.toString());
        }
        block7: while (offset < totalsize) {
            TSubscription sub = new TSubscription(tineProtocol, data, offset, hdrSize);
            astr = this.getNameFromAlias(sub.contract.eqmDeviceName);
            if (astr != null) {
                sub.contract.eqmDeviceName = astr;
            }
            if ((astr = this.getNameFromAlias(sub.contract.eqmProperty)) != null) {
                sub.contract.eqmProperty = astr;
            }
            offset += hdrSize + conSize + sub.contract.extStringSize;
            if (debugLevel > 3) {
                DbgLog.log("getRequest", sub.toString());
            }
            if ((datasize = sub.getInputDataSize()) > 0) {
                din = this.getInputDataTypeRepository(tc, sub);
                din.update(data, offset, datasize, sub.blknum, sub.blkid);
                din.bytesin += datasize;
                offset += datasize + datasize % 2;
                if (din.blksin < din.numblks) continue;
                din.getData();
                if (debugLevel > 3) {
                    DbgLog.log("getRequest", "input data : \n" + din.toString());
                }
            }
            this.fixOutputDataTypeAndSize(sub);
            TContractTable tct = this.LocateContractInList(sub.contract, din, isNewContract);
            this.shrinkInputDataTypeRepository();
            if (tct == null) {
                this.SendMessageToCaller(tc, sub, 77, null);
                continue;
            }
            if (gServerWaiting) {
                this.SendMessageToCaller(tc, sub, 152, d);
                continue;
            }
            cc = this.isIllegalProperty(tc, sub, d);
            if (cc != 0) {
                this.SendMessageToCaller(tc, sub, cc, d);
                continue;
            }
            if (tct.expired && (sub.mode & 0x800) == 0) {
                tct.lasttime = 0L;
                tct.expired = false;
                TEquipmentModuleFactory.isNewContract[0] = true;
                if (this.numExpiredContracts > 0) {
                    --this.numExpiredContracts;
                }
                if (debugLevel > 1) {
                    DbgLog.log("getRequest", tct.contract.eqmName + "/" + tct.contract.eqmDeviceName + "[" + tct.contract.eqmProperty + "] attaching to expired contract");
                }
            }
            if ((sub.mode & 0x300) != 0) {
                isTrueMCast = (sub.mode & 0x200) != 0;
                sub.mode = TMode.getBaseMode(sub.mode);
                if (sub.mode == 0) continue;
                if (isTrueMCast || this.isMemberBcastNets(tc)) {
                    ByteArrayOutputStream boas = new ByteArrayOutputStream(2);
                    DataOutputStream dos = new DataOutputStream(boas);
                    try {
                        dos.writeShort((short)tct.contractID);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    byte[] subid = boas.toByteArray();
                    Swap.Bytes(subid, (short)1);
                    this.SendMessageToCaller(tc, sub, 119, subid);
                    tc.IPaddress = isTrueMCast ? this.getMCastAddr() : this.getBCastAddr(tc.IPaddress);
                    tc.port = initializer.getMCastPort();
                    tc = this.LocateClientInList(tc.IPaddress, tc.port);
                    tc.userName = "NETWORK";
                    sub.id = (short)tct.contractID;
                    sub.starttime = 255;
                }
            }
            if ((tce = this.LocateClientInContract(tct, tc)) == null) {
                this.SendMessageToCaller(tc, sub, 77, null);
                continue;
            }
            tce.sts.reset(sub);
            int renewalMultiplier = 1;
            if (sub.pollingRate < 500) {
                renewalMultiplier = 3;
            }
            if (tce.sts.mode != Short.MAX_VALUE) {
                if (tce.sts.counter == 0 && sub.starttime != 255 || sub.mode == 2) {
                    tce.sts.Stale = 1;
                    tce.sts.lasttime = System.currentTimeMillis();
                }
                if (sub.mode != 0 && sub.mode != 2 && tce.sts.counter > 10 * renewalMultiplier && tce.sts.counter < 60 * renewalMultiplier) {
                    ++tce.sts.reconnects;
                    ++this.gClientReconnects;
                }
            }
            if ((sub.mode & 0x800) != 0) {
                tce.sts.Stale = 1;
                tct.isStale = true;
                tce.sts.isRetry = true;
                ++this.gClientRetries;
                sub.mode = TMode.getBaseMode(sub.mode);
                if (debugLevel > 1) {
                    DbgLog.log("getRequest", tct.contract.eqmName + "/" + tct.contract.eqmDeviceName + "[" + tct.contract.eqmProperty + "] is retrying reqeust");
                }
            }
            if (tct.nclients == 0) {
                ++tct.nclients;
                tct.contract.dataAccess = TAccess.removeBits(tct.contract.dataAccess, (short)128);
            }
            tct.contract.dataAccess = TAccess.removeBits(tct.contract.dataAccess, (short)4);
            if (isNewContract[0]) {
                tct.contract.dataAccess = (byte)(tct.contract.dataAccess | 0x40);
            }
            int SubsciptionPacketOffset = 0;
            tce.sts.mode = sub.mode;
            switch (tce.sts.mode) {
                case 1: {
                    ++this.gSingleLinkCount;
                    tce.sts.counter = 1;
                    if (!tct.expired || !tce.sts.isRetry) {
                        tct.lasttime = 1L;
                    } else {
                        tct.lasttime = System.currentTimeMillis();
                        if (tct.dataSizeOut < tct.contract.dataSizeOut) {
                            tct.renegotiateContract((short)tct.compStatus);
                        }
                    }
                    if (tct.pollingRate == 0) {
                        tct.pollingRate = tce.sts.PollingRate;
                    }
                    if (tct.nclients != 1) continue block7;
                    tct.contract.dataAccess = (byte)(tct.contract.dataAccess | 0x80);
                    continue block7;
                }
                case 3: {
                    SubsciptionPacketOffset = (int)(100.0 * Math.random());
                    if (sub.pollingRate > 2000) {
                        SubsciptionPacketOffset /= 10;
                    }
                }
                case 2: 
                case 6: {
                    tce.sts.counter = (short)(60 * renewalMultiplier + SubsciptionPacketOffset);
                    tct.pollingRate = this.findpoll(sub.pollingRate, tct.pollingRate);
                    continue block7;
                }
            }
            if (tce.cln.userName.compareTo("NETWORK") == 0) continue;
            if (tct.nclients == 1) {
                if (isNewContract[0]) {
                    this.SendMessageToCaller(tc, sub, 58, null);
                    continue;
                }
                if (tce.sts.counter > 0) {
                    tct.contract.dataAccess = (byte)(tct.contract.dataAccess | 0x80);
                }
                tct.lasttime = 2L;
                tct.pending = 0;
            }
            tce.sts.counter = 0;
        }
    }

    private void validateContextAndSubsystem(TEquipmentModule eqm) {
        String ctx = eqm.getContext();
        String sub = eqm.getSubsystem();
        if (ctx == null) {
            eqm.setCompletionString("TEST");
            TFecLog.log("Context not given: set to \"TEST\"");
            return;
        }
        int idx = ctx.indexOf(46);
        if (idx == -1) {
            return;
        }
        String s = ctx.substring(idx + 1);
        if (s.endsWith("TEST")) {
            return;
        }
        if (sub.length() == 0 || sub.compareToIgnoreCase(s) == 0) {
            sub = s;
            ctx = ctx.substring(0, idx);
        }
        if (sub.length() == 0) {
            sub = this.gFecSubsystem;
        }
        if (ctx.compareTo(eqm.getContext()) != 0) {
            TFecLog.log("given context " + eqm.getContext() + " will be treated as the " + sub + " subsystem decorated context " + ctx);
        }
    }

    private void SendRegisteredExportToENS(TEquipmentModule eqm) {
        if (eqm == null) {
            return;
        }
        if (eqm.getLocalName() == null || eqm.getLocalName().length() == 0) {
            DbgLog.log("SendRegisteredExportToENS", "attempt to register equipment module with empty local name !");
            eqm.isRegistered = true;
            return;
        }
        if (eqm.getExportName() == null || eqm.getExportName().length() == 0) {
            DbgLog.log("SendRegisteredExportToENS", "attempt to register equipment module with empty export name !");
            eqm.isRegistered = true;
            return;
        }
        if (this.gFecName == null) {
            return;
        }
        if (this.gFecAddr == null) {
            new TSrvEntry();
            this.gFecAddr = new FECAddr();
            this.gFecAddr.setFecName(this.gFecName);
            try {
                String ip = gSystemRunningStandAlone ? "127.0.0.1" : InetAddress.getLocalHost().getHostAddress().toString();
                this.gFecAddr.setIpAddr(ip);
            }
            catch (UnknownHostException e) {
                MsgLog.log("SendRegisteredExportToENS", this.gFecName + " cannot get local host!", 108, e, 0);
            }
            this.gFecAddr.setPortOffset(this.gPortOffset);
        }
        if (this.gFecInfo == null) {
            this.gFecInfo = new FECInfo("JAVA", this.getFecDescription(), this.getFecLocation(), this.getFecHardware(), this.getFecResponsible());
        }
        if (eqm.getContext() == null || eqm.getContext().length() == 0) {
            eqm.setContext(this.getFecContext());
        }
        if (eqm.getSubsystem() == null || eqm.getSubsystem().length() == 0) {
            eqm.setSubsystem(this.getFecSubsystem());
        }
        this.validateContextAndSubsystem(eqm);
        SrvAddr da = new SrvAddr(this.gFecAddr);
        da.expName = eqm.getExportName();
        da.eqmContext = eqm.getContext();
        da.eqmName = eqm.getModuleName();
        da.subSystem = eqm.getSubsystem();
        if (gSystemRunningStandAlone) {
            SrvAddr srv = new SrvAddr(this.gFecAddr.getFecName(), "127.0.0.1", this.gFecAddr.getPortOffset(), eqm.getModuleName(), eqm.getExportName(), eqm.getContext());
            TSrvEntry.addAddressToCacheFile(srv);
            return;
        }
        byte[] expAddr = new byte[SrvAddr.sizeInBytes + FECInfo.getSizeInBytes()];
        System.arraycopy(da.toByteArray(), 0, expAddr, 0, SrvAddr.sizeInBytes);
        System.arraycopy(this.gFecInfo.toByteArray(), 0, expAddr, SrvAddr.sizeInBytes, FECInfo.getSizeInBytes());
        TDataType din = new TDataType(expAddr, "");
        TDataType dout = new TDataType(expAddr, "");
        if (debugLevel > 0) {
            DbgLog.log("SendRegisteredExportToENS", "fec -> " + this.gFecAddr.toString());
            DbgLog.log("SendRegisteredExportToENS", "dev -> " + da.toString());
            DbgLog.log("SendRegisteredExportToENS", "fec info -> " + this.gFecInfo.toString());
        }
        if (TSrvEntry.currentConfiguredNameServerTag != null) {
            int rc;
            if (debugLevel > 2) {
                DbgLog.log("SendRegisteredExportToENS", "Using ENS : " + TSrvEntry.currentConfiguredNameServerTag);
            }
            TLink expLnk = new TLink(TSrvEntry.currentConfiguredNameServerTag, "EXPORT", dout, din, 2);
            if (this.gLinkFactory == null) {
                this.gLinkFactory = expLnk.tf;
            }
            if ((rc = expLnk.execute(500, true)) == 0) {
                eqm.isRegistered = true;
                TFecLog.log("FEC " + this.getFecName() + ", Server " + da.expName + "(" + da.eqmName + ") registered with equipment name server");
                TFecLog.log("Context is " + da.eqmContext);
                this.gNumEnsErrors = 0;
            } else {
                if (this.gNumEnsErrors++ > 30) {
                    eqm.isRegistered = true;
                }
                TFecLog.log("FEC " + this.getFecName() + ", Server " + da.expName + "(" + da.eqmName + ") failed to register with equipment name server " + TSrvEntry.currentConfiguredNameServerTag + " : " + TErrorList.getErrorString(rc));
            }
        } else {
            DbgLog.log("SendRegisteredExportToENS", "No configured ENS !");
        }
        TEquipmentManifest.update(eqm);
    }

    private void joinEnsGroup(TEquipmentModule eqm) {
        String sub;
        if (this.gFecName == null) {
            return;
        }
        if (eqm == null) {
            return;
        }
        if (!eqm.isRegistered) {
            return;
        }
        String grp = eqm.getGroupName();
        if (grp == null || grp.length() == 0) {
            eqm.grpRegistered = true;
            return;
        }
        if (eqm.grpRegistered) {
            return;
        }
        String exp = eqm.getExportName();
        if (exp == null) {
            eqm.grpRegistered = true;
            return;
        }
        String cnt = eqm.getContext();
        if (cnt == null) {
            cnt = new String("");
        }
        if ((sub = eqm.getSubsystem()) == null || sub.length() == 0) {
            sub = eqm.getEquipmentModuleFactory().getFecSubsystem();
        }
        TCompoundDataObject[] n32 = new NAME32[]{new NAME32(exp), new NAME32(grp), new NAME32(cnt), new NAME32(String.valueOf(eqm.getGroupIndex())), new NAME32(sub)};
        TDataType din = new TDataType(n32);
        TDataType dout = new TDataType();
        if (debugLevel > 0) {
            String dbgstr = "/" + cnt + "/" + exp + " -> ";
            DbgLog.log("joinEnsGroup", dbgstr + "joining group " + grp + " (index " + eqm.getGroupIndex() + ")");
        }
        if (TSrvEntry.currentConfiguredNameServerTag != null) {
            TLink expLnk = new TLink("/SITE/GENS", "JOIN", dout, din, 2);
            if (this.gLinkFactory == null) {
                this.gLinkFactory = expLnk.tf;
            }
            int rc = expLnk.execute(500, true);
            expLnk.cancel();
            switch (rc) {
                case 0: {
                    eqm.grpRegistered = true;
                    TFecLog.log(exp + " joined group " + grp);
                    return;
                }
                case 45: 
                case 98: {
                    return;
                }
            }
            eqm.grpRegistered = true;
            TFecLog.log(exp + " joining group failed : " + TErrorList.getErrorString(rc));
            return;
        }
        DbgLog.log("joinEnsGroup", "No configured GENS !");
    }

    private void SendMessageToCaller(TClient tc, TSubscription s, int cc, byte[] data) {
        int len;
        TClientEntry tce = new TClientEntry();
        TContractTable tct = new TContractTable();
        int totalsize = 2;
        int hdrsize = 44;
        int msgsize = 192;
        if (s.isLegacy) {
            hdrsize = 24;
            msgsize = 32;
        }
        Arrays.fill(this.msgBytes, (byte)0);
        byte[] payload = this.msgBytes;
        tct.dtimestamp = System.currentTimeMillis() + this.gDataTimeStampOffset;
        tce.sts = new TClientStatus(tc.inetProtocol);
        if (s != null) {
            tct.contract = s.contract;
            tce.sts.starttime = (long)s.starttime * 1000L;
            tce.sts.id = s.id;
        }
        tce.sts.statusCode = (short)cc;
        tce.sts.numblks = 1;
        tce.cln = tc;
        TPHdr tpd = new TPHdr(msgsize + hdrsize, tce, tct);
        System.arraycopy(tpd.dBuffer.toByteArray(), 0, payload, totalsize, hdrsize);
        totalsize = (short)(totalsize + hdrsize);
        switch (cc) {
            case 119: {
                if (data == null) {
                    return;
                }
                len = 2;
                break;
            }
            case 121: 
            case 130: {
                if (data == null) {
                    return;
                }
                len = data.length;
                break;
            }
            default: {
                data = TErrorList.getErrorString(cc).getBytes();
                len = data.length;
            }
        }
        System.arraycopy(data, 0, payload, totalsize, len);
        totalsize = (short)(totalsize + msgsize);
        if (debugLevel > 0) {
            switch (cc) {
                case 36: 
                case 64: 
                case 86: 
                case 105: 
                case 121: 
                case 130: {
                    DbgLog.log("SendMessageToCaller", "MSG : " + s.contract.eqmName + " " + s.contract.eqmProperty + " -> " + TErrorList.getErrorString((short)cc));
                    break;
                }
                default: {
                    DbgLog.log("SendMessageToCaller", "MSG : " + TErrorList.getErrorString((short)cc));
                }
            }
        }
        payload[0] = (byte)(totalsize & 0xFF);
        payload[1] = (byte)(totalsize >> 8);
        this.sendToPeer(tc, payload, totalsize);
    }

    private void systemCleanupDataStreams() {
        for (int i = 0; i < this.bucketList.size(); ++i) {
            if (this.bucketList.get((int)i).active) continue;
            this.bucketList.remove(i);
        }
    }

    private void systemAcceptDataStreamRequest() {
        block3: {
            if (!this.isInitialized) {
                return;
            }
            try {
                Socket sck = this.srvs.accept();
                sck.setTcpNoDelay(true);
                sck.setTrafficClass(24);
                sck.setSoTimeout(10);
                this.bucketList.add(new TContractBucket(sck));
            }
            catch (Exception e) {
                if (debugLevel <= 0) break block3;
                DbgLog.log("systemAcceptDataStreamRequest", "interrupted IO");
            }
        }
    }

    private void systemAcceptDataGramRequest() {
        if (!this.isInitialized) {
            return;
        }
        try {
            this.srvp.getSocket().receive(this.srvp.dpIn);
            this.gLinkTablesAccessed = true;
            TClient tc = this.LocateClientInList(this.srvp.dpIn.getAddress(), this.srvp.dpIn.getPort());
            tc.inetProtocol = (short)8;
            this.getRequest(tc, this.srvp.dpIn.getData());
            this.gLinkTablesAccessed = false;
        }
        catch (IOException e) {
            if (debugLevel > 0) {
                DbgLog.log("systemAcceptDataGramRequest", "IO exception: " + e.getMessage());
            }
        }
        catch (Exception e) {
            MsgLog.log("systemAcceptDataGramRequest", "unhandled exception", 66, e, 0);
        }
    }

    private long systemSrvCycle() {
        long cycletime = System.currentTimeMillis();
        long msecToSleep = 10L;
        if (!this.isInitialized) {
            return 200L;
        }
        if (this.gLinkTablesAccessed) {
            return 1L;
        }
        if (this.isInsideCycle) {
            return 1L;
        }
        this.isInsideCycle = true;
        try {
            if (debugLevel > 25) {
                DbgLog.log("systemSrvCycle", "SystemCycle called at " + new Date().toString());
            }
            for (int i = 0; i < this.numEqmTableEntries; ++i) {
                this.eqmTable[i].update();
            }
            this.doScheduler();
            if (this.registrationPending && cycletime - this.registrationTime > 1000L) {
                int doneCounter = 0;
                for (int i = 0; i < this.numEqmTableEntries; ++i) {
                    if (this.eqmTable[i] == null) continue;
                    if (!this.eqmTable[i].isRegistered) {
                        this.SendRegisteredExportToENS(this.eqmTable[i]);
                        continue;
                    }
                    if (!this.eqmTable[i].grpRegistered) {
                        this.joinEnsGroup(this.eqmTable[i]);
                        continue;
                    }
                    ++doneCounter;
                }
                if (doneCounter == this.numEqmTableEntries) {
                    this.registrationPending = false;
                }
                this.registrationTime = cycletime;
            }
        }
        catch (Exception e) {
            TFecLog.log("systemSrvCycle", "unhandled exception " + e.getMessage());
        }
        if (this.gCycleDelay > 10) {
            msecToSleep = this.gCycleDelay;
        }
        this.isInsideCycle = false;
        return msecToSleep;
    }

    public int systemInit(String fecName, int portOffset) {
        return this.systemInit(fecName, portOffset, null);
    }

    public int systemInit(String fecName, int portOffset, String expName) {
        int rc;
        String thDisplay = instance.getInitializer().getTineHome();
        String fhDisplay = instance.getInitializer().getFecHome();
        String wd = new File(".").getAbsolutePath();
        if (thDisplay.compareTo(".") == 0) {
            thDisplay = ". (" + wd + ")";
        }
        if (fhDisplay.compareTo(".") == 0) {
            fhDisplay = ". (" + wd + ")";
        }
        TFecLog.log("VERSION   : " + TStockProperties.getStockSrvVersion());
        TFecLog.log("OS        : JAVA");
        TFecLog.log("TINE HOME : " + thDisplay);
        TFecLog.log("FEC HOME  : " + fhDisplay);
        String lclName = null;
        if (expName == null) {
            for (int i = 0; lclName == null && i < this.numEqmTableEntries; ++i) {
                if (this.eqmTable[i] == null) continue;
                lclName = this.eqmTable[i].getModuleName();
                expName = this.eqmTable[i].getExportName();
                String cntName = this.eqmTable[i].getContext();
                if (cntName == null || cntName.length() <= 0) continue;
                expName = "/" + cntName + "/" + expName;
            }
        }
        if (fecName != null) {
            this.setFecName(fecName);
        }
        if ((rc = this.getFecInformationFromFile(expName, lclName)) != 0 && (fecName == null || fecName.length() == 0)) {
            MsgLog.log("systemInit", "Needed to read fecid.csv and couldn't!", 56, null, 0);
        }
        if (portOffset > 0) {
            this.gPortOffset = portOffset;
        }
        int port = initializer.getSrvPort() + this.gPortOffset;
        this.srvp = new TPacket(port, this.sckRcvBufferSize, this.sckTimeToLive);
        port = initializer.getTCPPort() + this.gPortOffset;
        if (this.gFecName != null) {
            TLinkFactory.getInstance().setUserName(this.getFecName());
        } else {
            MsgLog.log("systemInit", "FEC Name unknown at start time !", 56, null, 0);
        }
        try {
            ServerSocketChannel srvsChannel = ServerSocketChannel.open();
            this.srvs = srvsChannel.socket();
            this.srvs.setReuseAddress(true);
            this.srvs.setReceiveBufferSize(this.sckRcvBufferSize);
            this.srvs.bind(new InetSocketAddress(port));
        }
        catch (Exception e) {
            e.toString();
            MsgLog.log("systemInit", "Cannot start server; closing down!", 17, null, 0);
            return 90;
        }
        String sas = System.getenv("TINE_STANDALONE");
        if (sas != null && sas.compareToIgnoreCase("TRUE") == 0) {
            gSystemRunningStandAlone = true;
            TFecLog.log("FEC is running in stand-alone mode");
        }
        if (this.tEqmHook != null) {
            this.tEqmHook.SystemInit();
        }
        this.registerStockAlarmDefinitions();
        for (int i = 0; i < this.numEqmTableEntries; ++i) {
            this.eqmTable[i].startup();
            if (this.eqmTable[i].isRegistered) continue;
            this.SendRegisteredExportToENS(this.eqmTable[i]);
        }
        this.gSrvStartupTime = System.currentTimeMillis();
        this.serverStatistics.setStarttime((int)(this.gSrvStartupTime / 1000L));
        if (this.useGlobalSynchronization) {
            this.systemStartGlobalSynchronization();
        }
        if (this.useCycleTrigger) {
            this.systemStartCycleTrigger();
        }
        this.isInitialized = true;
        return 0;
    }

    public int systemInit(int portOffset) {
        return this.systemInit(null, portOffset, null);
    }

    public int systemInit() {
        return this.systemInit(null, 0, null);
    }

    public void systemWait(long milliseconds) {
        try {
            if (milliseconds < 0L) {
                while (!this.gSystemExitCondition) {
                    Thread.sleep(1000L);
                }
            } else {
                Thread.sleep(milliseconds);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void shutdown() {
        this.shutdown(0);
    }

    public void shutdown(int status) {
        TLinkFactory.getInstance().shutdown();
        this.gSystemExitCondition = true;
        for (int i = 0; i < this.eqmTable.length; ++i) {
            if (this.eqmTable[i] == null) continue;
            this.eqmTable[i].shutdown();
        }
        try {
            Thread.sleep(this.gSystemTick * 2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.exitOnShutdown) {
            System.exit(status);
        }
    }

    int getFecXmlDocument() {
        if (this.gFecXmlCfg != null) {
            return 0;
        }
        TInitializer initializer = TInitializerFactory.getInstance().getInitializer();
        File fecXml = null;
        try {
            fecXml = new File(initializer.getFecHome() + "/fec.xml");
            if (fecXml != null) {
                DocumentBuilderFactory f = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = f.newDocumentBuilder();
                Document doc = builder.parse(fecXml);
                TineXMLparser p = new TineXMLparser(doc);
                this.gFecXmlCfg = p.parse();
                this.setFecName(this.gFecXmlCfg.getName());
                this.setFecContext(this.gFecXmlCfg.getContext());
                this.setFecSubsystem(this.gFecXmlCfg.getSubsystem());
                this.setFecDescription(this.gFecXmlCfg.getDescription());
                this.setFecHardware(this.gFecXmlCfg.getHardware());
                this.setFecResponsible(this.gFecXmlCfg.getResponsible());
                LinkedList<EqmCfg> el = this.gFecXmlCfg.getEqmList();
                Iterator i$ = el.iterator();
                if (i$.hasNext()) {
                    EqmCfg ec = (EqmCfg)i$.next();
                    if (this.getFecContext() == null || this.getFecContext().length() == 0) {
                        this.setFecContext(ec.getContext());
                    }
                    if (this.getFecDescription() == null || this.getFecDescription().length() == 0) {
                        this.setFecDescription(ec.getDescription());
                    }
                    if (this.getFecHardware() == null || this.getFecHardware().length() == 0) {
                        this.setFecHardware(ec.getHardware());
                    }
                    if (this.getFecSubsystem() == null || this.getFecSubsystem().length() == 0) {
                        this.setFecSubsystem(ec.getSubsystem());
                    }
                    if (this.getFecResponsible() == null || this.getFecResponsible().length() == 0) {
                        this.setFecResponsible(ec.getResponsible());
                    }
                }
                this.gPortOffset = (short)this.gFecXmlCfg.getPortOffset().getValue();
                TFecLog.log("fec.xml read");
            }
        }
        catch (FileNotFoundException e) {
            this.gFecXmlCfg = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            TFecLog.log("error reading fec.xml : " + e.getLocalizedMessage());
        }
        return this.gFecXmlCfg == null ? 42 : 0;
    }

    int getFecInformationFromFile(String targetExportName, String targetLocalName) {
        if (this.getFecXmlDocument() == 0) {
            return 0;
        }
        TFecLog.log("no fec.xml found, try fecid.csv ...");
        FecRowHndlr fHndlr = new FecRowHndlr();
        if (targetExportName != null) {
            fHndlr.latchExpName = true;
            fHndlr.target = targetExportName;
            TFecLog.log("trying to latch export name " + targetExportName + " in fecid.csv");
        } else {
            fHndlr.latchEqmName = true;
            fHndlr.target = targetLocalName;
            TFecLog.log("trying to latch local name " + targetLocalName + " in fecid.csv");
        }
        csvColumn[] fecCols = new csvColumn[]{new csvColumn("FEC_NAME", null, new StringFieldHandler(fHndlr, "nam")), new csvColumn("PORT_OFFSET", "0", new IntFieldHandler(fHndlr, "port")), new csvColumn("CONTEXT", "", new StringFieldHandler(fHndlr, "ctx")), new csvColumn("EXPORT_NAME", "", new StringFieldHandler(fHndlr, "exp")), new csvColumn("LOCAL_NAME", "", new StringFieldHandler(fHndlr, "eqm")), new csvColumn("DESCRIPTION", "", new StringFieldHandler(fHndlr, "dsc")), new csvColumn("LOCATION", "", new StringFieldHandler(fHndlr, "loc")), new csvColumn("HARDWARE", "none", new StringFieldHandler(fHndlr, "hdw")), new csvColumn("SUBSYSTEM", "TST", new StringFieldHandler(fHndlr, "sub")), new csvColumn("RESPONSIBLE", "", new StringFieldHandler(fHndlr, "rsp")), new csvColumn("HISTORY_HOME", "", new StringFieldHandler(fHndlr, "hstHome"))};
        csv fecFile = new csv(initializer.getFecIdResource());
        int rc = fecFile.readFile(fecCols, fHndlr);
        fecFile.close();
        if (rc != 42) {
            TFecLog.log("get fec information from fecid.csv : " + TErrorList.errorString[rc]);
        }
        if (!fHndlr.namefound) {
            TFecLog.log("get fec information from fecid.csv : could not find matching entry for " + fHndlr.target);
            rc = 86;
        }
        if (rc == 0) {
            this.setFecName(fHndlr.nam);
            this.setFecContext(fHndlr.ctx);
            this.setFecDescription(fHndlr.dsc);
            this.setFecHardware(fHndlr.hdw);
            this.setFecLocation(fHndlr.loc);
            this.setFecSubsystem(fHndlr.sub);
            this.setFecResponsible(fHndlr.rsp);
            this.gPortOffset = (short)fHndlr.port;
        }
        return rc;
    }

    int getAliasListFromFile() {
        FecCfg cfg = this.getFecXmlCfg();
        if (cfg != null) {
            LinkedList<AliasCfg> al = cfg.getAliasList();
            for (AliasCfg ac : al) {
                this.gAliasList.add(new AliasTableEntry(ac.getTarget(), ac.getName()));
            }
            return 0;
        }
        TInitializer initializer = TInitializerFactory.getInstance().getInitializer();
        csvColumn[] aliasCols = new csvColumn[2];
        aliasListRowHndlr aliasRows = new aliasListRowHndlr();
        aliasCols[0] = new csvColumn("NAME", "", new StringFieldHandler(aliasRows, "aName"));
        aliasCols[1] = new csvColumn("ALIAS", "0", new StringFieldHandler(aliasRows, "aAlias"));
        csv aliasFile = new csv(initializer.getAliasResource(null));
        aliasFile.readFile(aliasCols, aliasRows);
        aliasFile.close();
        return 0;
    }

    public void registerStockAlarmDefinitions() {
        if (this.stockAlarmDefinitionsRegistered) {
            return;
        }
        this.stkAlarmDefinitions.put(Integer.toString(103), new TAlarmDefinition("invalid data", "value not at set point", "device", 103, 12, 0, -1, 3, 1, "last measured value", ""));
        this.stkAlarmDefinitions.put(Integer.toString(122), new TAlarmDefinition("value too high", "value exceeds threshold", "device", 122, 12, 0, -1, 5, 1, "last measured value", ""));
        this.stkAlarmDefinitions.put(Integer.toString(124), new TAlarmDefinition("warn too high", "value is near threshold", "device", 124, 8, 0, -1, 5, 1, "last measured value", ""));
        this.stkAlarmDefinitions.put(Integer.toString(123), new TAlarmDefinition("value too low", "value exceeds threshold", "device", 123, 12, 0, -1, 5, 1, "last measured value", ""));
        this.stkAlarmDefinitions.put(Integer.toString(125), new TAlarmDefinition("warn too low", "value is near threshold", "device", 125, 8, 0, -1, 5, 1, "last measured value", ""));
        this.stkAlarmDefinitions.put(Integer.toString(115), new TAlarmDefinition("more than 100 total alarms", "more than 100 total alarms (collapse alarm messages)", "device", 115, 12, 5001, -1, 1, 1, "", ""));
        this.stkAlarmDefinitions.put(Integer.toString(15), new TAlarmDefinition("I/O error", "hardware input/ouput error", "device", 15, 12, 5001, -1, 255, 0, "", ""));
        this.stkAlarmDefinitions.put(Integer.toString(21), new TAlarmDefinition("File error", "file input/ouput error", "device", 21, 12, 5000, -1, 4, 64, "file/path name which caused the alarm", ""));
        this.stkAlarmDefinitions.put(Integer.toString(34), new TAlarmDefinition("Hardware error", "general hardware error", "device", 34, 12, 5001, -1, 4, 64, "hardware device description", ""));
        this.stkAlarmDefinitions.put(Integer.toString(28), new TAlarmDefinition("Network read error", "network read error", "device", 28, 12, 5000, -1, 255, 0, "", ""));
        this.stkAlarmDefinitions.put(Integer.toString(102), new TAlarmDefinition("Network write error", "network write error", "device", 102, 12, 5000, -1, 255, 0, "", ""));
        this.stkAlarmDefinitions.put(Integer.toString(65), new TAlarmDefinition("Link error", "link to dependent server is not open", "device", 65, 12, 5000, -1, 4, 64, "link which has the problem", ""));
        this.stkAlarmDefinitions.put(Integer.toString(82), new TAlarmDefinition("Driver not installed", "hardware driver not installed or not initialized", "device", 82, 12, 5001, -1, 4, 64, "name of hardware driver", ""));
        this.stkAlarmDefinitions.put(Integer.toString(83), new TAlarmDefinition("Port not available", "hardware port not avaliable", "device", 83, 12, 5001, -1, 4, 64, "Port Id", ""));
        this.stkAlarmDefinitions.put(Integer.toString(90), new TAlarmDefinition("Not Running", "hardware device is not running", "device", 90, 12, 5001, -1, 255, 0, "", ""));
        this.stkAlarmDefinitions.put(Integer.toString(79), new TAlarmDefinition("Sedac error", "sedac module has an error", "device", 79, 12, 5001, -1, 1, 3, "line/crate/subaddress of defective module", ""));
        this.stkAlarmDefinitions.put(Integer.toString(95), new TAlarmDefinition("GPIB error", "GPIB bus error", "device", 95, 12, 5001, -1, 4, 64, "hardware module description", ""));
        this.stkAlarmDefinitions.put(Integer.toString(96), new TAlarmDefinition("RS232 error", "RS232 bus communication error", "device", 96, 12, 5001, -1, 4, 64, "hardware module description", ""));
        this.stkAlarmDefinitions.put(Integer.toString(143), new TAlarmDefinition("Device error", "general device error/device defective", "device", 143, 12, 5001, -1, 4, 64, "module description", ""));
        this.stkAlarmDefinitions.put(Integer.toString(154), new TAlarmDefinition("CAN bus error", "CAN module has an error", "device", 154, 12, 5001, -1, 3, 4, "address of CAN module", ""));
        this.stkAlarmDefinitions.put(Integer.toString(155), new TAlarmDefinition("PROFIBUS error", "PROFIBUS module has an error", "device", 155, 12, 5001, -1, 3, 4, "address of PROFIBUS module", ""));
        this.stockAlarmDefinitionsRegistered = true;
    }

    int getAlarmWatchListFromFile(String eqmName) {
        FecCfg cfg = this.getFecXmlCfg();
        if (cfg != null) {
            LinkedList<EqmCfg> el = cfg.getEqmList();
            for (EqmCfg ec : el) {
                if (ec.getName().compareTo(eqmName) != 0) continue;
                TEquipmentModule eqm = this.getEquipmentModule(eqmName);
                LinkedList<PropertyCfg> pl = ec.getPropertyList();
                for (PropertyCfg pc : pl) {
                    short fmt = (short)pc.getDTypeOut().getValue();
                    AlarmCfg ac = pc.getAlarm();
                    int mask = ac.getValueMask().getValue();
                    TAlarmWatchThreshold awt = mask == 0 ? new TAlarmWatchThreshold(ac.getCountThreshold().getValue(), ac.getValueHigh().getValue(), ac.getValueWarnHigh().getValue(), ac.getValueLow().getValue(), ac.getValueWarnLow().getValue()) : new TAlarmWatchThreshold(ac.getCountThreshold().getValue(), mask, ac.getValueNormal().getValue(), ac.isNormalAlarm());
                    TAlarmWatchEntry awe = new TAlarmWatchEntry(eqm, ac.getDeviceName(), pc.getName(), pc.getSizeOut().getValue(), fmt, pc.getDArrayTypeOut(), ac.getSystem().getValue(), ac.getSeverity().getValue(), ac.getCode().getValue(), ac.getCodeHigh().getValue(), ac.getCodeLow().getValue(), awt);
                    eqm.gAlarmWatchList.add(awe);
                }
            }
            return 0;
        }
        TInitializer initializer = TInitializerFactory.getInstance().getInitializer();
        csvColumn[] almwCols = new csvColumn[21];
        almwRowHndlr almwRows = new almwRowHndlr();
        almwCols[0] = new csvColumn("LOCAL_NAME", "", new almwEqmHndlr(almwRows));
        almwCols[1] = new csvColumn("DEVICE_NAME", "#0", new StringFieldHandler(almwRows, "dev"));
        almwCols[2] = new csvColumn("PROPERTY", "", new StringFieldHandler(almwRows, "prp"));
        almwCols[3] = new csvColumn("SIZE", "0", new IntFieldHandler(almwRows, "siz"));
        almwCols[4] = new csvColumn("FORMAT", "null", new FormatFieldHandler(almwRows, "fmt"));
        almwCols[5] = new csvColumn("SEVERITY", "0", new IntFieldHandler(almwRows, "sev"));
        almwCols[6] = new csvColumn("ALARM_SYSTEM", "0", new IntFieldHandler(almwRows, "asys"));
        almwCols[7] = new csvColumn("COUNT_THRESHOLD", "3", new IntFieldHandler(almwRows, "cnt"));
        almwCols[8] = new csvColumn("HIGH", "1.0", new FloatFieldHandler(almwRows, "hi"));
        almwCols[9] = new csvColumn("LOW", "0.0", new FloatFieldHandler(almwRows, "lo"));
        almwCols[10] = new csvColumn("HIGH_WARN", "0.5", new FloatFieldHandler(almwRows, "hiwarn"));
        almwCols[11] = new csvColumn("LOW_WARN", "0.1", new FloatFieldHandler(almwRows, "lowarn"));
        almwCols[12] = new csvColumn("MASK", "0", new IntFieldHandler(almwRows, "mask"));
        almwCols[13] = new csvColumn("NORMAL", "0", new almwNormalValueHndlr(almwRows));
        almwCols[14] = new csvColumn("SEVERITY_HIGH", "0", new IntFieldHandler(almwRows, "hisev"));
        almwCols[15] = new csvColumn("SEVERITY_LOW", "0", new IntFieldHandler(almwRows, "losev"));
        almwCols[16] = new csvColumn("SEVERITY_HIGHWARN", "0", new IntFieldHandler(almwRows, "hiwarnsev"));
        almwCols[17] = new csvColumn("SEVERITY_LOWWARN", "0", new IntFieldHandler(almwRows, "lowarnsev"));
        almwCols[18] = new csvColumn("ALARM_CODE", "0", new IntFieldHandler(almwRows, "code"));
        almwCols[19] = new csvColumn("ALARM_CODE_HIGH", "0", new IntFieldHandler(almwRows, "codeHigh"));
        almwCols[20] = new csvColumn("ALARM_CODE_LOW", "0", new IntFieldHandler(almwRows, "codeLow"));
        csv almwFile = new csv(initializer.getAlmWatchResource(eqmName));
        int rc = almwFile.readFile(almwCols, almwRows);
        almwFile.close();
        if (rc != 42) {
            TFecLog.log("get Alarm Watch information from almwatch.csv : " + TErrorList.errorString[rc]);
        }
        return 0;
    }

    int getHistoryListFromFile(String eqmName) {
        FecCfg cfg = this.getFecXmlCfg();
        if (cfg != null) {
            LinkedList<EqmCfg> el = cfg.getEqmList();
            for (EqmCfg ec : el) {
                if (ec.getName().compareTo(eqmName) != 0) continue;
                TEquipmentModule eqm = this.getEquipmentModule(eqmName);
                LinkedList<PropertyCfg> pl = ec.getPropertyList();
                for (PropertyCfg pc : pl) {
                    short fmt = (short)pc.getDTypeOut().getValue();
                    if (!THistoryRecord.isAllowableFormat(fmt)) {
                        TFecLog.log("history format " + TFormat.toString(fmt) + " read from database not archiveable");
                        continue;
                    }
                    HistoryCfg hc = pc.getHistory();
                    THistorySpecification spc = new THistorySpecification(hc.getPollRate().getValue(), hc.getArchiveRate().getValue(), hc.getDepthShort().getValue(), hc.getDepthLong().getValue(), hc.getHeartbeat().getValue(), hc.getTolerance().getTolerancePercent(), hc.getTolerance().getToleranceAbsolute(), hc.getRedirection());
                    THistoryRecord hst = new THistoryRecord(eqm, hc.getDeviceName(), pc.getName(), pc.getSizeOut().getValue(), fmt, pc.getDArrayTypeOut(), hc.getIndex().getValue(), spc);
                    if (eqm.isUseMSecHistoryTimestamps()) {
                        hst.setUseMsecHistoryTimeStamps(true);
                    }
                    if (eqm.isUseMonthlyHistoryFiles()) {
                        hst.setUseMonthlyHistoryFiles(true);
                    }
                    eqm.gLclHstList.add(hst);
                }
            }
            return 0;
        }
        TInitializer initializer = TInitializerFactory.getInstance().getInitializer();
        csvColumn[] hstCols = new csvColumn[13];
        hstRowHndlr hstRows = new hstRowHndlr();
        hstCols[0] = new csvColumn("INDEX", "1", new IntFieldHandler(hstRows, "recordIndex"));
        hstCols[1] = new csvColumn("LOCAL_NAME", "", new hstEqmHndlr(hstRows));
        hstCols[2] = new csvColumn("PROPERTY", "", new StringFieldHandler(hstRows, "prp"));
        hstCols[3] = new csvColumn("DEVICE", "#0", new StringFieldHandler(hstRows, "dev"));
        hstCols[4] = new csvColumn("DATA_LENGTH", "1", new IntFieldHandler(hstRows, "siz"));
        hstCols[5] = new csvColumn("FORMAT", "float", new FormatFieldHandler(hstRows, "fmt"));
        hstCols[6] = new csvColumn("HEARTBEAT", "900", new IntFieldHandler(hstRows, "heartbeat"));
        hstCols[7] = new csvColumn("POLLING_RATE", "1000", new hstPollHndlr(hstRows));
        hstCols[8] = new csvColumn("ARCHIVE_RATE", "1000", new hstArchHndlr(hstRows));
        hstCols[9] = new csvColumn("TOLERANCE", "0%", new hstTolHndlr(hstRows));
        hstCols[10] = new csvColumn("SHORT_DEPTH", "600", new IntFieldHandler(hstRows, "depthShort"));
        hstCols[11] = new csvColumn("LONG_DEPTH", "1", new IntFieldHandler(hstRows, "depthLong"));
        hstCols[12] = new csvColumn("REMOTE_SERVER", "", new StringFieldHandler(hstRows, "redirString"));
        csv hstFile = new csv(initializer.getHistoryResource(eqmName));
        int rc = hstFile.readFile(hstCols, hstRows);
        hstFile.close();
        if (rc != 42) {
            TFecLog.log("get local history information from history.csv : " + TErrorList.errorString[rc]);
        }
        return 0;
    }

    public long getDataTimeStampOffset() {
        return this.gDataTimeStampOffset;
    }

    public void setDataTimeStampOffset(long offset) {
        this.gDataTimeStampOffset = offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int systemScheduleProperty(TEquipmentModule eqm, String prp) {
        int i;
        int listsize;
        boolean needsHistoryCycle = false;
        boolean needsScheduler = false;
        TContractTable tct = null;
        ArrayList<TContractTable> arrayList = this.conTable;
        synchronized (arrayList) {
            listsize = this.conTable.size();
            if (debugLevel > 2) {
                DbgLog.log("systemScheduleProperty", "Property " + prp + " is being scheduled");
            }
            for (i = 0; i < listsize; ++i) {
                tct = this.conTable.get(i);
                if (tct.expired || tct.nclients <= 0 || tct.contract.eqmProperty.compareToIgnoreCase(prp) != 0) continue;
                tct.lasttime = 0L;
                needsScheduler = true;
            }
        }
        if (needsScheduler) {
            this.doScheduler();
        }
        THistoryRecord lhr = null;
        listsize = eqm.gLclHstList.size();
        for (i = 0; i < listsize; ++i) {
            lhr = eqm.gLclHstList.get(i);
            if (lhr.getPrp().compareToIgnoreCase(prp) != 0) continue;
            needsHistoryCycle = true;
            lhr.setScheduled(true);
        }
        if (needsHistoryCycle) {
            eqm.update();
        }
        return 0;
    }

    public TCycleTrigger[] getCycleTriggerList() {
        return this.gCycTrgLst.toArray(new TCycleTrigger[0]);
    }

    public int registerCycleTrigger(TCycleTrigger trigger) {
        if (this.gCycTrgLst.contains(trigger)) {
            return 135;
        }
        this.gCycTrgLst.add(trigger);
        return 0;
    }

    public int unregisterCycleTrigger(TCycleTrigger trigger) {
        if (!this.gCycTrgLst.contains(trigger)) {
            return 12;
        }
        this.gCycTrgLst.remove(trigger);
        return 0;
    }

    public void setUseGlobalSynchronization(boolean value) {
        this.useGlobalSynchronization = value;
    }

    public double getSyncTimeStamp() {
        return this.gSyncTimeStamp[0];
    }

    private int systemStartGlobalSynchronization() {
        if (this.gSynchronizationStarted) {
            return 0;
        }
        TDataType sdt = new TDataType(this.gSyncTimeStamp);
        TLink tl = new TLink("/SITE", "SYSTIME", sdt, null, 1);
        int id = tl.attach((short)5, (TLinkCallback)new TSyncCallback(), 1000);
        if (id < 0) {
            return -id;
        }
        this.gSynchronizationStarted = true;
        return 0;
    }

    public int getCycleNumber() {
        return this.gCycleNumber[0];
    }

    private boolean assertCycleTriggerExists() {
        if (this.gFecContext == null || this.gFecContext.length() == 0) {
            return false;
        }
        for (int i = 0; i < this.numEqmTableEntries; ++i) {
            if (this.eqmTable[i].getLocalName() == null) continue;
            if (this.eqmTable[i].getExportName().compareToIgnoreCase("CYCLER") == 0) {
                TFecLog.log("this server is the machine cycler for context " + this.gFecContext + " : not listening for machine cycles");
                return false;
            }
            TSrvEntry trgsrv = new TSrvEntry("CYCLER", this.gFecContext);
            if (trgsrv.fecAddr == null) continue;
            TFecLog.log("a machine cycler exists for context " + this.gFecContext);
            return true;
        }
        return false;
    }

    public int getCycleTriggerDeadBand() {
        return cycleTriggerDeadBand;
    }

    public void setCycleTriggerDeadBand(int value) {
        if (value < 100) {
            value = 100;
        }
        cycleTriggerDeadBand = value;
    }

    private int systemStartCycleTrigger() {
        if (this.gCycleTriggerStarted) {
            return 0;
        }
        if (!this.assertCycleTriggerExists()) {
            return 8;
        }
        TDataType sdt = new TDataType(this.gCycleNumber);
        String srv = "/" + this.gFecContext + "/CYCLER";
        TLink tl = new TLink(srv, "CycleNumber", sdt, null, 1);
        int id = tl.attach((short)5, (TLinkCallback)new TCycleTriggerCallback(), cycleTriggerDeadBand);
        if (id < 0) {
            return -id;
        }
        this.gCycleTriggerStarted = true;
        return 0;
    }

    public int getBurstLimit() {
        return this.gBurstLimit;
    }

    public void setBurstLimit(int burstLimit) {
        this.gBurstLimit = burstLimit;
    }

    public boolean isExitOnShutdown() {
        return this.exitOnShutdown;
    }

    public void setExitOnShutdown(boolean exitOnShutdown) {
        this.exitOnShutdown = exitOnShutdown;
    }

    public class TContractBucket
    extends TBucket {
        TContractBucket(Socket socket) {
            this.initBucket(socket, new TEqmFactoryBucketThread(this));
            this.activate();
        }
    }

    public class TEqmFactoryBucketThread
    extends Thread {
        private TContractBucket tb;
        boolean isWaiting = false;

        TEqmFactoryBucketThread(TContractBucket tbucket) {
            this.tb = tbucket;
            this.tb.active = true;
            String s = null;
            Socket sck = this.tb.getSocket();
            s = sck != null ? new String("tcp port " + sck.getLocalPort()) : new String("tcp unbound socket ?");
            this.setName("Equipment Module Factory " + s);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            byte[] wa = new byte[1472];
            byte[] msgsizb = new byte[2];
            TFecLog.log("EQM Factory Bucket Thread started ...");
            try {
                while (this.tb.active && !TEquipmentModuleFactory.this.gSystemExitCondition) {
                    int nread;
                    this.isWaiting = true;
                    try {
                        nread = this.tb.getInputStream().read(wa, 0, 1472);
                    }
                    catch (InterruptedIOException e) {
                        continue;
                    }
                    this.isWaiting = false;
                    if (nread == -1) {
                        this.tb.isDeactivating = true;
                        break;
                    }
                    int nleft = nread;
                    int waptr = 0;
                    int ptr = this.tb.getBucketPointer();
                    int siz = this.tb.getBucketSize();
                    byte[] buf = this.tb.getBucketBuffer();
                    while (nleft > 0) {
                        int n;
                        if (ptr == 0) {
                            System.arraycopy(wa, waptr, msgsizb, 0, 2);
                            siz = Swap.Short(new DataInputStream(new ByteArrayInputStream(msgsizb)).readShort());
                        }
                        if (nleft >= (n = siz - ptr)) {
                            System.arraycopy(wa, waptr, buf, ptr, n);
                            TEquipmentModuleFactory.this.gLinkTablesAccessed = true;
                            TClient tc = TEquipmentModuleFactory.this.LocateClientInList(this.tb.getBucketEndpoint(), this.tb.getBucketPort());
                            tc.inetProtocol = (short)4;
                            tc.output = this.tb.getOutputStream();
                            tc.sck = this.tb.getSocket();
                            TEquipmentModuleFactory.this.getRequest(tc, buf);
                            TEquipmentModuleFactory.this.gLinkTablesAccessed = false;
                            waptr += n;
                            nleft -= n;
                            ptr = 0;
                        } else {
                            System.arraycopy(wa, waptr, buf, ptr, nleft);
                            ptr += nleft;
                            nleft = 0;
                        }
                        this.tb.setBucketPointer(ptr);
                    }
                }
                this.tb.getInputStream().close();
                this.tb.getOutputStream().close();
            }
            catch (IOException e) {
                if (debugLevel > 1) {
                    DbgLog.log("TEqmFactoryBucketThread", "EQM Bucket IOException : " + e);
                }
            }
            catch (Exception e) {
                if (debugLevel > 1) {
                    e.printStackTrace();
                }
            }
            finally {
                this.tb.active = false;
            }
        }
    }

    class hstTolHndlr
    implements csvHandler {
        private hstRowHndlr rHndlr;

        hstTolHndlr(hstRowHndlr rowHndlr) {
            this.rHndlr = rowHndlr;
        }

        public int process(String strValue, int index) {
            int i = 0;
            try {
                i = strValue.indexOf(37);
                if (i == -1) {
                    this.rHndlr.aTolerance = Float.parseFloat(strValue);
                    this.rHndlr.pTolerance = 0.0f;
                } else {
                    this.rHndlr.aTolerance = 0.0f;
                    this.rHndlr.pTolerance = Float.parseFloat(strValue.substring(0, i - 1));
                }
            }
            catch (Exception e) {
                this.rHndlr.pTolerance = 0.0f;
                this.rHndlr.aTolerance = 0.0f;
            }
            return 0;
        }
    }

    class hstArchHndlr
    implements csvHandler {
        private hstRowHndlr rHndlr;

        hstArchHndlr(hstRowHndlr rowHndlr) {
            this.rHndlr = rowHndlr;
        }

        public int process(String strValue, int index) {
            try {
                this.rHndlr.archiveRate = Integer.parseInt(strValue);
                if (this.rHndlr.archiveRate < 20) {
                    this.rHndlr.archiveRate *= 1000;
                }
            }
            catch (NumberFormatException e) {
                this.rHndlr.archiveRate = 10000;
            }
            return 0;
        }
    }

    class hstPollHndlr
    implements csvHandler {
        private hstRowHndlr rHndlr;

        hstPollHndlr(hstRowHndlr rowHndlr) {
            this.rHndlr = rowHndlr;
        }

        public int process(String strValue, int index) {
            try {
                this.rHndlr.pollingRate = Integer.parseInt(strValue);
                if (this.rHndlr.pollingRate < 20) {
                    this.rHndlr.pollingRate *= 1000;
                }
            }
            catch (NumberFormatException e) {
                this.rHndlr.pollingRate = 1000;
            }
            return 0;
        }
    }

    class hstExpHndlr
    implements csvHandler {
        private String target;
        private hstRowHndlr rHndlr;

        hstExpHndlr(hstRowHndlr rowHndlr, String name) {
            this.rHndlr = rowHndlr;
            this.target = name;
        }

        public int process(String strValue, int index) {
            if (this.target == null || this.target.length() == 0 || strValue.compareTo(this.target) == 0) {
                this.rHndlr.skip = false;
            } else {
                this.rHndlr.skip = true;
            }
            return 0;
        }
    }

    class hstEqmHndlr
    implements csvHandler {
        private hstRowHndlr rHndlr;

        hstEqmHndlr(hstRowHndlr rowHndlr) {
            this.rHndlr = rowHndlr;
        }

        public int process(String strValue, int index) {
            for (int i = 0; i < TEquipmentModuleFactory.this.numEqmTableEntries; ++i) {
                if (TEquipmentModuleFactory.this.eqmTable[i].getLocalName().compareTo(strValue) != 0) continue;
                this.rHndlr.eqm = TEquipmentModuleFactory.this.eqmTable[i];
                return 0;
            }
            return 86;
        }
    }

    class hstRowHndlr
    implements RowHandler {
        private TEquipmentModule eqm;
        public String dev;
        public String prp;
        public int siz;
        public int fmt;
        public int atyp;
        public int pollingRate;
        public int archiveRate;
        public int depthShort;
        public int depthLong;
        public int heartbeat;
        public float pTolerance;
        public float aTolerance;
        public int recordIndex;
        public String redirString;
        private boolean skip = false;

        hstRowHndlr() {
        }

        public int process(int index) {
            if (this.skip) {
                return 0;
            }
            if (this.eqm == null) {
                return 86;
            }
            THistorySpecification spc = new THistorySpecification(this.pollingRate, this.archiveRate, this.depthShort, this.depthLong, this.heartbeat, this.pTolerance, this.aTolerance, this.redirString);
            if (!THistoryRecord.isAllowableFormat((short)this.fmt)) {
                TFecLog.log("history format " + TFormat.toString((short)this.fmt) + " read from database not archiveable");
                return 0;
            }
            THistoryRecord hst = new THistoryRecord(this.eqm, this.dev, this.prp, this.siz, this.fmt, this.atyp, this.recordIndex, spc);
            if (this.eqm.isUseMSecHistoryTimestamps()) {
                hst.setUseMsecHistoryTimeStamps(true);
            }
            if (this.eqm.isUseMonthlyHistoryFiles()) {
                hst.setUseMonthlyHistoryFiles(true);
            }
            this.eqm.gLclHstList.add(hst);
            return 0;
        }
    }

    class almwNormalValueHndlr
    implements csvHandler {
        private almwRowHndlr rHndlr;

        almwNormalValueHndlr(almwRowHndlr rowHndlr) {
            this.rHndlr = rowHndlr;
        }

        public int process(String strValue, int index) {
            String s;
            if (strValue.startsWith("!")) {
                this.rHndlr.normalIsAlarm = true;
                s = strValue.substring(1);
            } else {
                this.rHndlr.normalIsAlarm = false;
                s = strValue;
            }
            this.rHndlr.normal = csv.getIntFromString(s);
            return 0;
        }
    }

    class almwEqmHndlr
    implements csvHandler {
        private almwRowHndlr rHndlr;

        almwEqmHndlr(almwRowHndlr rowHndlr) {
            this.rHndlr = rowHndlr;
        }

        public int process(String strValue, int index) {
            for (int i = 0; i < TEquipmentModuleFactory.this.numEqmTableEntries; ++i) {
                if (TEquipmentModuleFactory.this.eqmTable[i].getLocalName().compareTo(strValue) != 0) continue;
                this.rHndlr.eqm = TEquipmentModuleFactory.this.eqmTable[i];
                return 0;
            }
            return 0;
        }
    }

    class almwRowHndlr
    implements RowHandler {
        private TEquipmentModule eqm;
        public String dev;
        public String prp;
        public int siz;
        public int fmt;
        public int atyp;
        public int asys;
        public int sev;
        public int hisev;
        public int losev;
        public int hiwarnsev;
        public int lowarnsev;
        public int cnt;
        public int mask;
        public int normal;
        public float hi;
        public float lo;
        public float hiwarn;
        public float lowarn;
        public int code;
        public int codeHigh;
        public int codeLow;
        public boolean normalIsAlarm = false;

        almwRowHndlr() {
        }

        public int process(int index) {
            if (this.eqm == null) {
                return 86;
            }
            TAlarmWatchThreshold awt = this.mask == 0 ? new TAlarmWatchThreshold(this.cnt, this.hi, this.hiwarn, this.lo, this.lowarn) : new TAlarmWatchThreshold(this.cnt, this.mask, this.normal, this.normalIsAlarm);
            TAlarmWatchEntry awe = new TAlarmWatchEntry(this.eqm, this.dev, this.prp, this.siz, this.fmt, this.atyp, this.asys, this.sev, this.code, this.codeHigh, this.codeLow, awt);
            this.eqm.gAlarmWatchList.add(awe);
            return 0;
        }
    }

    class aliasListRowHndlr
    implements RowHandler {
        public String aName;
        public String aAlias;

        aliasListRowHndlr() {
        }

        public int process(int index) {
            AliasTableEntry ate = new AliasTableEntry(this.aName, this.aAlias);
            TEquipmentModuleFactory.this.gAliasList.add(ate);
            return 0;
        }
    }

    class FecRowHndlr
    implements RowHandler {
        private boolean latchExpName = false;
        private boolean latchEqmName = false;
        protected boolean namefound = false;
        private String target;
        public String ctx;
        public String sub;
        public String rsp;
        public String hdw;
        public String dsc;
        public String nam;
        public String loc;
        public String exp;
        public String eqm;
        public String hstHome;
        public int port;

        FecRowHndlr() {
        }

        public int process(int index) {
            if (this.latchExpName) {
                String tctx = null;
                String texp = this.target;
                if (this.target.startsWith("/")) {
                    String[] parts = this.target.split("/");
                    if (parts.length < 3) {
                        return 0;
                    }
                    tctx = parts[1];
                    texp = parts[2];
                }
                if (this.exp == null || this.exp.length() == 0) {
                    TFecLog.log("no exports column : accept " + this.nam + " as fecname");
                    this.namefound = true;
                    return -1;
                }
                if (this.ctx != null && this.ctx.length() > 0 && tctx != null && tctx.length() > 0 && this.ctx.compareToIgnoreCase(tctx) != 0) {
                    return 0;
                }
                if (this.exp.compareToIgnoreCase(texp) == 0) {
                    this.namefound = true;
                    return -1;
                }
            } else if (this.latchEqmName) {
                if (this.eqm == null || this.eqm.length() == 0) {
                    TFecLog.log("no local name column : accept " + this.nam + " as fecname");
                    this.namefound = true;
                    return -1;
                }
                if (this.eqm.compareToIgnoreCase(this.target) == 0) {
                    this.namefound = true;
                    return -1;
                }
            } else {
                this.namefound = true;
                return -1;
            }
            return 0;
        }
    }

    class tgtHndlr
    implements csvHandler {
        String target;

        tgtHndlr(String name) {
            this.target = name;
        }

        public int process(String strValue, int index) {
            if (this.target == null || strValue.length() == 0) {
                TFecLog.log("accept first entry in fecid.csv as valid!");
                return -1;
            }
            if (strValue.compareTo(this.target) == 0) {
                TFecLog.log("found target " + this.target + " in fecid.csv!");
                return -1;
            }
            return 0;
        }
    }

    public class TBackgroundThread
    extends Thread {
        private TEquipmentBackgroundTask tbkg;

        TBackgroundThread(TEquipmentBackgroundTask tBkgTask) {
            this.tbkg = tBkgTask;
            this.setName("Equipment Module background " + this.tbkg.getClass().getSimpleName());
        }

        public synchronized void run() {
            long interim = 0L;
            long deadTimeInMsec = 0L;
            TFecLog.log("Background Thread " + this.getName() + " started ...");
            while (!TEquipmentModuleFactory.this.gSystemExitCondition) {
                try {
                    interim = System.currentTimeMillis();
                    if (!this.tbkg.isIdleState()) {
                        this.tbkg.call();
                    }
                    if ((deadTimeInMsec = this.tbkg.getBackgroundTaskInterval() - (System.currentTimeMillis() - interim)) < 0L) {
                        deadTimeInMsec = 0L;
                    }
                    if (debugLevel > 3) {
                        DbgLog.log("TBackgroundThread", "sleeping " + deadTimeInMsec + " msec in background task");
                    }
                    TBackgroundThread.sleep(deadTimeInMsec);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DbgLog.log("TBackgroundThread", "thread execution error");
                }
            }
        }
    }

    public class TCycleThread
    extends Thread {
        public synchronized void run() {
            this.setName("Equipment Module Cycle");
            DbgLog.log("TCycleThread", "Cycle Thread started ...");
            while (!TEquipmentModuleFactory.this.gSystemExitCondition) {
                try {
                    TCycleThread.sleep(TEquipmentModuleFactory.this.systemSrvCycle());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    DbgLog.log("TCycleThread", "cycle thread execution error");
                }
            }
            TFecLog.log("System halted");
        }
    }

    public class TAcceptorThread
    extends Thread {
        private int transportProtocol = 8;

        TAcceptorThread(int transport) {
            this.transportProtocol = transport;
            this.setName("Equipment Module " + TTransport.toString((short)transport) + " acceptor");
        }

        TAcceptorThread() {
            this.transportProtocol = 8;
            this.setName("Equipment Module UDP acceptor");
        }

        public synchronized void run() {
            DbgLog.log("TAcceptorThread", "Acceptor Thread " + this.getName() + " started ...");
            block7: while (!TEquipmentModuleFactory.this.gSystemExitCondition) {
                try {
                    if (!TEquipmentModuleFactory.this.isInitialized) {
                        TAcceptorThread.sleep(200L);
                    }
                    switch (this.transportProtocol) {
                        case 8: {
                            TEquipmentModuleFactory.this.systemAcceptDataGramRequest();
                            TEquipmentModuleFactory.this.gTotalUdpPackets++;
                            continue block7;
                        }
                        case 4: {
                            TEquipmentModuleFactory.this.systemAcceptDataStreamRequest();
                            TEquipmentModuleFactory.this.systemCleanupDataStreams();
                            TEquipmentModuleFactory.this.gTotalTcpPackets++;
                            continue block7;
                        }
                    }
                    MsgLog.log("TAcceptorThread", "transportProtocol " + TTransport.toString((short)this.transportProtocol) + " not supported", 94, null, 0);
                    TEquipmentModuleFactory.this.gSystemExitCondition = true;
                }
                catch (InterruptedException e) {
                    if (debugLevel <= 2) continue;
                    DbgLog.log("TAcceptorThread", "interrupted");
                }
                catch (Exception e) {
                    MsgLog.log("TAcceptorThread", "unhandled exception: " + e.getMessage(), 66, e, 0);
                }
            }
            MsgLog.log("TAcceptorThread", "Acceptor Thread terminating ...", 0, null, 0);
        }
    }

    private class clnInputData {
        TDataType din;
        TClient tc;
        int id;
        int starttime;

        private clnInputData() {
        }
    }

    class AliasTableEntry {
        private String name;
        private String alias;

        AliasTableEntry(String thisName, String thisAlias) {
            this.name = thisName;
            this.alias = thisAlias;
        }

        public String getTag() {
            return this.name;
        }

        public String getAlias() {
            return this.alias;
        }
    }
}

