/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.server.equipment;

import de.desy.tine.client.TLink;
import de.desy.tine.client.TLinkCallback;
import de.desy.tine.server.equipment.TCycleTrigger;
import de.desy.tine.server.equipment.TEquipmentModuleFactory;
import de.desy.tine.server.logger.TFecLog;

public class TCycleTriggerCallback
implements TLinkCallback {
    private static TEquipmentModuleFactory f = TEquipmentModuleFactory.getInstance();
    private int last_cc = -1;
    private int last_cycleNumber = -1;

    public void callback(TLink link) {
        int cc = link.getLinkStatus();
        if (cc != this.last_cc) {
            this.last_cc = cc;
            TFecLog.log("cycle trigger : " + link.getLastError());
        }
        if (cc != 0) {
            return;
        }
        int cycleNumber = f.getCycleNumber();
        if (cycleNumber == this.last_cycleNumber) {
            return;
        }
        this.last_cycleNumber = cycleNumber;
        TCycleTrigger[] trgs = f.getCycleTriggerList();
        for (int i = 0; i < trgs.length; ++i) {
            trgs[i].update(cycleNumber, cc);
        }
        f.setSystemStamp(cycleNumber);
    }
}

