/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.server.connections;

import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.definitions.TErrorList;
import de.desy.tine.headers.TContract;
import de.desy.tine.server.connections.TClientEntry;
import de.desy.tine.server.connections.TContractEntry;
import de.desy.tine.server.connections.TContractStruct;
import de.desy.tine.server.equipment.TEquipmentModule;
import de.desy.tine.stringUtils.StringToBytes;
import de.desy.tine.structUtils.TStructBase;
import de.desy.tine.structUtils.TStructDescription;
import de.desy.tine.structUtils.TStructRegistry;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;

public class TContractTable
extends TStructBase {
    public ConcurrentLinkedQueue<TClientEntry> clt = new ConcurrentLinkedQueue();
    public int nclients;
    public int contractID;
    public TContract contract;
    public int pollingRate;
    public long lasttime;
    public long lastmarked;
    public long starttime;
    public long dtimestamp;
    public int sysstamp;
    public int usrstamp;
    public TDataType dout;
    public TDataType drb;
    public TDataType din;
    public int dataSizeOut;
    public int pending;
    public boolean expired;
    public boolean isRepeat = false;
    public boolean isStale = false;
    public int compStatus;
    public int returnCode;
    public int delays;
    public int misses;
    public String compString;
    public TEquipmentModule eqm;
    public static final int nice_query_size = 50;
    private static TStructDescription myStructDsc;

    public void setStale(byte staleFlag) {
        TClientEntry tce2 = null;
        for (TClientEntry tce2 : this.clt) {
            tce2.sts.Stale = staleFlag;
        }
    }

    public int renegotiateContract(short statusCode) {
        TClientEntry tce = null;
        int datasize = 0;
        boolean addsts = false;
        int n = datasize = this.drb.dFormat == 57 ? this.drb.getSizeInBytes() : this.drb.getDataSize();
        if (statusCode != 0) {
            addsts = true;
        }
        Iterator<TClientEntry> li = this.clt.iterator();
        while (li.hasNext()) {
            int ds = datasize;
            tce = li.next();
            if (addsts) {
                ds += tce.cln.tineProtocol < 6 ? 32 : 192;
            }
            tce.sts.BytesRemaining = ds;
            tce.sts.BytesTotal = ds;
            tce.sts.nextDataSize = tce.sts.BytesRemaining;
            if (tce.sts.BytesRemaining > tce.sts.mtu) {
                tce.sts.nextDataSize = tce.sts.mtu;
            }
            tce.sts.numblks = (short)(ds / tce.sts.mtu + (ds % tce.sts.mtu > 0 ? 1 : 0));
            if (datasize != 0) continue;
            tce.sts.numblks = 1;
        }
        return 0;
    }

    private static void createQueryStruct() {
        if (!TStructRegistry.contains("CONQS")) {
            new TContractStruct();
        }
        if (!TStructRegistry.contains("CTQSr4")) {
            new TContractEntry();
        }
    }

    public static TStructDescription getStructDescription() {
        return myStructDsc;
    }

    public void readData(DataInput din) throws IOException {
    }

    public void writeData(DataOutput dout) throws IOException {
        dout.write(StringToBytes.stringToFixedBytes(this.contract.eqmProperty, 32));
        dout.write(StringToBytes.stringToFixedBytes(this.contract.eqmDeviceName, 16));
        dout.write(StringToBytes.stringToFixedBytes(this.contract.eqmName, 8));
        dout.writeInt(this.contract.dataSizeIn);
        dout.writeInt(this.contract.dataSizeOut);
        dout.writeByte(this.contract.hEqmName);
        dout.writeByte(this.contract.dataAccess);
        dout.writeByte(this.contract.dataFormatIn);
        dout.writeByte(this.contract.dataFormatOut);
        dout.write(StringToBytes.stringToFixedBytes(this.contract.dataTagIn, 8));
        dout.write(StringToBytes.stringToFixedBytes(this.contract.dataTagOut, 8));
        dout.writeInt(this.pollingRate);
        dout.writeInt(this.clt.size());
    }

    public void writeData(String tag, DataOutput dout) throws IOException {
        int plen = 64;
        int dlen = 64;
        int tlen = 16;
        if (tag == null) {
            tag = "CTQSr4";
        }
        if (tag.compareTo("CONQS") == 0) {
            if (!TStructRegistry.contains("CONQS")) {
                new TContractStruct();
            }
            plen = 32;
            dlen = 16;
            tlen = 8;
        } else if (tag.compareTo("CTQSr4") == 0) {
            if (!TStructRegistry.contains("CTQSr4")) {
                new TContractEntry();
            }
        } else {
            return;
        }
        dout.write(StringToBytes.stringToFixedBytes(this.contract.eqmProperty, plen));
        dout.write(StringToBytes.stringToFixedBytes(this.contract.eqmDeviceName, dlen));
        dout.write(StringToBytes.stringToFixedBytes(this.contract.eqmName, 8));
        dout.writeInt(this.contract.dataSizeIn);
        dout.writeInt(this.contract.dataSizeOut);
        dout.writeByte(this.contract.hEqmName);
        dout.writeByte(this.contract.dataAccess);
        dout.writeByte(this.contract.dataFormatIn);
        dout.writeByte(this.contract.dataFormatOut);
        dout.write(StringToBytes.stringToFixedBytes(this.contract.dataTagIn, tlen));
        dout.write(StringToBytes.stringToFixedBytes(this.contract.dataTagOut, tlen));
        dout.writeInt(this.pollingRate);
        dout.writeInt(this.clt.size());
    }

    public String toString() {
        String s = this.contract.toString();
        s = s.concat("\ncontract id : " + this.contractID);
        s = s.concat("\nnumber of clients : " + this.nclients + " (list size " + this.clt.size() + ")");
        s = s.concat("\nlast completion code : " + this.returnCode + " (" + TErrorList.getErrorString(this.returnCode) + ")");
        s = s.concat("\nlast link status : " + this.compStatus + " (" + TErrorList.getErrorString(this.compStatus) + ")");
        s = s.concat("\nnumber clients pending delivery : " + this.pending);
        s = s.concat("\ncontract expired : " + this.expired);
        return s;
    }

    static {
        TContractTable.createQueryStruct();
    }
}

