/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.server.connections;

import de.desy.tine.definitions.TFormat;
import de.desy.tine.headers.TSubscription;
import de.desy.tine.server.equipment.TEquipmentModuleFactory;

public class TClientStatus {
    public short id;
    public short mode;
    public int PollingRate;
    public long lasttime;
    public long starttime;
    public short counter;
    public short Stale;
    public short numblks;
    public short blknum;
    public short statusCode;
    public int mtu;
    public int nextDataSize;
    public int nextDataPtr;
    public int BytesRemaining;
    public int BytesTotal;
    public int misses;
    public int reconnects;
    public boolean isRetry;
    public int transport;

    public TClientStatus() {
        this.transport = 8;
    }

    public TClientStatus(int transport) {
        this.transport = transport;
    }

    public void reset(TSubscription sub) {
        int datasize = sub.getOutputDataSize();
        int fmtsize = TFormat.formatSizeOf(sub.contract.dataFormatOut);
        this.PollingRate = sub.pollingRate;
        this.id = sub.id;
        this.starttime = 1000L * (long)sub.starttime;
        this.blknum = 1;
        this.nextDataPtr = 0;
        this.BytesRemaining = datasize;
        this.BytesTotal = datasize;
        int hdrSize = sub.isLegacy ? 24 : 44;
        int pmtu = TEquipmentModuleFactory.getServerPacketMTU();
        if (this.transport == 4 && pmtu > 5888) {
            pmtu = 5888;
        }
        int datamtu = pmtu - hdrSize - 2;
        if (fmtsize > 0) {
            datamtu -= datamtu % fmtsize;
        }
        this.mtu = datamtu;
        this.nextDataSize = this.BytesRemaining;
        if (this.BytesRemaining > this.mtu) {
            this.nextDataSize = this.mtu;
        }
        this.numblks = (short)(datasize / this.mtu + (datasize % this.mtu > 0 ? 1 : 0));
        if (datasize == 0) {
            this.numblks = 1;
        }
    }
}

