/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.server.alarms;

import de.desy.tine.client.TLinkFactory;
import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.server.alarms.TAlarmDescriptor;
import de.desy.tine.server.alarms.TAlarmMessage;
import de.desy.tine.structUtils.TTaggedStructure;

public class TCASAlarmMessage
extends TTaggedStructure
implements Comparable {
    private char[] server = new char[32];
    private String serverString;
    private char[] device = new char[64];
    private String deviceString;
    private char[] alarmText = new char[64];
    private String alarmTextString;
    private int[] alarmCode = new int[1];
    private int[] timestamp = new int[1];
    private int[] timestampUSec = new int[1];
    private int[] starttime = new int[1];
    private int[] starttimeUSec = new int[1];
    private int[] alarmMask = new int[1];
    private int[] alarmSystem = new int[1];
    private byte[] alarmData = new byte[64];
    private byte[] alarmDataFormat = new byte[1];
    private byte[] alarmDataArraySize = new byte[1];
    private TDataType tAlarmData;
    private byte[] severity = new byte[1];
    private byte[] descriptor = new byte[1];
    public static final int sizeInBytes = 224;

    public int getAlarmCode() {
        return this.alarmCode[0];
    }

    public int getAlarmSeverity() {
        return this.severity[0];
    }

    public int getAlarmDescriptor() {
        return this.descriptor[0];
    }

    public String getAlarmDescriptorAsString() {
        return TAlarmDescriptor.toLongString(this.descriptor[0]);
    }

    public boolean isTransient() {
        return (this.descriptor[0] & 0x10) != 16;
    }

    public boolean isActive() {
        if ((this.descriptor[0] & 0x40) != 64) {
            return true;
        }
        return (this.descriptor[0] & 1) == 1;
    }

    public int getAlarmSystem() {
        return this.alarmSystem[0];
    }

    public long getTimeStamp() {
        return (long)this.timestamp[0] * 1000L + (long)(this.timestampUSec[0] / 1000);
    }

    public long getStartTime() {
        return (long)this.starttime[0] * 1000L + (long)(this.starttimeUSec[0] / 1000);
    }

    public int getAlarmMask() {
        return this.alarmMask[0];
    }

    public boolean hasData() {
        return this.alarmDataArraySize[0] > 0;
    }

    public TDataType getAlarmData() {
        if (this.tAlarmData == null) {
            byte dsiz = this.alarmDataArraySize[0];
            short dfmt = this.alarmDataFormat[0];
            this.tAlarmData = new TDataType(dsiz, dfmt);
            if (dsiz > 0 && dfmt != 255) {
                this.tAlarmData.pushBytes(this.alarmData);
                TLinkFactory.getInstance().fillinIncomingData(this.tAlarmData);
            }
        }
        return this.tAlarmData;
    }

    public String getServer() {
        if (this.serverString == null) {
            this.serverString = new String(this.server).trim();
        }
        return this.serverString;
    }

    public String getDevice() {
        if (this.deviceString == null) {
            this.deviceString = new String(this.device).trim();
        }
        return this.deviceString;
    }

    public String getAlarmText() {
        if (this.alarmTextString == null) {
            this.alarmTextString = new String(this.alarmText).trim();
        }
        return this.alarmTextString;
    }

    private void initStructDescription() {
        this.addField(this.server, "server");
        this.addField(this.device, "device");
        this.addField(this.alarmText, "almText");
        this.addField(this.alarmCode, "almCode");
        this.addField(this.timestamp, "timestamp");
        this.addField(this.timestampUSec, "timestampUSec");
        this.addField(this.starttime, "starttime");
        this.addField(this.starttimeUSec, "starttimeUSec");
        this.addField(this.alarmMask, "almMask");
        this.addField(this.alarmSystem, "almSystem");
        this.addField(this.alarmData, "almData");
        this.addField(this.alarmDataFormat, "almDataFormat");
        this.addField(this.alarmDataArraySize, "almDataArraySize");
        this.addField(this.severity, "severity");
        this.addField(this.descriptor, "descriptor");
        this.initDone();
    }

    public TCASAlarmMessage() {
        super("XAMSr4");
        this.initStructDescription();
    }

    private void pushByteArray(byte[] barray) {
        for (int i = 0; i < 64; ++i) {
            this.alarmData[i] = 0;
        }
        if (barray == null) {
            return;
        }
        int len = Math.min(barray.length, 64);
        for (int i = 0; i < len; ++i) {
            this.alarmData[i] = barray[i];
        }
    }

    private void pushString(String s, char[] c) {
        if (s != null) {
            int len = s.length();
            if (len > c.length) {
                len = c.length;
            }
            s.getChars(0, len, c, 0);
        }
    }

    public TCASAlarmMessage(TAlarmMessage ams) {
        super("XAMSr4");
        this.initStructDescription();
        this.pushString(ams.getServer(), this.server);
        this.pushString(ams.getDevice(), this.device);
        this.pushString(ams.getAlarmTag(), this.alarmText);
        this.alarmCode[0] = ams.getAlarmCode();
        this.timestamp[0] = (int)(ams.getTimeStamp() / 1000L);
        this.timestampUSec[0] = (int)(ams.getTimeStamp() % 1000L) * 1000;
        this.starttime[0] = (int)(ams.getStartTime() / 1000L);
        this.starttimeUSec[0] = (int)(ams.getStartTime() % 1000L) * 1000;
        this.pushByteArray(ams.getAlarmData().getDataBuffer());
        this.descriptor[0] = (byte)ams.getAlarmDescriptor();
    }

    public int compareTo(Object a) {
        if (a == null) {
            return -999;
        }
        if (a instanceof TCASAlarmMessage) {
            int dt = this.timestamp[0] - ((TCASAlarmMessage)a).timestamp[0];
            if (dt != 0) {
                return dt;
            }
            return this.timestampUSec[0] - ((TCASAlarmMessage)a).timestampUSec[0];
        }
        return -998;
    }
}

